<?php

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: index.php,v 1.16 2005/06/10 22:07:04 mdruilhe Exp $
 *	Usage:		Statistics module
 *	Author:		Syloo (syloo@w-agora.net)
 */


global $agora_dir;

$agora_dir = "..";
$base_url = "..";

chdir($agora_dir);

include ("init_admin.inc");
include ("stats/find_stats.inc");


/**
 * Display general statistics for the site
 * @param     $site		site to display
 * @access    public
 * @return    void
 */
function dspSiteGeneralStats($stat) {
	global $ext,$agora_dir,$site;

	reset($stat);
	while (list($k,$val) = each($stat)) {
	    if (empty($val)) {
	        $stat[$k] = "-";
	    }
	}
	?>
    <table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
	  <tr class="stats_border"><td>
	   <table width="100%" border="0" cellspacing="1" cellpadding="4" align="center">
        <tr>
          <td class="stats_title" colspan="2"><?php printf(TITLE_ACTIVITY_SUMMARY, $stat["site_name"])?></td>
	    </tr>
		<tr class="stats_even">
          <td class="stats_label" width="70%"><?php echo LABEL_FORUMS?></td>
		  <td class="stats_value"><b><?php echo $stat["totalforums"]?></td>
		</tr>
        <tr class="stats_odd">
		  <td class="stats_label" width="70%"><a href="<?php echo "$agora_dir/users.$ext?site=$site"?>" class=label><?php echo LABEL_REGISTERED_U?></a></td>
		  <td class="stats_value"><b><?php echo $stat["totalusers"]?></b></td>
		</tr>
		<tr class="stats_even">
		  <td class="stats_label" width="70%"><?php echo LABEL_SUBSCRIBED_U?></td>
		  <td class="stats_value"><b><?php echo $stat["totalsubscribes"]?></td>
		</tr>
		<tr class="stats_odd">
		  <td class="stats_label" width="70%"><?php echo LABEL_THREADS?></td>
		  <td class="stats_value"><b><?php echo $stat["totalthreads"]?></td>
		</tr>
		<tr class="stats_even">
		  <td class="stats_label" width="70%"><?php echo LABEL_NOTES?></td>
		  <td class="stats_value"><?php echo $stat["totalnotes"]?></td>
		</tr>
		<tr class="stats_odd">
		  <td class="stats_label" width="70%"><?php echo LABEL_LAST_NOTE?></td>
		  <td class="stats_value"><?php echo formated_date($stat["lastnote"])?></td>
		</tr>
		<tr class="stats_even">
		  <td class="stats_label" width="70%"><?php echo LABEL_ATTACHMENTS?>:</td>
		  <td class="stats_value"><?php echo $stat["totalfiles"]?> (<b><?php echo pretty_size($stat["totalfilesize"])?></b>)</td>
		</tr>
	   </table>
    </td></tr></table><?php
}

/**
 * Display stats by month
 */
function dspSiteMonthStats(&$stat)
{
	global $db, $site, $ext;

	if (!is_array($stat)) {
	    return;
	}
?>

    <table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
	  <tr class="stats_border"><td>
	   <table width="100%" border="0" cellspacing="1" cellpadding="4" align="center">
        <tr>
		  <td class="stats_title" colspan="10"><?php echo TITLE_MONTHLY_STATS?></td>
		</tr>
        <tr bgcolor="#CCCCCC">
          <td rowspan="2" class="stats_th" width="10%"><?php echo COLUMN_MONTH?></td>
          <td colspan="4" class="stats_th" ><?php echo COLUMN_DAILY_AVG?></td>
          <td colspan="5" class="stats_th" ><?php echo COLUMN_MONTHLY_TOT?></td></tr>
        <tr>
		  <td align="center" bgcolor="#FFCCFF" class="stats_th" width="10%"><?php echo COLUMN_HITS?></td>
          <td align="center" bgcolor="#CCFFCC" class="stats_th" width="10%"><?php echo COLUMN_LOGINS?></td>
          <td align="center" bgcolor="#FFFFCC" class="stats_th" width="10%"><?php echo COLUMN_POSTS?></td>
		  <td align="center" bgcolor="#99FF99" class="stats_th" width="10%"><?php echo COLUMN_SUBSCRIBES?></td>
		  <td align="center" bgcolor="#FFCCFF" class="stats_th" width="10%"><?php echo COLUMN_HITS?></td>
          <td align="center" bgcolor="#CCFFCC" class="stats_th" width="10%"><?php echo COLUMN_LOGINS?></td>
          <td align="center" bgcolor="#FFFFCC" class="stats_th" width="10%"><?php echo COLUMN_POSTS?></td>
		  <td align="center" bgcolor="#99FF99" class="stats_th" width="10%"><?php echo COLUMN_SUBSCRIBES?></td>
          <td align="center" bgcolor="#66FFCC" class="stats_th" width="10%"><?php echo COLUMN_VISITS?></td></tr>
<?php
	reset($stat);
	while (list($k,$tab) = each($stat)) {
		$cur_date = date("M. Y",$tab["date"]);
		$cur_month = date("m",$tab["date"]);
		$cur_year = date("Y",$tab["date"]);
		$days = ((date("m") == date("m",$tab["date"])) && (date("Y") == date("Y",$tab["date"]))) ? date("d") : date("t",$tab["date"]);
		$moy[BAR_NUM_LOGINS] = $tab[BAR_NUM_LOGINS] / $days;
		$moy[BAR_NUM_POSTS] = $tab[BAR_NUM_POSTS] / $days;
		$moy[BAR_NUM_HITS] = $tab[BAR_NUM_HITS] / $days;
		$moy[BAR_NUM_SUBSCRIBES] = $tab[BAR_NUM_SUBSCRIBES] / $days;
?>
	<tr>
	  <td bgcolor="#CCCCCC" align="right" class="stats_label" nowrap><a href="<?php echo "month_stats.$ext?site=$site&month=$cur_month&year=$cur_year"?>" class="label"><?php echo $cur_date?></a>&nbsp;</td>
	  <td class="stats_value"><?php echo number_format($moy[BAR_NUM_HITS],2)?>&nbsp;</td>
	  <td class="stats_value"><?php echo number_format($moy[BAR_NUM_LOGINS],2)?>&nbsp;</td>
	  <td class="stats_value"><?php echo number_format($moy[BAR_NUM_POSTS],2)?>&nbsp;</td>
	  <td class="stats_value"><?php echo number_format($moy[BAR_NUM_SUBSCRIBES],2)?>&nbsp;</td>
	  <td class="stats_value2"><?php echo $tab[BAR_NUM_HITS]?>&nbsp;</td>
	  <td class="stats_value2"><?php echo $tab[BAR_NUM_LOGINS]?>&nbsp;</td>
	  <td class="stats_value2"><?php echo $tab[BAR_NUM_POSTS]?>&nbsp;</td>
	  <td class="stats_value2"><?php echo $tab[BAR_NUM_SUBSCRIBES]?>&nbsp;</td>
	  <td class="stats_value2"><?php echo $tab[BAR_NUM_VISITS]?>&nbsp;</td>
    </tr>
<?php
	}
?>
      </table>
    </td>
  </tr>
</table><?php
} // end func


/**
 * Display stats for site forums
 * @param     $site		site to display
 * @access    public
 * @return    void
 */
function dspSiteForumStats(&$stat)
{
	global $ext,$agora_dir;
?>

    <table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
	  <tr class="stats_border"><td>
	   <table width="100%" border="0" cellspacing="1" cellpadding="4" align="center">
        <tr>
		  <td class="stats_title" colspan="8"><?php echo TITLE_FORUMS_STATS?></td>
		</tr>
        <tr bgcolor="#CCCCCC">
          <td class="stats_th" width="25%"><?php echo COLUMN_NAME?></td>
          <td class="stats_th" width="10%"><?php echo COLUMN_THREADS?></td>
          <td class="stats_th" width="20%"><?php echo COLUMN_NOTES?></td>
          <td class="stats_th" width="15%"><?php echo COLUMN_ATT?></td>
          <td class="stats_th" width="7%"><?php echo COLUMN_REGISTERED?></td>
		  <td class="stats_th" width="7%"><?php echo COLUMN_AUTHORS?></td>
		  <td class="stats_th" width="7%"><?php echo COLUMN_SUBSCRIBED?></td>
          <td class="stats_th" width="10%"><?php echo COLUMN_HITS?></td>
		</tr>
<?php
	reset($stat);
	while (list($line,$tab) = each($stat)) {
		while (list($k,$val) = each($tab)) {
		    if (empty($val)) {
		        $tab[$k] = "-";
		    }
			$att_text = ($tab["att_count"] == "-") ? "-" : "<b>" . $tab["att_count"] . "</b> (" . pretty_size($tab["att_size"]) . ")";
		}

		$last_url = ($tab["totalnotes"] == "-") ? '' : '(<a href="' ."$agora_dir/view.$ext?bn=".$tab['bn_name'].'&key='.$tab['lastnote'] . '" class=label>'. LABEL_LAST . '</a>: '.formated_date($tab['lastnote']). ')';
?>
	    <tr>
          <td class="stats_label"><a href="<?php echo "$agora_dir/index.$ext?bn=".$tab['bn_name']?>" class=label><?php echo $tab["bn_title"]?></a></td>
          <td class="stats_value">&nbsp;<?php echo $tab["totalthreads"]?></td>
          <td class="stats_value" nowrap>&nbsp;<?php echo $tab["totalnotes"]?> <?php echo $last_url?></td>
          <td class="stats_value">&nbsp;<?php echo $att_text?></td>
          <td class="stats_value">&nbsp;<?php echo (isset($tab["totalregisters"]))? $tab["totalregisters"] : "-";?></td>
		  <td class="stats_value">&nbsp;<?php echo $tab["totalauthors"]?></td>
		  <td class="stats_value">&nbsp;<?php echo $tab["totalsubscribes"]?></td>
          <td class="stats_value">&nbsp;<?php echo $tab["totalhits"]?></td>
        </tr><?php
	}?>
      </table>
    </td></tr></table><?php
}

/**
 * Display hit parade for the site
 * @param     $site		site to display
 * @param     $hit		hit parade to display
 * @param     $n		#lines to display
 * @access    public
 * @return    void
 */
function dspSiteHitParade($stat)
{
	global $ext, $agora_dir;
?>

    <table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
	 <tr class="stats_border"><td>
	  <table width="100%" border="0" cellspacing="1" cellpadding="4" align="center">
       <tr bgcolor="<?php echo $stat["title_color"]?>" align="center">
		<td class="stats_title"><?php echo $stat["title"]?></td>
	   </tr>
       <tr>
		<td class="stats_value">
		<div align="left"><ol>
<?php
	reset($stat);
	while (list($k,$line) = each ($stat) ) {
	    if (is_int($k)) {
	        echo "<li>$line</li>";
	    }
	}
?>        </ol>
		</div>
	     </td>
        </tr>
	   </table>
      </td></tr></table><?php
}

if (empty($site) || ($site=="agora") ) {
        header("Location: $agora_dir/admin.$ext");
        exit;
}

include "include/dbstats.$ext";
$stats =& new DBStats($db, $site);
$stats->updateStats();

$general_stats = siteGeneralStats($site);
$forum_stats = siteForumStats($site);
$hit_stats_1 = siteHitParade($site,1,10);
$hit_stats_2 = siteHitParade($site,2,10);
$hit_stats_3 = siteHitParade($site,3,10);
$to_find["hits"] = 1;
$to_find["logins"] = 1;
$to_find["posts"] = 1;
$to_find["subscribes"] = 1;
$to_find["visits"] = 1;
$month_stats = siteMonthStats ($site, $to_find);

$categories = $db->getCategories($site);
$site_title = $categories[0];

$db->closeDB();

display_header (sprintf(TITLE_STATS, $site_title), "$base_url");

?>

<div align="center">
 <small><strong><?php printf (LABEL_GENERATED_ON, $formated_date)?></strong></small>
 <hr noshade width="90%">
 <p>
 <small>
  <a href="#YEARSTATS" class="label"><?php echo LABEL_YEAR_STATS?></a>&nbsp;
  <a href="#FORUMSTATS" class="label"><?php echo LABEL_FORUM_SUMMARY?></a>&nbsp;
  <a href="#TOPTEN" class="label"><?php echo LABEL_TOP_TEN?></a>&nbsp;
  <a href="<?php echo "../admin_site.$ext?site=$site"?>" class="label" target="_top"><?php echo LABEL_ADMIN?></a>
 </small>
</div>

<!-- General stats -->
<p>
<h3><?php echo TITLE_GENERAL_STATS?></h3>
<center>
<?php dspSiteGeneralStats($general_stats)?>
</center>
</p>

<!-- Graph for month stats -->
<hr noshade width="90%">
<p>
<a name="YEARSTATS" />
<h3><?php echo TITLE_YEAR_ACTIVITY?></h3>

    <table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
	 <tr class="stats_border"><td>
      <table width="100%" border="0" cellspacing="1" cellpadding="10" align="center">
        <tr>
		  <td class="stats_title"><?php printf(TITLE_YEAR_GRAPH,$site)?></td>
		</tr>
        <tr bgcolor="white">
<?php
 $img1 = "wa_bar_graph.$ext?graph=yearstats&site=$site&width=680&height=200&hits=1";
 $img2 = "wa_bar_graph.$ext?graph=yearstats&site=$site&width=680&height=200&logins=1&visits=1&posts=1";
?>
          <td align="center">&nbsp;<img src="<?php echo $img1?>" align="absmiddle" alt="<?php printf(ALT_YEAR_IMG1, $site)?>" width="680" height="200"></td>
		</tr>
		<tr bgcolor="white">
		  <td align="center">&nbsp;<img src="<?php echo $img2?>" align="absmiddle" alt="<?php printf(ALT_YEAR_IMG2, $site)?>" width="680" height="200"></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
</p>

<!-- Month stats -->
<p>
<?php dspSiteMonthStats($month_stats)?>
</p>

<!-- Forum stats -->
<hr noshade width="90%">
<p>
<a name="FORUMSTATS">
<?php dspSiteForumStats($forum_stats)?>
</p>

<!-- Hit Parade -->
<hr noshade width="90%">
<p>
<a name="TOPTEN">
<h3><?php echo TITLE_TOP_TEN?></h3>
<table width="90%" border="0" cellspacing="1" cellpadding="1" align="center">
 <tr>
  <td width="33%" valign=top><?php dspSiteHitParade($hit_stats_1)?></td>
  <td width="33%" valign=top><?php dspSiteHitParade($hit_stats_2)?></td>
  <td width="33%" valign=top><?php dspSiteHitParade($hit_stats_3)?></td>
 </tr>
</table>
<?php
	display_footer();
?>
