<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: search.php,v 1.23 2005/11/02 21:39:58 mdruilhe Exp $
 *	Usage:		display search form or perform search in forum
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

	$bn_action="search";
	$bn_action_mode="R";

	require ("init.inc");

# A forum/site must be selected
# ------------------------
	if ($site=='agora') {
		die (ERROR_NO_SITE_SPECIFIED);
	}

	$where = ""; // must be defined in before_access
	$casesensitive = (empty($casesensitive)) ? 0 : 1;

# Execute before_access program
# ----------------------------
	if (!empty($before_access)) include $before_access;

	if (empty($bn) ) {
		$search_forums = $forums;
		unset ($search_forums[""]);
		$search_forums["ALL"] = LABEL_ALL_FORUMS;
		$search_forum_field = getListBox ("search_forum", $search_forums, "ALL", 0);
	} else {
		if (!$bn_search) {
			display_header ("", $header_footer);
			msgForm ("Sorry, search is not available into this forum ($bn)", "$main_page");
			display_footer ($header_footer);
		}
		$search_forums["$bn"] = LABEL_THIS_FORUM;
		$search_forums["ALL"] = LABEL_ALL_FORUMS;
		$search_forum_field = getListBox ("search_forum", $search_forums, "$bn", 0);
	}

	$search_users = $db->getAllUsers($site, 'username', 'lastpost>0');
	$search_users['ALL'] = LABEL_ALL_AUTHORS;
	$search_user_field = getListBox ('search_user', $search_users, 'ALL', 0);

	$search_dates = array(	
		0	=> LABEL_ALL_DATES,
		1	=> str_replace("{NB}", "", str_replace("{PERIOD}", LABEL_YESTERDAY, LABEL_SINCE_W_W)),
		7	=> str_replace("{NB}", "1", str_replace("{PERIOD}", LABEL_WEEK, LABEL_SINCE_W_W)),
		31	=> str_replace("{NB}", "1", str_replace("{PERIOD}", LABEL_MONTH, LABEL_SINCE_W_W)),
		182	=> str_replace("{NB}", "6", str_replace("{PERIOD}", LABEL_MONTHS, LABEL_SINCE_W_W)),
		385 => str_replace("{NB}", "1", str_replace("{PERIOD}", LABEL_YEAR, LABEL_SINCE_W_W)));
	
	$search_date_field = getListBox('search_date', $search_dates, 'ALL');

	display_header ("", $header_footer);

	if ($gosearch) {

		if ($bn_search_engine == "none" || $bn_doc_type != "static") {
			// search in database

			$userid = ($search_user == "ALL") ? "" : $search_user;
			$forum = ($search_forum == "ALL") ? "" : $search_forum;
			if ($search_date > 0) {
				$start_date = $now - ($search_date * 86400);
			    $where .= empty($where) ? "" : " AND ";
				$where .= "unixdate>$start_date";
			}

			if (!empty($userid) ) {
			    $where .= (empty($where)) ? "" : " AND ";
				$where .= "userid='$userid'";
			}
	
			include "$inc_dir/dbsearch.$ext";
			$search = new DBsearch;
			$pattern = htmlspecialchars(getFormVar('pattern'));

			if (is_array($_POST['search_fields']) ) {
				$search_in = array();
				while ( list( $key, $val ) = each($_POST['search_fields']) ) {
					if (!empty($val)) {
						if (is_string($key) ) {
							// using new 4.1.5 format (associative array:  ie.  <input type="checkbox" name="search_fields[subject]"> )
							$search_in[] = $key;
						} else {
							// old format (scalar array : ie.  <input type="checkbox" name="search_fields[0]" value="subject"> )
							$search_in[] = $val;
						}
				    }
				}
			} else {
				$search_in = array ('subject', 'body', 'username', 'useraddress');
			}

			$num = $search->search ($pattern, $forum, $search_mode, $search_in, $where, 0, $casesensitive);
			if ($num==0) {
			    printf(MSG_NO_MATCHES, $msg[0]);
			}
		} else {
			include "$inc_dir/$bn_search_engine.$ext";
			$search->search ($pattern, $casesensitive);
		}
	} else {
		beginForm();
		hiddenField ("gosearch", "1");
		if (!empty($bn_search_form)) {
			include "$bn_dir/$bn_search_form";
		} elseif (file_exists("$bn_dir_default/search_form.$ext") ) {
			include ("$bn_dir_default/search_form.$ext");
		} else {
			include "$tmpl_dir/default/agora/search_form.$ext";
		}
		endForm();
	}

# Display footer
# --------------
	display_footer ($header_footer);
?>
