<?PHP

/*
 * W-AGORA 4.1
 * -----------
 * $Id: admin_nl.inc,v 1.8 2005/02/09 15:20:22 mdruilhe Exp $
 * Usage: Administration localized strings constant
 * Description: This script is used to define strings used by the administration part of the application
 * Author: Alexandre GHEZ (aghez@decan.fr)
 * Translator: Joke Bekkering (joke.bekkering@xs4all.nl)
 */

 ///////////////////
 // file setup.php3
 ///////////////////
 define ('ERROR_SETUP_ALREADY_DONE', 'w-Agora is waarschijnlijk al geinstalleerd,<br> de configuratie file (<tt>%s</tt>) bestaat al,<br> om opnieuw te installeren moet de configuratie file en de DB tabellen handmatig worden verwijderd.<br><br>Druk op de knop om een nieuwe site aan te maken.');
 define ('ERROR_MISSING_ADMIN_NAME', 'De naam voor de system administrator ontbreekt');
 define ('ERROR_MISSING_ADMIN_EMAIL', 'Ongeldig email adres');
 define ('ERROR_MISSING_DB_ACCESS', 'DB access mode ontbreekt');
 define ('ERROR_BAD_PASSWORD', 'verifieer svp dat het paswoord tweemaal is opgegeven');
 define ('ERROR_MISSING_DB_NAME', 'Naam databse ontbreekt');
 define ('ERROR_SF_CREATE_FILE', 'Kan niet schrijven naar directory <u>%s</u>, controleer svp de schrijfrechten, of lees de safe mode instructies in de <a href="doc/INSTALL.txt">INSTALL.txt file</a>');
 define ('ERROR_COPY_FILE', 'File kan niet worden gekopieerd naar<u>%s</u>');
 define ('ERROR_OPEN_DB', 'Geen verbinding met database <u>%s</u> (host: <u>%s</u>, port: <u>%s</u>, user: <u>%s</u>)');
 define ('ERROR_CREATE_CONFIG_FILE', 'Kan configuratie file <u>%s</u> niet aanmaken, controleer schrijfrechten');
 define ('LABEL_SETUP_DONE', 'w-agora is geinstalleerd');
 define ('LABEL_SETUP_AGORA', 'installatie w-agora');

 define ('CAPTION_DB_PARAMETERS', 'Database parameters (voor site tabellen)');
 define ('CAPTION_DEFAULT_PARAMETERS', 'Default parameters voor configuratie van sites');
 define ('CAPTION_ADMIN_INFO', 'System Administrator\'s Informations (login : <u>admin</u>)');

 define ('LABEL_ADMIN_NAME', 'Naam');
 define ('LABEL_ADMIN_ADDRESS', 'e-mail');
 define ('LABEL_ADMIN_PASSWORD1', 'Kies een paswoord');
 define ('LABEL_ADMIN_PASSWORD2', 'Kies een paswoord (opnieuw)');
 define ('BUTTON_INSTALL', 'Installeren');

 /////////////////////
 //File Init_Admin.inc
 /////////////////////

 // function display_header
 define ('ADMINISTRATION_TITLE', "W-Agora administratie");

 // function list_forums
 define (COLUMN_FORUM_ADMIN, "Forum");
 define (COLUMN_EDIT, "Wijzig");
 define (COLUMN_DELETE, "Verwijder");
 define (COLUMN_CREATE, "Aanmaken");
 define ('COLUMN_ORDER', "Volgnummer");

 define ('MSG_ADMINISTRATE_FORUM', "Beheer forum");
 define ('ALT_DELETE_FORUM', "Verwijder forum : %s");
 define ('ALT_EDIT_FORUM', "Wijzig forum : %s");

 define ('ERROR_SITE_EMPTY', "Je moet een site specificeren om hier binnen te komen.");
 define ('ERROR_NO_CONFIG_FILE', "Geen toegang tot configuratie file: ");
 define ('ERROR_NO_ROOT', "Alleen de system administrator heeft hier authorisatie voor.");
 define ('ERROR_NO_ADMIN', "Alleen de administrators hebben hier authorisatie voor.");
 define ('ERROR_NO_MODERATOR', "Sorry, je bent geen moderator van dit forum, svp opnieuw inloggen.");

 define ('TITLE_ADMINISTRATION_LOGIN', "Administratie login");
 define ('TITLE_INVALID_LOGIN', "Onjuiste gegevens, svp opnieuw inloggen");

 define ('ERROR_NO_DATABASE', "Geen toegang tot database, check parameters.");

 //Function List User
 define ('COLUMN_USER_ID', "Id");
 define ('COLUMN_USER_NAME', "Naam");
 define ('COLUMN_USER_PRIVILEGE', "Functie");
 define ('COLUMN_USER_REGISTERED', "Registratie");
 define ('COLUMN_USER_LOGIN_COUNT', "# Logins");
 define ('COLUMN_USER_LAST_LOGIN', "Laatste login");
 define ('COLUMN_USER_POST_COUNT', "# Postings");
 define ('COLUMN_USER_LAST_POST', "Laatste Posting");
 define ('COLUMN_ACTION', "<trans>Action");

 define ('LABEL_REG_NO_CONTROL',"Automatic registration");
 define ('LABEL_REG_CHALLENGE_RESPONSE',"RFU");	
 define ('LABEL_REG_ADMIN_APPROVAL',"Approved by administrators");

 /////////////////////
 //File Create_Site.php3
 /////////////////////
 define ('FORM_NO_SITE', "Naam site ontbreekt.");
 define ('FORM_NO_DESCRIPTION', "Omschrijving van de site ontbreekt.");
 define ('FORM_NO_DBACCESS', "Access mode ontbreekt.");
 define ('FORM_NO_DBNAME', "Naam database ontbreekt.");
 define ('FORM_NO_DIRECTORY', "Forum directory naam ontbreekt.");
 define ('FORM_SITE_LONG', "Site naam is te lang, kies svp een kortere naam.");

 define ('CHECK_SITE_EXISTS', "Site {SITE} bestaat al, verwijder deze handmatig of kies een andere naam.");
 define ('CHECK_CONFIG_EXISTS', "Configuratie file (<tt>%s</tt>) bestaat al, verwijder deze handmatig of kies een andere naam.");

 define ('ERROR_SAFE_MODE', 'SAFE MODE is enabled, het kan zijn dat de directory: {DIRECTORY} handmatig moet worden aangemaakt');
 define ('ERROR_CREATE_DIR', "Kan directory niet aanmaken: {DIRECTORY}.");
 define ('ERROR_NO_PERMISSIONS', "Controleer schrijfrechten");

 define ('ERROR_ADMIN_NOT_FOUND', "Kan gebruiker 'admin' niet van main agora site halen");

 define ('ERROR_DB_DBM_EXISTS', "Forum's database {SITE} bestaat al,<br> verwijder svp handmatig de DBM file: <em>dbm/{SITE}/{DATABASE}</em><br> [en de lockfile .lck] .");
 define ('ERROR_DB_EXISTS', "The forum's table {SITE} bestaat al in deze database {DATABASE}, verwijder deze svp handmatig.");
 define ('ERROR_FILESYSTEM', "Probleem met toegang tot schijf, controleer ruimtegebruik en authorisaties.");
 define ('ERROR_DB_ACCESS', "Probleem met toegang tot database, controleer of een database genaamd {DATABASE} is aangemaakt en controleer de toegangsrechten");

 define ('ERROR_CREATE_SITE', "Kan de site: {SITE} niet aanmaken.");

 define ('ERROR_TABLE_EXISTS', "De tabel {TABLE} bestaat al in database {DATABASE}, verwijder deze svp handmatig.");

 define ('ERROR_CREATE_ADMIN', "Kan gebruiker {USER} niet aanmaken in de nieuwe site.");
 define ('ERROR_CREATE_USER', "Kan gebruiker {USER} niet aanmaken in de tabel {TABLE}.");
 define ('ERROR_NO_ADD_SITE', "Kan site niet toevoegen aan database.");

 define ('LABEL_BACK', "Terug");
 define ('LABEL_CREATE_SITE_DONE', "De site {SITE} is aangemaakt. <BR><BR>&nbsp;&nbsp;Kies nu een van de volgende mogelijkheden");
 define ('LABEL_CREATE_FORUM', "Forum aanmaken in deze site");
 define ('LABEL_CREATE_SITE', "Andere site aanmaken");
 define ('LABEL_CREATE_THIS_SITE', "Site aanmaken");
 define ('LABEL_CREATE_NEW_SITE', "Nieuwe site aanmaken");
 define ('LABEL_CREATE_ANOTHER_SITE', "Andere site aanmaken");
 define ('LABEL_ADMINISTRATE_SITE', "Site beheren");
 define ('LABEL_SITE_MANAGEMENT', "Site management");
 define ('CREATE_SITE_DONE', "Site {SITE} is aangemaakt.");

 define ('LABEL_SITE_NAME', "Site naam");
 define ('LABEL_SITE_TITLE', "Titel (korte omschrijving)");
 define ('LABEL_SITE_DESCRIPTION', "Omschrijving");
 define ('LABEL_DB_PARAMETERS', "Database parameters");
 define ('LABEL_DB_TYPE', "Database type");
 define ('LABEL_DB_NAME', "Database name");

 define ('LABEL_DB_USER', "Database user");
 define ('LABEL_DB_PASSWORD', "Database password");

 define ('LABEL_DB_ADMIN_USER', "Database admin user (indien leeg: DB user invullen)");
 define ('LABEL_DB_ADMIN_PASSWORD', "Database admin paswoord");
 define ('LABEL_DB_SERVER_NAME', "Server naam");
 define ('LABEL_DB_SERVER_PORT', "Server port");
 define ('LABEL_DB_USER_SOURCE', "User source");

 define ('LABEL_FORUMS_CONFIGURATION', "Forums instellingen");

 define ('LABEL_FORUM_DIRECTORY', "Forums directory");
 define ('LABEL_SEARCH_ENGINE', "Zoekmachine");
 define ('LABEL_DEFAULT_THEME', "Default template");
 define ('NOTICE_SAFEMODE', "SAFE MODE enabled.");
 define ('NOTICE_MANUAL_INSTALL', 'de volgende directories moeten handmatig worden aangemaakt:');

 /////////////////////
 //File Admin.php3
 /////////////////////
 define ('TITLE_SITE_MANAGEMENT', "Administratie sites");
 define ('LABEL_SITES_OUTLINE', "Sites outline");
 define ('COLUMN_SITE_TITLE', "Onderwerp (titel)");

 define ('ALT_DELETE_SITE', "Verwijder site : %s");
 define ('ALT_EDIT_SITE', "Wijzig site : %s");
 define ('ERROR_NO_SITE', "Geen sites aanwezig,<br> Klik op 'OK' om een site aan te maken.");

 /////////////////////
 //File Delete_Site.php3
 /////////////////////
 define ('TITLE_SITE_DELETE', "Verwijder site");
 define ('ERROR_NO_DELETE', "Let op: Niet alle tabellen en bestanden van {SITE} konden worden verwijderd");
 define ('ERROR_NO_DELETE_AGORA', "could not remove entry for the site {SITE} in the agora database");
 define ('LABEL_FILE_REMOVING', "Bezig met verwijderen van file: ");
 define ('LABEL_DIRECTORY_REMOVING', "Bezig met verwijderen van directory: ");
 define ('LABEL_SITE_REMOVING', "Site {SITE} is verwijderd.");
 define ('LABEL_SITE_CONTENT', "Deze site bevat de volgende forums:");
 define ('LABEL_SITE_NO_CONTENT', "Deze site bevat geen forum");
 define ('LABEL_SITE_DELETE_CONFIRMATION', "Weet je zeker dat de site '{SITE}' moet worden verwijderd ?");
 define ('LABEL_DELETE_THIS_SITE', "Verwijder deze site");

 /////////////////////
 //File Edit_Site.php3
 /////////////////////
 define ('TITLE_SITE_EDIT', "Wijzig site");
 define ('ERROR_NO_READ_SITE_PROPERTIES', "Could not access {SITE} description.");
 define ('ERROR_NO_UPDATE_SITE_PROPERTIES', "Could not update characteristics of site {SITE}.");
 define ('LABEL_SITE_EDITING', "Bezig met wijzigen van site: ");
 define ('LABEL_SITE_PROPERTIES', "Site informatie");
 define ('LABEL_CHANGE_SITE_ADMINISTRATOR', "Kies de gebruiker die de hoofd-administrator van deze site wordt");
 define ('COLUMN_SITE_REGISTRATION_MODE',"Registration mode");
 define ('COLUMN_SITE_PASSWORD_HANDLING',"Password handling");

 /////////////////////
 //File editList.php3
 /////////////////////
 define ('NOTICE_DEFAULT_FILE', "Let op: deze file is de default file");
 define ('ERROR_NO_CURRENT_FILE', "No current file");
 define ('ERROR_OPEN_FILE', "Kan file {FILE} niet openen");

 define ('LABEL_MAXTHREADS', "Maximum aantal onderwerpen per pagina"); 
 define ('LABEL_PAD', "Padding sequence used for indentation");
 define ('LABEL_DEPTH_LIMIT', "Thread depth displaying limit");
 define ('LABEL_BEFORE_LINE', "Script dat wordt uitgevoerd voor elke regel");
 define ('LABEL_SORT', "Default volgorde");
 define ('LABEL_HOT_COLOR', "Kleur nieuwste berichten, initialiseer {date_color} met: " );
 define ('LABEL_NEW_COLOR', "Kleur recente berichten, initialiseer {date_color} met: " );
 define ('LABEL_NORMAL_COLOR', "Kleur oude berichten, initialiseer {date_color} met:  ");
 define ('LABEL_HOT_AGE', "Aantal seconden voor nieuwste berichten" );
 define ('LABEL_NEW_AGE', "Aantal seconden voor recente berichten");
 define ('LABEL_HOT_THRESHOLD', "Hot Topic drempel (Meer dan xx berichten, 0 = niet in gebruik)");
 define ('LABEL_TYPE_FILENAME', "Enter file naam");
 define ('TITLE_SITE_OUTLINE', "Wijzigen indeling sites lijst");
 define ('TITLE_FORUM_OUTLINE', "Wijzigen indeling forums lijst");
 define ('TITLE_MESSAGE_OUTLINE', "Wijzigen indeling berichten lijst");
 define ('LABEL_FILE_EDITING', "Wijzigen van file");
 define ('LABEL_THREAD_FIRSTLINE_ODD', "Eerste regel in ONDERWERP (oneven)");
 define ('LABEL_THREAD_FIRSTLINE_EVEN', "Eerste regel in ONDERWERP (even)");
 define ('LABEL_LEVEL_START', "Nieuw NIVEAU begint met");
 define ('LABEL_LEVEL_END', "Niveau eindigt met");
 define ('LABEL_LINE_CONTENT_ODD', "Inhoud antwoord regel (oneven)");
 define ('LABEL_LINE_CONTENT_EVEN', "Inhoud antwoord regel (even)");
 define ('LABEL_THREAD_END', "Onderwerp eindigt met");
 define ('LABEL_LIST_END', "Einde van de lijst");

 define ('LABEL_GLOBAL_FORMAT', "Algemene instellingen");
 define ('LABEL_DEFAULT_ORDER', "Default volgorde (in no-threaded mode)");
 define ('LABEL_USE_COLOR', "Kleurgebruik");
 define ('LABEL_NEWEST_MESSAGE', "Nieuwste berichten");
 define ('LABEL_NEW_MESSAGE', "Recente berichten");
 define ('LABEL_OLD_MESSAGE', "Oude berichten");
 define ('LABEL_MESSAGES_NEWER_THAN', "berichten nieuwer dan");
 define ('LABEL_FORUM_OUTLINE', "Instellingen forum lijst");
 define ('LABEL_HEAD_LISTING', "Kop van tabel");
 define ('LABEL_CATEGORY_LINE', "Categorie subkop");

 define ('LABEL_SITE_LINE_ODD', "Site regel (oneven)");
 define ('LABEL_SITE_LINE_EVEN', "Site regel (even)");

 define ('LABEL_FORUM_LINE_ODD', "Forum regel (oneven)");
 define ('LABEL_FORUM_LINE_EVEN', "Forum regel (even)");
 define ('LABEL_BOTTOM_LISTING', "Lijst eindigt met:");

 define ('EDIT_THREAD_LIST', "Instellingen lijst van onderwerpen (LIST mode): ");
 define ('LABEL_EDIT_SEARCH_LISTING' , "Instellingen pagina ZOEKRESULTATEN: ");
 define ('LABEL_SEARCH_FORM_TITLE', "Forum titel (bij multi-forum zoeken):");

 define ('EDIT_THREAD_VIEW', "Instellingen lijst van antwoorden op bericht (VIEW mode): ");
 define ('LABEL_FIRST_THREAD', "Eerste bericht");
 define ('EDIT_THREAD_DOWNLOAD', "Instellingen lijst in <B>DOWNLOAD</B> mode:");

 /////////////////////
 //File Admin_Site.php3
 /////////////////////
 define ('LABEL_AGORA_WEBSITE', 'W-Agora Web Site');
 define ('TITLE_SITE_ADMINISTRATION', 'Beheer van site');
 define ('LABEL_RELOGIN', 'Opnieuw inloggen (andere gebruiker)');
 define ('LABEL_SITES', 'Sites lijst');
 define ('LABEL_ADMINISTRATION_MAIN', 'Terug naar het administratie hoofdmenu');
 define ('ALT_STATS', 'Toon statistieken voor de site %s');
 define ('LABEL_ACCESS_THIS_SITE', 'Ga naar deze site');
 define ('ALT_ACCESS_SITE', 'ga naar site %s als gebruiker');

 define ('LABEL_CATEGORIES', "Categorieen");
 define ('COLUMN_ADMIN_USERS', "Beheren gebruikers");
 define ('COLUMN_INACTIVE_USERS', "Inactieve gebruikers");
 define ('COLUMN_MAIL_USERS', "Mail gebruikers");

 define ('ALT_USER_EDIT', "Wijzig gebruikers");
 define ('ALT_USER_ADMIN', "Beheren geregistreerde gebruikers");
 define ('ALT_USER_ADD', "Gebruiker toevoegen");
 define ('ALT_USER_DELETE', "Gebruiker verwijderen");
 define ('ALT_INACTIVE_USERS', "Niet actieve gebruikers verwijderen");
 define ('ALT_MAIL_USERS', "Mail gebruikers");
 define ('ALT_CATEGORY_CREATE', "Categorie toevoegen");
 define ('ALT_CATEGORY_EDIT', "Categorie wijzigen");

 define ('COLUMN_MANAGE_FORUM', "Beheer forums");
 define ('COLUMN_CHANGE_ORDER', "Volgorde wijzigen");

 define ('ALT_FORUM_MANAGE', "Forum beheren");
 define ('ALT_FORUM_CREATE', "Forum aanmaken");
 define ('ALT_FORUM_ORDER', "Wijzig de volgorde waarin de forums worden getoond");

 define ('LABEL_FORUM_LAYOUT', "Layout forums lijst");

 define ('LABEL_SITECONF', 'Instellingen');
 define ('LABEL_STYLESHEET', 'Style sheet');
 define ('LABEL_HEADER', 'Koptekst');
 define ('LABEL_FORUM_LIST', 'Forums lijst');
 define ('LABEL_FOOTER', 'Voettekst');
 define ('LABEL_MESSAGES', 'Meldingen');

 define ('ALT_SITECONF', 'Algemene instellingen van de forum lijst(BODY, date format, ...)');
 define ('ALT_MODIFY_STYLESHEET', 'Wijzig Style sheet (CSS) file');
 define ('ALT_HEADER', 'Wijzig de koptekst van de forums lijst');
 define ('ALT_FOOTER', 'Wijzig de voettekst van de forums lijst');
 define ('ALT_FORUM_LIST', 'Wijzig de layout van de forums lijst');
 define ('ALT_MESSAGES', 'Wijzig teksten, meldingen, en plaatjes in de forums lijst');

 define ('LABEL_DEFAULT_TEMPLATES', "Site default templates");

 define ('COLUMN_PROFILE', "Toon gebruikersprofiel");
 define ('COLUMN_LOGIN', "Login formulier");
 define ('COLUMN_REGISTER', "Registratie formulier");
 define ('COLUMN_CHANGE_PASSWORD', "Formulier nieuw paswoord");
 define ('COLUMN_FORGOT_PASSWORD', "Formulier paswoord vergeten");
 define ('COLUMN_MAIL', "Mail templates");
 define ('COLUMN_SUBSCRIBING', "Formulier mail abonnement");

 define ('ALT_PROFILE_FORM', "Wijzigen profiel template");
 define ('ALT_LOGIN_FORM', "Wijzigen login formulier");
 define ('ALT_REGISTER_FORM', "Wijzigen registratie formulier");
 define ('ALT_CHANGE_PASSWORD_FORM', "Wijzigen formulier nieuw paswoord");
 define ('ALT_FORGOT_PASSWORD', "Wijzigen formulier paswoord vergeten");
 define ('ALT_MAIL_TEMPLATE', "Mail instellingen en templates");
 define ('ALT_SUBSCRIBE_FORM', "Wijzigen formulier mail abonnement");

 define ('LABEL_USER_TEMPLATES', "Templates gebruikersbeheer");
 define ('COLUMN_USER_FIELDS', "Database velden");
 define ('ALT_USER_FIELDS', "Wijzigen / toevoegen velden gebruikersprofiel");

 /////////////////////
 //File admin_Forum.php3
 /////////////////////
 define ('TITLE_FORUM_ADMINISTRATION', "Forum administratie (Site: %s)");
 define ('LABEL_CHOOSE_FORUM', "Kies een forum om te beheren / wijzigen / verwijderen");
 define ('ERROR_NO_FORUM_ADMIN', "Geen forum in site '%s',<br> klik op 'OK' om een forum aan te maken.");
 define ('ERROR_NO_FORUM', "Er is geen forum beschikbaar in de site '{SITE}' waar jij verantwoordelijk voor bent.");
 define ('LABEL_FORUM_ADMINISTRATION', "Administratie van forum ");
 define ('LABEL_SITE', "Site ");
 define ('LABEL_FORUM', "Forum");
 define ('LABEL_FORUM_ACCESS', "Ga naar forum ");
 define ('LABEL_ACCESS_THIS_FORUM', "Ga naar dit forum");
 define ('ALT_ADMINISTRATION_SITE', 'Terug naar administratie van de site %s');

 define ('TITLE_NOTES_MANAGEMENT', "Beheer postings");
 define ('LABEL_EDIT_NOTES', "Postings bewerken");
 define ('LABEL_MANAGE_THREADS', "Beheer onderwerpen");
 define ('LABEL_POST_MSG', "Posting toevoegen");

 define ('ALT_EDIT_NOTES', "Verwijderen/wijzigen postings");
 define ('ALT_MANAGE_THREADS', "Verwijderen - kopieren - verplaatsen discussie-onderwerpen");
 define ('ALT_POST', "Posting toevoegen");

 define ('LABEL_ADD_USER', "Toevoegen aan dit forum");
 define ('COLUMN_SHOWEDIT', "Weergeven/Wijzigen");
 define ('ALT_USER_SHOWEDIT', "Bekijk-wijzig geregistreerde/wachtende gebruikers");
 define ('ALT_USER_CREATE', "Gebruiker toevoegen");

 define ('LABEL_CONFIGURATION', "Instellingen");
 define ('LABEL_BASIC', "Basis");
 define ('LABEL_ADVANCED', "Uitgebreid");
 define ('LABEL_PROPERTIES', "Eigenschappen");

 define ('ALT_BASIC', "Wijzigen basis instellingen");
 define ('ALT_ADVANCED', "Wijzigen uitgebreide instellingen");
 define ('ALT_PROPERTIES', "Wijzigen forum eigenschappen");

 define ('LABEL_LAYOUT', "Layout/Templates");

 define ('COLUMN_NOTES_LISTING', "Lijst van berichten");
 define ('COLUMN_FORM', "Formulier");
 define ('COLUMN_MAIL_FORM',"Mail form");
 define ('COLUMN_FIELDS', "Velden");
 define ('COLUMN_TEMPLATE', "Template");
 define ('COLUMN_SEARCH_FORM', "Zoekformulier");
 define ('COLUMN_INCLUDED', "Included script");
 define ('COLUMN_PROFILE_FORM', "Profiel formulier");
 define ('ALT_INCLUDED', "php3 script dat wordt uitgevoerd voor toegang tot het forum");
 define ('ALT_TEMPLATE', "Wijzigen HTML template voor postings");
 define ('ALT_FIELDS', "Wijzigen Database velden");
 define ('ALT_SEARCH_FORM', "Wijzigen zoekformulier");
 define ('ALT_FORM', "Wijzigen HTML formulier voor aanmaken/wijzigen van postings");
 define ('ALT_MAIL_FORM', "Edit the form used to send private mails");
 define ('ALT_NOTES_LISTING', "Wijzigen lijst van berichten");
 define ('ALT_AGORA_MESSAGES', "Wijzigen meldingen van W-Agora");

define('LABEL_MASS_EDIT_FORUMS_DONE', '<trans>mass update has been done on all forums!');
define('TITLE_MASS_EDIT_FORUMS', '<trans>Edit settings on all forums');
define('MSG_MASS_EDIT_FORUMS', '<trans>This form enables you to edit some settings on all forums at the same time');
define('LABEL_MASS_EDIT_FORUM_STATE', '<trans>Forum state');
define('LABEL_MASS_EDIT_FORUM_ACCESS', '<trans>Access mode');
define('LABEL_MASS_EDIT_FORUM_MODERATED', '<trans>Moderated forums');
define('BUTTON_UPDATE_ALL_FORUMS', '<trans>Apply changes to all forums');

 /////////////////////
 //File Moderate_Notes.php3
 /////////////////////
 define ('TITLE_MODERATE_NOTES', 'Goedkeuren nieuwe postings');
 define ('ERROR_NO_INCOMING', 'In dit forum zijn geen postings die nog moeten worden goedgekeurd');
 define ('LABEL_MESSAGE_DELETE_CONFIRMATION', 'Moet deze posting werkeleijk worden verwijderd?');
 define ('CAPTION_VALIDATE_DELETE_MESSAGE', 'Klik op de posting die moet worden verwijderd of gewijzigd.');
 define ('CAPTION_MESSAGE_ACTION', 'Wat moet er gebeuren met deze posting.');
 define ('LABEL_VALIDATE', 'Goedkeuren');
 define ('LABEL_DELETE', 'Verwijderen');

 /////////////////////
 //Admin_Notes.php3
 /////////////////////
 define ('LABEL_DELETE_FOL_NOTES', "De volgende postings worden verwijderd");
 define ('LABEL_NOTES_IN_FORUM', "Postings in forum <font color=red>%s</font>");
 define ('LABEL_NO_FORM', "Geen formulier gedefinieerd voor dit forum");
 define ('LABEL_EDIT_NOTE', "Een posting wijzigen:");
 define ('LABEL_DISPLAY_NOTES', "Toon postings");
 define ('LABEL_ALL_NOTES', "Alle postings");
 define ('LABEL_HIDDEN', "Verborgen");
 define ('LABEL_VISIBLE', "Zichtbaar"); 
 define ('COLUMN_SHOW_NOTE', "Toon");
 define ('COLUMN_HIDE_NOTE', "Verberg");
 define ('ALT_DELETE_NOTE', "Deze posting verwijderen");
 define ('ALT_EDIT_NOTE', "Deze posting wijzigen");
 define ('ALT_POPUP', "Pop-up");

 define ('LABEL_COPY_FOL_NOTES', "<trans>The following notes (with ALL replies) will be copied/moved");
 define ('ACTION_MESSAGES_DELETE', "<trans>Delete selected notes");
 define ('ACTION_MESSAGES_COPY', "<trans>Copy selected notes to another thread into forum");
 define ('ERROR_DELETE_NOTE', "<trans>Couldn't delete message {NOTE} from forum {FORUM}");
 define ('LABEL_SELECT_DEST_THREAD', "<trans>Select note to attach messages");
 define ('ERROR_COPY_NOTE', "<trans>Couldn't copy note {NOTE} into forum {FORUM}");
 define ('ACTION_MESSAGES_MOVE', "<trans>[Move notes]");
 define ('ERROR_NO_DEST_FORUM', "<trans>Error: you must specify the destination forum.");
 define ('TITLE_COPY_NOTES', "<trans>Copying/moving messages");
 define ('OPEN_NEW_THREAD', "<trans>Open new thread");

 /////////////////////
 //Delete_Notes.php3
 /////////////////////
 define ('TITLE_DELETE_NOTES', "Een posting verwijderen");
 define ('CAPTION_SELECT_NOTES', "Selecteer postings om te wijzigen/verwijderen");
 define ('LABEL_DELETE_THIS', "Bezig met verwijderen");
 define ('CAPTION_SELECT_NOTES_DELETED', "Selecteer postings om te verwijderen");

 /////////////////////
 //Delete_Threads.php3
 /////////////////////
 define ('ERROR_INCORRECT_DATES', "Incorrecte datum");
 define ('ERROR_NO_PERIOD', "Selecteer svp een aantal dagen/weken/maanden");
 define ('ERROR_NO_NOTES_OLDER', "Geen posting gevonden ouder dan {NUMBER} {UNIT}.");
 define ('CONFIRM_THREAD_MOVE', "Wil je de onderwerpen verplaatsen naar forum \"{FORUM}\" ?");
 define ('CONFIRM_THREAD_COPY', "Wil je de onderwerpen kopieren naar forum \"{FORUM}\" ?");
 define ('CONFIRM_DELETE_THREAD', '%s threads will be removed, are you sure ? ');
 define ('CONFIRM_DELETE_THREAD_DATE', 'Are your sure to delete all threads between %s and %s');
 define ('ERROR_NO_THREAD', "Geen onderwerp geselecteerd");
 define ('LABEL_COPYING_NOTES', "bezig met kopieren van postings naar {FORUM}...");

 define ('ERROR_PARENT_NOT_FOUND', "Kon bericht niet toevoegen, parent niet gevonden");
 define ('ERROR_COPY_THREAD', "Kon het onderwerp {THREAD} niet kopieren in forum {FORUM}");
 define ('ERROR_DELETE_THREAD', "Kon het onderwerp {THREAD} niet verwijderen uit forum {FORUM}");
 define ('ERROR_INSERT_ATTTACHMENT', "Kon bijlage '{NAME}' voor bericht '{CLE}' niet toevoegen aan forum '{FORUM}'");

 define ('TITLE_MANAGE_THREADS', "Verwijderen/kopieren/verplaatsen onderwerpen");
 define ('CAPTION_SELECT_THREAD', "Geen onderwerp geselecteerd");
 define ('LABEL_SELECT_THREAD', "Selecteer de onderwerpen die worden verwijderd of gekopieerd/verplaatst naar een ander forum");
 define ('LABEL_SELECT_THREAD_OR_DATE', "Selecteer onderwerpen of kies een groep onderwerpen");
 define ('LABEL_SELECT_INDIVIDUAL_THREAD', "Selecteer individuele onderwerpen");
 define ('LABEL_EXECUTE', "Uitvoeren");
 define ('LABEL_THREAD_BETWEEN', "Selecteer onderwerpen tussen");
 define ('LABEL_THREAD_OLDER', "Selecteer onderwerpen ouder dan: ");
 define ('LABEL_SELECT_ACTION', "Kies een bewerking");
 define ('ACTION_THREAD_DELETE', "Verwijderen geselecteerde onderwerpen");
 define ('ACTION_THREAD_MOVE', "verplaatsen (verwijderen na kopieren)");
 define ('ACTION_THREAD_COPY', "Kopieer geselcteerde onderwerpen naar forum : ");
 define ('LABEL_REPLIES', "reacties");

 /////////////////////
 //Admin_User.php3
 /////////////////////
 define ('TITLE_SITE_USER_ADMIN', "Beheer gebruikers in site \"{SITE}\"");
 define ('TITLE_FORUM_USER_ADMIN', "Beheer gebruikers in forum \"{FORUM}\"");
 define ('TITLE_SELECT_USERS', "Selecteer gebruikers");
 define ('TITLE_MAIL_USERS', "Mail opstellen en verzenden naar <font color=blue>%s</font>");
 define ('LABEL_CHOOSE_USERID_INIT', "Kies een beginletter");
 define ('LABEL_CHOOSE_USERID_PATTERN', "Of geef een zoekpatroon");
 define ('LABEL_BY_NAME', "<b>Op naam</b>");
 define ('LABEL_BY_ACTIVITY', "<b>Op activiteit</b>");
 define ('LABEL_SHOW_NO_POST', "Toon gebruikers die nooit posten...");
 define ('LABEL_SHOW_NO_LOGIN', "Toon gebruikers die nooit inloggen...");
 define ('LABEL_SHOW_DIDNT_POST', "Toon gebruikers die niet meer posten sinds...");
 define ('LABEL_SHOW_DIDNT_LOGIN', "Toon gebruikers die niet meer inloggen sinds......");
 define ('LABEL_SHOW_IN_STATE', "Toon gebruikers met status: ");
 define ('LABEL_NOT_REGISTERED', "<trans>Not Registered");
 define ('LABEL_USERS_IN_STATE', "Gebruikers met status: <font color=blue>%s</font> ");
 define ('LABEL_USERS_BEGINING', "Gebruikers waarvan ID of naam begint met <font color=blue>%s</font> ");
 define ('LABEL_USERS_NEVER_POST', "Gebruikers die nooit posten ");
 define ('LABEL_USERS_NEVER_LOGIN', "Gebruikers die nooit inloggen");
 define ('LABEL_USERS_DIDNT_POST', "Gebruikers die niet meer posten sinds <font color=blue>%s %s</font> ");
 define ('LABEL_USERS_DIDNT_LOGIN', "Gebruikers die niet meer inloggen sinds <font color=blue>%s %s</font> ");
 define ('LABEL_REG_USERS_FORUM', "in forum <font color=red>%s</font>");
 define ('LABEL_REG_USERS_SITE', "in site <font color=red>%s</font>");
 define ('LABEL_CONFIRM_USER_DELETE', "Moeten deze gebruikers worden verwijderd?");
 define ('LABEL_DELETE_THESE_USERS', "Verwijder deze gebruikers");
 define ('LABEL_USER_CONFIRM_DELETE', "Gebruiker <font color=blue>%s</font> is verwijderd");
 define ('LABEL_RETURN_LIST', "Terug naar gebruikerslijst");
 define ('LABEL_EDIT_MAIL_PROFILE', "Mail profiel naar gebruiker <font color=blue>%s</font>");
 define ('LABEL_TO', "Aan");
 define ('LABEL_SEND', "Zend mail");
 define ('LABEL_REG_USER_FORUM', "Je bent geregistreerd in dit forum");
 define ('LABEL_NO_REG_USER_FORUM', "Je bent niet geregistreerd in dit forum");
 define ('LABEL_MAIL_USER_OK', "Mail verstuurd aan gebruiker(s) <font color=blue>%s</font>");
 define ('LABEL_MAIL_USER_NO_OK', "Kon geen mail versturen aan gebruiker(s) <font color=blue>%s</font>");
 define ('ERROR_NO_USER_MATCHING', "Geen gebruiker die voldoet aan (<font color=blue>%s</font>)");
 define ('ERROR_NO_REMOVE_PRIVILEGE', "Je hebt geen authorisatie om gebruiker <font color=blue>%s</font> te verwijderen");
 define ('ERROR_NO_EDIT_PRIVILEGE', "Je hebt geen authorisatie om gebruiker <font color=blue>%s</font> te wijzigen");
 define ('ERROR_NO_REMOVE_PERMISSION', "Gebruiker <font color=blue>%s</font> heeft toegang tot forum (%s) waarvoor jij geen moderator authorisatie hebt,<bR> je kunt deze gebruiker niet verwijderen");
 define ('ERROR_SITE_USER_DELETE', "Het is niet mogelijk om gebruiker <font color=blue>%s</font> te verwijderen uit site %s");
 define ('LABEL_STATUS', "Status");
 define ('ERROR_NO_MATCHING_USERS', "Geen gebruikers gevonden ");
 define ('ERROR_NO_MATCHING_USER', "Gebruiker %s bestaat niet in deze site");
 define ('ERROR_NO_OWNER_UPDATE', "Kon de eigenaar van forum %s in site %s niet aanpassen");
 define ('ERROR_NO_SITE_USER_UPDATE', "Kon gebruiker {FORUM} in site {SITE} niet aanpassen");
 define ('TITLE_EDITING_USER', "Wijzigen eigenschappen gebruiker ");
 define ('LABEL_IN_SITE', "in site");
 define ('COLUMN_USER_EMAIL', "E-mail");
 define ('COLUMN_USER_WEBPAGE', "Home page");
 define ('COLUMN_USER_DESCRIPTION', "Omschrijving");
 define ('COLUMN_USER_LASTLOGIN', "Laatste login");
 define ('COLUMN_USER_MAILOK', "E-mail OK");
 define ('COLUMN_USER_COUNTRY', "Land");
 define ('LABEL_UNSELECT', "Niet selecteren"); 
 define ('LABEL_SELECT_ALL', "<trans>Select all"); 
 define ('LABEL_WITH_SELECTED', "<trans>With selected : "); 
 define ('LABEL_MAIL_USER', "Zend mail"); 
 define ('LABEL_REMOVE_ACCESS', "<trans>Remove access"); 
 
 define ('ALT_CHANGE_PASSWORD', "Paswoord wijzigen");
 define ('CAPTION_USER_PRIVILEGE', "Authorisatie gebruiker: ");
 define ('LABEL_CHANGE_USER_PRIVILEGE', "Authorisatie veranderen in: ");
 define ('LABEL_USER_SITE_STATUS', "User status in site : ");
 define ('LABEL_CHANGE_STATUS' , "Change status to : ");
 define ('LABEL_USER_CONFIRM_STATUS' , "User <font color=blue>%s</font> is now %s."); //$userid, $user_states[$user_state]
 define ('LABEL_MAIL_USER_STATUS' , "Send new status by mail");
 define ('LABEL_MAIL_STATUS_SUBJECT' , "Modification of your profile in sitede votre profil in site %s"); //$site
 define ('LABEL_MAIL_STATUS_BODY' , "Hello,\n administrator of site %s modified your account. Your account is now %s."); // $site, $user_state
 define ('ERROR_NO_ADMIN_CHANGE_STATUS', "Status of user 'Admin' can't be changed"); 
 define ('ERROR_NO_USER_STATUS', "Status of user couldn't be modified in site %s"); //$userid
 define ('ERROR_NO_ADMIN_CHANGE_PRIVILEGE', "De authorisatie voor gebruiker admin kan niet worden gewijzigd");
 define ('CAPTION_CHANGE_USER_FORUM_PRIVILEGES', "Selecteer de authorisaties die je aan deze gebruiker wilt toekennen");
 define ('LABEL_AS', "als ");
 define ('LABEL_GRANT_PRIVILEGES', " Selecteer de acties die je wilt toestaan aan deze gebruiker ");
 define ('COLUMN_CAN_LIST', "Bekijken");
 define ('COLUMN_CAN_READ', "Lezen");
 define ('COLUMN_CAN_WRITE', "Posten");
 define ('COLUMN_SITE', "site");
 define ('LABEL_ADD_FORUM', "Forum toevoegen: ");
 define ('LABEL_MAIL_USER_PROFILE', "Mail het nieuwe profiel naar gebruiker ");
 define ('LABEL_SHOW', "Weergeven");
  
 define ('ERROR_NO_ADD_PRIVILEGES', "Kon geen authorisaties veranderen voor gebruiker %s in forum %s");

 define ('COLUMN_MAIL_SUBSCRIBED_USERS', "Mail geabonneerde gebruikers");
 define ('ALT_MAIL_SUBSCRIBED_USERS', "Mail versturen aan gebruikers die op dit forum zijn geabonneerd.");
 define ('LABEL_SEND_FORUM_SUBSCRIBED_EMAIL', "Mail versturen aan gebruikers die zijn geabonneerd op forum $bn_name");
 define ('TITLE_SELECT_SUBSCRIBED_USERS', "Selecteer geabonneerde gebruikers");
 define ('LABEL_NO_SUBSCRIBED_USERS', "Geen geabonneerde gebruikers in dit forum");
 define ('LABEL_IN_FORUM', "in forum");
 define ('LABEL_SUBSCRIBE_USER', "Abonnementen toevoegen");
 define ('LABEL_SUBSCRIBE', "Abonneren");
 define ('LABEL_UNSUBSCRIBE', "Abonnement opheffen");
 define ('LABEL_CONFIRM_USER_UNSUBSCRIBE', "De volgende abonnementen worden opgeheven");
 define ('LABEL_CONFIRM_USER_SUBSCRIBE', "De volgende gebruikers krijgen een abonnement");
 define ('ERROR_NO_MATCHING_ADDRESS', "Geabonneerde gebruiker %s niet gevonden in forum %s");
 define ('COLUMN_USER_NEW_EMAIL', "Nieuw adres:");
 define ('LABEL_EDIT_MAIL_SUBSCRIBE', "Stuur gebruiker <font color=blue>%s</font> zijn(haar) nieuwe adres");
 define ('LABEL_MAIL_USER_SUBSCRIBE', "Informeer gebruikers per e-mail");
 define ('COLUMN_ADMIN_SUBSCRIBED_USERS', "Geabonneerde gebruikers");
 define ('ALT_ADMIN_SUBSCRIBED_USERS', "Beheren van abonnementen op dit forum");
 define ('TITLE_FORUM_SUBSCRIBED_USER_ADMIN', "Beheer van gebruikersabonnementen in forum \"{FORUM}\"");
 define ('LABEL_USER_CONFIRM_UNSUBSCRIBE', "Het abonnement van <font color=blue>%s</font> is opgeheven");
 define ('LABEL_USER_CONFIRM_SUBSCRIBE', "Gebruiker <font color=blue>%s</font> is geabonneerd");
 define ('LABEL_KEEP_THREADS', "Abonnementen op onderwerpen handhaven");
 define ('LABEL_MAIL_SUBSCRIBE_SUBJECT', "Abonnement op forum %s");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_YES', "Je bent vanaf heden geabonneerd op forum %s. Je zult alle nieuwe berichten per e-mail ontvangen.");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_NO', "Je abonnement op forum %s is opgeheven. Je zult geen e-mails meer ontvangen van dit forum.");
 define ('LABEL_SUBSCRIBED_USERS', "<trans>Subscribed users");
 define ('LABEL_UNSUBSCRIBED_USERS', "<trans>Unsubscribed users");

 /////////////////////
 //Add_User.php3
 /////////////////////
 define ('TITLE_ADD_USER', "Gebruiker toevoegen");
 define ('ERROR_NO_ADD_USER', "Kon geen gebruiker toevoegen %s in tabel %s_userforum");
 define ('WARNING_USER_ADDED', "Gebruiker '%s' is toegevoegd aan forum '%s'");
 define ('LABEL_RETRIEVING_USERS', "Even geduld, bezig alle gebruikers in deze site op te zoeken ...");
 define ('WARNING_NO_USER_TO_ADD', "Geen gebruiker die kan worden toegevoegd");
 define ('LABEL_ADD_FORUM_USER', "Gebruiker toevoegen aan forum <em><FONT color=#FF6633>%s</FONT></em>");
 define ('LABEL_CHOOSE_USER_ADD', "Selecteer de gebruiker die je wilt toevoegen");
 define ('LABEL_USER_GRANT_PRIVILEGES', "<b>Kies authorisaties voor forum <FONT color=#FF6633>%s</font> voor deze gebruiker</b><br>");
 define ('LABEL_ACTIVE', "Actief");
 define ('LABEL_FORM_SELECT', "&lt;-- Kies een naam --&gt;");
 define ('LABEL_ENTER_EMAILS_TO_ADD', 'Voer hier een lijst van email adressen in');
 define ('LABEL_CHOOSE_EMAILS_FILE', 'Kies een file met een lijst van email adressen');

 /////////////////////
 //Create_User.php3
 /////////////////////
 define ('TITLE_NEW_USER', "Gebruiker aanmaken");
 define ('ERROR_NO_PASSWORD', "Controleer svp dat het paswoord tweemaal is ingevoerd");
 define ('ERROR_NO_SITE_ADD_USER', "Kon gebruiker %s niet toevoegen aan tabel %s_users");
 define ('LABEL_USER_ADDED', "Gebruiker '%s' is aangemaakt");
 define ('LABEL_USER_SENT_FOR_APPROVAL', "His/her account will bea ctive once validated by the administrators of the site."); 
 define ('LABEL_CREATE_ANOTHER_USER', "Gebruiker aanmaken");
 define ('LABEL_EDIT_THIS_USER', "Deze gebruiker wijzigen");
 define ('ALT_EDIT_THIS_USER', "Gebruikersinformatie wijzigen");
 define ('LABEL_SITE_CREATE_NEW_USER', "Nieuwe gebruiker aanmaken in site: ");
 define ('LABEL_USER_INFORMATIONS', "Gebruikers informatie");
 define ('COLUMN_USER_PASSWORD', "Paswoord");
 define ('COLUMN_USER_CONFIRM_PASSWORD', "Paswoord (opnieuw)");
 define ('LABEL_ADD_MAILING_LIST', "Gebruiker toevoegen aan mailing list?");
 define ('LABEL_CREATE_USER', "Aanmaken");
 define ('LABEL_USER_PRIVILEGE', "Choose privilege for this gebruiker");

 /////////////////////
 //Mail_Users.php3
 /////////////////////
 define ('LABEL_SEND_SITE_EMAIL', 'Zend email aan gebruikers in site ');
 define ('LABEL_SEND_FORUM_EMAIL', 'Zend email aan gebruikers in forum ');
 define ('LABEL_NO_ACTIVE_USERS', 'Geen actieve gebruiker gevonden ');
 define ('LABEL_MAIL_USERS', 'Mail zal worden verstuurd aan %s gebruiker(s)');
 define ('LABEL_USER_MAILED', 'Mail verstuurd aan <em> %s </em> <tt>&lt; %s &gt;</tt>.<br>');
 define ('LABEL_USER_NOT_MAILED', '%s &lt; %s &gt; wensen geen mail te ontvangen.<br>');
 define ('LABEL_MAIL_FILL_FORM', 'Vul dit formulier in om je mail te verzenden');
 define ('LABEL_SEND_TO_ALL', 'Zenden aan ALLE gebruikers');
 define ('COLUMN_TO', 'Aan:');
 define ('COLUMN_FROM', 'From:');
 define ('COLUMN_REPLY_TO', 'Reply to:');
 define ('COLUMN_MESSAGE', 'Tekst van mail:');
 define ('LABEL_SEND_MAIL', 'Zend mail');

 /////////////////////
 //Editconf.php3
 /////////////////////
 define ('ERROR_NO_WRITE_CONFIGURATION', "Kan niet schrijven naar configuratie file, check rechten");
 define ('ERROR_FILE_UPLOAD_DISABLED', "<trans>File upload feature has been disabled on this server, check your php3 configuration (php3.ini) or contact your ISP!!");
 define ('LABEL_CHANGE_CONFIG_DONE', "Wijzigingen opgeslagen naar ");
 define ('LABEL_SETTINGS_RESTORED', "Instellingen zijn teruggezet");
 define ('LABEL_FORUM_CONFIGURATION', "Forum instellingen (%s) ");
 define ('LABEL_EDITING_FILE', "Wijzigen file");
 define ('TITLE_GENERAL_SETTINGS', "Algemene instellingen");
 define ('COLUMN_BODY', "Achtergrond");
 define ('ALT_BODY', "Parameter bij de Tag &lt;BODY&gt;");
 define ('COLUMN_DATE_FORMAT', "Datum format");
 define ('ALT_DATE_FORMAT', "Format voor data (see the php3 documentation)");
 define ('COLUMN_TIME_OFFSET', "Time offset");
 define ('ALT_TIME_OFFSET', "Time offset from local time (in Hours)");
 define ('COLUMN_USE_COOKIE', "Cookies gebruiken");
 define ('ALT_USE_COOKIE', "Aanmaken/ophalen cookies om gebruikersnaam/adres op te slaan en om berichten als nieuw te markeren");
 define ('COLUMN_ALLOW_MODIFICATION', "Wijzigen toegestaan");
 define ('ALT_ALLOW_MODIFICATION', "Gebruikers mogen berichten wijzigen, hiervoor is een paswoord nodig");
 define ('COLUMN_ALLOW_DELETE', "Verwijderen toegestaan");
 define ('ALT_ALLOW_DELETE', "Gebruikers mogen berichten verwijderen, hiervoor is een paswoord nodig");

 define ('TITLE_MESSAGE_FORMATING', "Berichten");
 define ('COLUMN_ALLOW_HTML', "HTML toegestaan");
 define ('ALT_ALLOW_HTML', "Gebruikers mogen HTML tags invoegen");
 define ('COLUMN_TAGS_ALLOWED', "Geaccepteerde tags:");
 define ('ALT_TAGS_ALLOWED', "type hier de HTML tags die van de gebruiker worden geaccepteerd, gescheiden door spaties, komma's of puntkomma's (< en > niet opgeven)");
 define ('COLUMN_TAGS_DISALLOWED', "Verboden tags:");
 define ('ALT_TAGS_DISALLOWED', "type hier de HTML tags worden verwijderd uit de tekst van de gebruiker, gescheiden door spaties, komma's of puntkomma's (< en > niet opgeven) Alleen invullen als 'Geaccepteerde tags' leeg is");
 define ('COLUMN_USE_SMILEY', "Gebruik smileys");
 define ('ALT_USE_SMILEY', "Converteer smileys naar iconen (alleen in velden waar HTML is toegestaan)");
 define ('COLUMN_CONVERT_URL', "Converteer URLs");
 define ('ALT_CONVERT_URL', "Automatische conversie van URL naar links (alleen in velden waar HTML is toegestaan)");

 define ('TITLE_LAMER_FILTER', "Filters op gebruikers");
 define ('COLUMN_DISALLOW_IP', "Weiger ips:");
 define ('ALT_DISALLOW_IP', "Typ de ips waarvandaan niet mag worden gepost, gescheiden door spaties, komma's of puntkomma's");

 define ('TITLE_FILE_UPLOAD', "File Upload");
 define ('COLUMN_FILE_UPLOAD', "File upload toegestaan ");
 define ('ALT_FILE_UPLOAD', "Gebruikers mogen files uploaden (als attachments) naar je server");
 define ('COLUMN_MAX_FILE_SIZE', "Maximum file grootte (in bytes)");
 define ('ALT_MAX_FILE_SIZE', "Limiet voor de grootte van  uploaded files");

 define ('COLUMN_ALLOW_EXTENSION', "accepteer extensies: ");
 define ('ALT_ALLOW_EXTENSION', "Typ de file extensions (bv: .gif) die worden geaccepteerd voor uploaded files, gescheiden door spaties, komma's of puntkomma's");
 define ('COLUMN_DENY_EXTENSION', "weiger extensies: ");
 define ('ALT_DENY_EXTENSION', "typ de file extensies (eg: .gif) die niet worden geaccepteerd voor uploaded files, gescheiden door spaties, komma's of puntkomma's (Alleen invullen als 'geaccepteerde extensies' leeg is)");

 define ('COLUMN_ALLOW_MIME', "accepteer mime-types: ");
 define ('ALT_ALLOW_MIME', "typ de mime-types (bv: image/gif, text/*) die worden geaccepteerd voor uploaded files, gescheiden door spaties, komma's of puntkomma's (de extensies moeten er uitzien als (type/subtype or type/*)) ");
 define ('COLUMN_DENY_MIME', "weiger mime-types: ");
 define ('ALT_DENY_MIME', "typ de mime-types (bv: image/gif, text/*) die niet worden geaccepteerd voor uploaded files, gescheiden door spaties, komma's of puntkomma's (alleen invullen als 'accepteer mime-types' leeg is");

 define ('TITLE_SEARCH', "Zoeken");
 define ('COLUMN_SEARCH_SUPPORT', "Zoeken mogelijk ");
 define ('ALT_SEARCH_SUPPORT', "Gebruikers kunnen zoeken in berichten");
 define ('COLUMN_SEARCH_ENGINE', "Zoekmachine: ");
 define ('COLUMN_PATH_NAME', "Padnaam ");
 define ('ALT_PATH_NAME', "Plaats van het zoekprogramma");
 define ('TITLE_SEND_MAIL', "Versturen e-mails");
 define ('COLUMN_MAIL_MODERATOR', "Stuur mail naar de moderator");
 define ('ALT_MAIL_MODERATOR', "Informeer de moderator per email als een bericht is gepost of gewijzigd");
 define ('COLUMN_ALLOW_MAIL_SUBSCRIPTION', "Mail abonnement mogelijk");
 define ('ALT_ALLOW_MAIL_SUBSCRIPTION', "Gebruikers kunnen reacties per mail ontvangen");
 define ('COLUMN_ALLOW_PRIVATE_MAIL', "Allow private mails");
 define ('ALT_ALLOW_PRIVATE_MAIL', "allow users tosend private mails to the authors of notes");
 define ('COLUMN_MAIL_ATTACHMENT', "Attach files to mails");
 define ('ALT_MAIL_ATTACHMENT', "Attach \"attachment\" files to the mails sent to users");
 define ('LABEL_DEFAULT', "Ongedaan maken");

 define ('LABEL_FRAMES', "Frames");
 define ('COLUMN_USE_FRAMES', "Frames gebruiken");
 define ('ALT_USE_FRAMES', "Ook als de optie is aangevinkt worden oude browsers ondersteund");
 define ('COLUMN_FRAMESET_PARAMETER', "Frameset parameter:");
 define ('ALT_FRAMESET_PARAMETER', "Parameter bij de tag &lt;FRAMESET&gt; ");
 define ('COLUMN_HEADER_FRAME_PARAMETER', "Header Frame parameter:");
 define ('ALT_HEADER_FRAME_PARAMETER', "Parameter bij de tag &lt;FRAME&gt; ");
 define ('COLUMN_FOOTER_FRAME_PARAMETER', "Footer Frame parameter:");

 define ('TITLE_POST_MESSAGES', "Berichten toevoegen");
 define ('COLUMN_POST_POPUP', "Post in popup window ");
 define ('ALT_POST_POPUP', "Open een apart window voor het post/reactie/wijzig formulier");
 define ('COLUMN_NO_BUTTON_BAR', "Knoppenbalk niet weergeven");
 define ('ALT_NO_BUTTON_BAR', "Knoppenbalk en opties niet weergeven onder het post/reactie/wijzig formulier");
 define ('COLUMN_NO_THANKS', "Dank melding niet weergeven");
 define ('ALT_NO_THANKS', "Na posten/wijzigen direct volgende pagina weergeven zonder dank melding");
 define ('COLUMN_AFTER_POSTING', "Na versturen nieuw bericht, ga naar");
 define ('ALT_AFTER_POSTING', "Pagina die wordt getoond nadat een bericht is gepost");
 define ('COLUMN_NEWLY_POSTED', "Het nieuw geposte bericht");
 define ('COLUMN_MESSAGE_LIST', "Lijst van berichten");
 define ('COLUMN_FIRST_MESSAGE', "Eerste bericht van het onderwerp");

 define ('TITLE_INCLUDE_FILES', "Include files (alle files bevinden zich in %s), bij blanke velden worden default waarden gebruikt");

 define ('COLUMN_CSS_FILE', "Style sheet (CSS) file:");
 define ('ALT_CSS_FILE', "CSS file (in de &lt;head&gt; tag:");
 define ('COLUMN_HEADER_FILE', "Header file");
 define ('ALT_HEADER_FILE', "Header include file");
 define ('COLUMN_FOOTER_FILE', "Footer");
 define ('ALT_FOOTER_FILE', "Footer include file");
 define ('COLUMN_LISTING_OUTLINE', "Lijst lay-out");
 define ('ALT_LISTING_OUTLINE', "Lijst van berichten");
 define ('COLUMN_INCLUDE_MESSAGES', "Meldingen");
 define ('ALT_INCLUDE_MESSAGES', "Teksten, meldingen en graphics");
 define ('COLUMN_FORM_FILE', "Formulier");
 define ('ALT_FORM_FILE', "FORMULIER voor posten/reageren op/wijzigen van berichten");
 define ('COLUMN_MAIL_FORM_FILE', "Private mails form");
 define ('ALT_MAIL_FORM_FILE', "form used to send private mails");
 define ('COLUMN_FILE_SEARCH', "Zoekformulier");
 define ('ALT_FILE_SEARCH', "Zoekformulier");
 define ('COLUMN_TEMPLATE_FILE', "Template");
 define ('ALT_TEMPLATE_FILE', "Berichten template");
 define ('COLUMN_FIELDS_NAME', "Namen velden");
 define ('ALT_FIELDS_NAME', "Definitie velden database (variabelen)");
 define ('COLUMN_php3_INCLUDE', "php3 file included voor toegang tot forum");
 define ('ALT_php3_INCLUDE', "Optionele php3 file die wordt uitgevoerd (included) voor toegang tot het forum");
 define ('COLUMN_FILE_LOGIN', "Login formulier");
 define ('ALT_FILE_LOGIN', "Gebruikers login formulier");
 define ('COLUMN_REGISTER_FORM', "Registratie formulier");
 define ('ALT_FILE_REGISTER', "Gebruikers registratie formulier");
 define ('COLUMN_SHOW_PROFILE', "Profiel formulier");
 define ('ALT_FILE_SHOW_PROFILE', "Teplate voor de weergave van het gebruikers profiel");
 define ('COLUMN_FILE_CHANGE_PASSWORD', "Formulier nieuw paswoord");
 define ('ALT_FILE_CHANGE_PASSWORD', "Formulier voor het wijzigen van het paswoord");
 define ('COLUMN_FILE_FORGOT_PASSWORD', "Formulier paswoord vergeten");
 define ('ALT_FILE_FORGOT_PASSWORD', "Formulier voor het aanvragen van een nieuw paswoord");
 define ('COLUMN_FILE_MAIL_TEMPLATE', "Mail template");
 define ('ALT_FILE_MAIL_TEMPLATE', "Mail instellingen en templates");
 define ('COLUMN_SUBSCRIBE_FORM_TEMPLATE', "Abonnement formulier");
 define ('ALT_FILE_SUBSCRIBE_FORM', "Template voor het formulier om zich op een forum te abonneren");

 define ('TITLE_DISCUSSION_BOARD', "Bulletin board");
 define ('COLUMN_ALLOW_REPLIES', "Reacties toegestaan (discussies)");
 define ('ALT_ALLOW_REPLIES', "Gebruikers kunnen reageren op berichten (onderwerpen)");

 define ('TITLE_DISPLAYED_MESSAGE', "Weergave berichten");
 define ('COLUMN_NO_TOOLBAR', "Geen menubalk in bericht");
 define ('ALT_NO_TOOLBAR', "Menubalk (reactie|wijzigen|verwijderen|lijst) niet weergeven onder bericht");
 define ('COLUMN_NO_NAVIGATION_BAR', "Geen navigatiebalk in bericht");
 define ('ALT_NO_NAVIGATION_NAR', "Navigatiebalk (volgende/vorige onderwerp/bericht) niet weergeven onder bericht");
 define ('COLUMN_NO_THREAD', "Geen reacties onder bericht");
 define ('ALT_NO_THREAD', "Lopende discussie niet weergeven in het bericht");
 define ('COLUMN_APPEND_MESSAGE', "Reactie formulier onder getoonde berichten");
 define ('ALT_APPEND_MESSAGE', "Reactie formulier toevoegen onder getoonde berichten");

 define ('TITLE_MESSAGE_LISTING', "Berichten lijsten");
 define ('COLUMN_MESSAGE_NO_NAVIGATION_BAR', "Geen navigatiebalk in lijst");
 define ('ALT_MESSAGE_NO_NAVIGATION_NAR', "Navigatiebalk (volgende / vorige pagina) niet weergeven in de berichtenlijst");
 define ('COLUMN_GUESTBOOK', "Post formulier onder berichtenlijst");
 define ('ALT_GUESTBOOK', "Formulier weergeven onder de lijst van berichten (gastenboek)");

 define ('TITLE_BROWSE_SERVER', "Bladeren op de server");
 define ('COLUMN_BROWSE_SERVER', "Bladeren op server toegestaan");
 define ('ALT_BROWSE_SERVER', "Gebruikers kunnen bestanden toevoegen die op je server staan");
 define ('COLUMN_BASE_DIRECTORY', "Basis directory");
 define ('ALT_BASE_DIRECTORY', "Naam van de top directory waarin gebruikers kunnen bladeren om bestanden toe te voegen");

 /////////////////////
 //Edit_Forum.php3
 /////////////////////
 define ('LABEL_EDIT_FORUM', "Forum eigenschappen wijzigen");
 define ('LABEL_SITE_EDIT_FORUM', "Kies het forum in site %s");
 define ('ERROR_NO_FORUM_UPDATE', "Kon forum %s in site %s niet wijzigen");
 define ('ERROR_NO_NEW_MODERATOR', "Kon gebruiker %s geen moderator authorisatie geven op forum %s ");
 define ('LABEL_EDIT_FORUM_SHORT', "Wijzigen forum: ");
 define ('LABEL_FORUM_INFORMATION', "Eigenschappen van het forum");
 define ('COLUMN_STATE', "Status");
 define ('COLUMN_CATEGORY', "Categorie");
 define ('LABEL_PRIVACY_INFORMATION', "Privacy Informatie");
 define ('LABEL_CHANGE_ACCESS', "Selecteer een toegangsmodus voor dit forum");
 define ('LABEL_MODERATED', "met moderator");
 define ('LABEL_UPDATE_THIS_FORUM' , "Forum wijzigen");
 define ('LABEL_CHOOSE_MODERATOR', "Selecteer een gebruiker als eerste moderator voor dit forum");

 /////////////////////
 //admin_categories.php3
 /////////////////////
 define ('LABEL_EDIT_CATEGORIES', "Wijzigen categorieen in site ");
 define ('LABEL_ADD_CATEGORY', "Categorie toevoegen");
 define ('COLUMN_EDIT_CATEGORY', "Categorie wijzigen");
 define ('COLUMN_DELETE_CATEGORY', "Categorie verwijderen");
 define ('COLUMN_CAT_TITLE', "Naam categorie");
 define ('LABEL_UPDATE_ORDER', "Volgorde wijzigen");
 define ('LABEL_ADD_NEW_CATEGORY', "Nieuwe categorie toevoegen");
 define ('LABEL_ADD_THIS_CATEGORY', "Deze categorie toevoegen");
 define ('LABEL_EDIT_CATEGORY', "Categorie wijzigen");
 define ('LABEL_UPDATE_THIS_CATEGORY', "Deze categorie wijzigen");

 /////////////////////
 //Create_Forum.php3
 /////////////////////
 define ('TITLE_CREATE_FORUM', "Forum aanmaken");
 define ('ERROR_FORUM_NAME_TO_LONG', "Forum naam is te lang, kies svp een kortere naam.");
 define ('ERROR_CONFIG_FILE_EXISTS', "Configuratie file (%s) bestaat al, verwijder deze handmatig of kies een andere naam");
 define ('ERROR_NO_FILE_COPY', "Kon file %s niet kopieren");

 define ('ERROR_FORUM_DB_DBM_EXISTS', "Site database %s bestaat al, <br> de DBM file: <em>dbm/%s/%s</em><br> [en de lockfile .lck] moeten handmatig worden verwijderd");
 define ('ERROR_FORUM_DB_EXISTS', "Dit forum's tabel (%s) bestaat al in deze database (%s), verwijder deze handmatig of kies een andere naam");

 define ('ERROR_FORUM_DB_DBM_ACCESS', "Probleem met toegang, kon DBM file (<em>%s</em>) niet aanmaken, check ruimte en rechten in het file systeem");
 define ('ERROR_FORUM_DB_ACCESS', "Probleem met toegang, kon tabel (<em>%s</em>) niet aanmaken, controleer of de database genaamd %s is aangemaakt check toegangsrechten");
 define ('ERROR_NO_CREATE_FORUM', "Kon forum niet aanmaken:");
 define ('ERROR_NO_FORUM_INSERT', "Kon forum %s in site %s niet aanmaken");
 define ('LABEL_FORUM_CREATED', "Forum '<em>%s</em>' is aangemaakt in site %s<BR><BR>&nbsp;&nbsp;je kunt nu:");
 define ('LABEL_CREATE_ANOTHER_FORUM', "Een ander forum aanmaken");
 define ('ALT_ACCESS_FORUM', "Naar dit forum gaan");
 define ('LABEL_ADMINISTRATE_FORUM', "Het forum beheren");
 define ('ALT_ADMINISTRATE_FORUM', "Instellingen wijzigen van dit forum");
 define ('LABEL_EDIT_THIS_FORUM', "Dit forum wijzigen");
 define ('ALT_EDIT_THIS_FORUM', "Instellingen van dit forum wijzigen");
 define ('LABEL_SITE_ADMINISTRATION', "Terug naar site beheer");
 define ('LABEL_FORUM_CREATED_SUCCESSFULLY', "Forum %s is aangemaakt");
 define ('LABEL_INSTALL_FORUM', "Installeer een nieuw forum in site: ");
 define ('COLUMN_GIVE_FORUM_NAME', "Forum's naam:");
 define ('COLUMN_FORUM_TEMPLATE', "Selecteer een template(theme):");
 define ('LABEL_SET_ACCESS', "Kies de toegangs modus voor dit forum:");
 define ('LABEL_CREATE_THIS_FORUM', "Forum aanmaken");
 define ('LABEL_NAME_OF_FORUM', "(de naam die je aan dit forum wilt geven)");
 define ('LABEL_CHOOSE_FIRST_MODERATOR', "Selecteer de gebruiker (beheerder) die moderator van dit forum wordt:");

 /////////////////////
 //Reorder_Forum.php3
 /////////////////////
 define ('TITLE_REORDER_FORUM', "Volgorde van weergave van de forums in site: ");
 define ('LABEL_CHANGE_FORUM_ORDER', "Hier kan je de volgorde van de forums instellen. Geef elk forum een uniek volgnummer, beginnend bij 1. Bij de waarde 0 wordt het forum niet in de lijst getoond.");


 /////////////////////
 //editform.php3
 /////////////////////
 define ('LABEL_NEW_FILE_EDITING', "Nieuw bestand wijzigen");
 define ('WARNING_EDITING_DEFAULT', "Let op: dit is een default file voor deze site, wijzigingen hebben gevolgen voor alle forums die de default van deze site gebruiken.");
 define ('LABEL_SPECIFIC_TEMPLATE', "als je een forumspecifieke template wilt gebruiken, geef de naam dan op in de <a href='%s'>instellingen pagina</a>");

 /////////////////////
 //editmsg.php3
 /////////////////////
 define ('TITLE_EDITING_MESSAGES', "Meldingen wijzigen");
 define ('ERROR_NO_CREATE_MESSAGE', "Meldingen file kan niet worden aangemaakt, check rechten");

 /////////////////////
 //editfields.php3
 /////////////////////
 define ('TITLE_EDITING_FIELDS', 'Velden wijzigen');
 define ('LABEL_NAME', 'Naam');
 define ('LABEL_SIZE', 'Grootte');
 define ('LABEL_REQUIRED', 'Verplicht');
 define ('LABEL_LISTED', 'In lijst');
 define ('LABEL_ACCEPT_HTML', 'Accepteer HTML/smileys');
 define ('LABEL_SAVE_COOKIE', 'Opslaan in een permanent cookie');
 define ('LABEL_DELETE_FIELD', 'Verwijderen');
 define ('LABEL_USER_VARIABLES', 'Gebruiker variabelen');
 define ('LABEL_LISTED_VARIABLES', 'Variabelen in lijst');
 define ('LABEL_REQUIRED_VARIABLES', 'Verplichte variabelen');
 define ('LABEL_VARIABLES_ACCEPT_HTML', 'HTML variabelen');
 define ('LABEL_VARIABLES_COOKIE', 'Variabelen die in een permanent cookie worden opgeslagen');
 define ('LABEL_CONFIRM_DELETE_FIELD', 'Wil je dit veld uit de tabel verwijderen');
 define ('ALT_DELETE_FIELD', 'Verwijder veld: %s');
 define ('ALT_ADD_FIELD', 'Veld toevoegen');
 define ('ERROR_UNDEFINED_VARNAME', 'Geef de naam van het veld dat je wilt toevoegen');
 define ('ERROR_UNDEFINED_VARSIZE', 'Geef de grootte/type van het veld dat je wilt toevoegen [xxx | int | text]');
 define ('ERROR_VARNAME_ALREADY_DEFINED', 'Deze veldnaam is al in gebruik');

 /////////////////////
 //edittemplate.php3
 /////////////////////
 define ('TITLE_EDITING_TEMPLATE', "Document template wijzigen");
 define ('LABEL_DEFINE_DOCUMENT_GENERATION', "Geef aan hoe documenten (uit de template) worden gegenereerd:");
 define ('LABEL_STATIC', "<b>Statisch</b><i> (een HTML file wprdt aangemaakt als een bericht is gepost) </i>");
 define ('LABEL_ONTHEFLY', "<b>Dynamisch</b><i> (geen HTML file, het bericht wordt aangemaakt als de gebruiker het aanroept)</i>");
 define ('LABEL_NO_DOCUMENTS', "<b>Geen document</b><i> (alleen de database wordt getoond)</i>");
 define ('LABEL_EDIT_TEMPLATE', "Documenten template:");

 /////////////////////
 //editmail.php3
 /////////////////////
 define ('TITLE_EDITING_MAIL', "Mail template wijzigen");
 define ('LABEL_OVERWRITE_MAIL_FILE', "Mail template file (<font color=red>WARNING!</font> this choice will overwrite current file)");
 define ('LABEL_SEND_OUT_EMAILS', "Emails verzenden vanaf (from: header)");
 define ('LABEL_USER_EMAIL', "Gebruikers email adres");
 define ('LABEL_THIS_EMAIL', "Dit email adres");
 define ('LABEL_FIRST_RECIPIENT', "Eerste geadresseerde (To: header)");
 define ('LABEL_RETURN_PATH', "Return-Path");
 define ('LABEL_REPLY_TO', "Antwoorden aan");
 define ('LABEL_NO_MAIL_SUBJECT', "Mail subject als het bericht geen subject heeft");
 define ('LABEL_MAIL_SUBJECT', "Mail subject");
 define ('LABEL_MAIL_NEW_MESSAGES', "Mail verstuurd voor nieuwe berichten");
 define ('LABEL_MAIL_UPDATED_MESSAGES', "Mail verstuurd voor gewijzigde berichten");
 define ('LABEL_MAIL_APPROVAL', "Mail verstuurd aan moderators voor het goedkeuren van berichten (moderated forum)");
 define ('LABEL_MAIL_BODY', "Tekst van mail");
 define ('LABEL_MAIL_REGISTRATION', "Mail verstuurd aan gebruikers na registratie");
 define ('LABEL_MAIL_CONFIRM_REGISTRATION', "Mail verstuurd aan gebruikers nadat administrator het profiel heeft gewijzigd");
 define ('LABEL_MAIL_USER_APPROVAL', "Mail verstuurd aan moderators voor goedkeuren gebruikers");
 define ('LABEL_MAIL_USER_MODIFICATION', "Mail verstuurd aan moderators na wijzigen profiel door gebruiker");
 define ('LABEL_MAIL_FORGOT_PASSWORD', "Mail verstuurd aan gebruikers die het paswoord zijn vergeten");

 /////////////////////
 //delete_Forum.php3
 /////////////////////
 define ('TITLE_DELETE_FORUM', 'Forum verwijderen');
 define ('TITLE_DELETE_FORUM_IN_SITE', 'Verwijderen forum %s van site %s');

 define ('ERROR_MUST_BE_ADMIN_TO_REMOVE_FORUM', 'Je moet als administrator zijn ingelogged om een forum te verwijderen');
 define ('ERROR_NO_AVAILABLE_FORUM', 'Geen forum beschikbaar in site %s,<br>');
 define ('ERROR_FORUM_DOESNT_EXIST', 'forum %s bestaat niet in deze site');
 define ('ERROR_CANT_REMOVE_FORUM', 'Kon forum %s niet verwijderen van site %s');

 define ('LABEL_CHOOSE_FORUM_TO_DELETE', 'Selecteer het forum dat moet worden verwijderd uit site %s');
 define ('LABEL_FORUM_DELETED', 'Forum %s is verwijderd');

 define ('CAPTION_DELETE_FORUM', '<B>Het volgende forum zal worden verwijderd</B>');
 define ('LABEL_FORUM_TITLE', 'subject: ');
 define ('LABEL_FORUM_DESCR', 'Omschrijving: ');
 define ('LABEL_FORUM_OWNER', 'Beheerder: ');
 define ('LABEL_FORUM_TYPE', 'Type: ');
 define ('LABEL_FORUM_MODER', 'Moderated: ');
 define ('LABEL_FORUM_STATE', 'Status: ');
 define ('LABEL_DELETE_THIS_FORUM', 'Verwijder dit forum');

?>
