<?PHP

/*
 * W-AGORA 4.1
 * -----------
 * $Id: admin_en.inc,v 1.66 2006/07/11 21:55:02 mdruilhe Exp $
 * Usage: Administration localized strings constant
 * Description: This script is used to define strings used by the administration part of the application
 * Author: Alexandre GHEZ (aghez@decan.fr)
 * Translator: Marc Druilhe (mdruilhe@w-agora.net)
 */

 ///////////////////
 // file setup.php3
 ///////////////////
 define ('ERROR_SETUP_ALREADY_DONE', 'w-Agora seems to be already installed,<br> main configuration file (<tt>%s</tt>) already exists,<br> you must delete it (and DB tables) manually in order to reinstall.<br><br>press the button if you wish to create a new site');
 define ('ERROR_MISSING_ADMIN_NAME', 'You must give a name for the system administrator');
 define ('ERROR_MISSING_ADMIN_EMAIL', 'You must give a valid email address');
 define ('ERROR_MISSING_DB_ACCESS', 'You must give a DB access mode');
 define ('ERROR_BAD_PASSWORD', 'password must be set and must be entered twice, please verify');
 define ('ERROR_MISSING_DB_NAME', 'You must give a database name');
 define ('ERROR_SF_CREATE_FILE', 'Could not create file in directory <u>%s</u>, please check permissions, or read the safe mode instructions in the <a href="doc/INSTALL.txt">INSTALL.txt file</a>');
 define ('ERROR_COPY_FILE', 'could not copy file to <u>%s</u>');
 define ('ERROR_OPEN_DB', 'Could not connect to database <u>%s</u> (host: <u>%s</u>, port: <u>%s</u>, user: <u>%s</u>)');
 define ('ERROR_CREATE_CONFIG_FILE', 'Cannot create configuration file <u>%s</u>, check permissions');
 define ('LABEL_SETUP_DONE', 'w-agora has been successfully installed');
 define ('LABEL_SETUP_AGORA', 'w-agora installation'); 

 define ('CAPTION_DB_PARAMETERS', 'Database parameters (for sites tables)');
 define ('CAPTION_DEFAULT_PARAMETERS', 'Default parameters for sites configuration');
 define ('CAPTION_ADMIN_INFO', 'System Administrator\'s Informations (login : <u>admin</u>)'); 

 define ('LABEL_ADMIN_NAME', 'Name');
 define ('LABEL_ADMIN_ADDRESS', 'e-mail');
 define ('LABEL_ADMIN_PASSWORD1', 'Choose a password');
 define ('LABEL_ADMIN_PASSWORD2', 'Please, reenter the password');
 define ('BUTTON_INSTALL', 'Install');

 /////////////////////
 //File Init_Admin.inc
 /////////////////////

 // function display_header
 define ('ADMINISTRATION_TITLE', "W-Agora administration");

 // function list_forums
 define ('COLUMN_FORUM_ADMIN', "Admin forum");
 define ('COLUMN_EDIT', "Edit");
 define ('COLUMN_DELETE', "Delete");
 define ('COLUMN_CREATE', "Create");
 define ('COLUMN_ORDER', "Order");

 define ('MSG_ADMINISTRATE_FORUM', "Administrate forum");
 define ('ALT_DELETE_FORUM', "Delete forum : %s");
 define ('ALT_EDIT_FORUM', "Edit forum : %s");

 define ('ERROR_SITE_EMPTY', "You must specify a site in order to enter in this area.");
 define ('ERROR_NO_CONFIG_FILE', "Cannot access configuration file: ");
 define ('ERROR_NO_ROOT', "You must be logged in as a system administrator to access this.");
 define ('ERROR_NO_ADMIN', "You must be logged in as an administrator to access this.");
 define ('ERROR_NO_MODERATOR', "Sorry, you have not moderation privilege on this forum, please relogin.");

 define ('TITLE_ADMINISTRATION_LOGIN', "Administration login");
 define ('TITLE_INVALID_LOGIN', "Invalid login, please relogin");

 define ('ERROR_NO_DATABASE', "Could not connect to database, please check parameters.");

 //Function List User
 define ('COLUMN_USER_ID', "Id");
 define ('COLUMN_USER_NAME', "Name");
 define ('COLUMN_USER_PRIVILEGE', "Privilege");
 define ('COLUMN_USER_REGISTERED', "Registered");
 define ('COLUMN_USER_LOGIN_COUNT', "# Logins");
 define ('COLUMN_USER_LAST_LOGIN', "Last login");
 define ('COLUMN_USER_POST_COUNT', "# Posts");
 define ('COLUMN_USER_LAST_POST', "Last Post");
 define ('COLUMN_ACTION', "Action");

 define ('LABEL_REG_NO_CONTROL',"Automatic registration");
 define ('LABEL_REG_CHALLENGE_RESPONSE',"RFU");	
 define ('LABEL_REG_ADMIN_APPROVAL',"Approved by administrators");

 /////////////////////
 //File Create_Site.php3
 /////////////////////
 define ('FORM_NO_SITE', "You must give the site name.");
 define ('FORM_NO_DESCRIPTION', "Please, enter a short description for this site.");
 define ('FORM_NO_DBACCESS', "You must specify an access mode.");
 define ('FORM_NO_DBNAME', "You must give a database name.");
 define ('FORM_NO_DIRECTORY', "You must give the forum directory name.");
 define ('FORM_SITE_LONG', "Site name is too long, please choose a shorter one.");

 define ('CHECK_SITE_EXISTS', "Site {SITE} already exists, you must either delete it manually or choose another name.");
 define ('CHECK_CONFIG_EXISTS', "Configuration file (<tt>%s</tt>) already exists, you must either delete it manually or choose another name.");

 define ('ERROR_SAFE_MODE', 'SAFE MODE is enabled, you may have to create the directory: {DIRECTORY}');
 define ('ERROR_CREATE_DIR', "Cannot create directory: {DIRECTORY}.");
 define ('ERROR_NO_PERMISSIONS', "Check permissions");

 define ('ERROR_ADMIN_NOT_FOUND', "Could not get user 'admin' from main agora site");

 define ('ERROR_DB_DBM_EXISTS', "Forum's database {SITE} already exists,<br> you must delete the DBM file: <em>dbm/{SITE}/{DATABASE}</em><br> [and the lockfile .lck] manually.");
 define ('ERROR_DB_EXISTS', "The forum's table {SITE} already exists in this database {DATABASE}, you must first drop this table manually.");
 define ('ERROR_FILESYSTEM', "Access problem, check space and permissions in the file system.");
 define ('ERROR_DB_ACCESS', "Access problem, make sure you have created a database named {DATABASE} and check access rights");

 define ('ERROR_CREATE_SITE', "Could not create site: {SITE}.");

 define ('ERROR_TABLE_EXISTS', "The table {TABLE} already exists in this database {DATABASE}, you must first drop this table manually.");

 define ('ERROR_CREATE_ADMIN', "Could not create user {USER} in the new site.");
 define ('ERROR_CREATE_USER', "Could not create user {USER} in the table {TABLE}.");
 define ('ERROR_NO_ADD_SITE', "Could not add site in main database.");

 define ('LABEL_BACK', "Back");
 define ('LABEL_CREATE_SITE_DONE', "You have successfully created the site {SITE}<BR><BR>&nbsp;&nbsp;You can now");
 define ('LABEL_CREATE_FORUM', "Create a forum");
 define ('LABEL_CREATE_SITE', "Create a site");
 define ('LABEL_CREATE_THIS_SITE', "Create this site");
 define ('LABEL_CREATE_NEW_SITE', "Create a new site");
 define ('LABEL_CREATE_ANOTHER_SITE', "Create another site");
 define ('LABEL_ADMINISTRATE_SITE', "Administrate this site");
 define ('LABEL_SITE_MANAGEMENT', "Site management");
 define ('CREATE_SITE_DONE', "Site {SITE} was successfully created.");

 define ('LABEL_SITE_NAME', "Site name");
 define ('LABEL_SITE_TITLE', "Title (short description)");
 define ('LABEL_SITE_DESCRIPTION', "Description");
 define ('LABEL_DB_PARAMETERS', "Database parameters");
 define ('LABEL_DB_TYPE', "Database type");
 define ('LABEL_DB_NAME', "Database name");

 define ('LABEL_DB_USER', "Database user");
 define ('LABEL_DB_PASSWORD', "Database password");

 define ('LABEL_DB_ADMIN_USER', "Database admin user (if empty: use DB user)");
 define ('LABEL_DB_ADMIN_PASSWORD', "Database admin password");
 define ('LABEL_DB_SERVER_NAME', "Server name");
 define ('LABEL_DB_SERVER_PORT', "Server port");
 define ('LABEL_DB_USER_SOURCE', "User source");

 define ('LABEL_FORUMS_CONFIGURATION', "Forums configuration");

 define ('LABEL_FORUM_DIRECTORY', "Forums directory");
 define ('LABEL_SEARCH_ENGINE', "Search engine");
 define ('LABEL_DEFAULT_THEME', "Default template");
 define ('NOTICE_SAFEMODE', "SAFE MODE enabled.");
 define ('NOTICE_MANUAL_INSTALL', 'you may have to create the following directories manually:');

 /////////////////////
 //File Admin.php3
 /////////////////////
 define ('TITLE_SITE_MANAGEMENT', "Admin sites");
 define ('LABEL_SITES_OUTLINE', "Sites outline");
 define ('COLUMN_SITE_TITLE', "Topic (title):");

 define ('ALT_DELETE_SITE', "Delete site : %s");
 define ('ALT_EDIT_SITE', "Edit site : %s");
 define ('ERROR_NO_SITE', "No available site,<br> hit the button 'OK' to create a new one.");

 /////////////////////
 //File Delete_Site.php3
 /////////////////////
 define ('TITLE_SITE_DELETE', "Delete site");
 define ('ERROR_NO_DELETE', "Warning : could not remove all tables/files in {SITE}");
 define ('ERROR_NO_DELETE_AGORA', "could not remove entry for the site {SITE} in the agora database");
 define ('LABEL_FILE_REMOVING', "Removing file: ");
 define ('LABEL_DIRECTORY_REMOVING', "Removing directory: ");
 define ('LABEL_SITE_REMOVING', "Site {SITE} has been removed.");
 define ('LABEL_SITE_CONTENT', "This site contains the following forums:");
 define ('LABEL_SITE_NO_CONTENT', "This site does not contain any forum");
 define ('LABEL_SITE_DELETE_CONFIRMATION', "Are you sure to remove site '{SITE}' ?");
 define ('LABEL_DELETE_THIS_SITE', "Delete this site");

 /////////////////////
 //File Edit_Site.php3
 /////////////////////
 define ('TITLE_SITE_EDIT', "Edit site");
 define ('ERROR_NO_READ_SITE_PROPERTIES', "Could not access {SITE} description.");
 define ('ERROR_NO_UPDATE_SITE_PROPERTIES', "Could not update characteristics of site {SITE}.");
 define ('LABEL_SITE_EDITING', "Editing site: ");
 define ('LABEL_SITE_PROPERTIES', "Site informations");
 define ('LABEL_CHANGE_SITE_ADMINISTRATOR', "Choose/change the User that you would like to become the main administrator of this site");
 define ('COLUMN_SITE_REGISTRATION_MODE',"Registration mode");
 define ('COLUMN_SITE_PASSWORD_HANDLING',"Password handling");

 /////////////////////
 //File editList.php3
 /////////////////////
 define ('NOTICE_DEFAULT_FILE', "Warning : this file is a default file for this installation");
 define ('ERROR_NO_CURRENT_FILE', "No current file");
 define ('ERROR_OPEN_FILE', "Could not open {FILE}");

 define ('LABEL_MAXTHREADS', "Maximum number of threads per page");
 define ('LABEL_PAD', "Padding sequence used for indentation");
 define ('LABEL_DEPTH_LIMIT', "Thread depth displaying limit");
 define ('LABEL_BEFORE_LINE', "Script executed for each line");
 define ('LABEL_SORT', "Default order");
 define ('LABEL_HOT_COLOR', "For newest messages, initialize {date_color} with : " );
 define ('LABEL_NEW_COLOR', "For recent messages, initialize {date_color} with :" );
 define ('LABEL_NORMAL_COLOR', "For older messages, initialize {date_color} with : ");
 define ('LABEL_HOT_AGE', "Number of seconds used for newest messages" );
 define ('LABEL_NEW_AGE', "Number of seconds used for recent messages");
 define ('LABEL_HOT_THRESHOLD', "Hot Topic Threshold (More than xx messages, 0 = not used)");
 define ('LABEL_TYPE_FILENAME', "Enter file name");
 define ('TITLE_SITE_OUTLINE', "Edit sites listing outline");
 define ('TITLE_FORUM_OUTLINE', "Edit forums listing outline");
 define ('TITLE_MESSAGE_OUTLINE', "Edit messages listing outline");
 define ('LABEL_FILE_EDITING', "Editing file");
 define ('LABEL_THREAD_FIRSTLINE_ODD', "First line in THREAD (odd)");
 define ('LABEL_THREAD_FIRSTLINE_EVEN', "First line in THREAD (even)");
 define ('LABEL_LEVEL_START', "Starts new LEVEL with");
 define ('LABEL_LEVEL_END', "Ends level with");
 define ('LABEL_LINE_CONTENT_ODD', "Reply Line contents (odd)");
 define ('LABEL_LINE_CONTENT_EVEN', "Reply Line contents (even)");
 define ('LABEL_THREAD_END', "Ends thread with");
 define ('LABEL_LIST_END', "End of list");

 define ('LABEL_GLOBAL_FORMAT', "Global listing formats");
 define ('LABEL_DEFAULT_ORDER', "Default order (in no-threaded mode)");
 define ('LABEL_USE_COLOR', "Use color");
 define ('LABEL_NEWEST_MESSAGE', "Newest messages");
 define ('LABEL_NEW_MESSAGE', "New messages");
 define ('LABEL_OLD_MESSAGE', "Old messages");
 define ('LABEL_MESSAGES_NEWER_THAN', "for messages newer than");
 define ('LABEL_FORUM_OUTLINE', "Forum listing outline");
 define ('LABEL_HEAD_LISTING', "Head of listing");
 define ('LABEL_CATEGORY_LINE', "Category line");

 define ('LABEL_SITE_LINE_ODD', "Site line (odd)");
 define ('LABEL_SITE_LINE_EVEN', "Site line (even)");

 define ('LABEL_FORUM_LINE_ODD', "Forum line (odd)");
 define ('LABEL_FORUM_LINE_EVEN', "Forum line (odd)");
 define ('LABEL_BOTTOM_LISTING', "End of list:");

 define ('EDIT_THREAD_LIST', "Edit main threads listing page (LIST mode): ");
 define ('LABEL_EDIT_SEARCH_LISTING' , "Edit SEARCH listing result page: ");
 define ('LABEL_SEARCH_FORM_TITLE', "Forum title (multi-forum search):");

 define ('EDIT_THREAD_VIEW', "Edit Thread listing displayed below message (VIEW mode): ");
 define ('LABEL_FIRST_THREAD', "First message in thread");
 define ('EDIT_THREAD_DOWNLOAD', "Edit listing (thread) format in <B>DOWNLOAD</B> mode:");

 /////////////////////
 //File Admin_Site.php3
 /////////////////////
 define ('LABEL_AGORA_WEBSITE', 'W-Agora Web Site');
 define ('TITLE_SITE_ADMINISTRATION', 'Administration of site');
 define ('LABEL_RELOGIN', 'Relogin (change user)');
 define ('LABEL_SITES', 'Sites list');
 define ('LABEL_ADMINISTRATION_MAIN', 'Return to the main administration page');
 define ('ALT_STATS', 'Show statistics for the site %s');
 define ('LABEL_ACCESS_THIS_SITE', 'Access this site');
 define ('ALT_ACCESS_SITE', 'access site %s as a user');

 define ('LABEL_CATEGORIES', "Categories");
 define ('COLUMN_ADMIN_USERS', "Admin users");
 define ('COLUMN_INACTIVE_USERS', "Inactive users");
 define ('COLUMN_MAIL_USERS', "Mail users");

 define ('ALT_USER_EDIT', "Edit user");
 define ('ALT_USER_ADMIN', "Manage registered users");
 define ('ALT_USER_ADD', "Add user");
 define ('ALT_USER_DELETE', "Delete user");
 define ('ALT_INACTIVE_USERS', "Delete inactive users");
 define ('ALT_MAIL_USERS', "Mail users");
 define ('ALT_CATEGORY_CREATE', "Add category");
 define ('ALT_CATEGORY_EDIT', "Edit category");

 define ('COLUMN_MANAGE_FORUM', "Admin forums");
 define ('COLUMN_CHANGE_ORDER', "Change order");

 define ('ALT_FORUM_MANAGE', "Manage forum");
 define ('ALT_FORUM_CREATE', "Create forum");
 define ('ALT_FORUM_ORDER', "Change the order that the forums are displayed");

 define ('LABEL_FORUM_LAYOUT', "Forums listing layout");

 define ('LABEL_SITECONF', 'Configuration');
 define ('LABEL_STYLESHEET', 'Style sheet');
 define ('LABEL_HEADER', 'Header');
 define ('LABEL_FORUM_LIST', 'Forums listing');
 define ('LABEL_FOOTER', 'Footer');
 define ('LABEL_MESSAGES', 'Messages');

 define ('ALT_SITECONF', 'Edit general settings in forum listing (BODY, date format, ...)');
 define ('ALT_MODIFY_STYLESHEET', 'Modify Style sheet (CSS) file');
 define ('ALT_HEADER', 'Edit the header of the forums list');
 define ('ALT_FOOTER', 'Edit the footer of the forums list');
 define ('ALT_FORUM_LIST', 'Edit the layout of the forums list');
 define ('ALT_MESSAGES', 'Edit texts,messages, images displayed in the forums list');

 define ('LABEL_DEFAULT_TEMPLATES', "Site default templates");

 define ('COLUMN_PROFILE', "Show profile");
 define ('COLUMN_LOGIN', "Login form");
 define ('COLUMN_REGISTER', "Register form");
 define ('COLUMN_CHANGE_PASSWORD', "Change password form");
 define ('COLUMN_FORGOT_PASSWORD', "Forgot password form");
 define ('COLUMN_MAIL', "Mail templates");
 define ('COLUMN_SUBSCRIBING', "Mail subscribing form");

 define ('ALT_PROFILE_FORM', "Edit profile template");
 define ('ALT_LOGIN_FORM', "Edit login form");
 define ('ALT_REGISTER_FORM', "Edit register form");
 define ('ALT_CHANGE_PASSWORD_FORM', "Edit change password form");
 define ('ALT_FORGOT_PASSWORD', "Edit forgot password form");
 define ('ALT_MAIL_TEMPLATE', "Mail configuration and templates");
 define ('ALT_SUBSCRIBE_FORM', "Edit subscribing form");

 define ('LABEL_USER_TEMPLATES', "User management templates");
 define ('COLUMN_USER_FIELDS', "User fields");
 define ('ALT_USER_FIELDS', "Edit/Add user profile fields ");

 /////////////////////
 //File admin_Forum.php3
 /////////////////////
 define ('TITLE_FORUM_ADMINISTRATION', "Forum administration (Site: %s)");
 define ('LABEL_CHOOSE_FORUM', "Choose the forum you wish to administrate/edit or delete");
 define ('ERROR_NO_FORUM_ADMIN', "No available forum in site '%s',<br> hit the button 'OK' to create a new one.");
 define ('ERROR_NO_FORUM', "There is no available forum in the site '{SITE}' that your are responsible for .");
 define ('LABEL_FORUM_ADMINISTRATION', "Administration of forum ");
 define ('LABEL_SITE', "Site ");
 define ('LABEL_FORUM', "Forum");
 define ('LABEL_FORUM_ACCESS', "Access forum ");
 define ('LABEL_ACCESS_THIS_FORUM', "Access this forum");
 define ('ALT_ADMINISTRATION_SITE', 'Return to the admin of the site %s');

 define ('TITLE_NOTES_MANAGEMENT', "Notes management");
 define ('LABEL_EDIT_NOTES', "Manage notes");
 define ('LABEL_MANAGE_THREADS', "Manage threads");
 define ('LABEL_POST_MSG', "Post a message");

 define ('ALT_EDIT_NOTES', "Delete/Modify messages");
 define ('ALT_MANAGE_THREADS', "Delete - Copy - Move discussions");
 define ('ALT_POST', "Post");

 define ('LABEL_ADD_USER', "Add to this forum");
 define ('COLUMN_SHOWEDIT', "Show/Edit");
 define ('ALT_USER_SHOWEDIT', "View/Edit registered/pending users");
 define ('ALT_USER_CREATE', "Add user");

 define ('LABEL_CONFIGURATION', "Configuration");
 define ('LABEL_BASIC', "Basic");
 define ('LABEL_ADVANCED', "Advanced");
 define ('LABEL_PROPERTIES', "Properties");

 define ('ALT_BASIC', "Edit basic configuration parameters");
 define ('ALT_ADVANCED', "Edit advanced configuration parameters");
 define ('ALT_PROPERTIES', "Edit forum properties");

 define ('LABEL_LAYOUT', "Layout/Templates");

 define ('COLUMN_NOTES_LISTING', "Notes listing");
 define ('COLUMN_FORM', "Form");
 define ('COLUMN_MAIL_FORM',"Mail form");
 define ('COLUMN_FIELDS', "Fields");
 define ('COLUMN_TEMPLATE', "Template");
 define ('COLUMN_SEARCH_FORM', "Search form");
 define ('COLUMN_INCLUDED', "Included script");
 define ('COLUMN_PROFILE_FORM', "Profile form");
 define ('ALT_INCLUDED', "PHP script to be included befor access");
 define ('ALT_TEMPLATE', "Modify HTML note template");
 define ('ALT_FIELDS', "Modify/Edit Database fields");
 define ('ALT_SEARCH_FORM', "Edit search form");
 define ('ALT_FORM', "Edit HTML form used to Post/Edit notes");
 define ('ALT_MAIL_FORM', "Edit the form used to send private mails");
 define ('ALT_NOTES_LISTING', "Change/Edit notes listing");
 define ('ALT_AGORA_MESSAGES', "Change/Edit messages used by W-Agora");

define('LABEL_MASS_EDIT_FORUMS_DONE', 'Mass update has been done on all forums!');
define('TITLE_MASS_EDIT_FORUMS', 'Edit settings on all forums');
define('MSG_MASS_EDIT_FORUMS', 'This form enables you to edit some settings on all forums at the same time');
define('LABEL_MASS_EDIT_FORUM_STATE', 'Forum state');
define('LABEL_MASS_EDIT_FORUM_ACCESS', 'Access mode');
define('LABEL_MASS_EDIT_FORUM_MODERATED', 'Moderated forums');
define('BUTTON_UPDATE_ALL_FORUMS', 'Apply changes to all forums');

 /////////////////////
 //File Moderate_Notes.php3
 /////////////////////
 define ('TITLE_MODERATE_NOTES', 'Validate incoming messages');
 define ('ERROR_NO_INCOMING', 'There is no note awaiting moderation in this forum');
 define ('LABEL_MESSAGE_DELETE_CONFIRMATION', 'Are you sure to delete this message ?');
 define ('CAPTION_VALIDATE_DELETE_MESSAGE', 'Click on the message that you want to validate or delete.');
 define ('CAPTION_MESSAGE_ACTION', 'Choose the action you want to do with this message.');
 define ('LABEL_VALIDATE', 'Approve');
 define ('LABEL_DELETE', 'Delete');

 /////////////////////
 //Admin_Notes.php3
 /////////////////////
 define ('LABEL_DELETE_FOL_NOTES', "Following notes will be deleted");
 define ('LABEL_NOTES_IN_FORUM', "Notes in forum <font color=red>%s</font>");
 define ('LABEL_NO_FORM', "No  defined form for this forum");
 define ('LABEL_EDIT_NOTE', "Edit a note:");
 define ('LABEL_DISPLAY_NOTES', "Display notes");
 define ('LABEL_ALL_NOTES', "All notes");
 define ('LABEL_HIDDEN', "Hidden");
 define ('LABEL_VISIBLE', "Visible"); 
 define ('COLUMN_SHOW_NOTE', "Show");
 define ('COLUMN_HIDE_NOTE', "Hide");
 define ('ALT_DELETE_NOTE', "Delete this note");
 define ('ALT_EDIT_NOTE', "Edit this note");
 define ('ALT_POPUP', "Pop-up");

 define ('LABEL_COPY_FOL_NOTES', "The following notes (with ALL replies) will be copied/moved");
 define ('ACTION_MESSAGES_DELETE', "Delete selected notes");
 define ('ACTION_MESSAGES_COPY', "Copy selected notes to another thread into forum");
 define ('ACTION_MESSAGES_MOVE', "[Move notes]");
 define ('LABEL_SELECT_DEST_THREAD', "Select the destination thread where to copy the messages");
 define ('ERROR_COPY_NOTE', "Couldn't copy note {NOTE} into forum {FORUM}");
 define ('ERROR_DELETE_NOTE', "Couldn't delete message {NOTE} from forum {FORUM}");
 define ('ERROR_NO_DEST_FORUM', "Error: you must specify the destination forum.");
 define ('TITLE_COPY_NOTES', "Copying/moving messages");
 define ('OPEN_NEW_THREAD', "Open new thread");

 /////////////////////
 //Delete_Notes.php3
 /////////////////////
 define ('TITLE_DELETE_NOTES', "Delete a message");
 define ('CAPTION_SELECT_NOTES', "Select the notes you want to Edit/Delete");
 define ('LABEL_DELETE_THIS', "Deleting");
 define ('CAPTION_SELECT_NOTES_DELETED', "Select the notes you want to delete");

 /////////////////////
 //Delete_Threads.php3
 /////////////////////
 define ('ERROR_INCORRECT_DATES', "Incorrect dates given");
 define ('ERROR_NO_PERIOD', "Please, select a number of days/week or months");
 define ('ERROR_NO_NOTES_OLDER', "No note found older than {NUMBER} {UNIT}.");
 define ('CONFIRM_THREAD_MOVE', "Are you sure to move threads to forum \"{FORUM}\" ?");
 define ('CONFIRM_THREAD_COPY', "Are you sure to copy threads to forum \"{FORUM}\" ?");
 define ('CONFIRM_DELETE_THREAD', '%s threads will be removed, are you sure ? ');
 define ('CONFIRM_DELETE_THREAD_DATE', 'Are your sure to delete all threads between %s and %s');
 define ('ERROR_NO_THREAD', "No thread selected");
 define ('LABEL_COPYING_NOTES', "copying notes to {FORUM}...");

 define ('ERROR_PARENT_NOT_FOUND', "Could not insert message, parent not found");
 define ('ERROR_COPY_THREAD', "Could not copy thread {THREAD} into forum {FORUM}");
 define ('ERROR_DELETE_THREAD', "Could not remove thread {THREAD} from forum {FORUM}");
 define ('ERROR_INSERT_ATTTACHMENT', "Could insert attachment '{NAME}' for the note '{CLE}' in forum '{FORUM}'");

 define ('TITLE_MANAGE_THREADS', "Delete/Copy/Move threads");
 define ('CAPTION_SELECT_THREAD', "No thread selected");
 define ('LABEL_SELECT_THREAD', "select the thread that are to be deleted or copied/moved to another forum");
 define ('LABEL_SELECT_THREAD_OR_DATE', "Select threads or choose a range of threads");
 define ('LABEL_SELECT_INDIVIDUAL_THREAD', "Select individual threads below");
 define ('LABEL_EXECUTE', "Execute");
 define ('LABEL_THREAD_BETWEEN', "Select threads between");
 define ('LABEL_THREAD_OLDER', "Select threads older than: ");
 define ('LABEL_SELECT_ACTION', "Choose the action to perform");
 define ('ACTION_THREAD_DELETE', "Delete selected threads ");
 define ('ACTION_THREAD_MOVE', "move threads (delete threads once copied)");
 define ('ACTION_THREAD_COPY', "Copy selected threads to forum : ");
 define ('LABEL_REPLIES', "replies");

 /////////////////////
 //Admin_User.php3
 /////////////////////
 define ('TITLE_SITE_USER_ADMIN', "Manage users in site \"{SITE}\"");
 define ('TITLE_FORUM_USER_ADMIN', "Manage users in site \"{FORUM}\"");
 define ('TITLE_SELECT_USERS', "Choose users to manage");
 define ('TITLE_MAIL_USERS', "Compose mail to send to <font color=blue>%s</font>");
 define ('LABEL_CHOOSE_USERID_INIT', "Choose an initial");
 define ('LABEL_CHOOSE_USERID_PATTERN', "Or give a pattern");
 define ('LABEL_BY_NAME', "<b>By name</b>");
 define ('LABEL_BY_ACTIVITY', "<b>By activity</b>");
 define ('LABEL_SHOW_NO_POST', "Display users who never post...");
 define ('LABEL_SHOW_NO_LOGIN', "Display users who never login...");
 define ('LABEL_SHOW_DIDNT_POST', "Display users who didn't post since...");
 define ('LABEL_SHOW_DIDNT_LOGIN', "Display users who didn't login since......");
 define ('LABEL_SHOW_IN_STATE', "Display users in state: ");
 define ('LABEL_NOT_REGISTERED', "Not Registered");
 define ('LABEL_USERS_IN_STATE', "Users in state <font color=blue>%s</font> ");
 define ('LABEL_USERS_BEGINING', "Users who have ID or name begining by <font color=blue>%s</font> ");
 define ('LABEL_USERS_NEVER_POST', "Users who never post ");
 define ('LABEL_USERS_NEVER_LOGIN', "Users who never login ");
 define ('LABEL_USERS_DIDNT_POST', "Users who didn't post since <font color=blue>%s %s</font> ");
 define ('LABEL_USERS_DIDNT_LOGIN', "Users who didn't login since <font color=blue>%s %s</font> ");
 define ('LABEL_REG_USERS_FORUM', "in forum <font color=red>%s</font>");
 define ('LABEL_REG_USERS_SITE', "in site <font color=red>%s</font>");
 define ('LABEL_CONFIRM_USER_DELETE', "Are you sure you want to delete these users?");
 define ('LABEL_DELETE_THESE_USERS', "Delete these users");
 define ('LABEL_USER_CONFIRM_DELETE', "User <font color=blue>%s</font> has been deleted");
 define ('LABEL_RETURN_LIST', "Return to users list");
 define ('LABEL_EDIT_MAIL_PROFILE', "Mail profile to user <font color=blue>%s</font>");
 define ('LABEL_TO', "To");
 define ('LABEL_SEND', "Send mail");
 define ('LABEL_REG_USER_FORUM', "You are registered in this forum");
 define ('LABEL_NO_REG_USER_FORUM', "You are not registered in this forum");
 define ('LABEL_MAIL_USER_OK', "Mail has been sent to user(s) <font color=blue>%s</font>");
 define ('LABEL_MAIL_USER_NO_OK', "Could not send mail to user(s) <font color=blue>%s</font>");
 define ('ERROR_NO_USER_MATCHING', "No user matching (<font color=blue>%s</font>)");
 define ('ERROR_NO_REMOVE_PRIVILEGE', "You have not privileges to delete user <font color=blue>%s</font>");
 define ('ERROR_NO_EDIT_PRIVILEGE', "You have not privileges to edit user <font color=blue>%s</font>");
 define ('ERROR_NO_REMOVE_PERMISSION', "The user <font color=blue>%s</font> has access to a forum (%s) for which you have not moderator privilege,<bR> you cannot remove this user");
 define ('ERROR_SITE_USER_DELETE', "It is not possible to delete user <font color=blue>%s</font> in site %s");
 define ('LABEL_STATUS', "State");
 define ('ERROR_NO_MATCHING_USERS', "No matching users ");
 define ('ERROR_NO_MATCHING_USER', "User %s doesn't exist in this site");
 define ('ERROR_NO_OWNER_UPDATE', "Could not update owner of forum %s in site %s");
 define ('ERROR_NO_SITE_USER_UPDATE', "Could not update user {FORUM} in site {SITE}");
 define ('TITLE_EDITING_USER', "Editing user ");
 define ('LABEL_IN_SITE', "in site");
 define ('COLUMN_USER_EMAIL', "E-mail");
 define ('COLUMN_USER_WEBPAGE', "Home page");
 define ('COLUMN_USER_DESCRIPTION', "Description");
 define ('COLUMN_USER_LASTLOGIN', "Last login");
 define ('COLUMN_USER_MAILOK', "E-mail OK");
 define ('COLUMN_USER_COUNTRY', "Country");
 define ('LABEL_UNSELECT', "Unselect"); 
 define ('LABEL_SELECT_ALL', "Select all"); 
 define ('LABEL_WITH_SELECTED', "With selected : "); 
 define ('LABEL_MAIL_USER', "Send a mail"); 
 define ('LABEL_REMOVE_ACCESS', "Remove access"); 
 
 define ('ALT_CHANGE_PASSWORD', "Change user password");
 define ('CAPTION_USER_PRIVILEGE', "User privileges: ");
 define ('LABEL_CHANGE_USER_PRIVILEGE', "Change user privileges in : ");
 define ('LABEL_USER_SITE_STATUS', "User status in site : ");
 define ('LABEL_CHANGE_STATUS' , "Change status to : ");
 define ('LABEL_USER_CONFIRM_STATUS' , "User <font color=blue>%s</font> is now %s."); //$userid, $user_states[$user_state]
 define ('LABEL_MAIL_USER_STATUS' , "Send new status by mail");
 define ('LABEL_MAIL_STATUS_SUBJECT' , "Modification of your profile in sitede votre profil in site %s"); //$site
 define ('LABEL_MAIL_STATUS_BODY' , "Hello,\n administrator of site %s modified your account. Your account is now %s."); // $site, $user_state
 define ('ERROR_NO_ADMIN_CHANGE_STATUS', "Status of user 'Admin' can't be changed"); 
 define ('ERROR_NO_USER_STATUS', "Status of user couldn't be modified in site %s"); //$userid
 define ('ERROR_NO_ADMIN_CHANGE_PRIVILEGE', "The privilege can not be changed for user admin");
 define ('CAPTION_CHANGE_USER_FORUM_PRIVILEGES', "Select the access privileges you want to grant to this user");
 define ('LABEL_AS', "as ");
 define ('LABEL_GRANT_PRIVILEGES', "Select the access privileges you want to grant to this user");
 define ('COLUMN_CAN_LIST', "List");
 define ('COLUMN_CAN_READ', "Read");
 define ('COLUMN_CAN_WRITE', "Write");
 define ('COLUMN_SITE', "site");
 define ('LABEL_ADD_FORUM', "Add a forum : ");
 define ('LABEL_MAIL_USER_PROFILE', "Mail to user his new profile ");
 define ('LABEL_SHOW', "Show");

 define ('ERROR_NO_ADD_PRIVILEGES', "Could not add privileges to user %s in forum %s");

 define ('COLUMN_MAIL_SUBSCRIBED_USERS', "Mail subscribed users");
 define ('ALT_MAIL_SUBSCRIBED_USERS', "Send a mail to users who subscribed to this forum.");
 define ('LABEL_SEND_FORUM_SUBSCRIBED_EMAIL', "Send a mail to users subscribed to forum $bn_name");
 define ('TITLE_SELECT_SUBSCRIBED_USERS', "Chose subscribed users to administrate");
 define ('LABEL_NO_SUBSCRIBED_USERS', "No subscribed users in this forum");
 define ('LABEL_IN_FORUM', "in forum");
 define ('LABEL_SUBSCRIBE_USER', "Subscribe a new user");
 define ('LABEL_SUBSCRIBE', "Subscribe");
 define ('LABEL_UNSUBSCRIBE', "Unsubscribe");
 define ('LABEL_CONFIRM_USER_UNSUBSCRIBE', "Are you sure to unsubscribe these users ?");
 define ('LABEL_CONFIRM_USER_SUBSCRIBE', "Are you sure to subscribe these users ?");
 define ('ERROR_NO_MATCHING_ADDRESS', "Subscribed user %s not found in forum %s");
 define ('COLUMN_USER_NEW_EMAIL', "New address :");
 define ('LABEL_EDIT_MAIL_SUBSCRIBE', "Send user <font color=blue>%s</font> his(her) new address");
 define ('LABEL_MAIL_USER_SUBSCRIBE', "Send user his(her) new subscription");
 define ('COLUMN_ADMIN_SUBSCRIBED_USERS', "Subscribed users");
 define ('ALT_ADMIN_SUBSCRIBED_USERS', "Administrate users who subscribed to this forum");
 define ('TITLE_FORUM_SUBSCRIBED_USER_ADMIN', "Administrate subscribed users in forum \"{FORUM}\"");
 define ('LABEL_USER_CONFIRM_UNSUBSCRIBE', "User <font color=blue>%s</font> has been unsubscribed");
 define ('LABEL_USER_CONFIRM_SUBSCRIBE', "User <font color=blue>%s</font> has been subscribed");
 define ('LABEL_KEEP_THREADS', "Keep threads subcriptions");
 define ('LABEL_MAIL_SUBSCRIBE_SUBJECT', "Your subscription to forum %s");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_YES', "You've been subscribed to forum %s. You will receive every new messages bay e-mail.");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_NO', "You've been unsubcribed from forum %s. You'll no longer receive e-mails from this forum.");
 define ('LABEL_SUBSCRIBED_USERS', "Subscribed users");
 define ('LABEL_UNSUBSCRIBED_USERS', "Unsubscribed users");

 /////////////////////
 //Add_User.php3
 /////////////////////
 define ('TITLE_ADD_USER', "Add user");
 define ('ERROR_NO_ADD_USER', "Could not add user %s in the table %s_userforum");
 define ('WARNING_USER_ADDED', "User '%s' has been added in forum '%s'");
 define ('LABEL_RETRIEVING_USERS', "Getting all users in this site (please wait) ...");
 define ('WARNING_NO_USER_TO_ADD', "No user to add");
 define ('LABEL_ADD_FORUM_USER', "Add a user to the forum <em><FONT color=#FF6633>%s</FONT></em>");
 define ('LABEL_CHOOSE_USER_ADD', "Choose a user to add");
 define ('LABEL_USER_GRANT_PRIVILEGES', "<b>Set privileges over forum <FONT color=#FF6633>%s</font> for this user</b><br>");
 define ('LABEL_ACTIVE', "Active");
 define ('LABEL_FORM_SELECT', "&lt;-- Choose an entry --&gt;");
 define ('LABEL_ENTER_EMAILS_TO_ADD', 'Enter here the email list of users you want to add');
 define ('LABEL_CHOOSE_EMAILS_FILE', 'Choose a file that contain a list of user emails');

 /////////////////////
 //Create_User.php3
 /////////////////////
 define ('TITLE_NEW_USER', "Create user");
 define ('ERROR_NO_PASSWORD', "Password must be set and must be entered twice, please verify");
 define ('ERROR_NO_SITE_ADD_USER', "Could not add user %s in the table %s_users");
 define ('LABEL_USER_ADDED', "User '%s' has been created");
 define ('LABEL_USER_SENT_FOR_APPROVAL', "His/her account will bea ctive once validated by the administrators of the site."); 
 define ('LABEL_CREATE_ANOTHER_USER', "Create user");
 define ('LABEL_EDIT_THIS_USER', "Modify this user");
 define ('ALT_EDIT_THIS_USER', "Edit user informations");
 define ('LABEL_SITE_CREATE_NEW_USER', "Create a new user in the site: ");
 define ('LABEL_USER_INFORMATIONS', "User informations");
 define ('COLUMN_USER_PASSWORD', "Enter password");
 define ('COLUMN_USER_CONFIRM_PASSWORD', "Please reenter the password");
 define ('LABEL_ADD_MAILING_LIST', "Add this user to the mailing list?");
 define ('LABEL_CREATE_USER', "Create user");
 define ('LABEL_USER_PRIVILEGE', "Choose privilege for this user");
 
 /////////////////////
 //Mail_Users.php3
 /////////////////////
 define ('LABEL_SEND_SITE_EMAIL', 'Send email to users in site ');
 define ('LABEL_SEND_FORUM_EMAIL', 'Send email to users in forum ');
 define ('LABEL_NO_ACTIVE_USERS', 'No active user found ');
 define ('LABEL_MAIL_USERS', 'Mail will be sent to %s user(s)');
 define ('LABEL_USER_MAILED', 'Mail sent to <em> %s </em> <tt>&lt; %s &gt;</tt>.<br>');
 define ('LABEL_USER_NOT_MAILED', '%s &lt; %s &gt; decided not to receive mail.<br>');
 define ('LABEL_MAIL_FILL_FORM', 'Fill this form to send your message');
 define ('LABEL_SEND_TO_ALL', 'Send to ALL users');
 define ('COLUMN_TO', 'Send to:');
 define ('COLUMN_FROM', 'From:');
 define ('COLUMN_REPLY_TO', 'Reply to:');
 define ('COLUMN_MESSAGE', 'Message:');
 define ('LABEL_SEND_MAIL', 'Send mail');

 /////////////////////
 //Editconf.php3
 /////////////////////
 define ('ERROR_NO_WRITE_CONFIGURATION', "Cannot write configuration file, check permissions");
 define ('ERROR_FILE_UPLOAD_DISABLED', "File upload feature has been disabled on this server, check your PHP configuration (php.ini) or contact your ISP!!");
 define ('LABEL_CHANGE_CONFIG_DONE', "Changes saved to ");
 define ('LABEL_SETTINGS_RESTORED', "Settings have been restored");
 define ('LABEL_FORUM_CONFIGURATION', "Forum %s configuration");
 define ('LABEL_EDITING_FILE', "Editing file: ");
 define ('TITLE_GENERAL_SETTINGS', "General settings");
 define ('COLUMN_BODY', "Background");
 define ('ALT_BODY', "Additional parameter to the Tag &lt;BODY&gt;");
 define ('COLUMN_DATE_FORMAT', "Date format");
 define ('ALT_DATE_FORMAT', "Format for displaying dates (see the PHP documentation)");
 define ('COLUMN_TIME_OFFSET', "Time offset");
 define ('ALT_TIME_OFFSET', "Time offset from local time (in Hours)");
 define ('COLUMN_USE_COOKIE', "Use cookies");
 define ('ALT_USE_COOKIE', "Set/get cookies to store username/address and to manage new messages");
 define ('COLUMN_ALLOW_MODIFICATION', "Allows modification");
 define ('ALT_ALLOW_MODIFICATION', "Allows the users to modify (edit) notes, a password is necessary to edit a note");
 define ('COLUMN_ALLOW_DELETE', "Allows deletes");
 define ('ALT_ALLOW_DELETE', "Allows the users to delete notes, the user's password is necessary to delete a note");

 define ('TITLE_MESSAGE_FORMATING', "Message formatting");
 define ('COLUMN_ALLOW_HTML', "Allows HTML");
 define ('ALT_ALLOW_HTML', "Allows the users to insert HTML tags");
 define ('COLUMN_TAGS_ALLOWED', "Allows tags:");
 define ('ALT_TAGS_ALLOWED', "type in the HTML tags which will only be accepted from user input, separated by spaces, commas or semicolons (do not insert < and >)");
 define ('COLUMN_TAGS_DISALLOWED', "Disallows tags:");
 define ('ALT_TAGS_DISALLOWED', "type in the HTML tags which will be censored (stripped) from user input, separated by spaces, commas or semicolons (do not insert < and >) Only used if 'allows tag' is empty");
 define ('COLUMN_USE_SMILEY', "Use smileys");
 define ('ALT_USE_SMILEY', "Convert smileys to icons (only fields accepting HTML will accept smileys)");
 define ('COLUMN_CONVERT_URL', "Convert URLs");
 define ('ALT_CONVERT_URL', "Auto-convert embedded URL to links (only in fields accepting HTML)");

 define ('TITLE_LAMER_FILTER', "Lamer filters");
 define ('COLUMN_DISALLOW_IP', "Disallows ips: :");
 define ('ALT_DISALLOW_IP', "Type the ips which will be disallowed from posting, separated by spaces, commas or semicolons");

 define ('TITLE_FILE_UPLOAD', "File Upload");
 define ('COLUMN_FILE_UPLOAD', "File upload support ");
 define ('ALT_FILE_UPLOAD', "Allows users to upload files (as attachments) to your server");
 define ('COLUMN_MAX_FILE_SIZE', "Maximum file size (in bytes)");
 define ('ALT_MAX_FILE_SIZE', "Limit the allowed size of uploaded files");

 define ('COLUMN_ALLOW_EXTENSION', "allows only extensions: ");
 define ('ALT_ALLOW_EXTENSION', "Type in the file extensions (eg: .gif) which will only be allowed for uploaded files, separated by spaces, commas or semicolons");
 define ('COLUMN_DENY_EXTENSION', "deny extensions: ");
 define ('ALT_DENY_EXTENSION', "type the file extensions (eg: .gif) which will be rejected for uploaded files, separated by spaces, commas or semicolons (only used if 'allows extension' field is empty)");

 define ('COLUMN_ALLOW_MIME', "allows mime-types: ");
 define ('ALT_ALLOW_MIME', "type the mime-types (eg: image/gif, text/*) which will be allowed for uploaded files, separated by spaces, commas or semicolons (the extensions must have the format (type/subtype or type/*)) ");
 define ('COLUMN_DENY_MIME', "deny mime-types: ");
 define ('ALT_DENY_MIME', "type the mime-types (eg: image/gif, text/*) which will be allowed for uploaded files, separated by spaces, commas or semicolons (only used if 'allows mime-types' field is empty)");

 define ('TITLE_SEARCH', "Search");
 define ('COLUMN_SEARCH_SUPPORT', "Search support ");
 define ('ALT_SEARCH_SUPPORT', "Allows users to search in the notes");
 define ('COLUMN_SEARCH_ENGINE', "Search Engine: ");
 define ('COLUMN_PATH_NAME', "Pathname ");
 define ('ALT_PATH_NAME', "Location of the search program");
 define ('TITLE_SEND_MAIL', "Sending e-mails");
 define ('COLUMN_MAIL_MODERATOR', "Send mail to the moderator");
 define ('ALT_MAIL_MODERATOR', "Inform the main moderator by email when a note has been posted or updated");
 define ('COLUMN_ALLOW_MAIL_SUBSCRIPTION', "Allows mail subscription");
 define ('ALT_ALLOW_MAIL_SUBSCRIPTION', "Allows the users to receive replies by mail");
 define ('COLUMN_ALLOW_PRIVATE_MAIL', "Allow private mails");
 define ('ALT_ALLOW_PRIVATE_MAIL', "allow users tosend private mails to the authors of notes");
 define ('COLUMN_MAIL_ATTACHMENT', "Attach files to mails");
 define ('ALT_MAIL_ATTACHMENT', "Attach \"attachment\" files to the mails sent to users");
 define ('LABEL_DEFAULT', "Undo");

 define ('LABEL_FRAMES', "Frames");
 define ('COLUMN_USE_FRAMES', "Use frames");
 define ('ALT_USE_FRAMES', "Even if the option is set, old browsers are also supported");
 define ('COLUMN_FRAMESET_PARAMETER', "Frameset parameter:");
 define ('ALT_FRAMESET_PARAMETER', "Additional parameter to the tag &lt;FRAMESET&gt; ");
 define ('COLUMN_HEADER_FRAME_PARAMETER', "Header Frame parameter:");
 define ('ALT_HEADER_FRAME_PARAMETER', "Additional parameter to the tag &lt;FRAME&gt; ");
 define ('COLUMN_FOOTER_FRAME_PARAMETER', "Footer Frame parameter:");

 define ('TITLE_POST_MESSAGES', "Post messages");
 define ('COLUMN_POST_POPUP', "Post in popup window ");
 define ('ALT_POST_POPUP', "Open a separate window for the post/reply/edit form");
 define ('COLUMN_NO_BUTTON_BAR', "Don't display buttons bar");
 define ('ALT_NO_BUTTON_BAR', "Do not display the buttons bar and options at bottom of the post/reply/edit form");
 define ('COLUMN_NO_THANKS', "Don't display thanks message ");
 define ('ALT_NO_THANKS', "Display the next page after posting/editing without displaying the thanks message");
 define ('COLUMN_AFTER_POSTING', "After posting, return to");
 define ('ALT_AFTER_POSTING', "Page to return to after sending post");
 define ('COLUMN_NEWLY_POSTED', "Newly posted message");
 define ('COLUMN_MESSAGE_LIST', "Messages listing");
 define ('COLUMN_FIRST_MESSAGE', "First message in thread");

 define ('TITLE_INCLUDE_FILES', "Include files (all files are located in %s), leave these fields blank to use defaults");

 define ('COLUMN_CSS_FILE', "Style sheet (CSS) file:");
 define ('ALT_CSS_FILE', "CSS file (included in the &lt;head&gt; tag:");
 define ('COLUMN_HEADER_FILE', "Header file");
 define ('ALT_HEADER_FILE', "Header include file");
 define ('COLUMN_FOOTER_FILE', "Footer");
 define ('ALT_FOOTER_FILE', "Footer include file");
 define ('COLUMN_LISTING_OUTLINE', "Listing outline");
 define ('ALT_LISTING_OUTLINE', "Listing of notes");
 define ('COLUMN_INCLUDE_MESSAGES', "Messages");
 define ('ALT_INCLUDE_MESSAGES', "Displayed messages and images file");
 define ('COLUMN_FORM_FILE', "Form");
 define ('ALT_FORM_FILE', "FORM used to post/edit/reply to a message");
 define ('COLUMN_MAIL_FORM_FILE', "Private mails form");
 define ('ALT_MAIL_FORM_FILE', "form used to send private mails");
 define ('COLUMN_FILE_SEARCH', "Search Form");
 define ('ALT_FILE_SEARCH', "Search Form");
 define ('COLUMN_TEMPLATE_FILE', "Template");
 define ('ALT_TEMPLATE_FILE', "Message template");
 define ('COLUMN_FIELDS_NAME', "Fields names");
 define ('ALT_FIELDS_NAME', "Fields (variables) definition");
 define ('COLUMN_PHP_INCLUDE', "PHP file included before access");
 define ('ALT_PHP_INCLUDE', "Optional PHP file executed (included) before insert datas");
 define ('COLUMN_FILE_LOGIN', "Login form");
 define ('ALT_FILE_LOGIN', "User login form");
 define ('COLUMN_REGISTER_FORM', "Register form");
 define ('ALT_FILE_REGISTER', "User registration form");
 define ('COLUMN_SHOW_PROFILE', "Show profile template");
 define ('ALT_FILE_SHOW_PROFILE', "User profile displaying");
 define ('COLUMN_FILE_CHANGE_PASSWORD', "Change password form");
 define ('ALT_FILE_CHANGE_PASSWORD', "Forgot password form");
 define ('COLUMN_FILE_FORGOT_PASSWORD', "Forgot password form");
 define ('ALT_FILE_FORGOT_PASSWORD', "User forgotten password form");
 define ('COLUMN_FILE_MAIL_TEMPLATE', "Mail template");
 define ('ALT_FILE_MAIL_TEMPLATE', "Mail configuration and templates");
 define ('COLUMN_SUBSCRIBE_FORM_TEMPLATE', "Subscribe form template");
 define ('ALT_FILE_SUBSCRIBE_FORM', "Forum mail subscribing template");

 define ('TITLE_DISCUSSION_BOARD', "Discussion board");
 define ('COLUMN_ALLOW_REPLIES', "Allows replies (thread notes)");
 define ('ALT_ALLOW_REPLIES', "Allows the users to reply to notes (threads)");

 define ('TITLE_DISPLAYED_MESSAGE', "Displayed messages");
 define ('COLUMN_NO_TOOLBAR', "No toolbar in message ");
 define ('ALT_NO_TOOLBAR', "Do not display the menu bar (reply|edit|delete|list) at the end of the displayed message");
 define ('COLUMN_NO_NAVIGATION_BAR', "No navigation bar in message");
 define ('ALT_NO_NAVIGATION_NAR', "Do not display the navigation bar (next / previous thread/note URLs) in the displayed message");
 define ('COLUMN_NO_THREAD', "No thread in message");
 define ('ALT_NO_THREAD', "Do not display the current thread in the displayed message");
 define ('COLUMN_APPEND_MESSAGE', "Append reply form to displayed message");
 define ('ALT_APPEND_MESSAGE', "Display the reply form at the end of the displayed message");

 define ('TITLE_MESSAGE_LISTING', "Messages listings");
 define ('COLUMN_MESSAGE_NO_NAVIGATION_BAR', "No navigation bar in the list");
 define ('ALT_MESSAGE_NO_NAVIGATION_NAR', "Do not display the navigation bar (next / previous page URLs) in the list of messages");
 define ('COLUMN_GUESTBOOK', "Append post form to messages listing");
 define ('ALT_GUESTBOOK', "Display the form at the end of the list of messages (guestbook mode)");

 define ('TITLE_BROWSE_SERVER', "Browse server");
 define ('COLUMN_BROWSE_SERVER', "Server file browser support");
 define ('ALT_BROWSE_SERVER', "Allows users to attach files located on your server");
 define ('COLUMN_BASE_DIRECTORY', "Base directory");
 define ('ALT_BASE_DIRECTORY', "Define the top directory where users can browse documents to attach");

 /////////////////////
 //Edit_Forum.php3
 /////////////////////
 define ('LABEL_EDIT_FORUM', "Edit forum characteristics");
 define ('LABEL_SITE_EDIT_FORUM', "Choose the forum you wish to edit in the site %s");
 define ('ERROR_NO_FORUM_UPDATE', "Could not update forum %s in site %s");
 define ('ERROR_NO_NEW_MODERATOR', "Could not set moderator privilege for the user %s over forum %s ");
 define ('LABEL_EDIT_FORUM_SHORT', "Edit forum: ");
 define ('LABEL_FORUM_INFORMATION', "Forum's informations");
 define ('COLUMN_STATE', "State");
 define ('COLUMN_CATEGORY', "Category");
 define ('LABEL_PRIVACY_INFORMATION', "Privacy Informations");
 define ('LABEL_CHANGE_ACCESS', "Change the access mode for this forum");
 define ('LABEL_MODERATED', "moderated");
 define ('LABEL_UPDATE_THIS_FORUM' , "Update forum");
 define ('LABEL_CHOOSE_MODERATOR', "Choose/change the User that you would like to become the main moderator of this forum");

 /////////////////////
 //admin_categories.php3
 /////////////////////
 define ('LABEL_EDIT_CATEGORIES', "Edit Categories in site ");
 define ('LABEL_ADD_CATEGORY', "Add category");
 define ('COLUMN_EDIT_CATEGORY', "Modify category ");
 define ('COLUMN_DELETE_CATEGORY', "Delete category ");
 define ('COLUMN_CAT_TITLE', "Category title");
 define ('LABEL_UPDATE_ORDER', "Update order");
 define ('LABEL_ADD_NEW_CATEGORY', "Add new category");
 define ('LABEL_ADD_THIS_CATEGORY', "Add this category");
 define ('LABEL_EDIT_CATEGORY', "Edit category");
 define ('LABEL_UPDATE_THIS_CATEGORY', "Update this category");

 /////////////////////
 //Create_Forum.php3
 /////////////////////
 define ('TITLE_CREATE_FORUM', "Create forum");
 define ('ERROR_FORUM_NAME_TO_LONG', "Forum name is too long, please choose a shorter one.");
 define ('ERROR_CONFIG_FILE_EXISTS', "Configuration file (%s) already exists, you must delete it manually or choose another name");
 define ('ERROR_NO_FILE_COPY', "Could not copy file %s");

 define ('ERROR_FORUM_DB_DBM_EXISTS', "Site databaes %s already exists, <br> you must delete the DBM file : <em>dbm/%s/%s</em><br> [and the lockfile .lck] manually");
 define ('ERROR_FORUM_DB_EXISTS', "The forum's table (%s) already exists in this database (%s), you must first drop this table manually or choose another name");

 define ('ERROR_FORUM_DB_DBM_ACCESS', "Access problem, could not create DBM file (<em>%s</em>) check space and permissions in the file system");
 define ('ERROR_FORUM_DB_ACCESS', "Access problem, could not create table (<em>%s</em>) make sure you have created a database named %s and check access rights");
 define ('ERROR_NO_CREATE_FORUM', "Could not create forum:");
 define ('ERROR_NO_FORUM_INSERT', "Could not create forum %s in site %s");
 define ('LABEL_FORUM_CREATED', "Forum '<em>%s</em>' has been created in site %s<BR><BR>&nbsp;&nbsp;you can now:");
 define ('LABEL_CREATE_ANOTHER_FORUM', "Create another forum");
 define ('ALT_ACCESS_FORUM', "Access forum");
 define ('LABEL_ADMINISTRATE_FORUM', "Administrate forum");
 define ('ALT_ADMINISTRATE_FORUM', "Configure more settings on this forum");
 define ('LABEL_EDIT_THIS_FORUM', "Edit this forum");
 define ('ALT_EDIT_THIS_FORUM', "Edit characteristics of this forum");
 define ('LABEL_SITE_ADMINISTRATION', "Return to site administration");
 define ('LABEL_FORUM_CREATED_SUCCESSFULLY', "Forum %s was successfully created");
 define ('LABEL_INSTALL_FORUM', "Install a new forum in site: ");
 define ('COLUMN_GIVE_FORUM_NAME', "Forum's name:");
 define ('COLUMN_FORUM_TEMPLATE', "Choose a template (theme):");
 define ('LABEL_SET_ACCESS', "Choose the access mode for this forum:");
 define ('LABEL_CREATE_THIS_FORUM', "Create this forum");
 define ('LABEL_NAME_OF_FORUM', "(name you give to this forum)");
 define ('LABEL_CHOOSE_FIRST_MODERATOR', "Choose the User (owner) that you would like to moderate this forum:");

 /////////////////////
 //Reorder_Forum.php3
 /////////////////////
 define ('TITLE_REORDER_FORUM', "Change the order that the forums are displayed in the site: ");
 define ('LABEL_CHANGE_FORUM_ORDER', "Below you can change the order that the forums are displayed. Assign each forum an individual number starting at 1. Setting a value of 0 will hide the forum from the list");


 /////////////////////
 //editform.php3
 /////////////////////
 define ('LABEL_NEW_FILE_EDITING', "Editing new file:");
 define ('WARNING_EDITING_DEFAULT', "Warning : this file is a default file for this site, modifications will affect all forums that use the default in this site.");
 define ('LABEL_SPECIFIC_TEMPLATE', "if you wish to use a specific template, you can set its name in the <a href='%s'>settings page</a>");

 /////////////////////
 //editmsg.php3
 /////////////////////
 define ('TITLE_EDITING_MESSAGES', "Editing messages");
 define ('ERROR_NO_CREATE_MESSAGE', "Cannot create messages file , check permissions");

 /////////////////////
 //editfields.php3
 /////////////////////
 define ('TITLE_EDITING_FIELDS', 'Editing fields');
 define ('LABEL_NAME', 'Name');
 define ('LABEL_SIZE', 'Size');
 define ('LABEL_REQUIRED', 'Required');
 define ('LABEL_LISTED', 'Listed');
 define ('LABEL_ACCEPT_HTML', 'Accept HTML/smileys');
 define ('LABEL_SAVE_COOKIE', 'Save in a permanent cookie');
 define ('LABEL_DELETE_FIELD', 'Delete');
 define ('LABEL_USER_VARIABLES', 'User variables');
 define ('LABEL_LISTED_VARIABLES', 'Listed variables');
 define ('LABEL_REQUIRED_VARIABLES', 'Required variables');
 define ('LABEL_VARIABLES_ACCEPT_HTML', 'HTML accepted variables');
 define ('LABEL_VARIABLES_COOKIE', 'Variables set as permanent cookie');
 define ('LABEL_CONFIRM_DELETE_FIELD', 'Do you wish to delete this field from the table description');
 define ('ALT_DELETE_FIELD', 'Delete field : %s');
 define ('ALT_ADD_FIELD', 'Add a field');
 define ('ERROR_UNDEFINED_VARNAME', 'Please, give a name to the field you want to add');
 define ('ERROR_UNDEFINED_VARSIZE', 'Please give a size/type for the field you want to add [xxx | int | text]');
 define ('ERROR_VARNAME_ALREADY_DEFINED', 'This field name is already used');

 /////////////////////
 //edittemplate.php3
 /////////////////////
 define ('TITLE_EDITING_TEMPLATE', "Edit templates");
 define ('LABEL_DEFINE_DOCUMENT_GENERATION', "Define how the documents will be generated (from the template):");
 define ('LABEL_STATIC', "<b>Static</b><i> (an HTML file is created when a note is posted) </i>");
 define ('LABEL_ONTHEFLY', "<b>On the fly</b><i> (no HTML file, the note is generated dynamically when the user access it)</i>");
 define ('LABEL_NO_DOCUMENTS', "<b>No document</b><i> (only the database is listed)</i>");
 define ('LABEL_EDIT_TEMPLATE', "Edit documents's template:");

 /////////////////////
 //editmail.php3
 /////////////////////
 define ('TITLE_EDITING_MAIL', "Editing mail template");
 define ('LABEL_OVERWRITE_MAIL_FILE', "Mail template file (<font color=red>WARNING!</font> this choice will overwrite current file)");
 define ('LABEL_SEND_OUT_EMAILS', "Send out emails from (from: header)");
 define ('LABEL_USER_EMAIL', "User email addresss");
 define ('LABEL_THIS_EMAIL', "This e-mail");
 define ('LABEL_FIRST_RECIPIENT', "First recipient (To: header)");
 define ('LABEL_RETURN_PATH', "Return-Path");
 define ('LABEL_REPLY_TO', "Reply-To");
 define ('LABEL_BEFORE_MAIL', "Script executed before sending mails");
 define ('LABEL_NO_MAIL_SUBJECT', "Mail subject if no subject in note");
 define ('LABEL_MAIL_SUBJECT', "Mail subject");
 define ('LABEL_MAIL_APPROVAL', "Mail sent to moderators for message approval (moderated forum)");
 define ('LABEL_MAIL_POSTED', "Mail sent when a new note is posted");
 define ('LABEL_MAIL_MODIFIED', "Mail sent when a note is modified");
 define ('LABEL_MAIL_BODY', "Body");
 define ('LABEL_MAIL_REGISTRATION', "Mail sent to users for registration");
 define ('LABEL_MAIL_CONFIRM_REGISTRATION', "Mail sent to users after administrator edit profile");
 define ('LABEL_MAIL_USER_APPROVAL', "Mail sent to moderators for user approval");
 define ('LABEL_MAIL_USER_MODIFICATION', "Mail sent to moderators for user profile modification");
 define ('LABEL_MAIL_FORGOT_PASSWORD', "Mail sent to users who forgot their password");

 /////////////////////
 //delete_Forum.php3
 /////////////////////
 define ('TITLE_DELETE_FORUM', 'Delete forum');
 define ('TITLE_DELETE_FORUM_IN_SITE', 'Delete forum %s from site %s');

 define ('ERROR_MUST_BE_ADMIN_TO_REMOVE_FORUM', 'You must be logged as an administrator to delete a forum');
 define ('ERROR_NO_AVAILABLE_FORUM', 'No available forum in site %s,<br>');
 define ('ERROR_FORUM_DOESNT_EXIST', 'forum %s does not exists in this site');
 define ('ERROR_CANT_REMOVE_FORUM', 'Could not remove forum %s from site %s');

 define ('LABEL_CHOOSE_FORUM_TO_DELETE', 'Choose the forum you wish to delete from the site %s');
 define ('LABEL_FORUM_DELETED', 'Forum %s has been deleted');

 define ('CAPTION_DELETE_FORUM', '<B>Are you sure to remove the following forum</B>');
 define ('LABEL_FORUM_TITLE', 'subject: ');
 define ('LABEL_FORUM_DESCR', 'Description: ');
 define ('LABEL_FORUM_OWNER', 'Owner: ');
 define ('LABEL_FORUM_TYPE', 'Type: ');
 define ('LABEL_FORUM_MODER', 'Moderated: ');
 define ('LABEL_FORUM_STATE', 'State: ');
 define ('LABEL_DELETE_THIS_FORUM', 'Remove this forum');
?>
