<?PHP

/*
 * W-AGORA 4.1
 * -----------
 * $Id: admin_de.inc,v 1.61 2005/02/09 15:20:04 mdruilhe Exp $
 * Usage: Administration localized strings constant
 * Description: This script is used to define strings used by the administration part of the application
 * Author: Alexandre GHEZ (aghez@decan.fr)
 * German translation by Ralf Schaefer (ralf.schaefer@gmx.ch)
 */

 ///////////////////
 // file setup.php3
 ///////////////////
 define ('ERROR_SETUP_ALREADY_DONE', 'W-Agora scheint bereits installiert zu sein,<br> die Hauptkonfigurationsdatei (<tt>%s</tt>) existiert bereits,<br> sie mu (zusammen mit den Datenbanktabellen) manuell gel&ouml;scht werden bevor erneut eine Installation erfolgen kann.<br><br>Dr&uuml;cken Sie OK um eine neue Site zu erzeugen');
 define ('ERROR_MISSING_ADMIN_NAME', 'Der Name des Systemadministrators mu angegeben werden');
 define ('ERROR_MISSING_ADMIN_EMAIL', 'Es mu eine g&uuml;ltige eMail-Adresse angegeben werden'); 
 define ('ERROR_MISSING_DB_ACCESS', 'Der Datenbank-Zugriffsmodus mu angegeben werden'); 
 define ('ERROR_BAD_PASSWORD', 'Das Kennwort mu zur Best&auml;tigung zweimal angegeben werden, bitte &uuml;berpr&uuml;fent'); 
 define ('ERROR_MISSING_DB_NAME', 'Es mu ein Datenbankname angegeben werden');
 define ('ERROR_SF_CREATE_FILE', 'Im Verzeichnis <u>%s</u> konnte keine Datei erzeugt werden, bitte &uuml;berpr&uuml;fen Sie die Zugriffsrechte please oder lesen Sie die Hinweise zum &quot;Save-Modus&quot;-Betrieb in der Datei <a href="doc/INSTALL.txt">INSTALL.txt</a>');
 define ('ERROR_COPY_FILE', 'Fehler beim Kopieren einer Datei nach <u>%s</u>');
 define ('ERROR_OPEN_DB', 'Verbindung zur Datenbank <u>%s</u> (host: <u>%s</u>, port: <u>%s</u>, user: <u>%s</u>) konnte nicht aufgebaut werden');
 define ('ERROR_CREATE_CONFIG_FILE', 'Die Konfigurationsdatei <u>%s</u> konnte nicht erstellt werden, bitte Zugriffsrechte &uuml;berpr&uuml;fen');
 define ('LABEL_SETUP_DONE', 'W-Agora wurde erfolgreiche installiert');
 define ('LABEL_SETUP_AGORA', 'W-Agora Installation');

 define ('CAPTION_DB_PARAMETERS', 'Datenbankparameter (f&uuml;r die Site-Tabellen)');
 define ('CAPTION_DEFAULT_PARAMETERS', 'Standardparameter f&uuml;r die Sites-Konfiguration');
 define ('CAPTION_ADMIN_INFO', 'Eigenschaften des System Administrator\'s (login: <u>admin</u>)');

 define ('LABEL_ADMIN_NAME', 'Name');
 define ('LABEL_ADMIN_ADDRESS', 'eMail');
 define ('LABEL_ADMIN_PASSWORD1', 'Kennwort');
 define ('LABEL_ADMIN_PASSWORD2', 'Kennwort best&auml;tigen');
 define ('BUTTON_INSTALL', 'Installieren');

 /////////////////////
 //File Init_Admin.inc
 /////////////////////

 // function display_header
 define ('ADMINISTRATION_TITLE', "W-Agora Administration");

 // function list_forums
 define ('COLUMN_FORUM_ADMIN', "Forum");
 define ('COLUMN_EDIT', "Bearbeiten");
 define ('COLUMN_DELETE', "L&ouml;schen");
 define ('COLUMN_CREATE', "Erstellen");
 define ('COLUMN_ORDER', "Reihenfolge");

 define ('MSG_ADMINISTRATE_FORUM', "Forum administrieren");
 define ('ALT_DELETE_FORUM', "Forum l&ouml;schen : %s");
 define ('ALT_EDIT_FORUM', "Forum bearbeiten: %s");

 define ('ERROR_SITE_EMPTY', "Um in diesen Bereich zu gelangen mu eine Site angegeben werden.");
 define ('ERROR_NO_CONFIG_FILE', "Auf Konfigurationsdatei kann nicht zugegriffen werden: ");
 define ('ERROR_NO_ROOT', "F&uuml;r diesen Zugriff m&uuml;ssen Sie als Systemadministrator angemeldet sein.");
 define ('ERROR_NO_ADMIN', "F&uuml;r diesen Zugriff m&uuml;ssen Sie als Administrator angemeldet sein.");
 define ('ERROR_NO_MODERATOR', "Sorry, Sie haben keine Moderator-Berechtigung f&uuml;r dieses Forum, melden Sie sich erneut an.");

 define ('TITLE_ADMINISTRATION_LOGIN', "Anmeldung als Administration");
 define ('TITLE_INVALID_LOGIN', "Ung&uuml;ltige Anmeldung, bitte erneut versuchen");

 define ('ERROR_NO_DATABASE', "Verbindung zur Datenbank nicht m&ouml;glich, bitte Parameter &uuml;berpr&uuml;fen.");

 //Function List User
 define ('COLUMN_USER_ID', "Id");
 define ('COLUMN_USER_NAME', "Name");
 define ('COLUMN_USER_PRIVILEGE', "Berechtigung");
 define ('COLUMN_USER_REGISTERED', "Registriert");
 define ('COLUMN_USER_LOGIN_COUNT', "#Anmeldungen");
 define ('COLUMN_USER_LAST_LOGIN', "Letzte Anmeldung");
 define ('COLUMN_USER_POST_COUNT', "#Beitr&auml;ge");
 define ('COLUMN_USER_LAST_POST', "Letzter Beitrag");
 define ('COLUMN_ACTION', "<trans>Action");

 define ('LABEL_REG_NO_CONTROL',"Automatic registration");
 define ('LABEL_REG_CHALLENGE_RESPONSE',"RFU");	
 define ('LABEL_REG_ADMIN_APPROVAL',"Approved by administrators");

 /////////////////////
 //File Create_Site.php3
 /////////////////////
 define ('FORM_NO_SITE', "Der Name der Site mu angegeben werden.");
 define ('FORM_NO_DESCRIPTION', "Bitte geben Sie eine Kurzbeschreibung der Site an.");
 define ('FORM_NO_DBACCESS', "Sie m&uuml;ssen einen Zugriffsmodus angeben.");
 define ('FORM_NO_DBNAME', "Sie m&uuml;ssen einen Namen f&uuml;r die Datenbank angeben.");
 define ('FORM_NO_DIRECTORY', "Sie m&uuml;ssen ein Verzeichnis f&uuml;r die Foren angeben.");
 define ('FORM_SITE_LONG', "Der Name der Site ist zu lang, bitte w&auml;hlen Sie einen k&uuml;rzeren Namen.");

 define ('CHECK_SITE_EXISTS', "Die Site {SITE} besteht bereits, Sie m&uuml;ssen sie entweder manuell l&ouml;schen oder einen anderen Namen angeben.");
 define ('CHECK_CONFIG_EXISTS', "Die Konfigurationsdatei f&uuml;r (<tt>%s</tt>) besteht bereits, Sie m&uuml;ssen sie entweder manuell l&ouml;schen oder einen anderen Namen angeben.");

 define ('ERROR_SAFE_MODE', "SAFE MODE ist eingeschaltet, Sie m&uuml;ssen das Verzeichnis {DIRECTORY} erstellen");
 define ('ERROR_CREATE_DIR', "Das Verzechnis {DIRECTORY} kann nicht erstellt werden.");
 define ('ERROR_NO_PERMISSIONS', "&Uuml;berpr&uuml;fen Sie die Zugriffs-Berechntigungen");

 define ('ERROR_ADMIN_NOT_FOUND', "Der Benutzer 'admin' der W-Agora Haupt-Site wurde nicht gefunden");

 define ('ERROR_DB_DBM_EXISTS', "Die Datenbank {SITE} des Forums besteht bereits,<br> Sie m&uuml;ssen die DBM Datei <em>dbm/{SITE}/{DATABASE}</em> [und auch die Lock-Datei .lck] manuell l&ouml;schen.");
 define ('ERROR_DB_EXISTS', "Die Datenbanktabelle des Forums ($new_site) besteht bereits in der Datenbank {DATABASE}, Sie m&uuml;ssen die Tabelle zuerst manuell l&ouml;schen.");
 define ('ERROR_FILESYSTEM', "Zugriffsproblem, &uuml;berpr&uuml;fen Sie den freien Plattenplatz und die Zugriffsberechtigungen der Dateien.");
 define ('ERROR_DB_ACCESS', "Zugriffsproblem, &uuml;berpr&uuml;fen Sie da die Datenbank {DATABASE} erstellt wurde und &uuml;berpr&uuml;fen Sie die Zugriffsrechte.");

 define ('ERROR_CREATE_SITE', "Die Site {SITE} konnte nicht erstellt werden.");

 define ('ERROR_TABLE_EXISTS', "Die Datenbanktabelle {TABLE} existiert bereits in der Datenbank {DATABASE}, Sie m&uuml;ssen die Tablle zuerst manuell l&ouml;schen.");
 
 define ('ERROR_CREATE_ADMIN', "Der Benutzer {USER} konnte in der neuen Site nicht erstellt werden.");
 define ('ERROR_CREATE_USER', "Der Benutzer {USER} konnte in der Datenbanktabelle {TABLE} nicht erstellt werden.");
 define ('ERROR_NO_ADD_SITE', "Die Site konnte nicht zur Datenbank hinzugef&uuml;gt werden.");

 define ('LABEL_BACK', "Zur&uuml;ck");
 define ('LABEL_CREATE_SITE_DONE', "Die Site {SITE} wurde erfolgreich erstellt.<BR><BR>&nbsp;&nbsp;Sie k&ouml;nnen jetzt");
 define ('LABEL_CREATE_FORUM', "Ein Forum erstellen");
 define ('LABEL_CREATE_SITE', "Eine Site erstellen");
 define ('LABEL_CREATE_THIS_SITE', "Diese Site erstellen");
 define ('LABEL_CREATE_NEW_SITE', "Eine neue Site erstellen");
 define ('LABEL_CREATE_ANOTHER_SITE', "Eine andere Site erstellen");
 define ('LABEL_ADMINISTRATE_SITE', "Diese Site administrieren");
 define ('LABEL_SITE_MANAGEMENT', "Site Management");
 define ('CREATE_SITE_DONE', "Die Site {SITE} wurde erfolgreich erzeugt.");

 define ('LABEL_SITE_NAME', "Name der Site");
 define ('LABEL_SITE_TITLE', "Titel (Kurzbeschreibung)");
 define ('LABEL_SITE_DESCRIPTION', "Beschreibung");
 define ('LABEL_DB_PARAMETERS', "Datenbank Parameter");
 define ('LABEL_DB_TYPE', "Typ der Datenbank");
 define ('LABEL_DB_NAME', "Name der Datenbank");

 define ('LABEL_DB_USER', "Datenbank User-ID");
 define ('LABEL_DB_PASSWORD', "Datenbank Kennwort");

 define ('LABEL_DB_ADMIN_USER', "Datenbank Administrator-ID (falls leer: verwende DB user)");
 define ('LABEL_DB_ADMIN_PASSWORD', "Datenbank Administrator-Kennwort");
 define ('LABEL_DB_SERVER_NAME', "Name des Servers");
 define ('LABEL_DB_SERVER_PORT', "Server-Port");
 define ('LABEL_DB_USER_SOURCE', "User source");

 define ('LABEL_FORUMS_CONFIGURATION', "Konfiguration der Foren");

 define ('LABEL_FORUM_DIRECTORY', "Verzeichnis der Foren");
 define ('LABEL_SEARCH_ENGINE', "Suchmaschine");
 define ('LABEL_DEFAULT_THEME', "Standard-Vorlage");
 define ('NOTICE_SAFEMODE', "SAFE MODE eingeschaltet.");
 define ('NOTICE_MANUAL_INSTALL', 'Die m&uuml;ssen das Verzeichnis manuell erzeugen :');

 /////////////////////
 //File Admin.php3
 /////////////////////
 define ('TITLE_SITE_MANAGEMENT', "Verwaltung der Sites");
 define ('LABEL_SITES_OUTLINE', "Sites &Uuml;bersicht");
 define ('COLUMN_SITE_TITLE', "Thema (Titel):");

 define ('ALT_DELETE_SITE', "Site l&ouml;schen : %s");
 define ('ALT_EDIT_SITE', "Site bearbeiten : %s");
 define ('ERROR_NO_SITE', "Keine Site verf&uuml;gbar,<br> dr&uuml;cken Sie 'OK' um eine neue Site zu erstellen.");

 /////////////////////
 //File Delete_Site.php3
 /////////////////////
 define ('TITLE_SITE_DELETE', "Site L&ouml;schen");
 define ('ERROR_NO_DELETE', "Warnung: nicht alle Datenbanktabellen/Dateien in {SITE} konnten gel&ouml;scht werden.");
 define ('ERROR_NO_DELETE_AGORA', "Der Eintrag f&uuml;r die Site {SITE} konnte nicht aus der agora Datenbank entfernt wreden.");
 define ('LABEL_FILE_REMOVING', "L&ouml;sche Datei: ");
 define ('LABEL_DIRECTORY_REMOVING', "L&ouml;sche Verzeichnis: ");
 define ('LABEL_SITE_REMOVING', "Die Site {SITE} wurde gel&ouml;scht.");
 define ('LABEL_SITE_CONTENT', "Diese Site enth&auml;lt folgende Foren:");
 define ('LABEL_SITE_NO_CONTENT', "Diese Site enth&auml;lt keine Foren");
 define ('LABEL_SITE_DELETE_CONFIRMATION', "Soll die Site '{SITE}' wirklich gel&ouml;scht werden ?");
 define ('LABEL_DELETE_THIS_SITE', "L&ouml;schen dieser Site");

 /////////////////////
 //File Edit_Site.php3
 /////////////////////
 define ('TITLE_SITE_EDIT', "Site Bearbeiten");
 define ('ERROR_NO_READ_SITE_PROPERTIES', "Auf die Definition der Site {SITE} konnte nicht zugegriffen werden.");
 define ('ERROR_NO_UPDATE_SITE_PROPERTIES', "Die Definition der Site {SITE} konnte nicht ge&auml;ndert werden.");
 define ('LABEL_SITE_EDITING', "Site bearbeiten: ");
 define ('LABEL_SITE_PROPERTIES', "Site Informationen");
 define ('LABEL_CHANGE_SITE_ADMINISTRATOR', "W&auml;hlen/&auml;ndern Sie den Benutzer, der der Haupt-Administrator dieser Site werden soll");
 define ('COLUMN_SITE_REGISTRATION_MODE',"Registration mode");
 define ('COLUMN_SITE_PASSWORD_HANDLING',"Password handling");

 /////////////////////
 //File editList.php3
 /////////////////////
 define ('NOTICE_DEFAULT_FILE', "Warnung: diese Datei ist die Standard-Voreinstellung f&uuml;r diese Installation");
 define ('ERROR_NO_CURRENT_FILE', "Keine aktuelle Datei");
 define ('ERROR_OPEN_FILE', "Die Datei {FILE} kann nicht ge&ouml;ffnet werden");

 define ('LABEL_MAXTHREADS', "Maximal Anzahl von Diskussionen pro Seite");
 define ('LABEL_PAD', "F&uuml;llsequenz");
 define ('LABEL_DEPTH_LIMIT', "Maximal dargestellte Anzahl von Ebenen");
 define ('LABEL_BEFORE_LINE', "Skript, das f&uuml;r jede Zeile ausgef&uuml;hrt wird");
 define ('LABEL_SORT', "Standard-Reihenfolge");
 define ('LABEL_HOT_COLOR', "Farbe f&uuml;r die neuesten Beitr&auml;ge" );
 define ('LABEL_NEW_COLOR', "Farbe f&uuml;r aktuelle Beitr&auml;ge" );
 define ('LABEL_NORMAL_COLOR', "Farbe f&uuml;r &auml;ltere Beitr&auml;ge");
 define ('LABEL_HOT_AGE', "Maximales Alter f&uuml;r neueste Beitr&auml;ge [Sekunden]" );
 define ('LABEL_NEW_AGE', "Maximales Alter f&uuml;r aktuelle Beitr&auml;ge [Sekunden]");
 define ('LABEL_HOT_THRESHOLD', "Hot-Topic Grenze");
 define ('LABEL_TYPE_FILENAME', "Dateiname angeben");
 define ('TITLE_SITE_OUTLINE', "&Uuml;bersichtsliste der Sites bearbeiten");
 define ('TITLE_FORUM_OUTLINE', "&Uuml;bersichtsliste der Foren bearbeiten");
 define ('TITLE_MESSAGE_OUTLINE', "&Uuml;bersichtsliste der Beitr&auml;ge bearbeiten");
 define ('LABEL_FILE_EDITING', "Datei bearbeiten");
 define ('LABEL_THREAD_FIRSTLINE_ODD', "Erste Zeile in der Diskussion (ungerade)");
 define ('LABEL_THREAD_FIRSTLINE_EVEN', "Erste Zeile in der Diskussion (gerade)");
 define ('LABEL_LEVEL_START', "Neue Ebene beginnt mit");
 define ('LABEL_LEVEL_END', "Ebene endet mit");
 define ('LABEL_LINE_CONTENT_ODD', "Antwortzeile (ungerade)");
 define ('LABEL_LINE_CONTENT_EVEN', "Antwortzeile (gerade)");
 define ('LABEL_THREAD_END', "Diskussion endet mit");
 define ('LABEL_LIST_END', "Ende der Liste");

 define ('LABEL_GLOBAL_FORMAT', "Globale Listen-Einstellungen");
 define ('LABEL_DEFAULT_ORDER', "Standardreihenfolge (im no-threaded Modus)");
 define ('LABEL_USE_COLOR', "Verwende Farbe");
 define ('LABEL_NEWEST_MESSAGE', "Neueste Meldungen");
 define ('LABEL_NEW_MESSAGE', "Aktuelle Meldungen");
 define ('LABEL_OLD_MESSAGE', "Alte Meldungen");
 define ('LABEL_MESSAGES_NEWER_THAN', "f&uuml;r Meldungen die &auml;lter sind als ");
 define ('LABEL_FORUM_OUTLINE', "Forum listing outline");
 define ('LABEL_HEAD_LISTING', "Listenkopf");
 define ('LABEL_CATEGORY_LINE', "Kategorienzeile");

 define ('LABEL_SITE_LINE_ODD', "Site-Zeile (ungerade)");
 define ('LABEL_SITE_LINE_EVEN', "Site-Zeile (gerade)");

 define ('LABEL_FORUM_LINE_ODD', "Forum-Zeile (ungerade)");
 define ('LABEL_FORUM_LINE_EVEN', "Forum-Zeile (gerade)");
 define ('LABEL_BOTTOM_LISTING', "Listenende");

 define ('EDIT_THREAD_LIST', "Bearbeite Liste der Diskussionen (LISTEN-Modus): ");
 define ('LABEL_EDIT_SEARCH_LISTING' , "Seite mit Suchergebnissen bearbeiten: ");
 define ('LABEL_SEARCH_FORM_TITLE', "Forum Titel (Suche in mehreren Foren):");

 define ('EDIT_THREAD_VIEW', "Bearbeite Thread-Liste unter dem Beitrag (ANZEIGE-Modus): ");
 define ('LABEL_FIRST_THREAD', "Erster Beitrag im Thread");
 define ('EDIT_THREAD_DOWNLOAD', "Bearbeite Listen-Format (Thread) im <B>DOWNLOAD</B>-Modus:");

 /////////////////////
 //File Admin_Site.php3
 /////////////////////
 define ('LABEL_AGORA_WEBSITE', "W-Agora Web Site");
 define ('TITLE_SITE_ADMINISTRATION', "Verwaltung der Site");
 define ('LABEL_RELOGIN', "Erneut anmelden (Benutzer wechseln)");
 define ('LABEL_SITES', "Liste der Sites");
 define ('LABEL_ADMINISTRATION_MAIN', "Zur&uuml;ck zur Hauptverwaltung");
 define ('ALT_STATS', 'Zeige Statistik f&uuml; die Site %s');
 define ('LABEL_ACCESS_THIS_SITE', 'Diese Site benutzen');
 define ('ALT_ACCESS_SITE', 'Die Site %s benutzen als');

 define ('LABEL_CATEGORIES', "Kategorien");
 define ('COLUMN_ADMIN_USERS', "Administratoren");
 define ('COLUMN_INACTIVE_USERS', "Inaktive Benutzer");
 define ('COLUMN_MAIL_USERS', "Sende eMail an Benutzer");

 define ('ALT_USER_EDIT', "Bearbeite Benutzer");
 define ('ALT_USER_ADMIN', "Verwalte Benutzer");
 define ('ALT_USER_ADD', "Benutzer hinzuf&uuml;gen");
 define ('ALT_USER_DELETE', "Benutzer l&ouml;schen");
 define ('ALT_INACTIVE_USERS', "Inaktive Benutzer l&ouml;schen");
 define ('ALT_MAIL_USERS', "eMail an Benutzer");
 define ('ALT_CATEGORY_CREATE', "Kategorie erstellen");
 define ('ALT_CATEGORY_EDIT', "Kategorie bearbeiten");

 define ('COLUMN_MANAGE_FORUM', "Foren verwalten");
 define ('COLUMN_CHANGE_ORDER', "Reihenfolge &auml;ndern");

 define ('ALT_FORUM_MANAGE', "Forum verwalten");
 define ('ALT_FORUM_CREATE', "Forum erstellen");
 define ('ALT_FORUM_ORDER', "Darstellungsreihenfolge der Foren &auml;ndern");

 define ('LABEL_FORUM_LAYOUT', "Layout der Foren-Liste");

 define ('LABEL_SITECONF', 'Konfiguration');
 define ('LABEL_STYLESHEET', "Style Sheet");
 define ('LABEL_HEADER', "Header");
 define ('LABEL_FORUM_LIST', "Foren-Liste");
 define ('LABEL_FOOTER', "Footer");
 define ('LABEL_MESSAGES', "Meldungstexte");

 define ('ALT_SITECONF', 'Basiseinstellungen der Forenliste bearbeiten (BODY, Datumsformat, ...)');
 define ('ALT_MODIFY_STYLESHEET', "Style sheet (CSS) Datei &auml;ndern");
 define ('ALT_HEADER', "Kopf der Foren-Liste bearbeiten");
 define ('ALT_FOOTER', "Fu der Foren-Liste bearbeiten");
 define ('ALT_FORUM_LIST', "Layout der Foren-Liste bearbeitent");
 define ('ALT_MESSAGES', "In der Foren-Liste dargestellte Texte, Meldungen, Bilder bearbeiten");

 define ('LABEL_DEFAULT_TEMPLATES', "Standard-Vorlagen der Site");

 define ('COLUMN_PROFILE', "Formular 'Einstellungen'");
 define ('COLUMN_LOGIN', "Formular 'Anmelden'");
 define ('COLUMN_REGISTER', "Formular 'Registrierung'");
 define ('COLUMN_CHANGE_PASSWORD', "Formular 'Kennwort &auml;ndern'");
 define ('COLUMN_FORGOT_PASSWORD', "Formular 'Kennwort vergessen'");
 define ('COLUMN_MAIL', "Vorlagen f&uuml;r eMails");
 define ('COLUMN_SUBSCRIBING', "Formular 'eMail-Abonnement'");

 define ('ALT_PROFILE_FORM', "Bearbeite Formular 'Einstellungen'");
 define ('ALT_LOGIN_FORM', "Bearbeite Formular 'Anmelden'");
 define ('ALT_REGISTER_FORM', "Bearbeite Formular 'Registrierung'");
 define ('ALT_CHANGE_PASSWORD_FORM', "Bearbeite Formular 'Kennwort &auml;ndern'");
 define ('ALT_FORGOT_PASSWORD_FORM', "Bearbeite Formular 'Kennwort vergessen'");
 define ('ALT_MAIL_TEMPLATE', "eMail-Konfiguration und Vorlagen");
 define ('ALT_SUBSCRIBE_FORM', "Bearbeite Formular 'eMail-Abonnement'");

 define ('LABEL_USER_TEMPLATES', "Vorlage Benutzerverwaltung");
 define ('COLUMN_USER_FIELDS', "Benutzerfelder");
 define ('ALT_USER_FIELDS', "Benutzereigenschaften hinzufgen/bearbeiten");

 /////////////////////
 //File admin_Forum.php3
 /////////////////////
 define ('TITLE_FORUM_ADMINISTRATION', "Forum verwalten (Site: %s)");
 define ('LABEL_CHOOSE_FORUM', "W&auml;hlen Sie das Forum, das Sie verwalten, &auml;ndern oder l&ouml;schen wollen");
 define ('ERROR_NO_FORUM_ADMIN', "Die Site '%s' enth&auml;lt kein Forum,<br> dr&uuml;cken Sie 'OK' um ein neues Forum zu erstellen.");
 define ('ERROR_NO_FORUM', "Die Site '{SITE}' enth&auml;lt kein Forum, f&uuml;r das Sie verantwortlich w&auml;ren.");
 define ('LABEL_FORUM_ADMINISTRATION', "Verwaltung des Forums");
 define ('LABEL_SITE', "Site ");
 define ('LABEL_FORUM', "Forum");
 define ('LABEL_FORUM_ACCESS', "Forum benutzen");
 define ('LABEL_ACCESS_THIS_FORUM', "Dieses Forum benutzen");
 define ('ALT_ADMINISTRATION_SITE', 'Zur&uuml;ck zur Verwaltung von Stite %s');

 define ('TITLE_NOTES_MANAGEMENT', "Beitr&auml;ge verwalten");
 define ('LABEL_EDIT_NOTES', "Beitr&auml;ge bearbeiten");
 define ('LABEL_MANAGE_THREADS', "Diskussionen verwalten");
 define ('LABEL_POST_MSG', "Beitrag erstellen");

 define ('ALT_EDIT_NOTES', "Beitr&auml;ge l&ouml;schen/bearbeiten");
 define ('ALT_MANAGE_THREADS', "Diskussionen l&ouml;schen - kopieren - verschieben");
 define ('ALT_POST', "Absenden");

 define ('LABEL_ADD_USER', "Zu diesem Forum zuf&uuml;gen");
 define ('COLUMN_SHOWEDIT', "Anzeigen/Bearbeiten");
 define ('ALT_USER_SHOWEDIT', "Beantragte Benutzer anzeigen/bearbeiten");
 define ('ALT_USER_CREATE', "Benutzer erstellen");

 define ('LABEL_CONFIGURATION', "Konfiguration");
 define ('LABEL_BASIC', "Basis");
 define ('LABEL_ADVANCED', "Erweitert");
 define ('LABEL_PROPERTIES', "Eigenschaften");

 define ('ALT_BASIC', "Basis-Konfiguration bearbeiten");
 define ('ALT_ADVANCED', "Erweiterte Konfiguration bearbeiten");
 define ('ALT_PROPERTIES', "Forum-Eigenschaften bearbeiten");

 define ('LABEL_LAYOUT', "Layout/Vorlagen");

 define ('COLUMN_NOTES_LISTING', "Liste der Beitr&auml;ge");
 define ('COLUMN_FORM', "Beitr&auml;ge");
 define ('COLUMN_MAIL_FORM',"Mail form");
 define ('COLUMN_FIELDS', "Felder");
 define ('COLUMN_TEMPLATE', "Vorlagen");
 define ('COLUMN_SEARCH_FORM', "Formular 'Suchen'");
 define ('COLUMN_INCLUDED', "Eingef&uuml;gtes Skript");
 define ('COLUMN_PROFILE_FORM', "Formular 'Eigenschaften'");
 define ('ALT_INCLUDED', "Vor dem Zugriff auszuf&uuml;hrendes PHP Skript");
 define ('ALT_TEMPLATE', "HTML-Vorlage f&uuml;r Beitr&auml;ge &auml;ndern ");
 define ('ALT_FIELDS', "Datenbankfelder &auml;ndern/bearbeiten");
 define ('ALT_SEARCH_FORM', "Formulare 'Suchen' bearbeiten");
 define ('ALT_FORM', "HTML-Vorlage zum Erstellen/&Auml;ndern von Beitr&auml;gen bearbeiten");
 define ('ALT_MAIL_FORM', "Edit the form used to send private mails");
 define ('ALT_NOTES_LISTING', "Liste der Beitr&auml;ge bearbeiten");
 define ('ALT_AGORA_MESSAGES', "Von W-Agora benutzte Meldungen bearbeiten");

define('LABEL_MASS_EDIT_FORUMS_DONE', '<trans>mass update has been done on all forums!');
define('TITLE_MASS_EDIT_FORUMS', '<trans>Edit settings on all forums');
define('MSG_MASS_EDIT_FORUMS', '<trans>This form enables you to edit some settings on all forums at the same time');
define('LABEL_MASS_EDIT_FORUM_STATE', '<trans>Forum state');
define('LABEL_MASS_EDIT_FORUM_ACCESS', '<trans>Access mode');
define('LABEL_MASS_EDIT_FORUM_MODERATED', '<trans>Moderated forums');
define('BUTTON_UPDATE_ALL_FORUMS', '<trans>Apply changes to all forums');

 /////////////////////
 //File Moderate_Notes.php3
 /////////////////////
 define ('TITLE_MODERATE_NOTES', "Eingehende Beitr&auml;ge &uuml;berpr&uuml;fen");
 define ('ERROR_NO_INCOMING', "Dieses Forum enth&auml;lt momentan keine zu &uuml;berpr&uuml;fenden Beitr&auml;ge");
 define ('LABEL_MESSAGE_DELETE_CONFIRMATION', "Soll dieser Beitrag wirklich gel&ouml;scht werden ?");
 define ('CAPTION_VALIDATE_DELETE_MESSAGE', "W&auml;hlen Sie die den Beitrag, der &uuml;berpr&uuml;ft oder gel&ouml;scht werden soll.");
 define ('CAPTION_MESSAGE_ACTION', "W&auml;hlen Sie was mit dem Beitrag geschehen soll.");
 define ('LABEL_DELETE', "L&ouml;schen");
 define ('LABEL_VALIDATE', "Akzeptieren");

 /////////////////////
 //Admin_Notes.php3
 /////////////////////
 define ('LABEL_DELETE_FOL_NOTES', "Folgende Beitrge werden gelscht");
 define ('LABEL_NOTES_IN_FORUM', "Beitrge in Forum <font color=red>%s</font>");
 define ('LABEL_NO_FORM', "Keine Vorlage fr dieses Forum gefunden");
 define ('LABEL_EDIT_NOTE', "Beitrag bearbeiten:");
 define ('LABEL_DISPLAY_NOTES', "Beitrge anzeigen");
 define ('LABEL_ALL_NOTES', "Alle Beitrge");
 define ('LABEL_HIDDEN', "Verstecken");
 define ('LABEL_VISIBLE', "Sichtbar"); 
 define ('COLUMN_SHOW_NOTE', "Anzeigen");
 define ('COLUMN_HIDE_NOTE', "Verstecken");
 define ('ALT_DELETE_NOTE', "Diesen Beitrag lschen");
 define ('ALT_EDIT_NOTE', "Diesen Beitrag bearbeiten");
 define ('ALT_POPUP', "Pop-up");
 
 define ('LABEL_COPY_FOL_NOTES', "<trans>The following notes (with ALL replies) will be copied/moved");
 define ('ACTION_MESSAGES_DELETE', "<trans>Delete selected notes");
 define ('ACTION_MESSAGES_COPY', "<trans>Copy selected notes to another thread into forum");
 define ('ERROR_DELETE_NOTE', "<trans>Couldn't delete message {NOTE} from forum {FORUM}");
 define ('LABEL_SELECT_DEST_THREAD', "<trans>Select note to attach messages");
 define ('ERROR_COPY_NOTE', "<trans>Couldn't copy note {NOTE} into forum {FORUM}");
 define ('ACTION_MESSAGES_MOVE', "<trans>[Move notes]");
 define ('ERROR_NO_DEST_FORUM', "<trans>Error: you must specify the destination forum.");
 define ('TITLE_COPY_NOTES', "<trans>Copying/moving messages");
 define ('OPEN_NEW_THREAD', "<trans>Open new thread");

/////////////////////
 //Delete_Notes.php3
 /////////////////////
 define ('TITLE_DELETE_NOTES', "Beitrag L&ouml;schen");
 define ('CAPTION_SELECT_NOTES', "W&auml;hlen Sie die Beitr&auml;ge, die ge&auml;ndert/gel&ouml;scht werden sollen");
 define ('LABEL_DELETE_THIS', "L&ouml;schen");
 define ('CAPTION_SELECT_NOTES_DELETED', "W&auml;hlen Sie die Beitr&auml;ge, die ge&auml;ndert/gel&ouml;scht werden sollen");

 /////////////////////
 //Delete_Threads.php3
 /////////////////////
 define ('ERROR_INCORRECT_DATES', "Das Datum ist fehlerhaft");
 define ('ERROR_NO_PERIOD', "Bitte Anzahl der Tage, Wochen oder Monate angeben");
 define ('ERROR_NO_NOTES_OLDER', "Kein Beitrag &auml;lter als {NUMBER} {UNIT} gefunden.");
 define ('CONFIRM_THREAD_MOVE', "Soll die Diskussion wirklich in das Forum \"{FORUM}\" verschoben werden ?");
 define ('CONFIRM_THREAD_COPY', "Soll die Diskussion wirklich in das Forum \"{FORUM}\" kopiert werden ?");
 define ('CONFIRM_DELETE_THREAD', '%s diskussionen werden gel&ouml;scht');
 define ('CONFIRM_DELETE_THREAD_DATE', 'Best&auml;tigen Sie bitte das L&ouml;schen der Diskussionen zwischen %s und %s');
 define ('ERROR_NO_THREAD', "Keine Diskussion ausgew&auml;hlt");
 define ('LABEL_COPYING_NOTES', "Beitr&auml;ge werden nach {FORUM} kopiert...");

 define ('ERROR_PARENT_NOT_FOUND', "Beitrag kann nicht eingef&uuml;gt werden, Vater-Beitrag nicht gefunden");
 define ('ERROR_COPY_THREAD', "Diskussion {THREAD} kann nicht in Forum {FORUM} kopiert werden");
 define ('ERROR_DELETE_THREAD', "Diskussion {THREAD} fkann nicht aus Forum {FORUM} entfernt werden");
 define ('ERROR_INSERT_ATTTACHMENT', "Anhang '{NAME}' des Beitrags '{CLE}' kann nicht in Forum '{FORUM}' eingef&uuml;gt werden");

 define ('TITLE_MANAGE_THREADS', "Diskussionen L&ouml;schen/Kopieren/Verschieben");
 define ('CAPTION_SELECT_THREAD', "Keine Diskussion ausgew&auml;hlt");
 define ('LABEL_SELECT_THREAD', "W&auml;hlen Sie die Diskussion, die gel&ouml;scht oder in ein anderes Forum kopiert/verschoben werden soll");
 define ('LABEL_SELECT_THREAD_OR_DATE', "W&auml;hlen Sie die Diskussion(en) oder eine Reihe von Diskussionen aus");
 define ('LABEL_SELECT_INDIVIDUAL_THREAD', "W&auml;hlen Sie unten einzelne Diskussionen aus");
 define ('LABEL_EXECUTE', "Ausf&uuml;hren");
 define ('LABEL_THREAD_BETWEEN', "W&auml;hle Diskussionen zwischen");
 define ('LABEL_THREAD_OLDER', "W&auml;hle Diskussionen &auml;lter als: ");
 define ('LABEL_SELECT_ACTION', "W&auml;hlen Sie die auszuf&uuml;hrende Aktion");
 define ('ACTION_THREAD_DELETE', "L&ouml;sche ausgew&auml;hlte Diskussionen");
 define ('ACTION_THREAD_MOVE', "Verschiebe Diskussionen (Kopieren und L&ouml;schen der urspr&uuml;nglichen Diskussion)");
 define ('ACTION_THREAD_COPY', "Kopiere ausgew&auml;hlte Diskussionen nach Forum: ");
 define ('LABEL_REPLIES', "Antworten");

 /////////////////////
 //Admin_User.php3
 /////////////////////
 define ('TITLE_SITE_USER_ADMIN', "Benutzer verwalten in Site \"{SITE}\"");
 define ('TITLE_FORUM_USER_ADMIN', "Benutzer verwalten in Forum \"{FORUM}\"");
 define ('TITLE_SELECT_USERS', "Benutzer auswhlen");
 define ('TITLE_MAIL_USERS', "Erstelle eMail an <font color=blue>%s</font>");
 define ('LABEL_CHOOSE_USERID_INIT', "Initialen auswhlen");
 define ('LABEL_CHOOSE_USERID_PATTERN', "oder Muster angeben");
 define ('LABEL_BY_NAME', "<b>Nache Name</b>");
 define ('LABEL_BY_ACTIVITY', "<b>Nach Aktivitt</b>");
 define ('LABEL_SHOW_NO_POST', "Benutzer, die noch nie einen Beitrag erstellten...");
 define ('LABEL_SHOW_NO_LOGIN', "Benutzer, die sich noch nie anmeldeten...");
 define ('LABEL_SHOW_DIDNT_POST', "Benutzer, die keinen Beitrag erstellten seit...");
 define ('LABEL_SHOW_DIDNT_LOGIN', "Benutzer, die sich nicht anmeldeten seit......");
 define ('LABEL_SHOW_IN_STATE', "Benutzer, mit Status: ");
 define ('LABEL_NOT_REGISTERED', "<trans>Not Registered");
 define ('LABEL_USERS_IN_STATE', "Benutzer, mit Status <font color=blue>%s</font> ");
 define ('LABEL_USERS_BEGINING', "Benutzer, deren ID oder Name beginnt mit <font color=blue>%s</font> ");
 define ('LABEL_USERS_NEVER_POST', "Benutzer, die nie einen Beitrag erstellten ");
 define ('LABEL_USERS_NEVER_LOGIN', "<trans>Users who never login ");
 define ('LABEL_USERS_DIDNT_POST', "Benutzer, die keinen Beitrag erstellten seit <font color=blue>%s %s</font> ");
 define ('LABEL_USERS_DIDNT_LOGIN', "Benutzer, die sich nicht anmeldeten seit <font color=blue>%s %s</font> ");
 define ('LABEL_REG_USERS_FORUM', "in Forum <font color=red>%s</font>");
 define ('LABEL_REG_USERS_SITE', "in Site <font color=red>%s</font>");
 define ('LABEL_CONFIRM_USER_DELETE', "Sollen diese Benutzer wirklich gelscht werden?");
 define ('LABEL_DELETE_THESE_USERS', "Diese Benutzer lschen");
 define ('LABEL_USER_CONFIRM_DELETE', "Benutzer <font color=blue>%s</font> wurde gelscht");
 define ('LABEL_RETURN_LIST', "Zurck zur Liste der Benutzer");
 define ('LABEL_EDIT_MAIL_PROFILE', "eMail Einstellungen fr <font color=blue>%s</font>");
 define ('LABEL_TO', "An");
 define ('LABEL_SEND', "Sende eMail");
 define ('LABEL_REG_USER_FORUM', "Sie sind fr dieses Forum registriert");
 define ('LABEL_NO_REG_USER_FORUM', "Sie sind fr dieses Forum nicht registriert");
 define ('LABEL_MAIL_USER_OK', "eMail wurde an den Benutzer <font color=blue>%s</font> gesendet");
 define ('LABEL_MAIL_USER_NO_OK', "An folgende Benutzer konnte keine eMail gesendet werden <font color=blue>%s</font>");
 define ('ERROR_NO_USER_MATCHING', "Benutzer stimmt nicht berein (<font color=blue>%s</font>)");
 define ('ERROR_NO_REMOVE_PRIVILEGE', "Sie haben keine Berechtigung um den Benutzer <font color=blue>%s</font> zu lschen");
 define ('ERROR_NO_EDIT_PRIVILEGE', "Sie haben keine Berechtigung um den Benutzer <font color=blue>%s</font> zu bearbeiten");
 define ('ERROR_NO_REMOVE_PERMISSION', "Der Benutzer <font color=blue>%s</font> hat Zugriff auf das Forum (%s) fr das Sie keine Moderator-Berechtigung besitzen,<br> Sie knnen den Benutzer nicht lschen");
 define ('ERROR_SITE_USER_DELETE', "Der Benutzer <font color=blue>%s</font> in Site %s kann nicht gelscht werden");
 define ('LABEL_STATUS', "Status");
 define ('ERROR_NO_MATCHING_USERS', "Keine bereinstimmung der Benutzer ");
 define ('ERROR_NO_MATCHING_USER', "Benutzer %s existiert nicht in dieser Site");
 define ('ERROR_NO_OWNER_UPDATE', "Der Besitzer des Forums %s in Site %s konnte nicht gendert werden");
 define ('ERROR_NO_SITE_USER_UPDATE', "Der Benutzer {FORUM} in Site {SITE} konnte nicht gendert werden");
 define ('TITLE_EDITING_USER', "Benutzer bearbeiten");
 define ('LABEL_IN_SITE', "in Site");
 define ('COLUMN_USER_EMAIL', "eMail");
 define ('COLUMN_USER_WEBPAGE', "Homepage");
 define ('COLUMN_USER_DESCRIPTION', "Beschreibung");
 define ('COLUMN_USER_LASTLOGIN', "Letzte Anmeldung");
 define ('COLUMN_USER_MAILOK', "eMail OK");
 define ('COLUMN_USER_COUNTRY', "Land");
 define ('LABEL_UNSELECT', "Nicht auswhlen");; 
 define ('LABEL_SELECT_ALL', "<trans>Select all"); 
 define ('LABEL_WITH_SELECTED', "<trans>With selected : "); 
 define ('LABEL_MAIL_USER', "eMail senden"); 
 define ('LABEL_REMOVE_ACCESS', "<trans>Remove access"); 

 define ('ALT_CHANGE_PASSWORD', "Passwort ndern");
 define ('CAPTION_USER_PRIVILEGE', "Berechtigung: ");
 define ('LABEL_CHANGE_USER_PRIVILEGE', "Berechtigung ndern in : ");
 define ('LABEL_USER_SITE_STATUS', "User status in site : ");
 define ('LABEL_CHANGE_STATUS' , "Change status to : ");
 define ('LABEL_USER_CONFIRM_STATUS' , "User <font color=blue>%s</font> is now %s."); //$userid, $user_states[$user_state]
 define ('LABEL_MAIL_USER_STATUS' , "Send new status by mail");
 define ('LABEL_MAIL_STATUS_SUBJECT' , "Modification of your profile in sitede votre profil in site %s"); //$site
 define ('LABEL_MAIL_STATUS_BODY' , "Hello,\n administrator of site %s modified your account. Your account is now %s."); // $site, $user_state
 define ('ERROR_NO_ADMIN_CHANGE_STATUS', "Status of user 'Admin' can't be changed"); 
 define ('ERROR_NO_USER_STATUS', "Status of user couldn't be modified in site %s"); //$userid
 define ('ERROR_NO_ADMIN_CHANGE_PRIVILEGE', "Die Berechtigungfr den Administrator kann nicht gendert werden");
 define ('CAPTION_CHANGE_USER_FORUM_PRIVILEGES', "Zugriffsberechtigung fr Benutzer auswhlen");
 define ('LABEL_AS', "als ");
 define ('LABEL_GRANT_PRIVILEGES', "Zugriffsberechtigung fr Benutzer auswhlen");
 define ('COLUMN_CAN_LIST', "Auflisten");
 define ('COLUMN_CAN_READ', "Lesen");
 define ('COLUMN_CAN_WRITE', "Schreiben");
 define ('COLUMN_SITE', "Site");
 define ('LABEL_ADD_FORUM', "Forum hinzufgen : ");
 define ('LABEL_MAIL_USER_PROFILE', "eMail mit den neuen Einstellungen an den Benutzer senden ");
 define ('LABEL_SHOW', "Anzeigen"); 

 define ('ERROR_NO_ADD_PRIVILEGES', "Priviliegien fr Benutzer %s in Forum %s konnten nicht hinzugefgt werden");

 define ('COLUMN_MAIL_SUBSCRIBED_USERS', "<trans>Mail subscribed users");
 define ('ALT_MAIL_SUBSCRIBED_USERS', "<trans>Send a mail to users who subscribed to this forum.");
 define ('LABEL_SEND_FORUM_SUBSCRIBED_EMAIL', "<trans>Send a mail to users subscribed to forum $bn_name");
 define ('TITLE_SELECT_SUBSCRIBED_USERS', "<trans>Chose subscribed users to administrate");
 define ('LABEL_NO_SUBSCRIBED_USERS', "<trans>No subscribed users in this forum");
 define ('LABEL_IN_FORUM', "<trans>in forum");
 define ('LABEL_SUBSCRIBE_USER', "<trans>Subscribe a new user");
 define ('LABEL_SUBSCRIBE', "<trans>Subscribe");
 define ('LABEL_UNSUBSCRIBE', "<trans>Unsubscribe");
 define ('LABEL_CONFIRM_USER_UNSUBSCRIBE', "<trans>Are you sure to unsubscribe these users ?");
 define ('LABEL_CONFIRM_USER_SUBSCRIBE', "<trans>Are you sure to subscribe these users ?");
 define ('ERROR_NO_MATCHING_ADDRESS', "<trans>Subscribed user %s not found in forum %s");
 define ('COLUMN_USER_NEW_EMAIL', "<trans>New address :");
 define ('LABEL_EDIT_MAIL_SUBSCRIBE', "<trans>Send user <font color=blue>%s</font> his(her) new address");
 define ('LABEL_MAIL_USER_SUBSCRIBE', "<trans>Send user his(her) new subscription");
 define ('COLUMN_ADMIN_SUBSCRIBED_USERS', "<trans>Subscribed users");
 define ('ALT_ADMIN_SUBSCRIBED_USERS', "<trans>Administrate users who subscribed to this forum");
 define ('TITLE_FORUM_SUBSCRIBED_USER_ADMIN', "<trans>Administrate subscribed users in forum \"{FORUM}\"");
 define ('LABEL_USER_CONFIRM_UNSUBSCRIBE', "<trans>User <font color=blue>%s</font> has been unsubscribed");
 define ('LABEL_USER_CONFIRM_SUBSCRIBE', "<trans>User <font color=blue>%s</font> has been subscribed");
 define ('LABEL_KEEP_THREADS', "<trans>Keep threads subcriptions");
 define ('LABEL_MAIL_SUBSCRIBE_SUBJECT', "<trans>Your subscription to forum %s");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_YES', "<trans>You've been subscribed to forum %s. You will receive every new messages bay e-mail.");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_NO', "<trans>You've been unsubcribed from forum %s. You'll no longer receive e-mails from this forum.");
 define ('LABEL_SUBSCRIBED_USERS', "<trans>Subscribed users");
 define ('LABEL_UNSUBSCRIBED_USERS', "<trans>Unsubscribed users");

 /////////////////////
 //Add_User.php3
 /////////////////////
 define ('TITLE_ADD_USER', "Benutzer hinzuf&uuml;gen");
 define ('ERROR_NO_ADD_USER', "Der Benutzer %s kann nicht zur Tabelle %s_userforum hinzugef&uuml;gt werden");
 define ('WARNING_USER_ADDED', "Benutzer '%s' wurde zum Forum '%s' hinzugef&uuml;gt");
 define ('LABEL_RETRIEVING_USERS', "Ermittle alle Benutzer dieser Site (bitte warten) ...");
 define ('WARNING_NO_USER_TO_ADD', "Kein Benutzer zum einf&uuml;gen");
 define ('LABEL_ADD_FORUM_USER', "F&uuml;ge Benutzer zum Forum <em><FONT color=#FF6633>%s</FONT></em> hinzu");
 define ('LABEL_CHOOSE_USER_ADD', "W&auml;hlen Sie den zuzuf&uuml;genden Benutzer ");
 define ('LABEL_USER_GRANT_PRIVILEGES', "<b>Berechtigung des Benutzers f&uuml;r Forum <FONT color=#FF6633>%s</font></b><br>");
 define ('LABEL_ACTIVE', "Aktiv");
 define ('LABEL_FORM_SELECT', "&lt;-- Eintrag ausw&auml;hlen --&gt;");
 define ('LABEL_ENTER_EMAILS_TO_ADD', 'Whlen Sie die zuzufgenden Adressen');
 define ('LABEL_CHOOSE_EMAILS_FILE', 'Whlen Sie eine Datei mit hinzuzufgenden Adressen');

 /////////////////////
 //Create_User.php3
 /////////////////////
 define ('TITLE_NEW_USER', "Benutzer erstellen");
 define ('ERROR_NO_PASSWORD', "Zur Sicherheit mu das Kennwort zweimal angegeben werden, bitte &uuml;berpr&uuml;fen");
 define ('ERROR_NO_SITE_ADD_USER', "Der Benutzer %s konnte nicht in die Datenbanktabelle %s_users eingetragen werden");
 define ('LABEL_USER_ADDED', "Benutzer '%s' wurde erstellt");
 define ('LABEL_USER_SENT_FOR_APPROVAL', "His/her account will bea ctive once validated by the administrators of the site."); 
 define ('LABEL_CREATE_ANOTHER_USER', "Benutzer erstellen");
 define ('LABEL_EDIT_THIS_USER', "Benutzer bearbeiten");
 define ('ALT_EDIT_THIS_USER', "Benutzerinformationen bearbeiten");
 define ('LABEL_SITE_CREATE_NEW_USER', "Neuen Benutzer erstellen in der Site: ");
 define ('LABEL_USER_INFORMATIONS', "Benutzerinformationen");
 define ('COLUMN_USER_PASSWORD', "Kennwort angeben");
 define ('COLUMN_USER_CONFIRM_PASSWORD', "Kennwort best&auml;tigen");
 define ('LABEL_ADD_MAILING_LIST', "Benutzer zur Mailing-Liste hinzuf&uuml;gen ?");
 define ('LABEL_CREATE_USER', "Benutzer erstellen");
 define ('LABEL_USER_PRIVILEGE', "Berechtigung des Benutzers w&auml;hlen");

 /////////////////////
 //Mail_Users.php3
 /////////////////////
 define ('LABEL_SEND_SITE_EMAIL', "Sende eMails zu den Benutzer der Site ");
 define ('LABEL_SEND_FORUM_EMAIL', "Sende eMails zu den Benutzer des Forums ");
 define ('LABEL_NO_ACTIVE_USERS', "Keine aktiven Benutzer gefunden ");
 define ('LABEL_MAIL_USERS', "eMail wird an %s Benutzer gesendet");
 define ('LABEL_USER_MAILED', "eMail gesendet an <em> %s </em> <tt>&lt; %s &gt;</tt>.<br>");
 define ('LABEL_USER_NOT_MAILED', "%s &lt; %s &gt; hat den Empfang von eMails deaktiviert.<br>");
 define ('LABEL_MAIL_FILL_FORM', "Erstellen einer eMail an Benutzer");
 define ('LABEL_SEND_TO_ALL', 'An alle Benutzer senden');
 define ('COLUMN_TO', 'Senden an:');
 define ('COLUMN_FROM', "Von:");
 define ('COLUMN_REPLY_TO', "R&uuml;ckantwort an:");
 define ('COLUMN_MESSAGE', "Nachricht:");
 define ('LABEL_SEND_MAIL', "eMail senden");

 /////////////////////
 //Editconf.php3
 /////////////////////
 define ('ERROR_NO_WRITE_CONFIGURATION', "Konfigurationsdatei kann nicht geschrieben werden, &uuml;berpr&uuml;fen Sie die Berechtigungen");
 define ('ERROR_FILE_UPLOAD_DISABLED', "<trans>File upload feature has been disabled on this server, check your PHP configuration (php.ini) or contact your ISP!!");
 define ('LABEL_CHANGE_CONFIG_DONE', "&Auml;nderungen gespeichert als ");
 define ('LABEL_SETTINGS_RESTORED', "Die Einstellungen wurden wieder hergestellt");
 define ('LABEL_FORUM_CONFIGURATION', "Forum %s konfigurieren");
 define ('LABEL_EDITING_FILE', "Datei bearbeiten: ");
 define ('TITLE_GENERAL_SETTINGS', "Allgemeine Einstellungen");
 define ('COLUMN_BODY', "Hintergrund");
 define ('ALT_BODY', "Zus&auml;tzliche Parameter f&uuml;r das BODY Tag");
 define ('COLUMN_DATE_FORMAT', "Datums-Format");
 define ('ALT_DATE_FORMAT', "Format zur Darstellung des Datums (siehe PHP Dokumentation)");
 define ('COLUMN_TIME_OFFSET', "Zeitdifferenz");
 define ('ALT_TIME_OFFSET', "Differenz zur lokalen Ortszeit (in Stunden)");
 define ('COLUMN_USE_COOKIE', "Cookies verwenden");
 define ('ALT_USE_COOKIE', "Cookies zum Speichern von Benutzerdaten und zum Verwalten der gelesenen Beitr&auml;ge an den Browser senden");
 define ('COLUMN_ALLOW_MODIFICATION', "&Auml;nderungen erlauben");
 define ('ALT_ALLOW_MODIFICATION', "Erlaubt es den Benutzern Beitr&auml;ge zu &uuml;berarbeiten, dazu mu ein Kennwort angegeben werden");
 define ('COLUMN_ALLOW_DELETE', "L&ouml;schen erlauben");
 define ('ALT_ALLOW_DELETE', "Erlaubt es den Benutzern Beitr&auml;ge zu l&ouml;schen, dazu mu ein Kennwort angegeben werden");

 define ('TITLE_MESSAGE_FORMATING', "Formatierung der Beitr&auml;ge");
 define ('COLUMN_ALLOW_HTML', "Erlaube HTML");
 define ('ALT_ALLOW_HTML', "Erlaubt es den Benutzern HTML Tags in ihren Beitr&auml;gen zu verwenden");
 define ('COLUMN_TAGS_ALLOWED', "Erlaubte Tags:");
 define ('ALT_TAGS_ALLOWED', "Angabe der in Beitr&auml;gen erlaubten HTML Tags, getrennt durch Leerzeichen, Komma oder Semikolon (< und > nicht mit angeben)");
 define ('COLUMN_TAGS_DISALLOWED', "Unerlaubte Tags:");
 define ('ALT_TAGS_DISALLOWED', "Angabe der HTML Tags, die automatisch aus Beitr&auml;gen entfernt werden, getrennt durch Leerzeichen, Komma oder Semikolon (< und > nicht mit angeben). Nur benutzt, wenn keine 'erlaubten Tags' angegeben wurden");
 define ('COLUMN_USE_SMILEY', "Verwende Smilies");
 define ('ALT_USE_SMILEY', "Konvertiert Smilies zu Icons (nur Felder, die f&uuml;r HTML zugelassen sind, akzeptieren Smilies)");
 define ('COLUMN_CONVERT_URL', "Konvertiere URLs");
 define ('ALT_CONVERT_URL', "Angegebene URLs werden automatisch in Links gewandelt (nur in Feldern, die f&uuml;r HTML zugelassen sind)");

 define ('TITLE_LAMER_FILTER', "Lamer Filter");
 define ('COLUMN_DISALLOW_IP', "Unerlaubte IP-Adressen:");
 define ('ALT_DISALLOW_IP', "Angabe der IP-Adressen, von denen aus keine Beitr&auml;ge erstellt werden d&uuml;rfen, getrennt durch Leerzeichen, Komma oder Semikolon");

 define ('TITLE_FILE_UPLOAD', "Dateien senden");
 define ('COLUMN_FILE_UPLOAD', "Dateien d&uuml;rfen gesendet werden");
 define ('ALT_FILE_UPLOAD', "Erlaubt Benutzern Dateien als Anhang zum Server zu senden");
 define ('COLUMN_MAX_FILE_SIZE', "Maximal erlaubte Dateigr&ouml;e (in Bytes)");
 define ('ALT_MAX_FILE_SIZE', "Es k&ouml;nnen nur Dateien gesendet werden, die kleiner als die angegebene Gr&ouml;e sind");

 define ('COLUMN_ALLOW_EXTENSION', "Erlaubte Endungen: ");
 define ('ALT_ALLOW_EXTENSION', "Angabe der erlaubten Datei-Endungen (z.B.: .gif), getrennt durch Leerzeichen, Komma oder Semikolon. Nur Dateien mit diesen Endungen d&uuml;rfen gesendet werden");
 define ('COLUMN_DENY_EXTENSION', "Unerlaubte Endungen: ");
 define ('ALT_DENY_EXTENSION', "Angabe der unerlaubten Datei-Endungen (z.B.: .gif), getrennt durch Leerzeichen, Komma oder Semikolon. Dateien mit diesen Endungen d&uuml;rfen nicht gesendet werden. Nur benutzt, wenn keine 'erlaubten Endungen' angegeben wurden");

 define ('COLUMN_ALLOW_MIME', "Erlaubte MIME-Typen: ");
 define ('ALT_ALLOW_MIME', "Angabe der erlaubten MIME-Typen (z.B.: image/gif, text/*), getrennt durch Leerzeichen, Komma oder Semikolon. Das Format ist typ/subtyp oder typ/*");
 define ('COLUMN_DENY_MIME', "Unerlaubte MIME-Typen: ");
 define ('ALT_DENY_MIME', "Angabe der unerlaubten MIME-Typen (z.B.: image/gif, text/*), getrennt durch Leerzeichen, Komma oder Semikolon. Nur benutzt, wenn keine 'erlaubten MIME-Typen' angegeben wurden");

 define ('TITLE_SEARCH', "Suchen");
 define ('COLUMN_SEARCH_SUPPORT', "Suchunterst&uuml;tzung ");
 define ('ALT_SEARCH_SUPPORT', "Erlaubt Benutzer die Beitr&auml;ge zu durchsuchen");
 define ('COLUMN_SEARCH_ENGINE', "Suchmaschine: ");
 define ('COLUMN_PATH_NAME', "Pfadname ");
 define ('ALT_PATH_NAME', "Pfadspezifikation des Such-Programms");
 define ('TITLE_SEND_MAIL', "eMails senden");
 define ('COLUMN_MAIL_MODERATOR', "Sendet eMail an den Moderator");
 define ('ALT_MAIL_MODERATOR', "Bei neuen oder ge&auml;nderten Beitr&auml;gen Benachrichtigungs-eMail an den Hauptmoderator senden");
 define ('COLUMN_ALLOW_MAIL_SUBSCRIPTION', "eMail-Abonnement erlauben");
 define ('ALT_ALLOW_MAIL_SUBSCRIPTION', "Erlaubt den Benutzern Antworten zu Beitr&auml;gen als eMail zu erhalten");
 define ('COLUMN_ALLOW_PRIVATE_MAIL', "Allow private mails");
 define ('ALT_ALLOW_PRIVATE_MAIL', "allow users tosend private mails to the authors of notes");
 define ('COLUMN_MAIL_ATTACHMENT', "Attach files to mails");
 define ('ALT_MAIL_ATTACHMENT', "Attach \"attachment\" files to the mails sent to users");
 define ('LABEL_DEFAULT', "R&uuml;ckg&auml;ngig");

 define ('LABEL_FRAMES', "Frames");
 define ('COLUMN_USE_FRAMES', "Frames verwenden");
 define ('ALT_USE_FRAMES', "Auch wenn diese Option aktiviert ist, werden &auml;ltere Browser ebenfalls unterst&uuml;tzt");
 define ('COLUMN_FRAMESET_PARAMETER', "Frameset Parameter:");
 define ('ALT_FRAMESET_PARAMETER', "Zus&auml;tzliche Parameter f&uuml;r das FRAMESET Tag");
 define ('COLUMN_HEADER_FRAME_PARAMETER', "Header Frame Parameter:");
 define ('ALT_HEADER_FRAME_PARAMETER', "Zus&auml;tzliche Parameter f&uuml;r das FRAME Tag");
 define ('COLUMN_FOOTER_FRAME_PARAMETER', "Footer Frame Parameter:");

 define ('TITLE_POST_MESSAGES', "Beitr&auml;ge erstellen");
 define ('COLUMN_POST_POPUP', "In Popup-Fenster erstellen");
 define ('ALT_POST_POPUP', "&Ouml;ffnet ein separates Fenster mit dem Erstellen/&Auml;ndern-Formular");
 define ('COLUMN_NO_BUTTON_BAR', "Keine Button-Leiste darstellen");
 define ('ALT_NO_BUTTON_BAR', "Verhindert die Darstellung der Button-Leiste und der Optionen am Ende des Erstellen/&Auml;ndern-Formulars");
 define ('COLUMN_NO_THANKS', "Keine Danke-Meldung anzeigen");
 define ('ALT_NO_THANKS', "Zeigt nach dem Erstellen/&Auml;ndern statt eine Danke-Meldung direkt die n&auml;chste Seite an");
 define ('COLUMN_AFTER_POSTING', "Nach dem Erstellen fortfahren mit");
 define ('ALT_AFTER_POSTING', "Diese Seite erscheint nach dem &Uuml;bertragen eines Beitrags");
 define ('COLUMN_NEWLY_POSTED', "Neu erstellter Beitrag");
 define ('COLUMN_MESSAGE_LIST', "Liste der Beitr&auml;ge");
 define ('COLUMN_FIRST_MESSAGE', "Erster Beitrag der Diskussion");

 define ('TITLE_INCLUDE_FILES', "Eingebundene Dateien (alle Dateien befinden sich in %s), bei leeren Feldern wird eine Standardvorgabe benutzt");

 define ('COLUMN_CSS_FILE', "Style sheet (CSS) Datei:");
 define ('ALT_CSS_FILE', "CSS Datei (wird im HEAD Tag eingebunden):");
 define ('COLUMN_HEADER_FILE', "Header Datei");
 define ('ALT_HEADER_FILE', "Diese Datei wird mit dem Header eingebunden");
 define ('COLUMN_FOOTER_FILE', "Footer");
 define ('ALT_FOOTER_FILE', "Diese Datei wird mit dem Footer eingebunden");
 define ('COLUMN_LISTING_OUTLINE', "Beitrags-Listen-&Uuml;bersicht");
 define ('ALT_LISTING_OUTLINE', "Liste der Beitr&auml;ge");
 define ('COLUMN_INCLUDE_MESSAGES', "Beitr&auml;ge");
 define ('ALT_INCLUDE_MESSAGES', "Dargestellte Beitr&auml;ge und Bild-Dateien");
 define ('COLUMN_FORM_FILE', "Formular");
 define ('ALT_FORM_FILE', "Formular zum Erstellen/Bearbeiten/Antworten von/auf Beitr&auml;gen");
 define ('COLUMN_MAIL_FORM_FILE', "Private mails form");
 define ('ALT_MAIL_FORM_FILE', "form used to send private mails");
 define ('COLUMN_FILE_SEARCH', "Such-Formular");
 define ('ALT_FILE_SEARCH', "Search Form");
 define ('COLUMN_TEMPLATE_FILE', "Vorlage");
 define ('ALT_TEMPLATE_FILE', "Vorlage f&uuml;r Beitr&auml;ge");
 define ('COLUMN_FIELDS_NAME', "Feldnamen");
 define ('ALT_FIELDS_NAME', "Definition der Datenbankfelder (Variablen)");
 define ('COLUMN_PHP_INCLUDE', "PHP Skript, das vor dem Zugriff eingebunden wird");
 define ('ALT_PHP_INCLUDE', "Optionales PHP Skript das vor dem Abspeichern von Daten ausgef&uuml;hrt (eingebunden) wird");
 define ('COLUMN_FILE_LOGIN', "Anmelde-Formular");
 define ('ALT_FILE_LOGIN', "Formular, mit dem sich die Benutzer anmelden");
 define ('COLUMN_REGISTER_FORM', "Registierungs-Formular");
 define ('ALT_FILE_REGISTER', "Formular, mit dem sich die Anwender registrieren");
 define ('COLUMN_SHOW_PROFILE', "Eigenschaften-Vorlage");
 define ('ALT_FILE_SHOW_PROFILE', "Anzeige der Benutzer-Eigenschaften");
 define ('COLUMN_FILE_CHANGE_PASSWORD', "Formular 'Kennwort &auml;ndern'");
 define ('ALT_FILE_CHANGE_PASSWORD', "Formular zum &Auml;ndern des Benutzer-Kennwortes");
 define ('COLUMN_FILE_FORGOT_PASSWORD', "Formular 'Kennwort vergessen'");
 define ('ALT_FILE_FORGOT_PASSWORD', "Formular zur Berabeitung bei vergessenem Kennwort");
 define ('COLUMN_FILE_MAIL_TEMPLATE', "eMail Vorlagen");
 define ('ALT_FILE_MAIL_TEMPLATE', "eMail Konfiguration und -Vorlagen");
 define ('COLUMN_SUBSCRIBE_FORM_TEMPLATE', "Formular 'Abonnieren'");
 define ('ALT_FILE_SUBSCRIBE_FORM', "Formular mit dem die eMail-Benachrichtigung abonniert werden kann");

 define ('TITLE_DISCUSSION_BOARD', "Diskussionen");
 define ('COLUMN_ALLOW_REPLIES', "Antworten erlauben (Diskussionsbeitr&auml;ge)");
 define ('ALT_ALLOW_REPLIES', "Erlaubt es den Benutzern auf Beitr&auml;ge zu antworten (diskutieren)");

 define ('TITLE_DISPLAYED_MESSAGE', "Dargestellte Beitr&auml;ge");
 define ('COLUMN_NO_TOOLBAR', "Keine Werkzeugleiste f&uuml;r Beitr&auml;ge");
 define ('ALT_NO_TOOLBAR', "Verhindert die Darstellung der Werkzeugleiste (Antworten|Bearbeiten|L&ouml;schen|Auflisten) am Ende dargestellter Beitr&auml;ge");
 define ('COLUMN_NO_NAVIGATION_BAR', "Keine Navigationsleiste f&uuml;r Beitr&auml;ge");
 define ('ALT_NO_NAVIGATION_NAR', "Verhindert die Darstellung der Navigationsleiste (n&auml;chster/vorheriger Beitrag)");
 define ('COLUMN_NO_THREAD', "Keine Diskussionen darstellen");
 define ('ALT_NO_THREAD', "Verhindert die Darstellung von Antworten zu einem Beitrag");
 define ('COLUMN_APPEND_MESSAGE', "Antwort-Formular anzeigen");
 define ('ALT_APPEND_MESSAGE', "Zeigt ein Antwort-Formular am Ende jedes Beitrags an");

 define ('TITLE_MESSAGE_LISTING', "Liste der Beitr&auml;ge");
 define ('COLUMN_MESSAGE_NO_NAVIGATION_BAR', "Keine Navigationsleiste f&uuml;r die Liste");
 define ('ALT_MESSAGE_NO_NAVIGATION_NAR', "Verhindert die Darstellung der Navigationsleiste (n&auml;chster/vorheriger Seite)");
 define ('COLUMN_GUESTBOOK', "Beitrag Senden-Formular anzeigen");
 define ('ALT_GUESTBOOK', "Zeigt das Formular 'Beitrag senden' am Ende der Liste (G&auml;stebuch-Modus)");

 define ('TITLE_BROWSE_SERVER', "Server Durchsuchen");
 define ('COLUMN_BROWSE_SERVER', "Server durchsuchen erlauben");
 define ('ALT_BROWSE_SERVER', "Erlaubt es Benutzern Dateien anzuh&auml;ngen, die sich auf dem Server befinden");
 define ('COLUMN_BASE_DIRECTORY', "Startverzeichnis");
 define ('ALT_BASE_DIRECTORY', "Definiert des Startverzeichnis, von dem aus Benutzer nach anzuh&auml;ngenden Dateien suchen k&ouml;nnen");

 /////////////////////
 //Edit_Forum.php3
 /////////////////////
 define ('LABEL_EDIT_FORUM', "Forum-Einstellungen bearbeiten");
 define ('LABEL_SITE_EDIT_FORUM', "W&auml;hlen Sie das Forum der Site %s, das bearbeitet werden soll");
 define ('ERROR_NO_FORUM_UPDATE', "Das Forum %s der Site %s konnte nicht ge&auml;ndert werden");
 define ('ERROR_NO_NEW_MODERATOR', "Die Moderator-Berechtigung des Benutzers %s f&uuml;r das Forum %s konnte nicht gesetzt werden");
 define ('LABEL_EDIT_FORUM_SHORT', "Forum bearbeiten: ");
 define ('LABEL_FORUM_INFORMATION', "Forum-Einstellungen");
 define ('COLUMN_STATE', "Status");
 define ('COLUMN_CATEGORY', "Kategorie");
 define ('LABEL_PRIVACY_INFORMATION', "Eingestellte Vertraulichkeit");
 define ('LABEL_CHANGE_ACCESS', "Zugriffsmodus f&uuml;r dieses Forum &auml;ndern");
 define ('LABEL_MODERATED', "moderiert");
 define ('LABEL_UPDATE_THIS_FORUM' , "Forum aktualisieren");
 define ('LABEL_CHOOSE_MODERATOR', "Benutzer, der Hauptmoderator dieses Forums sein soll einstellen/&auml;ndern");

 /////////////////////
 //admin_categories.php3
 /////////////////////
 define ('LABEL_EDIT_CATEGORIES', "Kategorien der Site bearbeiten ");
 define ('LABEL_ADD_CATEGORY', "Kategorie zuf&uuml;gen");
 define ('COLUMN_EDIT_CATEGORY', "Kategorie &auml;ndern");
 define ('COLUMN_CAT_TITLE', "Thema (Titel):");
 define ('COLUMN_DELETE_CATEGORY', "Kategorie l&ouml;schen");
 define ('LABEL_UPDATE_ORDER', "Reihenfolge aktualisieren");
 define ('LABEL_ADD_NEW_CATEGORY', "Neue Kategorie erstellen");
 define ('LABEL_ADD_THIS_CATEGORY', "Diese Kategorie zuf&uuml;gen");
 define ('LABEL_EDIT_CATEGORY', "Kategorie bearbeiten");
 define ('LABEL_UPDATE_THIS_CATEGORY', "Diese Kategorie aktualisieren");

 /////////////////////
 //Create_Forum.php3
 /////////////////////
 define ('TITLE_CREATE_FORUM', "Forum erstellen");
 define ('ERROR_FORUM_NAME_TO_LONG', "Der Name des Forums ist zu lang, bitte k&uuml;rzeren Namen w&auml;hlen.");
 define ('ERROR_CONFIG_FILE_EXISTS', "Die Konfigurationsdatei (%s) existiert bereits, l&ouml;schen Sie sie manuell oder w&auml;hlen Sie einen anderen Namen");
 define ('ERROR_NO_FILE_COPY', "Die Datei %s konnte nicht kopiert werden");

 define ('ERROR_FORUM_DB_DBM_EXISTS', "Die Site-Datenbank %s existiert bereits, <br> Sie m&uuml;ssen die DBM Datei manuell l&ouml;schen: <em>dbm/%s/%s</em><br> [und ebenso die Lockdatei .lck]");
 define ('ERROR_FORUM_DB_EXISTS', "Die Datenbanktabelle (%s) des Forums existiert bereits in der Datenbank (%s), Sie m&uuml;ssen die Tabelle zuerst manuell l&ouml;schen oder einen anderen Namen w&auml;hlen");

 define ('ERROR_FORUM_DB_DBM_ACCESS', "Zugriffsproblem, die DBM Datei (<em>%s</em>) konnte nich terstellt werden, &uuml;berpr&uuml;fen Sie den freien Plattenplatz und die Zugriffsberechtigungen");
 define ('ERROR_FORUM_DB_ACCESS', "Zugriffsproblem, die datenbanktabelle (<em>%s</em>) konnte nicht erzeugt werden. Stellen Sie sicher, da die Datenbank %s existiert und &uuml;berpr&uuml;fen Sie die Zugriffsberechtigungen");
 define ('ERROR_NO_CREATE_FORUM', "Forum konnte nicht erstellt werden:");
 define ('ERROR_NO_FORUM_INSERT', "Forum %s konnte nicht in Site %s erstellt werden");
 define ('LABEL_FORUM_CREATED', "Forum '<em>%s</em>' wurde in der Site %s erstellt<BR><BR>&nbsp;&nbsp;Sie k&ouml;nnen jetzt:");
 define ('LABEL_CREATE_ANOTHER_FORUM', "Ein anderes Forum erstellen");
 define ('ALT_ACCESS_FORUM', "Auf das Forum zugreifen");
 define ('LABEL_ADMINISTRATE_FORUM', "Das Forum verwalten");
 define ('ALT_ADMINISTRATE_FORUM', "Weitere Einstellungen des Forums vornehmen");
 define ('LABEL_EDIT_THIS_FORUM', "Das Forum bearbeiten");
 define ('ALT_EDIT_THIS_FORUM', "Die Charakteristika des Forums bearbeiten");
 define ('LABEL_SITE_ADMINISTRATION', "Zur Site-Verwaltung zur&uuml;ckkehren");
 define ('LABEL_FORUM_CREATED_SUCCESSFULLY', "Das Forum %s wurde erfolgreich erstellt");
 define ('LABEL_INSTALL_FORUM', "Neues Forum in Site erstellen: ");
 define ('COLUMN_GIVE_FORUM_NAME', "Name des Forums:");
 define ('COLUMN_FORUM_TEMPLATE', "Vorlage ausw&auml;hlen (Design):");
 define ('LABEL_SET_ACCESS', "Zugriffsmodus f&uuml;r das Forum ausw&auml;hlen:");
 define ('LABEL_CREATE_THIS_FORUM', "Forum erstellen");
 define ('LABEL_NAME_OF_FORUM', "(Name, der f&uuml;r das Forum gelten soll)");
 define ('LABEL_CHOOSE_FIRST_MODERATOR', "Auswahl des Benutzers (Besitzer) der das Forum moderieren soll:");

 /////////////////////
 //Reorder_Forum.php3
 /////////////////////
 define ('TITLE_REORDER_FORUM', "&Auml;ndern der Darstellungsreihenfolge der Foren in der Site: ");
 define ('LABEL_CHANGE_FORUM_ORDER', "Im folgenden kann die Reihenfolge ge&auml;ndert werden, in der die Foren angezeigt werden. Jedem Forum kann, mit 1 beginnend, eine individuelle Reihenfolgenummer zugeordnet werden. Foren mit der Reihenfolgenummer 0 werden nicht angezeigt");


 /////////////////////
 //editform.php3
 /////////////////////
 define ('LABEL_NEW_FILE_EDITING', "Neue Datei bearbeiten:");
 define ('WARNING_EDITING_DEFAULT', "Warnung : die Datei ist eine Standard-Vorgabedatei f&uuml;r diese Site, &Auml;nderungen haben Auswirkungen auf alle Foren der Site.");
 define ('LABEL_SPECIFIC_TEMPLATE', "Falls eine spezielle Vorlage verwendet werden soll, kann der Name auf der Seite <a href='%s'>Eingebundene Dateien</a> angegeben werden");

 /////////////////////
 //editmsg.php3
 /////////////////////
 define ('TITLE_EDITING_MESSAGES', "Meldungen bearbeiten");
 define ('ERROR_NO_CREATE_MESSAGE', "Die Meldungsdatei kann nicht erstellt werden, bitte Zugriffsberechtigungen &uuml;berpr&uuml;fen");

 /////////////////////
 //editfields.php3
 /////////////////////
 define ('TITLE_EDITING_FIELDS', "Felder bearbeiten");
 define ('LABEL_NAME', 'Name');
 define ('LABEL_SIZE', 'Gr&ouml;e');
 define ('LABEL_REQUIRED', 'Notwendig');
 define ('LABEL_LISTED', 'Aufgelistet');
 define ('LABEL_ACCEPT_HTML', 'HTML/Smilies akzeptieren');
 define ('LABEL_SAVE_COOKIE', 'In permanentem Cookie speichern');
 define ('LABEL_DELETE_FIELD', 'L&ouml;schen');
 define ('LABEL_USER_VARIABLES', 'Benutzer Variablen');
 define ('LABEL_LISTED_VARIABLES', 'Aufgelistete Variablen');
 define ('LABEL_REQUIRED_VARIABLES', 'Ben&ouml;tigte Variables');
 define ('LABEL_VARIABLES_ACCEPT_HTML', 'Variablen, die HTML akzeptieren');
 define ('LABEL_VARIABLES_COOKIE', 'Variables die als permanenter Cookie gesetzt werden');
 define ('LABEL_CONFIRM_DELETE_FIELD', 'Soll dieses Feld aus der Tablle gel&ouml;scht werden');
 define ('ALT_DELETE_FIELD', 'Feld l&ouml;schen : %s');
 define ('ALT_ADD_FIELD', 'Feld zuf&uuml;gen');
 define ('ERROR_UNDEFINED_VARNAME', 'Bitte Name des einzuf&uuml;genden Feldes angeben');
 define ('ERROR_UNDEFINED_VARSIZE', 'Bitte Typ des einzuf&uuml;genden Feldes angeben [xxx | int | text]');
 define ('ERROR_VARNAME_ALREADY_DEFINED', 'Dieser Feldname existiert bereits');

 /////////////////////
 //edittemplate.php3
 /////////////////////
 define ('TITLE_EDITING_TEMPLATE', "Vorlagen bearneiten");
 define ('LABEL_DEFINE_DOCUMENT_GENERATION', "Definiert wie Dokumente aus Vorlagen erzeugt werden:");
 define ('LABEL_STATIC', "<b>Statisch</b><i> (Eine Datei mit der HTML Seite wird beim Erstellen eines Beitrags erzeugt) </i>");
 define ('LABEL_ONTHEFLY', "<b>Dynamisch</b><i> (Der Beitrag wird dynamisch erzeugt, wenn er abgerufen wird)</i>");
 define ('LABEL_NO_DOCUMENTS', "<b>Keine Dokumente</b><i> (nur die Datenbanken werden angezeigt)</i>");
 define ('LABEL_EDIT_TEMPLATE', "Bearbeiten der Dokumentenvorlage:");

 /////////////////////
 //editmail.php3
 /////////////////////
 define ('TITLE_EDITING_MAIL', "eMail-Vorlagen bearbeiten");
 define ('LABEL_OVERWRITE_MAIL_FILE', "<trans>Mail template file (<font color=red>WARNING!</font> this choice will overwrite current file)");
 define ('LABEL_SEND_OUT_EMAILS', "Absender (From: Zeile)");
 define ('LABEL_USER_EMAIL', "eMail-Adresse des Benutzers");
 define ('LABEL_THIS_EMAIL', "Diese eMail");
 define ('LABEL_FIRST_RECIPIENT', "Erster Empf&auml;nger (To: Zeile)");
 define ('LABEL_RETURN_PATH', "Antwort-Adresse (Return-Path)");
 define ('LABEL_REPLY_TO', "Antwort an (Reply-To)");
 define ('LABEL_NO_MAIL_SUBJECT', "Betreff, falls der Beitrag keinen Titel hat");
 define ('LABEL_MAIL_SUBJECT', "Betreff ");
 define ('LABEL_MAIL_APPROVAL', "eMail-Vorlage an Moderatoren zum &Uuml;berpr&uuml;fen von Beitr&auml;gen (nur moderierte Foren)"); 
 define ('LABEL_MAIL_POSTED', "<trans>Mail sent when a new note is posted");
 define ('LABEL_MAIL_MODIFIED', "<trans>Mail sent when a note is modified");
 define ('LABEL_MAIL_BODY', "Text");
 define ('LABEL_MAIL_REGISTRATION', "Vorlage f&uuml;r Registrierungs-Nachricht");
 define ('LABEL_MAIL_CONFIRM_REGISTRATION', "eMail-Vorlage an Benutzer nach dem ndern der Einstellungen durch den Administrator");
 define ('LABEL_MAIL_USER_APPROVAL', "eMail-Vorlage an Moderatoren zum Best&auml;tigen neuer Benutzer");
 define ('LABEL_MAIL_USER_MODIFICATION', "eMail-Vorlage an Moderatoren beim &Auml;ndern von Benutzer-Einstellungen");
 define ('LABEL_MAIL_FORGOT_PASSWORD', "Vorlage f&uuml;r eMails an Benutzer mit vergessenem Kennwort");

 /////////////////////
 //delete_Forum.php3
 /////////////////////
 define ('TITLE_DELETE_FORUM', 'Forum l&ouml;schen');
 define ('TITLE_DELETE_FORUM_IN_SITE', 'Forum %s in site %s l&ouml;schen');
 
 define ('ERROR_MUST_BE_ADMIN_TO_REMOVE_FORUM', 'Sie m&uuml;ssen als Administratror angemeldet sein um ein Forum l&ouml;schen');
 define ('ERROR_NO_AVAILABLE_FORUM', 'Kein Forum verf&uuml;gbar in Site %s,<br>');
 define ('ERROR_FORUM_DOESNT_EXIST', 'Das Forum %s existiert in dieser Site nicht');
 define ('ERROR_CANT_REMOVE_FORUM', 'Das Forum %s der Site %s konnte nicht gel&ouml;scht werden');

 define ('LABEL_CHOOSE_FORUM_TO_DELETE', 'W&auml;hlen Sie das Forum, das von Site %s entfernt werden soll'); 
 define ('LABEL_FORUM_DELETED', 'Forum %s wurde gel&ouml;scht');

 define ('CAPTION_DELETE_FORUM', '<B>Soll das folgende Forum wirklich gel&ouml;scht werden</B>');
 define ('LABEL_FORUM_TITLE', 'Titel: ');
 define ('LABEL_FORUM_DESCR', 'Beschreibung: ');
 define ('LABEL_FORUM_OWNER', 'Besitzer: ');
 define ('LABEL_FORUM_TYPE', 'Typ: ');
 define ('LABEL_FORUM_MODER', 'Moderiert: ');
 define ('LABEL_FORUM_STATE', 'Status: ');
 define ('LABEL_DELETE_THIS_FORUM', 'Dieses Forum l&ouml;schen');

?>
