<?PHP

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: wa_info.php,v 1.3 2005/06/10 22:13:03 mdruilhe Exp $
 *	Usage:		Include file : gives information about w-agora/PHP configuration
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net> and OTHERS
 */

function wa_info() {
	global $cfg_dir, $ext;

	if (file_exists ("$cfg_dir/site_agora.$ext")) {
		include ("$cfg_dir/site_agora.$ext");
		$backend = (empty ($bn_access) ) ? "unknown" : $bn_access;
		$setupdate = date ("M d Y h:i", filectime("$cfg_dir"));
	} else {
		$backend = "N/A";
		$setupdate = "not yet installed<br>";
	}

	$phpini = get_cfg_var('cfg_file_path');

	$get_config = (function_exists('ini_get')) ? "ini_get" : "get_cfg_var";

	// Global (system) configuration
	$safe_mode = $get_config('safe_mode');
	$register_globals = $get_config('register_globals');
	$include_path = $get_config('include_path');
	$log_errors = (int) $get_config('log_errors');
	$error_log = $get_config('error_log');
	$magic_quotes_gpc = $get_config('magic_quotes_gpc');

	// file upload config
	$file_uploads = $get_config('file_uploads');
	$upload_tmp_dir = $get_config('upload_tmp_dir');
	$upload_max_filesize = $get_config('upload_max_filesize');

	// Mail configuration
	$sendmail_path = $get_config('sendmail_path');
	$SMTP = $get_config('SMTP');
	$sendmail_from = $get_config('sendmail_from');
?>

<html><head><style type="text/css">
<!--
H1 { font-family: Helvetica, Arial, Geneva, Verdana, sans-serif; font-size: 18pt; font-weight: bold;}
BODY,TD,th { font-family: Helvetica, Arial, Geneva, Verdana, sans-serif; font-size: 10pt; }
-->
</style>
<title><?php print wa_version()?></title></head><body>
<TABLE BORDER=0 CELLPADDING=5 CELLSPACING=1 WIDTH=600 BGCOLOR="#000000" ALIGN="CENTER">
<TR VALIGN="middle" BGCOLOR="#c0cad6"><TD ALIGN="left">
<a href="http://www.w-agora.net/"><img src="images/logo1.jpg" border=0 align="right" alt="w-agora Logo"></a><h3><font color="#000080"><?php print wa_version() ?></font></h3>
</TD></TR>
</TABLE><BR>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=1 WIDTH=600 BGCOLOR="#000000" ALIGN="CENTER">

<tr><th BGCOLOR="#ffffff" colspan=2>w-agora Informations</th></tr>
<TR><TD BGCOLOR="#c0cad6"><B>Version</B></td><TD BGCOLOR="#d0dae6"><?php print wa_version() ?></td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>Setup date</B></TD><TD BGCOLOR="#d0dae6"><?php print $setupdate?></TD></TR>
<TR><TD BGCOLOR="#c0cad6"><B>Database backend</B></td><TD BGCOLOR="#d0dae6"><?php print $backend ?></td></TR>

<tr><th BGCOLOR="#ffffff" colspan=2>Environment</th></tr>
<?php  if (defined('PHP_OS') ) { ?>
<TR><TD BGCOLOR="#c0cad6"><B>Operating System </B></td><TD BGCOLOR="#d0dae6"><?php print PHP_OS ?></td></TR>
<?php  } ?>
<?php  if (function_exists('php_sapi_name') ) { ?>
<TR><TD BGCOLOR="#c0cad6"><B>Server API</B></td><TD BGCOLOR="#d0dae6"><?php print @php_sapi_name()?></td></TR>
<?php  } ?>
<TR><TD BGCOLOR="#c0cad6"><B>Script owner</B></td><TD BGCOLOR="#d0dae6"><?php print @get_current_user()?></td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>PHP version</B></TD><TD BGCOLOR="#d0dae6"><?php print phpversion()?></td></TR>

<tr><th BGCOLOR="#ffffff" colspan=2>PHP Configuration</th></tr>
<?php  if (!empty($phpini) ) { ?>
<TR><TD BGCOLOR="#c0cad6"><B>PHP configuration file (php.ini) path</B></td><TD BGCOLOR="#d0dae6"><?php print $phpini ?></td></TR>
<?php  } ?>
<TR><TD BGCOLOR="#c0cad6"><B>PHP Safe mode</B></td><TD BGCOLOR="#d0dae6"><?php print (get_cfg_var("safe_mode")) ? "On" : "Off"?></td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>PHP Register Globals</B></td><TD BGCOLOR="#d0dae6"><?php print $register_globals?></td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>Include path</B></td><TD BGCOLOR="#d0dae6"><?php print $include_path?></td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>log errors</B></td><TD BGCOLOR="#d0dae6"><?php print $log_errors?></td></TR>
<?php  if ($log_errors) { ?>
<TR><TD BGCOLOR="#c0cad6"><B>error_log file</B></td><TD BGCOLOR="#d0dae6"><?php print $error_log?></td></TR>
<?php  } ?>
<TR><TD BGCOLOR="#c0cad6"><B>magic_quotes_gpc</B></td><TD BGCOLOR="#d0dae6"><?php print $magic_quotes_gpc?></td></TR>

<tr><th BGCOLOR="#ffffff" colspan=2>File upload</th></tr>
<TR><TD BGCOLOR="#c0cad6"><B>HTTP File Uploads</B></td><TD BGCOLOR="#d0dae6"><?php print $file_uploads ?></td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>Temporary File Upload directory</B></td><TD BGCOLOR="#d0dae6"><?php print $upload_tmp_dir ?></td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>Maximum allowed size for uploaded files</B></td><TD BGCOLOR="#d0dae6"><?php print $upload_max_filesize ?></td></TR>

<tr><th BGCOLOR="#ffffff" colspan=2>Mail configuration</th></tr>
<TR><TD BGCOLOR="#c0cad6"><B>SMTP server (win32 only) </B></td><TD BGCOLOR="#d0dae6"><?php print $SMTP ?>&nbsp;</td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>Sendmail From address (win32 only) </B></td><TD BGCOLOR="#d0dae6"><?php print $sendmail_from ?>&nbsp;</td></TR>
<TR><TD BGCOLOR="#c0cad6"><B>Sendmail path (unix only)</B></td><TD BGCOLOR="#d0dae6"><?php print $sendmail_path ?>&nbsp;</td></TR>
</TABLE>
<?php
} // end wa_info()

?>
