<?php

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: tinymce.php,v 1.2 2005/12/07 18:35:13 mdruilhe Exp $
 *	Usage:	TinyMCE Wysigyg editor support (see http://tinymce.moxiecode.com/)
 *	Author:	Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

	define('HTML_EDITOR_DIR', 'tinymce/jscripts/tiny_mce');
	define('HTML_EDITOR_URL', 'tinymce/jscripts/tiny_mce');

# Disable wysiwyg editor if HTML not allowed or module not installed
# -------------------------------------------------------------------
	if (!file_exists(HTML_EDITOR_DIR."/tiny_mce.js") || empty($bn_allow_html) ) {
		$use_html_editor = false;
		return;
	}

# Set the editor language according to the w-agora current settings
# -------------------------------------------------------------------
	if ( isset($lang) && file_exists(HTML_EDITOR_DIR."/langs/$lang.js") ) {
		$editor_lang = $lang;
	} elseif ( isset($default_lang)&& file_exists(HTML_EDITOR_DIR."/lang/$default_lang.js") ) {
		$editor_lang = $default_lang;
	} else {
		$editor_lang = 'fr';
	}

?>

<!-- tinyMCE -->
<script language="javascript" type="text/javascript" src="<?php echo HTML_EDITOR_URL?>/tiny_mce.js"></script>
<script language="javascript" type="text/javascript">
tinyMCE.init({
	mode : "exact",
	theme : "advanced",
	theme_advanced_toolbar_location: "top",
	theme_advanced_toolbar_align: "left",
	theme_advanced_layout_manager : "SimpleLayout",
	remove_linebreaks : true,
	convert_newlines_to_brs : true,
	auto_cleanup_word : true,
	theme_advanced_buttons1: "formatselect, separator, bold, italic, underline, strikethrough, separator, forecolor, backcolor, separator, justifyleft, justifycenter, justifyright, justifyfull, separator, numlist, bullist, outdent, indent, separator, hr, charmap, code, separator, removeformat, undo, redo",
	theme_advanced_buttons2: "",
	theme_advanced_buttons3: "",
	language : "<?php echo $editor_lang?>",
	elements : "body"
  });

  _use_html_editor = true;

function editorSubmit(f) {
	tinyMCE.triggerSave();
}

function editorFocus(elem) {
	tinyMCE.execInstanceCommand(elem, 'mceFocus');
}

function editorQuoteText (elem, text) {
	quotedText = '<br/>'+text.replace(/\r\n/g, '<br />').replace(/\n/g, '<br />').replace(/\r/g, '<br />');
	tinyMCE.execInstanceCommand(elem, 'mceInsertContent', false, quotedText+'<br/>');
}

function editorReset (f) {
	tinyMCE.setContent('');
}


</script>
<!-- /tinyMCE --> 

