<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: mimetypes.php,v 1.24 2006/02/10 14:08:15 mdruilhe Exp $
 *	Usage:		Define mime types and how to display inline attachments
 *				Make sure to adjust the global statement in include/misc_func::load_mimetypes() 
 *				if you add new variables to this file.
 *				This file can be put in your forum directory if you need specific settings
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net> and OTHERS
 */


// display mode if displayed inline
define	('ATT_DSP_LINK', '1');		// displays as link (icon)
define	('ATT_DSP_IMG', '2');		// display inline as a picture, using <img> tag.
define	('ATT_DSP_HTML', '3');		// display inline as HTML, e.g. banned tags are stripped.
define	('ATT_DSP_PLAINTEXT', '4');	// display inline as text, using <pre> tag.
define	('ATT_DSP_PHP', '5');		// Highlighted PHP source code
define	('ATT_DSP_WAV', '6');		// Wave audio files 
define	('ATT_DSP_MID', '7');		// MIDI audio files
define	('ATT_DSP_MPG', '8');		// MPEG video files 
define	('ATT_DSP_AVI', '9');		// Windows Media Player file 
define	('ATT_DSP_QT', '10');		// Apple QuickTime video file 
define	('ATT_DSP_SWF', '11');		// Embedded Macromedia Shockwave Flash

$mimetypes = array (
  'avi'  => 'video/x-msvideo',
  'bat'  => 'text/plain',
  'bmp'  => 'image/bmp',
  'doc'  => 'application/msword',
  'gif'  => 'image/gif',
  'gz'   => 'application/x-gzip',
  'htm'  => 'text/html',
  'html' => 'text/html',
  'jpe'  => 'image/jpeg',
  'jpg'  => 'image/jpeg',
  'jpeg' => 'image/jpeg',
  'kar'  => 'audio/midi',
  'mid'  => 'audio/midi',
  'midi' => 'audio/midi',
  'mov'  => 'video/quicktime',
  'mpe'  => 'video/mpeg',
  'mpeg' => 'video/mpeg',
  'mpg'  => 'video/mpeg',
  'mpga' => 'audio/mpeg',
  'mp2'  => 'audio/mpeg',
  'mp3'  => 'audio/mpeg',
  'pdf'  => 'application/pdf',
  'php'  => 'text/php',
  'php'.'3' => 'text/php',
  'png'  => 'image/png',
  'ppt'  => 'application/vnd.ms-powerpoint',
  'qt'   => 'video/quicktime',
  'rtf'  => 'text/rtf',
  'swf'  => 'application/x-shockwave-flash',
  'tar'  => 'application/x-tar',
  'tgz'  => 'application/x-gzip',
  'tif'  => 'image/tiff',
  'tiff' => 'image/tiff',
  'txt'  => 'text/plain',
  'wav'  => 'audio/x-wav',
  'xls'  => 'application/vnd.ms-excel',
  'xml'  => 'text/xml',
  'zip'  => 'application/zip'
);

// mime type to be used if no other type known
// Do not modify without need!
$mimetype_default = 'application/octet-stream';
$mime_dspinl[$mimetype_default] = 'O';
$mime_dspfmt[$mimetype_default] = ATT_DSP_LINK;


// display mode if displayed inline
$mime_dspfmt['image/gif'] = ATT_DSP_IMG;
$mime_dspfmt['image/bmp'] = ATT_DSP_LINK;
$mime_dspfmt['image/png'] = ATT_DSP_IMG;
$mime_dspfmt['image/x-png'] = ATT_DSP_IMG;
$mime_dspfmt['image/jpeg'] = ATT_DSP_IMG;
$mime_dspfmt['image/pjpeg'] = ATT_DSP_IMG;
$mime_dspfmt['text/html'] = ATT_DSP_HTML;
$mime_dspfmt['text/php'] = ATT_DSP_PHP;
$mime_dspfmt['text/plain'] = ATT_DSP_PLAINTEXT;
$mime_dspfmt['audio/x-wav'] = ATT_DSP_WAV;
$mime_dspfmt['audio/midi'] = ATT_DSP_MID;
$mime_dspfmt['audio/mid'] = ATT_DSP_MID;
$mime_dspfmt['video/mpeg'] = ATT_DSP_MPG;
$mime_dspfmt['video/quicktime'] = ATT_DSP_QT;
$mime_dspfmt['video/x-msvideo'] = ATT_DSP_AVI;
$mime_dspfmt['application/x-shockwave-flash'] = ATT_DSP_SWF;


/*
Variables
---------
$att_name:		The name of the attachment
$att_type:		The mime-type of the attachment
$att_size:		attachment Size (pretty formated)
$att_url:		The URL of the attachment (getfile.php/forum/att_id/filename)
$att_icon:		Attachment icon (got from att_icons[]
$att_contents:	The embedded (formated/parsed) contents (HTML, text)
$img_size:		The string : "height=xxx width=xxx" (img, flash)

*/

// Plain text files
$mime_renderers[ATT_DSP_PLAINTEXT] = "<div class=\"att_plaintext\"><div class=\"att_name\"><a href=\"\$att_url\" class=\"wa_link\" target=\"_blank\">\$att_icon \$att_name</a></div><div class=\"att_contents\"><pre>\$att_contents</pre></div></div>";

// PHP files
$mime_renderers[ATT_DSP_PHP] = "<div class=\"att_php\"><div class=\"att_name\"><a href=\"\$att_url\" class=\"wa_link\" target=\"_blank\">\$att_icon \$att_name</a></div><div class=\"att_contents\">\$att_contents</div></div>";

// HTML file embedded in IFRAME
$mime_renderers[ATT_DSP_HTML] = "<div class=\"att_html\"><div class=\"att_name\"><a href=\"\$att_url\" class=\"wa_link\" target=\"_blank\">\$att_icon \$att_name</a></div><iframe src=\"\$att_url\" class=\"att_contents\">\$att_contents</iframe></div>";


// Image
$mime_renderers[ATT_DSP_IMG] = "<div class=\"att_img\"><img src=\"\$att_url\" alt=\"\$att_name\" border=\"0\" \$img_size></div>";

// Wave audio files
$mime_renderers[ATT_DSP_WAV] = "<div class=\"att_video\"><embed src=\"\$att_url\" name=\"\$att_name\" autostart=\"true\" loop=\"false\" controls=\"smallconsole\" hidden=\"true\" type=\"audio/wav\"></embed></div>";

// MIDI audio files
$mime_renderers[ATT_DSP_MID] = "<div class=\"att_video\"><embed src=\"\$att_url\" name=\"\$att_name\" autostart=\"true\" loop=\"false\" controls=\"smallconsole\" border=\"0\"></embed></div>";

// MPEG video files
$mime_renderers[ATT_DSP_MPG] = "<div class=\"att_video\"><embed src=\"\$att_url\" name=\"\$att_name\" autostart=\"true\" loop=\"false\" controls=\"smallconsole\" type=\"video/mpg\" quality=\"autohigh\" menu=\"true\" border=\"0\" width=\"$bn_max_width\" height=\"$bn_max_height\"></embed></div>";

// Windows Media Player file 
$mime_renderers[ATT_DSP_AVI] = "<div class=\"att_video\"><object id=\"MediaPlayer\" classid=\"CLSID:22D6F312-B0F6-11D0-94AB-0080C74C7E95\" type=\"application/x-oleobject\"><param name=\"FileName\" value=\"\$att_name\"><embed src=\"\$att_url\" type=\"application/x-mplayer2\" name=\"VideoAVI\" loop=\"0\" hidden=\"FALSE\" border=\"0\"></embed></object></div>";

// Apple QuickTime video file 
$mime_renderers[ATT_DSP_QT] = "<div class=\"att_video\"><object classid=\"02BF25D5-8C17-4B23-BC80-D3488ABDDC6B\" codebase=\"http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0\"><param name=\"pluginspage\" value=\"http://www.apple.com/quicktime/download/indext.html\"><param name=\"TYPE\" value=\"video/quicktime\"><param name=\"SRC\" value=\"\$att_url\"><param name=\"CONTROLLER\" value=\"true\"><param name=\"AUTOPLAY\" value=\"true\"><embed src=\"\$att_url\" pluginspage=\"http://www.apple.com/quicktime/download/indext.html\" type=\"video/quicktime\" controller=\"TRUE\" bgcolor=\"#000000\" border=\"0\"></embed></object></div>";

// Macromedia shockwave flash 
$mime_renderers[ATT_DSP_SWF] = "<div class=\"att_video\"><object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=4\,0\,2\,0\" \$img_size><param name=quality value=high><param name=\"SRC\" value=\"\$att_url\"><embed src=\"\$att_url\" quality=high pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" \$img_size></embed></object></div>";

// Other formats, displayed as link
$mime_renderers[ATT_DSP_LINK] = "<div class=\"att_link\"><a href=\"\$att_url\" title=\"\$label_download_file\" target=\"_blank\" onMouseover=\"window.status='\$label_download_file';return true\" onMouseout=\"window.status='';return true\">\$att_icon<div class=\"att_name\">\$att_name</div></a><div class=\"att_size\">\$att_size</div></div>";

$att_icons = array (
	'gz' => '<img src="images/file_types/zip.gif" border="0" width="15" height="18" align="absmiddle" alt="Archive file">',
	'zip' => '<img src="images/file_types/zip.gif" border="0" width="15" height="18" align="absmiddle" alt="ZIP file">',
	'doc' => '<img src="images/file_types/word.gif" border="0" width="16" height="16" align="absmiddle" alt="MsWord document">',
	'html' => '<img src="images/file_types/htm.gif" border="0" width="16" height="16" align="absmiddle" alt="HTML file">',
	'htm' => '<img src="images/file_types/htm.gif" border="0" width="16" height="16" align="absmiddle" alt="HTML file">',
	'pdf' => '<img src="images/file_types/pdf.gif" border="0" width="16" height="16" align="absmiddle" alt="Adobe Acrobat document">',
	'txt' => '<img src="images/file_types/txt.gif" border="0" width="14" height="16" align="absmiddle" alt="Text file">',
	'xls' => '<img src="images/file_types/excel.gif" border="0" width="16" height="16" align="absmiddle" alt="MsExcel file">',
	'swf' => '<img src="images/file_types/flash.gif" border="0" width="15" height="15" align="absmiddle" alt="ShockwaveFlash application">',
	'jpg' => '<img src="images/file_types/image.gif" border="0" width="16" height="16" align="absmiddle" alt="JPG picture">',
	'jpeg' => '<img src="images/file_types/image.gif" border="0" width="16" height="16" align="absmiddle" alt="JPEG picture">',
	'gif' => '<img src="images/file_types/image.gif" border="0" width="16" height="16" align="absmiddle" alt="GIF picture">',
	'png' => '<img src="images/file_types/image.gif" border="0" width="16" height="16" align="absmiddle" alt="PNG picture">',
	'php' => '<img src="images/file_types/php.gif" border="0" width="18" height="10" align="absmiddle" alt="PHP script">',
	'ph'.'p3' => '<img src="images/file_types/php.gif" border="0" width="18" height="10" align="absmiddle" alt="PH'.'P3 script">',
	'exe' => '<img src="images/file_types/exe.gif" border="0" width="16" height="16" align="absmiddle" alt="Application">',
	'ppt' => '<img src="images/file_types/ppt.gif" border="0" width="16" height="16" align="absmiddle" alt="MsPowerPoint file">',
	'wav' => '<img src="images/file_types/wav.gif" border="0" width="20" height="20" align="absmiddle">',
	'mid' => '<img src="images/file_types/mid.gif" border="0" width="20" height="20" align="absmiddle">',
	'avi' => '<img src="images/file_types/mov.gif" border="0" width="20" height="20" align="absmiddle">',
	'mpeg' => '<img src="images/file_types/mov.gif" border="0" width="20" height="20" align="absmiddle">',
	'mpg' => '<img src="images/file_types/mov.gif" border="0" width="20" height="20" align="absmiddle">',
	'qt' => '<img src="images/file_types/mov.gif" border="0" width="20" height="20" align="absmiddle">',
	'mov' => '<img src="images/file_types/mov.gif" border="0" width="20" height="20" align="absmiddle">'
); 

$att_icon_default = '<img src="images/file_types/unknown.gif" border="0" width="15" height="15" align="absmiddle">';

$att_icon_multiple = '<img src="images/file_types/multiple.gif" border="0" width="15" height="15" align="absmiddle">';

?>
