<?php

/*
 *  W-AGORA 4.2
 *  -----------
 *  $Id: listrenderer.php,v 1.8 2005/12/21 14:09:32 mdruilhe Exp $
 *  Usage:      include file - Handle lists using templates
 *  Authors:    Marc Druilhe <mdruilhe@w-agora.net>
 */

if (defined("_LISTRENDERER")) return;
define('_LISTRENDERER', 1);

class ListRenderer {

	var $debug = 0;				// 1 = turns debug mode On

	var $children = array();	// array of keys
	var $entries = array();		// array in which notes are stored
	var $users = array();		// loads threads contributors here
	var $lineNo;

	/* private */
	var $site;
	var $start;
	var $end;
	var $per_page;

function ListRenderer (&$db, $start=0, $per_page=0) {

	$this->db =& $db;
	$this->children = & $db->children;
	$this->entries = & $db->entries;
	$this->users = & $db->users;
	$this->start = (int) $start;
	$this->per_page = (int) $per_page;
	$this->end = $this->start + $this->per_page;
}

function displayForumList () {
	global $site, $bn, $ext, $main_page, $cookies, $auth, $is_authenticated;
	global $site_totalthreads, $site_totalnotes, $site_totalforums;
	global $site_title, $login_string;
	global $admin_url, $admin_text, $admin_link;
	global $list_url, $list_text, $list_link;
	global $post_url, $post_text, $post_link;
	global $search_url, $search_text, $search_link;
	global $login_url, $login_text, $login_link;
	global $register_url, $register_text, $register_link;
	global $profile_url, $profile_text, $profile_link;
	global $subscribe_url, $subscribe_text, $subscribe_link;
	global $download_forum_url, $download_forum_text, $download_forum_link;
	global $forum_list_url, $forum_list_text, $forum_list_link;
	global $choose_forum_box, $choose_forum_form;
	global $bn_win_width, $bn_win_height;
	global $forum_types;
	global $site_totalforums, $site_totalnotes, $site_totalusers, $site_totalthreads, $site_newest_userid, $site_newest_username;

	if (!is_array($this->entries)) return -1;
	if (!is_array($this->children[0])) return -1;

	// set variables from localization
	$caption_forum_list         = CAPTION_FORUM_LIST;
	$column_forum               = COLUMN_FORUM;
	$column_forum_state         = COLUMN_FORUM_STATE;
	$column_forum_access        = COLUMN_FORUM_ACCESS;
	$column_forum_moderated     = COLUMN_FORUM_MODERATED;
	$column_forum_moderators    = COLUMN_FORUM_MODERATORS;
	$column_forum_threads       = COLUMN_FORUM_THREADS;
	$column_messages            = COLUMN_MESSAGES;
	$column_forum_attachments   = COLUMN_FORUM_ATTACHMENTS;
	$column_forum_attachment    = COLUMN_FORUM_ATTACHMENT;
	$column_forum_posts         = COLUMN_FORUM_POSTS;
	$column_forum_last_post     = COLUMN_FORUM_LAST_POST;
	$column_forum_name          = COLUMN_FORUM_NAME;
	$column_forum_title         = COLUMN_FORUM_TITLE;
	$column_forum_description   = COLUMN_DESCRIPTION;
	$label_opened_forum         = LABEL_OPENED_FORUM;
	$label_updated_forum        = LABEL_UPDATED_FORUM;
	$label_locked_forum         = LABEL_LOCKED_FORUM;
	$label_closed_forum         = LABEL_CLOSED_FORUM;
	$label_stats                = LABEL_STATS;
	$label_site_msg_stats       = sprintf(LABEL_SITE_MSG_STATS, $site_totalforums, $forum_list_url, $site_totalnotes, $site_totalusers, $ext, $site, $site_totalthreads);
	$label_last_registered_user = sprintf(LABEL_LAST_REGISTERED_USER, $ext, $site, $site_newest_userid, $site_newest_username);

	// displays list header
	if (!empty($GLOBALS["bn_before_line"]) ) {
		eval ($GLOBALS["bn_before_line"]);
	}
	$l = str_replace('"', '\"', $GLOBALS["bn_list_header"])."\n";
	eval ("echo \"$l\";");
	// eval ("echo stripSlashes(\"$l\");");

	if (!empty($GLOBALS['bn_list_category'])) {
		$this->list_category = str_replace('"','\"', $GLOBALS["bn_list_category"])."\n";
	}
	$this->odd_line = str_replace('"','\"', $GLOBALS["bn_list_odd_first_line"])."\n";
	$this->even_line = str_replace('"','\"', $GLOBALS["bn_list_even_first_line"])."\n";

	$categories = $this->db->getCategories($site);

## display all forums
## ------------------
	$curcat = 0;    // current displayed category
	$this->lineNo = 0;
	reset($this->children[0]);
	while ( list (,$key) = each ($this->children[0]) ) {
		// evaluate all variables
		extract($this->entries[$key]);

# Handle cookies / new stuff
# --------------------------
		$new_icon = "";
		$is_updated = FALSE;

		if (isset($GLOBALS["WAS_${bn_name}"]) ) {
			parse_str($GLOBALS["WAS_${bn_name}"]);
			if ($lastnote > $ThisVisit) {
				$is_updated = TRUE;
				$new_icon = '<span class="new">'.LABEL_NEW.'</span>';
			}
		} elseif (isset($GLOBALS["WAP_${bn_name}"]) ) {
			parse_str($GLOBALS["WAP_${bn_name}"]);
			if ($lastnote > $LastVisit) {
				$is_updated = TRUE;
				$new_icon = '<span class="new">'.LABEL_NEW.'</span>';
			}
		} elseif ( ($GLOBALS['now'] - $lastnote) < ( (int) $GLOBALS['bn_new_age']) ) {
			$is_updated = TRUE;
			$new_icon = '<span class="new">'.LABEL_NEW.'</span>';
		}

# set updated color
# -----------------
		if ($lastnote > 0) {
			$age = $GLOBALS['now'] - $lastnote;
			if ($age > ( (int) $GLOBALS['bn_new_age']) ) {
				$date_color = $GLOBALS['bn_normal_color'];
			} elseif ($age < ( (int) $GLOBALS['bn_hot_age']) ) {
				$date_color = $GLOBALS['bn_hot_color'];
			} else {
				$date_color = $GLOBALS['bn_new_color'];
			}
			$newestNote = formated_date ($lastnote);
		} else {
			$newestNote = "";
		}

		$formated_date = formated_date($unixdate);
		$moder_icon = ($moderated == 1) ? LABEL_YES : LABEL_NO;
		$access_icon = $forum_types[$type];

		switch ($state) {
		 case "0":  // inactive
			$alt_state_label = ALT_INACTIVE_FORUM;
			$state_icon=msg(130, "<img src='images/inactive_thread.gif' alt='$alt_state_label'>");
			break;
		 case "L":  // locked
			$alt_state_label = ALT_LOCKED_FORUM;
			$state_icon=msg(131, "<img src='images/locked_thread.gif' alt='$alt_state_label'>");
			break;
		 case "C":  // closed
			$alt_state_label = LABEL_CLOSED_FORUM;
			$state_icon=msg(146, "<img src='images/closed_thread.gif' alt='$alt_state_label'>");
			break;
		 case "1":  // active
			if ($is_updated) {
				$alt_state_label = LABEL_UPDATED_FORUM;
				$state_icon=msg(148,"<img src='images/new_thread.gif' alt='$alt_state_label'>");
			} else {
				$alt_state_label = ALT_ACTIVE_FORUM;
				$state_icon=msg(132,"<img src='images/thread.gif' alt='$alt_state_label'>");
			}
			break;
		}
		$active_icon = $state_icon;

		$cat_id = $parent;
		if ($cat_id != $curcat) {
			// new category
			$cat_title = $categories[$cat_id];
			$cat_list_url = "list.$ext?site=$site&cat=$cat_id";
			$curcat = $cat_id;

			if (!empty($GLOBALS["bn_before_line"]) ) {
				eval ($GLOBALS["bn_before_line"]);
			}
			eval ('echo stripSlashes("'.$this->list_category.'");');
		}

		// display line
		$line = ($this->lineNo % 2) ? 'odd_line' : 'even_line';
		if (!empty($this->$line) ) {
			$this->lineNo ++;
			$lineNo = & $this->lineNo;

			if (!empty($GLOBALS["bn_before_line"]) ) {
				eval ($GLOBALS["bn_before_line"]);
			}
			$lastnote = $newestNote;    // backward compatibility
			eval ('echo stripSlashes("'.$this->$line.'");');
		}
	}

	// displays list footer
	if (!empty($GLOBALS["bn_before_line"]) ) {
		eval ($GLOBALS["bn_before_line"]);
	}
	$l = str_replace('"', '\"', $GLOBALS["bn_list_footer"])."\n";
	eval ("echo stripSlashes(\"$l\");");
}

#   ------------------------------------------------------------------
#               Notes management functions
#   ------------------------------------------------------------------

function displayList ($key, $action, $start=null, $per_page=null) {

	global $now, $main_page, $ext, $site, $bn, $bn_db, $bn_action, $bn_pad, $bn_depth_limit;
	global $cookies, $auth, $db;
	global $lynx, $pattern;
	global $icon_dir, $img_dir, $bn_dir_notes;

	global $msg;
	global $expnd, $here, $first, $last, $next, $prev;
	global $formated_date, $total, $totalthreads, $totalnotes, $notes, $threads;
	global $forum_types, $forum_states;

	global $bn_win_width, $bn_win_height;
	global $list_url, $list_text, $list_link;
	global $post_url, $post_text, $post_link;
	global $reply_url, $reply_text, $reply_link;
	global $search_url, $search_text, $search_link;
	global $list_prev_url, $list_prev_text, $list_prev_link;
	global $forum_list_url, $forum_list_text, $forum_list_link;
	global $download_forum_url, $download_forum_text, $download_forum_link;
	global $register_url, $register_text, $register_link;
	global $login_url, $login_text, $login_link;
	global $profile_url, $profile_text, $profile_link;
	global $subscribe_url, $subscribe_text, $subscribe_link;
	global $list_next_url, $list_next_text, $list_next_link;
	global $view_prev_url, $view_prev_text, $view_prev_link;
	global $view_next_url, $view_next_text, $view_next_link;
	global $label_add_reply, $label_posted, $label_suject;
	global $label_current_thread, $nav_bar, $page_nav_bar;
	global $label_read_more, $label_comments;
	global $column_subject;

	$this->begin_level = str_replace('"','\"', $GLOBALS["bn_${action}_begin_level"])."\n";
	$this->odd_first_line = str_replace('"','\"', $GLOBALS["bn_${action}_odd_first_line"])."\n";
	$this->even_first_line = str_replace('"','\"', $GLOBALS["bn_${action}_even_first_line"])."\n";
	$this->odd_line = str_replace('"','\"', $GLOBALS["bn_${action}_odd_line"])."\n";
	$this->even_line = str_replace('"','\"', $GLOBALS["bn_${action}_even_line"])."\n";
	$this->end_level = str_replace('"','\"', $GLOBALS["bn_${action}_end_level"])."\n";
	$this->end_thread = str_replace('"','\"', $GLOBALS["bn_${action}_end_thread"])."\n";

	$GLOBALS['edit_text'] = LABEL_EDIT_MESSAGE;
	$GLOBALS['delete_text'] = LABEL_DELETE_MESSAGE;
	$GLOBALS['reply_text'] = LABEL_REPLY_MESSAGE;
	$GLOBALS['mail_text'] = LABEL_MAIL;
	$GLOBALS['mail_moder_text'] = LABEL_MAIL_MODER;
	$GLOBALS['show_profile_text'] = msg(145, "<img src=\"$icon_dir/show_profile.gif\" width=15 height=15 border=0>");

	$caption_thread_list        = CAPTION_THREAD_LIST;
	$column_replies             = COLUMN_REPLIES;
	$column_last_reply          = COLUMN_LAST_REPLY;
	$column_topic_starter       = COLUMN_TOPIC_STARTER;
	$column_hits                = COLUMN_HITS;
	$column_date                = COLUMN_DATE;
	$column_description         = COLUMN_DESCRIPTION;
	$column_downloads           = COLUMN_DOWNLOADS;
	$label_comments             = LABEL_COMMENTS;
	$label_read_more            = LABEL_READ_MORE;

	$label_hot_thread           = LABEL_HOT_THREAD;
	$label_new_thread           = LABEL_NEW_THREAD;
	$label_hot_new_thread       = LABEL_HOT_NEW_THREAD;
	$label_normal_thread        = LABEL_NORMAL_THREAD;
	$label_closed_thread        = LABEL_CLOSED_THREAD;
	$label_forum_msg_stats      = sprintf(LABEL_FORUM_MSG_STATS, $formated_date, $totalnotes, $totalthreads);

	$label_current_thread       = LABEL_CURRENT_THREAD;
	$label_prev_thread          = LABEL_PREV_THREAD;
	$label_next_thread          = LABEL_NEXT_THREAD;
	$alt_prev_thread            = ALT_PREV_THREAD;
	$alt_next_thread            = ALT_NEXT_THREAD;
	$column_author              = COLUMN_AUTHOR;
	$column_subject             = COLUMN_SUBJECT;
	$label_mark_all_read        = LABEL_MARK_ALL_READ;
	$label_add_reply            = LABEL_ADD_REPLY;
	$label_posted               = LABEL_POSTED;

	if (isSet ($cookies) && !empty ($cookies->s_cookies["LastVisit"])) {
		$this->lastVisit = & $cookies->s_cookies['LastVisit'];
		$this->visitedKeys = & $cookies->s_cookies['visited'];
		$this->collapsedKeys = & $cookies->s_cookies['collapse'];
		$this->expandedKeys = & $cookies->s_cookies['expnd'];
	} else {
		// No cookie set, disable the feature
		$this->lastVisit = 0;
		$this->visitedKeys = '';
		$this->collapsedKeys = '';
		$this->expandedKeys = '';
	}
	$this->lineNo = 0;

	if (!is_null($start)) {
		$this->start = (int) $start;
	}
	if (!is_null($per_page)) {
		$this->per_page = (int) $per_page;
	}
	$this->end = $this->start + $this->per_page;

	if (!empty($GLOBALS['bn_before_line']) ) {
		eval ($GLOBALS['bn_before_line']);
	}

	$l = str_replace ('"', '\"', $GLOBALS["bn_${action}_header"]);
	eval ("echo stripSlashes(\"$l\");");
	if (is_array($this->entries)) {
		reset($this->entries);
		$this->displayNode ($key);
	}

	if (!empty($GLOBALS['bn_before_line']) ) {
		eval ($GLOBALS['bn_before_line']);
	}

	$l = str_replace ('"', '\"', $GLOBALS["bn_${action}_footer"]);
	eval ("echo stripSlashes(\"$l\");");
}

/**
 * return the position in the list of the first item (starting at 0) of the page containing the given key
 *
 * @access  public
 * @param   integer $key		The key to find in the list
 * @param   integer $per_page	Number of items per page
 * @since	4.2
 * @see		_getTreeList
 * @return	integer $start_item	The first item in the page
 */
function getStartItem ($key, $per_page) {
	$this->_tree_list = array();
	$this->_getTreeList(0);
	$pos = (int) array_search($key, $this->_tree_list);
	return floor($pos/$per_page) * $per_page;
}

/**
 * Retrieve recursively the list of keys and store then into the private array _tree_list
 *
 * @access  private
 * @param   integer $key	The starting key
 * @since	4.2
 * @return	void
 */
function _getTreeList($key=0) {
	$this->_tree_list[] = $key;
	if (@is_array($this->children[$key])) {
		foreach($this->children[$key] as $child) {
			$this->_getTreeList ($child);
		}
	}
}

function displayNode ($key) {
	global $now, $main_page, $ext, $site, $bn, $bn_db, $bn_action, $bn_pad, $bn_depth_limit;
	global $cookies, $auth, $db, $forum;
	global $note, $lynx, $pattern;
	global $icon_dir, $img_dir, $bn_dir_notes;

	global $msg;
	global $expnd, $here;
	global $first, $last, $next, $prev;
	global $total, $totalthreads, $totalnotes, $notes, $threads;
	global $forum_types, $forum_states;

	global $bn_win_width, $bn_win_height;

	global $list_url, $list_text, $list_link;
	global $post_url, $post_text, $post_link;
	global $search_url, $search_text, $search_link;
	global $forum_list_url, $forum_list_text, $forum_list_link;
	global $download_forum_url, $download_forum_text, $download_forum_link;
	global $register_url, $register_text, $register_link;
	global $login_url, $login_text, $login_link;
	global $profile_url, $profile_text, $profile_link;
	global $subscribe_url, $subscribe_text, $subscribe_link;

	global $list_prev_url, $list_prev_text, $list_prev_link;
	global $list_next_url, $list_next_text, $list_next_link;
	global $view_prev_url, $view_prev_text, $view_prev_link;
	global $view_next_url, $view_next_text, $view_next_link;

	global $label_add_reply, $label_posted;
	global $label_read_more, $label_comments, $label_posted_by_on;
	global $newestNote, $label_latest;
	global $column_subject;

	static $threadNo = 0;
	static $level = 0;
	static $threadNo = 0;

	$top_level=0;

	$has_children = isset($this->children[$key]);
	$is_expanded=1;
	setType ($bn_depth_limit, "integer");

# Initialize some variables
# -------------------------
	$new_icon = "";
	$is_new = FALSE;
	$is_updated = FALSE;
	$hidden_note = true;

	$att_name = "";
	$att_type = "";
	$att_url = "";
	$att_link = "";
	$attachments = "";
	$att_icon = "";

	if (($key>0) && is_array($this->entries[$key]) ) {

		$hidden_note = false;

# evaluate all variables
# ----------------------
		extract ($this->entries[$key]);

# Handle cookies / new stuff
# --------------------------
		if (!empty ($this->lastVisit)) {
			if ( ($unixdate > $this->lastVisit) && !ereg($key, $this->visitedKeys) ) {
				$is_new = TRUE;
				$new_icon = '<span class="new">'.LABEL_NEW.'</span>';
			} elseif ( ($newest > $this->lastVisit) && !ereg($key, $this->visitedKeys) ) {
				$is_updated = TRUE;
			}
		} else {
			// No cookie set, disable the feature
			$is_new = TRUE;
		}

	}

# shows Hidden notes only to moderator
# ------------------------------------
	if ( (!empty($hidden) && $auth->level<1) ) {
		$hidden_note = true;
	}

# don't display old notes if "list only new" is set
# -----------------------------------------------
	if ( ($expnd == "new") && !$is_new ) {
		$hidden_note = true;
	}

	if (!$hidden_note)  {

		if (isset($body)) {
			$body = format_text($body);
		}

		if (!empty($pattern)) {
			// $subject = highlight_pattern($subject, $pattern);
			if (isset($body)) {
				$body = highlight_pattern($body, $pattern);
			}
		}

		if (isset($this->users[$userid])) {
			extract ($this->users[$userid], EXTR_PREFIX_ALL, 'user');
		}

		// USER PRIVILEGES
		if (isset($user_userpriv) ) {
			$user_priv = ($userid=='guest') ? GUESTUSER_USERNAME : $GLOBALS['user_privs'][$user_userpriv];
		}

		// set color depending on note age
		$age = $GLOBALS['now'] - $unixdate;
		if ($age > ( (int) $GLOBALS['bn_new_age']) ) {
			$date_color = $GLOBALS['bn_normal_color'];
		} elseif ($age < ( (int) $GLOBALS['bn_hot_age']) ) {
			$date_color = $GLOBALS['bn_hot_color'];
		} else {
			$date_color = $GLOBALS['bn_new_color'];
		}

		$formated_date = formated_date($unixdate);
		$note = $key;

		if ($mod_date>$unixdate) {
		  $last_edited = sprintf (NOTE_LAST_EDITED, formated_date($mod_date), $mod_userid);
		}
		$alt_email_user = sprintf(ALT_SEND_EMAIL_TO, $username);

		if ($att_size>0) {
			$att = $this->db->getAttachments ($bn_db, $key);
			if (is_array($att)) {
				$att_count = count($att);
				for ($i=0; $i<$att_count; $i++) {
					$att_id        = $att[$i]["att_id"];
					$att_ids[$i]   = $att_id;
					$att_name      = $att[$i]["att_name"];
					$att_names[$i] = $att_name;
					$att_type      = $att[$i]["att_type"];
					$att_types[$i] = $att_type;
					$att_size      = (integer) $att[$i]["att_size"];
					$att_sizes[$i] = $att_size;
					if ($GLOBALS["use_path_info"]) {
						$att_url = "getfile.$ext/$bn/$att_id/$att_name";
					} else {
						$att_url = "getfile.$ext?bn=$bn&att_id=$att_id";
					}
					$att_urls[$i]  = $att_url;
					$att_inline    =  $att[$i]["inline"];
					$att_link     = getAttachmentUrl ($key, $att_id, "$bn_dir_notes/$att_id.$att_name", $att_type, $att_size, $att_inline);
					$att_links[$i]  = $att_link;
					$attachments .= $att_links[$i]."&nbsp;";
					$att_list[$att_id] = $att_name;
				}

				$att_icon = ($att_count>1) ? $GLOBALS['att_icon_multiple'] : att_icon($att_name);
				$att_list_box = getListBox ("att_id", $att_list, "", 0, "window.location=('getfile.$ext?bn=$bn&att_id='+this.options[this.selectedIndex].value)");
				$att_list_form = "<form action=\"getfile.$ext\"><input type=\"hidden\" name=\"bn\" value=\"$bn\">".LABEL_ATTACHMENTS.$att_list_box."<input type=\"submit\" value=\"".LABEL_DOWNLOAD."\"></form>";
				unset ($att);
			}
		}

		// determine if top level of thread (new thread)
		if ($parent==0) {
			$top_level=1;
			$threadNo++;
			$threadAnchor="<a name=\"A$thread\"></a>";
		}
		else {
			$top_level=0;
			$threadAnchor="";
		}

		// initialize "latest" pattern
		if (empty($newest)) {
			$newestNote="";
			$newestPrmpt="";
		} else {
			$newestNote = formated_date($newest);
			$label_latest = strip_tags(LABEL_LATEST);
			$newestPrmpt=msg(68);
		}

		// set the pointer to the current note
		if (isset($here) && ($here == $key)) {
			$currPointer=msg(73);
		} else {
			$currPointer="";
		}

		// is this entry at top of thread (ie. new topic)
		if ($top_level) {

			if ($closed == 1) {
				$alt_state_label = strip_tags(LABEL_CLOSED_THREAD);
				$thread_icon = msg(146, '<img src="images/locked_thread.gif">');    // closed thread
			} elseif ($is_updated || $is_new) {
				if ( $GLOBALS["bn_hot_threshold"] && ($replies>$GLOBALS["bn_hot_threshold"]) ) {
					$alt_state_label = strip_tags(LABEL_HOT_NEW_THREAD);
					$thread_icon = msg (147, '<img src="images/hot_new_thread.gif">');  // thread with new messages and more than XX replies
				} else {
					$alt_state_label = strip_tags(LABEL_NEW_THREAD);
					$thread_icon = msg (148, '<img src="images/new_thread.gif">');  // thread with new messages in it
				}
			} else {
				if ( $GLOBALS["bn_hot_threshold"] && ($replies > $GLOBALS["bn_hot_threshold"]) ) {
					$alt_state_label = strip_tags(LABEL_HOT_THREAD);
					$thread_icon = msg (149, '<img src="images/hot_thread.gif">');  // thread with more than XX replies
				} else {
					$alt_state_label = strip_tags(LABEL_NORMAL_THREAD);
					$thread_icon = msg (150, '<img src="images/thread.gif">');  // normal (old) thread
				}
			}

			if ($replies > 0) {
				// if newest note is since last visit, force thread to be expanded
				if ( ($expnd== 'none') || strstr($this->collapsedKeys, "$key+") ) {

					$is_expanded = 0;
				} elseif ( ($expnd=='all') || strstr($this->expandedKeys, "$key+") ) {
					$is_expanded = 1;
				} elseif ( ($newest > $this->lastVisit) && !strstr($this->visitedKeys, "$key+") ) {
					$is_expanded = 1;
				} else {
					$is_expanded = 0;
				}

				// set expand_icon depending on collapsed or expanded:
				$expand_icon="<a href='$list_url";
				if ($is_expanded) {
					// currently expanded
					$expand_icon .= "&collapse=$thread'>".msg(75)."</a>";
				} else {
					// currently collapsed
					$expand_icon .= "&expnd=$thread'>" . msg(76) . "</a>";
					if ($is_updated) {
						$new_icon = '<span class="new">'.LABEL_NEW.'</span>';
					}
				}
			} else {
				$expand_icon = msg(72); // set expand_icon to "single message"
			}
			$line = ($this->lineNo % 2) ? 'odd_first_line' : 'even_first_line';
		} else {
			$expand_icon = "";
			$line = ($this->lineNo % 2) ? 'odd_line' : 'even_line';
			$replies=0;
			if (!empty($bn_pad)) {
				if (empty($bn_depth_limit) ) {
					$depth = $level;
				} else {
					$depth = ($level<$bn_depth_limit) ? $level : $bn_depth_limit;
				}
				$pad = "";
				while ($depth--) {
					$pad .= "$bn_pad";
				}
			}
		}

		// set URL to display that note
		$view_url ="view.$ext?bn=$bn&key=$key";
		$edit_url ="edit.$ext?bn=$bn&key=$key";
		$delete_url ="delete.$ext?bn=$bn&key=$key";
		$reply_url ="post.$ext?bn=$bn&key=$key";
		$subscribe_thread_url = "subscribe_thread.$ext?bn=$bn&thread=$thread";
		$mail_url = "mail.$ext?bn=$bn&key=$key&type=author";
		$mail_moder_url = "mail.$ext?bn=$bn&key=$key&type=moderator";
		$close_url = "close.$ext?bn=$bn&key=$thread";
		if (!empty($first)) {
			$view_url .= "&first=$first";
		}
		if (!empty($this->start)) {
			$view_url .= '&st='.$this->start;
		}

		if (!empty($pattern)) {
			$view_url .= '&pattern='.urlencode($pattern);
		}
		$view_link = "<a href=\"$view_url\">$subject</a>";

		$reply_link="";
		if ($GLOBALS["bn_thread"] && ($forum['state'] == '1') ) {
			$reply_link = anchorWindow ($reply_url, $GLOBALS['reply_text'], ALT_REPLY_MESSAGE, $bn_win_width, $bn_win_height);
		}

		$edit_link="";
		if ($GLOBALS['bn_modify'] && ($GLOBALS['is_moderator'] || ($userid == 'guest') || ($auth->user["userid"] == $userid))) {
			$edit_link = anchorWindow ($edit_url, $GLOBALS['edit_text'], ALT_EDIT_MESSAGE, $bn_win_width, $bn_win_height);
		}

		$delete_link = "";
		if ($GLOBALS['bn_delete'] && ($GLOBALS['is_moderator'] || ($userid == 'guest') || ($auth->user["userid"] == $userid))) {
			$delete_link = anchor ($delete_url, "", $GLOBALS['delete_text'], ALT_DELETE_MESSAGE);
		}

		$mail_link = "";
		if ($GLOBALS['bn_private_mail']) {
			if ($bn_popup) {
				$mail_link = anchorWindow ($mail_url, $GLOBALS['mail_text'], ALT_PRIVATE_MAIL, $bn_win_width, $bn_win_height);
			} else {
				$mail_link = anchor ($mail_url, "", $GLOBALS['mail_text'], ALT_PRIVATE_MAIL);
			}
		}
		
		$mail_moder_link= "";
		if ($bn_popup) {
			$mail_moder_link = anchorWindow ($mail_moder_url, $GLOBALS['mail_moder_text'], ALT_MAIL_MODER, $bn_win_width, $bn_win_height);
		} else {
			$mail_moder_link = anchor ($mail_moder_url, "", $GLOBALS['mail_moder_text'], ALT_MAIL_MODER);
		}
		
		// SHOW PROFILE
		$show_profile_url = "";
		$show_profile_link = "";
		if ($userid != "guest") {
			$show_profile_url = "profile.$ext?bn=$bn&showuser=$userid";
			$show_profile_link = anchor ($show_profile_url, "", $GLOBALS['show_profile_text'], sprintf (ALT_SHOW_PROFILE, $userid) );
			$label_posted_by_on = sprintf(LABEL_POSTED_BY_ON, "<a href=\"$show_profile_url\">$userid</a>", $formated_date);
		} else {
			$label_posted_by_on = sprintf(LABEL_POSTED_BY_ON, "$username (".GUESTUSER_USERNAME.")", $formated_date);
		}

		// PICTURE / AVATAR
		$user_picture = trim($user_picture);
		if(!empty($user_picture)) {
//			$user_picture = "<img src=\"$user_picture\" width=\"".$GLOBALS['max_avatar_width']."\" height=\"".$GLOBALS['max_avatar_height']."\" class=\"avatar\">";
			$user_picture = "<img src=\"$user_picture\" class=\"avatar\">";
		}

		// display line
		if (!empty($this->$line) ) {
			$n = $this->lineNo;
			$this->lineNo ++;

			if (!empty($GLOBALS["bn_before_line"]) ) {
				eval ($GLOBALS["bn_before_line"]);
			}

			if( ($n >= $this->start) && ( ($this->end==0)||($n < $this->end) ) ) {
				eval ('echo stripSlashes("'.$this->$line.'");');
			}

		}
	}

	if ($has_children && $is_expanded) {
		// display begin level pattern
		if ($key>0) {
			$level++;
			if ( ($level<$bn_depth_limit)||($bn_depth_limit==0) ) {
				eval ('echo stripSlashes("'.$this->begin_level.'");');
			}
		}
		// display all replies to this thread
		foreach($this->children[$key] as $child) {
			$this->displayNode ($child);
		}

		// display end of level pattern
		if ($key>0) {
			if ( ($level<$bn_depth_limit)||($bn_depth_limit==0) ) {
				eval ('echo stripSlashes("'.$this->end_level.'");');
			}
			$level--;
		}
	}

	// display end of thread/level pattern
	if ($top_level) {
		eval ('echo stripSlashes("'.$this->end_thread.'");');
	}
}


} // end Class

?>
