<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: htmlarea.php,v 1.7 2005/12/07 18:35:13 mdruilhe Exp $
 *	Usage:	HTMLArea 3.0 Wysigyg editor handling (see http://sf.net/projects/itools-htmlarea/)
 *	Author:	Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

define('HTML_EDITOR_DIR', 'htmlarea');
define('HTML_EDITOR_URL', 'htmlarea');

# Disable htmlarea if HTML not allowed or module not installed
# ------------------------------------------------------------
	if (!file_exists(HTML_EDITOR_DIR."/htmlarea.js") || empty($bn_allow_html) ) {
		$use_html_editor = false;
		return;
	}

	$browser = $_SERVER['HTTP_USER_AGENT'];
	if (! @preg_match("/(msie|gecko)/i", $browser)) {
		$use_html_editor = false;
		return;
	}
	if (preg_match("/opera/i", $browser)) {
		$use_html_editor = false;
		return;
	}

	$use_htmlarea = true;

# Set the HTMLAREA language according to the w-agora current settings
# -------------------------------------------------------------------
	if ( isset($lang) && file_exists(HTML_EDITOR_DIR."/lang/$lang.js") ) {
		$htmlarea_lang = $lang;
	} elseif ( isset($default_lang)&& file_exists(HTML_EDITOR_DIR."/lang/$default_lang.js") ) {
		$htmlarea_lang = $default_lang;
	} else {
		$htmlarea_lang = 'fr';
	}
?>

<style type="text/css">
@import url("<?echo HTML_EDITOR_URL?>/htmlarea.css");
</style>

<script type="text/javascript" language="javascript">
<!-- // Hide for old browsers
var _editor_url = "<?echo HTML_EDITOR_URL?>";
// End of script -->

</script>

<script type="text/javascript" src="<?echo HTML_EDITOR_URL?>/htmlarea.js"></script>
<script type="text/javascript" src="<?echo HTML_EDITOR_URL?>/lang/<?echo $htmlarea_lang?>.js"></script>
<script type="text/javascript" src="<?echo HTML_EDITOR_URL?>/dialog.js"></script>

<script type="text/javascript" language="javascript">
 <!-- // Hide for old browsers

var _use_html_editor = false;

function editorSubmit(f) {
	if (editor) {
		editor._textArea.value = editor.getHTML();
	}
}

function editorFocus(elem) {
	if (editor) {
		editor.focusEditor();
	}
}

function editorQuoteText (elem, text) {
	if (editor) {
		quotedText = text.replace(/\r\n/g, '<br />').replace(/\n/g, '<br />').replace(/\r/g, '<br />');
		editor.focusEditor();
		editor.insertHTML ('<br />' + quotedText + '<br />');
	}
}

function editorReset (f) {
  if (editor) {
    editor.setHTML('');
    editor.focusEditor();
  }
}

var myConfig = new HTMLArea.Config();

if (myConfig) {
	_use_html_editor = true;
}

myConfig.width =  "590";
myConfig.height = "auto";
// myConfig.killWordOnPaste = true;

myConfig.pageStyle =
  'body { background-color: #FFFFFF; color: black; font-family: verdana,sans-serif; font-size: x-small; margin: 0.5em} ' +
  'p {margin-top: 0.2em; margin-bottom: 0em; } ';

/* Default config

myConfig.toolbar = [
	[ "fontname", "space",
	  "fontsize", "space",
	  "formatblock", "space",
	  "bold", "italic", "underline", "separator",
	  "strikethrough", "subscript", "superscript", "separator",
	  "copy", "cut", "paste", "space", "undo", "redo" ],

	[ "justifyleft", "justifycenter", "justifyright", "justifyfull", "separator",
	  "insertorderedlist", "insertunorderedlist", "outdent", "indent", "separator",
	  "forecolor", "hilitecolor", "textindicator", "separator",
	  "inserthorizontalrule", "createlink", "insertimage", "inserttable", "htmlmode", "separator",
	  "popupeditor", "separator", "showhelp", "about" ]
];

*/

myConfig.toolbar = [
	[ "fontname", "space",
	  "fontsize", "space",
	  "bold", "italic", "underline", "separator",
	  "forecolor", "hilitecolor", "textindicator", "separator",
	  "justifyleft", "justifycenter", "justifyright", "justifyfull", "separator",
	  "insertorderedlist", "insertunorderedlist", "outdent", "indent", "separator",
      "inserthorizontalrule", "htmlmode"
	  ],
];

myConfig.statusBar = false;

/* Smileys
function insertSmiley(editor, smiley) {
	editor.focusEditor();
	editor.insertHTML('<img src="<?php echo $icon_dir?>/' + smiley + '.gif" border=0 align="absmiddle">');
};

myConfig.registerButton ("icon7", ":-)", "<?php echo $icon_dir?>/icon7.gif", false, insertSmiley);
myConfig.registerButton ("icon28", ":lol:", "<?php echo $icon_dir?>/icon28.gif", false, insertSmiley);
myConfig.registerButton ("icon30", ":fou:", "<?php echo $icon_dir?>/icon30.gif", false, insertSmiley);
myConfig.registerButton ("icon12", ";-)", "<?php echo $icon_dir?>/icon12.gif", false, insertSmiley);
myConfig.registerButton ("icon38", ":sweat:", "<?php echo $icon_dir?>/icon38.gif", false, insertSmiley);

// add the new button to the toolbar
myConfig.toolbar.push(["linebreak", "icon7", "icon28", "icon30", "icon12", "icon38" ]);
*/

// End of script -->
</script>
