<?php

/*
 *  W-AGORA 4.0
 *  -----------
 *  $Id: cookies.php,v 1.14 2005/06/05 16:44:24 mdruilhe Exp $
 *  Usage:      include file - Cookies handling functions
 *  Authors:    Tom deLombarde <tomd@blackflute.com>
 *              Marc Druilhe <mdruilhe@w-agora.com>
 *
 */

	// set persistent to expire in 30 days:
	$PExpires = mktime()+(30*(24*3600));

	if (empty($bn)) {
		$Pe_cookie="WAP_".$site;    // persistent cookie
		$Se_cookie="WAS_".$site;    // session cookie
	} else {
		$Pe_cookie="WAP_".$bn;  // persistent cookie
		$Se_cookie="WAS_".$bn;  // session cookie
	}

class Cookies {

var	$setp=0;
var	$sets=0;

var	$p_cookies = array();   // persistent cookie
var	$s_cookies = array();   // session cookie

 // Get all cookies, initialize class
 function init () {
	global $bn, $bn_new_age;
	global $Pe_cookie, $Se_cookie;

	$this->firstEntry=0;
	$cookies->s_cookies["visited"] = "";

	$now = time();

	// Check if user has cookie:
	if (isset ($_COOKIE[$Pe_cookie])) {
		// Get permanent values
		$this->parse ($_COOKIE[$Pe_cookie], "p");

		if (isset ($_COOKIE[$Se_cookie])) {
			// browser Session already set => get cookies
			$this->parse ($_COOKIE[$Se_cookie], "s");
		} else {
			// first entry to site during this browser session -> update last visit ...
			$this->s_cookies["LastVisit"]=$this->p_cookies["LastVisit"];

			// ... and set persistent values in array to match new
			$this->p_cookies["Visits"] = $this->p_cookies["Visits"]+1;
			$this->p_cookies["LastVisit"] = $now;

			// mark the persistent cookie to be sent:
			$this->setp = 1;
		}
	} else {
		// First entry to the site, set persistent & session values
		$this->s_cookies["LastVisit"] = $now - $bn_new_age;

		// ... and set persistent values
		$this->p_cookies["Visits"] = 1;
		$this->p_cookies["LastVisit"] = $now;
		$this->setp = 1;
	}

	// mark the session cookie to be sent:
	$this->s_cookies["ThisVisit"] = $now;
	$this->sets = 1;


 }

 // Parse Cookies into persistent and session cookies arrays
 function parse ($cookie, $stor) {

	$pairs = split ('&', $cookie);
	$i = 0;
	while ($i < count ($pairs)) {
		$pair = split ('=', $pairs [$i]);
		$c_key=$pair[0];
		$c_val=$pair[1];
		switch ($stor) {
		  case "p":
			$this->p_cookies[$c_key]=$c_val;
			break;
		  case "s":
			$this->s_cookies[$c_key]=$c_val;
			break;
		  case "b":
			$this->p_cookies[$c_key]=$c_val;
			$this->s_cookies[$c_key]=$c_val;
			break;
		}
		$i++;
	}
 }

 function set ($stor) {
	global $Pe_cookie, $Se_cookie, $PExpires;

	if ($stor == "s" || $stor == "b") {
		if (is_array($this->s_cookies) && $this->sets==1) {
			reset ($this->s_cookies);
			$se_string="";
			while ( list( $cookie, $val ) = each( $this->s_cookies) ) {
				if (is_string ($cookie)) {
					$se_string .= "$cookie=$val". "&";
				}
			}
			if (!empty ($se_string)) {
				$se_string = ereg_replace ("&$", "", $se_string);
				@setCookie ($Se_cookie, $se_string, 0, '/');
			}
		}
	}

	if ($stor == "p" || $stor == "b") {
		if (is_array($this->p_cookies) && $this->setp) {
			reset ($this->p_cookies);
			$pe_string="";
			while ( list( $cookie, $val ) = each( $this->p_cookies)) {
				if (is_string ($cookie)) {
					$pe_string .= "$cookie=$val". "&";
				}
			}
			if (!empty ($pe_string)) {
				$pe_string = ereg_replace ("&$", "", $pe_string);
				@setCookie ($Pe_cookie, $pe_string, $PExpires, '/');
			}
		}
	}

 }

} // End Class

	$cookies = new Cookies;
	$cookies->init();

	if ($bn_action == "list") {
		$expnd = getFormVar('expnd');
		$expnd = getFormVar('expnd');
		if (!empty($expnd) ) {
			if ($expnd=='none') {
				$cookies->s_cookies['expnd'] = '';
			} elseif ($expnd=='all') {
				$cookies->s_cookies['collapse'] = '';
			} elseif (!strstr($cookies->s_cookies['expnd'], $expnd) ) {
				$cookies->s_cookies['expnd'] .= "$expnd+";
				$cookies->s_cookies['collapse'] = @ereg_replace ("$expnd+", "", $cookies->s_cookies['collapse']);
			}
			$cookies->sets=1;
		} elseif (!empty($collapse) ) {
			$cookies->s_cookies['collapse'] .= "$collapse+";
			$cookies->s_cookies['expnd'] = @ereg_replace ("$collapse+", "", $cookies->s_cookies['expnd']);
			$cookies->sets=1;
		} elseif (!empty($r)) {
			$cookies->s_cookies["LastVisit"]=time();
			$cookies->s_cookies["visited"] = "";
			$cookies->sets=1;
		}  
	}

	if ($bn_action == "view") {
		if ( !strstr($cookies->s_cookies["visited"], "$key+")) {
			$cookies->s_cookies["visited"] .= "$key+";
			$cookies->sets=1;
		}
	}

# If coming from post/edit => save user input into permanent cookie
# ------------------------------------------------------------------
	if ( ($bn_action == "insert" || $bn_action == "update") && is_array ($bn_cookie_var) && !isset($preview) ) {
		foreach($bn_cookie_var as $field=>$value) {
			if ( isset($_POST[$field]) && ((!isSet($cookies->p_cookies[$field])) || ($cookies->p_cookies[$field] != $_POST[$field]))) {
				$cookies->p_cookies[$field] = $_POST[$field];
				$cookies->setp=1;
			}
		}
	}

# set both the session and persistent cookies
# -------------------------------------------
	$cookies->set ("b");
?>
