<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: edituserfields.php,v 1.5 2005/06/15 15:01:41 mdruilhe Exp $
 *	Usage:		Edit variables to be inserted into database
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 */

	require ('init_admin.inc');

# Only a site administrator can edit layout
# -----------------------------------------
	if ($site=="agora") {
		if ($auth->level < ROOT) {
			msgForm (ERROR_NO_ROOT, "admin_site.$ext?site=$site&force_login=1", "", "_top");
			echo "</body></html>";
			exit;
		}
	} elseif ($auth->level < ADMIN) {
		msgForm (ERROR_NO_ADMIN, "admin_site.$ext?site=$site&force_login=1", "", "_top");
		echo "</body></html>";
		exit;
	}

	include ("$site_cfg_file");

	$page_info = '';
	$var_file = "$bn_dir_default/user_fields.$ext";
	$page_title = LABEL_FILE_EDITING . " '$var_file'";

# Prevent the user to edit a file outside w-agora
# -----------------------------------------------
	if (! (ereg("$bn_dir_forums", $var_file) || ereg("$tmpl_dir", $var_file))) {
		msgForm ("access restricted to $var_file", $WA_SELF, 'back');
		exit;
	}

	if (isset($_POST['undo'])) {
		if (file_exists ("$var_file.bak.$ext")) {
			copy ("$var_file.bak.$ext", "$var_file");
		}
	} elseif (isset($_POST['save']) || isset($_GET['save']) ) {

		if (empty($var_file)) {
			msgForm (ERROR_NO_CURRENT_FILE, "$WA_SELF&site=$site", 'back');
			exit;
		}

# delete field
# ------------
		if (isset ($_POST['delfield']) ) {
			$delfield = $_POST['delfield'];
		} elseif (isset ($_GET['delfield']) ) {
			$delfield = $_GET['delfield'];
		}

		if (!empty($delfield)) {
		    include "$var_file";
			if (isset($user_var_size[$delfield])) unset ($user_var_size[$delfield]);
			if (isset($user_bind_var[$delfield])) unset ($user_bind_var[$delfield]);
		}

# start writing file
# ------------------
		$new_contents = "<"."?php\n";
		$new_contents .= "unset (\$user_var);\n";
		$i = 0;			// user_var index
		$db_count = 0;	// new count index
		while (is_array($user_var) && ($i < count ($user_var)) ) {
			$var = $user_var[$i];
			if ($var != $delfield ) {
				$sz = $user_var_size[$var];
				$new_contents .= "\$user_var[$db_count]=\"$var\";\n";
				$new_contents .= "\$user_var_size[\"$var\"]=\"$sz\";\n";
				$db_count++;
			}
			$i++;
		}

# Add new field
# -------------
		if (!empty ($_POST['new_var']) ) {
			if (empty ($new_size) ) {
				msgForm (ERROR_UNDEFINED_VARSIZE, $WA_SELF, 'back');
				exit;
			}

			include "$var_file";
		}

		if (!empty ($new_var)) {

			$new_contents .= "\$user_var[$i]=\"$new_var\";\n";
			$new_contents .= "\$user_var_size[$new_var]=\"$new_size\";\n";

			$user_var_size[$new_var] = $new_size;
			if (isset($new_bind_var)) {
				$user_bind_var[$new_var] = 1;
			}

			$db->setHaltOnError('report');
			$db->addField("${site}_users", $new_var, $new_size);
		}

		if (is_array($user_bind_var)) {
			$new_contents .= "\n# ". LABEL_REQUIRED_VARIABLES. "\n";
			reset($user_bind_var);
			while (list($var,$val) = each($user_bind_var)) {
				if (!empty($val)) {
					$new_contents .= "\$user_bind_var[\"$var\"] = 1;\n";
				}
			}
		}

		$new_contents .= "?".">\n";

# Make a backup
# -------------
		copy ("$var_file", "$var_file.bak.$ext");

# and write new contents
# ----------------------
		$fd = fopen ($var_file, "w");
		if (!$fd) {
			msgForm (str_replace("{FILE}", $var_file, ERROR_OPEN_FILE), $WA_SELF, 'back');
			exit;
		}
		fputs ($fd, $new_contents);
		fclose ($fd);

	}

	if (file_exists ($var_file)) {
		include "$var_file";
		$form_title = '<em>' . LABEL_FILE_EDITING . ": $var_file </em>";
	} else {
		$form_title = "<em>" . LABEL_NEW_FILE_EDITING . " $var_file </em>";
		copy ("$tmpl_dir/admin/user_fields.$ext", "$var_file");
		include "$var_file";
	}

	display_header ($page_title);
?>
<script language="JavaScript" type="text/javascript">

function deleteField(n){
  f = document.forms[0];
  ok=window.confirm("<?php echo LABEL_CONFIRM_DELETE_FIELD?>: "+n);
  if(ok){
	f.delfield.value = n;
    f.submit();
  }
}

function addField(){
  f = document.forms[0];
  if (f.new_var.value.length==0) {
    alert ("<?php echo ERROR_UNDEFINED_VARNAME?>");
	f.new_var.focus();
	return false;
  }
  for (i = 0; i < f.elements.length; i++) {
    if ( (f.elements[i].name == 'user_var_size['+f.new_var.value+']') ) {
      alert ("<?php echo ERROR_VARNAME_ALREADY_DEFINED?>");
	  f.new_var.focus();
	  return false;
    }
  }
  if (f.new_size.value.length==0) {
    alert ("<?php echo ERROR_UNDEFINED_VARSIZE?>");
	f.new_size.focus();
	return false;
  }

  f.submit();
}
</script>
<?php
	echo $page_info;
	beginForm();
	table_header ($form_title);
	hiddenField ('var_file', $var_file);
	hiddenField ('delfield', '');
	hiddenField ('save', '1');
?>
  <TABLE align="center" border=1 cellspacing=0 cellpadding=5>
   <TR bgcolor=white>
    <TD width="55%" align="center" class="label"><?php echo LABEL_NAME ?></TD>
	<TD width="15%" align="right" class="label"><?php echo LABEL_SIZE?></TD>
	<TD width="15%" align="center" class="label"><?php echo LABEL_REQUIRED ?></TD>
	<TD width="15%" class="label"><?php echo LABEL_DELETE_FIELD?></TD>
   </TR>
<?php
	$wa_user_var = array (
		"unixdate" => 1,		// timestamp (registration date)
		"userid" => 1,		// login
		"password" => 1,		// password
		"userpriv" => 1,		// privilege : user, moderator, admin, root
		"totallogins" => 1,	// number of logins
		"lastlogin" => 1,	// last login (date/time in seconds)
		"totalposts" => 1,	// number of contributions (all forums)
		"lastpost" => 1,		// last post (date/time in seconds)
		"lastforumpost" => 1,	// forum where the last post was made
		"username" => 1,		// Name + firstname
		"useraddress" => 1,	// email
	);

	// fields managed by w-agora (can't be edited)
	reset ($wa_user_var);
	while (list($var) = each ($wa_user_var) ) {
		printf ("<tr><td align='center' class=label>%s</td>", $var);
		printf ("<td align='right' class=label>%s</td>", $user_var_size[$var]);
		printf ("<td align='center' class=label>%s</td>", ($user_bind_var[$var] == 1) ? "X" : '&nbsp;');
		echo "<td>&nbsp;</td></tr>\n";
	}

	// user fields (editable)
	$db_count = count ($user_var);
	for ($i=0; $i < $db_count; $i++) {
		$var = $user_var[$i];
		hiddenField ("user_var[$i]", $var);
		if (isset($wa_user_var[$var])) {
			hiddenField ("user_bind_var[$var]", $user_bind_var[$var]);
			hiddenField ("user_var_size[$var]", $user_var_size[$var]);
		} else {
			printf ('<tr><td align="center" class="label">%s</td>', $var);
			$sz = $user_var_size[$var];
			echo '</td><td align="right" class="label">';
			textField ("user_var_size[$var]", $sz, 5);
			echo '</td><td align="center" class="label">';
			checkBox ("user_bind_var[$var]", "1", $user_bind_var[$var]);
			echo '</td><td align="center" class="label"><a href="';
			echo "$WA_SELF?var_file=$var_file&delfield=$var&save=1";
			echo "\"  onclick=\"deleteField('$var'); return false;\"><img src=\"$icon_dir/delete.gif\" align=\"absmiddle\" border=0 alt=\"" . sprintf (ALT_DELETE_FIELD, $var). "\"></A></td></tr>";
		}
	}
?>
   <TR bgcolor="#d0dae6">
    <TD align="center"><INPUT NAME="new_var"></TD>
    <TD align="right"><INPUT SIZE=5 NAME="new_size"></TD>
    <TD align="center"><INPUT TYPE="checkbox" NAME="new_bind_var"></TD>
	<TD align="center" class="label">
      <a href="#" onclick="addField(); return false;"><img src="<?php echo "$icon_dir/expand.gif"?>" align="absmiddle" border=0 alt="<?php echo ALT_ADD_FIELD?>"></A>
    </TD>
   </TR>
   <TR>
    <TD colspan=7 align="center">
	 <HR noshade color="black" width="90%">
<?php
	submitButton('save', LABEL_SAVE);
	resetButton ('reset', LABEL_RESET);
	submitButton ('undo', LABEL_UNDO);
	echo '</TD></TR></TABLE>';

	table_footer();
	endForm();
?>
