<?php

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: edittemplate.php,v 1.12 2005/12/31 09:43:34 mdruilhe Exp $
 *	Usage:		Edit template for generated documents
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

	require ("init_admin.inc");

# Only a site administrator can edit layout
# -----------------------------------------
	if ($auth->level < ADMIN) {
		MsgForm (ERROR_NO_ADMIN, "admin_site.$ext?site=$site&force_login=1", "", "_top");
		echo "</body></html>";
		exit;
	}

# reads configuration
# -------------------
	require ("$site_cfg_file");
	require_once ("$cfg_file");

# set pathname of file to be edited : if variable $bn_xxx is empty then set path to default
# -----------------------------------------------------------------------------------------
	$page_title = TITLE_EDITING_TEMPLATE;
	$page_info = '';
	if ($editdefault==1) {
		$var_file = "$bn_dir_default/template.$ext";
		$page_info = WARNING_EDITING_DEFAULT;
	} elseif (empty ($bn_template) ) {
		if ($editsite==1) {
			$var_file="$bn_dir/template.$ext"; // default file for site listing
		} else {
			$var_file = "$bn_dir_default/template.$ext";
			$page_info = WARNING_EDITING_DEFAULT;
			if (!empty($bn) ) {
				$page_info .= "<br>" . sprintf(LABEL_SPECIFIC_TEMPLATE, "editconf.$ext?site=$site&bn=$bn&mode=advanced#include");
			}
		}
	} else {
		$var_file="$bn_dir/$bn_template";
	}

# Save file if submit has been sent
# ---------------------------------
	if (isset($_POST['save'])) {
		$conf = new Config;
		$ret = $conf->open($var_file);
		if (!$ret) {
			die (str_replace("{FILE}", $var_file, ERROR_OPEN_FILE));
		}
		$conf->writeString ("bn_doc_type", strip_magic_quotes($_POST['bn_doc_type']));
		$conf->writeString ("bn_doc_var", strip_magic_quotes($_POST['bn_doc_var']));
		$conf->close();

# Else : Restore file if UNDO has been requested
# ---------------------------------------
	} elseif (isset($undo)) {
		if (file_exists ("$var_file.bak.$ext"))
			Copy ("$var_file.bak.$ext", "$var_file");
	}

# Now reads the file (PHP variables)
# ----------------------------------
	if (file_exists ($var_file)) {
		include "$var_file";
		$form_title = LABEL_FILE_EDITING . ": $var_file";
	} else {
		if (file_exists ("$bn_dir_default/template.$ext")) {
			@copy ("$bn_dir_default/template.$ext", "$var_file");
			include "$var_file";
		}
		$form_title = LABEL_NEW_FILE_EDITING . ": $var_file";
	}

# Formats the editable fields (converts PHP variables to Template variables)
# --------------------------------------------------------------------------
	$bn_doc_var = ereg_replace("\\$"."([a-zA-Z0-9_]+)", "{\\1}", $bn_doc_var);

# Displays the FORM
# -----------------
	display_header ($page_title);
	echo "<center>$page_info</center><br>";
	table_header ($form_title);
	beginForm();
	hiddenField ('editdefault', $editdefault);
	
	echo "<span class=label>";
	echo LABEL_DEFINE_DOCUMENT_GENERATION . "<br>&nbsp;";
	radioButton ("bn_doc_type", "static", $bn_doc_type, LABEL_STATIC);
	echo "<br>&nbsp;";
	radioButton ("bn_doc_type", "dynamic", $bn_doc_type, LABEL_ONTHEFLY);
	echo "<br>&nbsp;";
	radioButton ("bn_doc_type", "none", $bn_doc_type, LABEL_NO_DOCUMENTS);
	echo "<br>";

	echo "<CENTER><B>" . LABEL_EDIT_TEMPLATE . "</B><BR>";
	textArea ("bn_doc_var", HtmlSpecialChars($bn_doc_var), 25, 80);
	br();
	submitButton ("save", LABEL_SAVE);
	resetButton ("reset", LABEL_RESET);
	submitButton ("undo", LABEL_UNDO);
	print "</CENTER>";
	echo "</span>";
	endForm();
	table_footer();

?>
