<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: delete_forum.php,v 1.14 2002/10/02 23:08:53 mdruilhe Exp $
 *	Usage:		Remove a forum
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

if (isset($remove_site) ) {
	$cfg_file = "${cfg_dir}/${bn}.${ext}";
} else {
	include ("init_admin.inc");
	display_header (TITLE_DELETE_FORUM);
}

# --------------------------------------------------
# check if this user is authorized to delete a forum
# --------------------------------------------------
if ($auth->level < ADMIN) {
	msgForm (ERROR_MUST_BE_ADMIN_TO_REMOVE_FORUM, "admin_site.$ext?site=$site&force_login=1", '', '_top');
	die ('</body></html>');
}

# ------------------------------------------------
# list forums if none has been selected, then exit
# ------------------------------------------------
if (empty($bn)) {
	include "$site_cfg_file";
	$forums = $db->listForums ($site);
	if (is_array($forums)) {
		list_forums ($forums, sprintf (LABEL_CHOOSE_FORUM_TO_DELETE, $site) );
	} else {
		msgForm ( sprintf (ERROR_NO_AVAILABLE_FORUM, $site), "admin_site.${ext}?site=$site", '', '_top');
	}
	exit;
}

# -----------------------------------------
# a forum has been selected => get this forum
# -----------------------------------------
$forum = $db->getForum($site, $bn);
if (!is_array($forum)) {
	msgForm (sprintf (ERROR_FORUM_DOESNT_EXIST, $bn), "$WA_SELF?site=$site", 'back');
	die ('</body></html>');
}

# ---------------------------------------------
# FORM has been submitted -> delete this forum
# ---------------------------------------------

if (isset($do_delete)) {

# drop table / delete DBM file for this forum
# -------------------------------------------
	$ret = $db->deleteForum ($site, $bn);
	if ($ret < 0) {
		msgForm (sprintf (ERROR_CANT_REMOVE_FORUM, $bn, $site), "$WA_SELF?site=$site", '', '_top');
	}

# check if we can read configuration file because we need to know where all
# files (config, forum directoy, ...) are located
# -------------------------------------------------------------------------
	if (isset($cfg_file) && file_exists ("$cfg_file") ) {

# include config. file for this forum
		include ("$cfg_file");

# Remove notes, attachments, notes directory
# -----------------------------------------
		if (!empty($bn_dir_notes) && is_dir($bn_dir_notes)) {
			$dir = opendir($bn_dir_notes);
			while ( $entry = readdir($dir) ) {
				if ( ($entry != ".") && ($entry != "..") ) {
					 if (is_dir("$bn_dir_notes/$entry")) {
						// remove all files in subdirectory
						$subdir = opendir("$bn_dir_notes/$entry");
						while ( $subentry = readdir($subdir) ) {
							if (is_file ("$bn_dir_notes/$entry/$subentry")) {
								echo LABEL_FILE_REMOVING. " <b>$bn_dir_notes/$entry/$subentry</b><br>";
								unlink ("$bn_dir_notes/$entry/$subentry");
							}
						}
						closedir($subdir);
						echo LABEL_DIRECTORY_REMOVING . "<b>$bn_dir_notes/$entry</b><br>";
						rmdir ("$bn_dir_notes/$entry");
					} else {
						echo LABEL_FILE_REMOVING. " <b>$bn_dir_notes/$entry</b><br>";
						unlink ("$bn_dir_notes/$entry");
					}
				}
			}
			closedir($dir);
			echo LABEL_DIRECTORY_REMOVING . " <b>$bn_dir_notes</b><br>";
			rmdir ("$bn_dir_notes");
		}

# Remove forum directory ($bn_dir)
# --------------------------------
		if (!empty($bn_dir) && is_dir($bn_dir)) {
			$dir = opendir($bn_dir);
			while ( $entry = readdir($dir) ) {
				if ( ($entry != ".") && ($entry != "..") ) {
					echo LABEL_FILE_REMOVING. " <b>$bn_dir/$entry</b><br>";
					unlink ("$bn_dir/$entry");
				}
			}
			closedir($dir);
			echo LABEL_DIRECTORY_REMOVING . " <b>$bn_dir</b><br>";
			rmdir ("$bn_dir");
		}
		
# Remove configuration file
# -------------------------
		echo LABEL_FILE_REMOVING. " <b>$cfg_file</b><br>";
		$rc = @unlink ("$cfg_file");
		$rc = @unlink ("${cfg_file}.bak");		// old backup filename extension
		$rc = @unlink ("${cfg_file}.bak.$ext");
	}

# if called from delete_site => don't display message FORM
# --------------------------------------------------------
	unset($bn);
	if (!$remove_site) {
		
		msgForm (sprintf (LABEL_FORUM_DELETED, $forum_name), "admin.$ext?site=$site", '', '_top');
		die ('</body></html>');
	}
} else {

# -----------------------------------------
# First entry in this script: display FORM
# -----------------------------------------

#  export fields in current scope from $forum and display form
#  ----------------------------------------------------------- 
	extract ($forum);

	beginForm();
	hiddenField ('do_delete', 'do_delete');
	table_header(sprintf(TITLE_DELETE_FORUM_IN_SITE, $forum_name, $site));
?>
 <TABLE BORDER="0" WIDTH="100%">
  <CAPTION><?php echo CAPTION_DELETE_FORUM ?></CAPTION>
  <TR>
   <TD class=label WIDTH="30%" ALIGN="RIGHT" VALIGN="MIDDLE"><?php echo LABEL_FORUM_TITLE ?></TD>
   <TD class=label><strong><font color="blue"><?php echo $bn_title ?></font></strong></TD>
  </TR>
  <TR>
   <TD class=label WIDTH="30%" ALIGN="RIGHT" VALIGN="MIDDLE"><?php echo LABEL_FORUM_DESCR ?></TD>
   <TD class=label><strong><font color="blue"><?php echo $descr ?></font></strong></TD>
  </TR>
  <TR>
   <TD class=label WIDTH="30%" ALIGN="RIGHT" VALIGN="MIDDLE"><?php echo LABEL_FORUM_OWNER ?></TD>
   <TD class=label><strong><font color="blue"><?php echo $owner ?></font></strong></TD>
  </TR>
  <TR>
   <TD class=label WIDTH="30%" ALIGN="RIGHT" VALIGN="MIDDLE"><?php echo LABEL_FORUM_TYPE ?></TD>
   <TD class=label><strong><font color="blue"><?php echo $forum_types[$type]; ?></font></TD>
  </TR>
  <TR>
   <TD class=label WIDTH="30%" ALIGN="RIGHT" VALIGN="MIDDLE"><?php echo LABEL_FORUM_MODER ?></TD>
   <TD class=label><strong><font color="blue"><?php print (($moderated==1) ? LABEL_YES: LABEL_NO); ?></font></strong></TD>
  </TR>
  <TR>
   <TD class=label WIDTH="30%" ALIGN="RIGHT" VALIGN="MIDDLE"><?php echo LABEL_FORUM_STATE ?></TD>
   <TD class=label><strong><font color="blue"><?php echo $forum_states[$state]; ?></font></TD>
  </TR>
 </TABLE>

<?php
	echo '<br><center>';
	submitButton('', LABEL_DELETE_THIS_FORUM);
	backButton('', BUTTON_CANCEL);
	echo '</center>';
	table_footer();
	endForm();
	echo '</BODY></HTML>';
}

?>
