<?php

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: browse_avatar.php,v 1.3 2005/10/18 22:41:39 mdruilhe Exp $
 *	Usage:	Enable users to choose/upload an avatar with their profile
 *	Authors:	Pavel Bandaletov <shveps@dpz.ru>
 *				Laurent Aufrre <laurent.aufrere@free.fr>
 *				Marc Druilhe <mdruilhe@w-agora.net>
 */

	$bn_action="avatar";
	$bn_action_mode="L";
	$popup = $bn_popup = 1;	// for msgForm()
	include "init.inc";

	if (empty($bn) && (empty($site) || $site=='agora') ) {
		die("you must select a forum or a site");
	}

	$upload_file_name = "avatar";
	$form_name = 'register_form';

	if (empty($bn_avatar_dir)) {
		die("$bn_avatar_dir not set");
	}

	if (!$bn_browse_avatar) {
		display_header (LABEL_BROWSE_AVATAR, false);
		msgForm (ERROR_NO_BROWSE_SERVER, "list.$ext", 'close');
		display_footer(false);
		exit;
	}

	$perpage = (int) getFormVar('perpage', 20);
	$first = (int) getFormVar('first', 0);

	function browse_dir ($dir, $start=0, $perpage=20, $perline=4) {
		global $WA_SELF,$site;

		settype ($perpage, 'integer');
		settype ($start, 'integer');

		// fill array which image entries
		$handle = opendir("./$dir");
		if (!$handle) {
			return -2;
		}
		$img_count = 0;
		$images = array();
		while ($entry = readdir($handle)) {
			if ($entry[0] == '.') {
				// skip all hidden directories/files 
				continue;
			} else {
				// Add image to the list
				$image_infos = @getimagesize("./$dir/$entry");
				if(is_array($image_infos)) {
					$image_infos[4] = $entry;
					$images[$img_count] = $image_infos;
					$img_count++;
				}
			}
		}
		closedir ($handle);
		ksort ($images);

		$end = min ($start + $perpage, $img_count);
		$pages = ceil ($img_count/$perpage);
		$page = ceil($end/$perpage);

		if($img_count == 0) {
			msgWarning(LABEL_NO_AVATARS);
		}

		$nav_bar = getNavBar("$WA_SELF?site=$site&perpage=$perpage&dir=$dir", $img_count, $start, $perpage);

		echo "<div class=\"title\">".LABEL_BROWSE_AVATAR."</div>";
		echo "<div class=\"subtitle\"><h3>".LABEL_CLICK_AVATAR."</h3></div>";

		echo "<div class=\"subtitle\">". sprintf(LABEL_IMAGE_SET, $start+1, $end, $img_count)."&nbsp;|&nbsp;".sprintf(PAGE_NUM_OF, $page, $pages)."</div>";

		print $nav_bar;
		print "<table class=\"thumbnail\"><tr>";
		print "<tr><td colspan=\"$perline\" class=\"column\">". LABEL_AVATAR_PER_PAGE . " ". anchor("$WA_SELF?site=$site&first=0&perpage=20&dir=$dir", "", "20"). " | " . anchor("$WA_SELF?site=$site&first=0&perpage=40&dir=$dir", "", "40") . " | " . anchor("$WA_SELF?site=$site&first=0&perpage=60&dir=$dir", "", "60") . "</td></tr>";

		for($i=$start; $i<$end; $i++) {
			list($width, $height, $type, $attr, $fname) = $images[$i];
			list($name, $ext) = explode (".", $fname);
			$reduc = max($width,$height,64)/64;
			$r_width = floor($width/$reduc);
			$r_height = floor($height/$reduc);
			$cell = "<td class=\"thumbcell\"><div class=\"thumbcell\">$name<br />($width x $height)<br /><a href=\"javascript:setAvatar('$dir/$fname')\"><img src=\"$dir/$fname\" id=\"$fname\" alt=\"$fname\" width=\"$r_width\" height=\"$r_height\"></a></div></td>";
			if ((($i-$start) % $perline) == 0) {
				print "</tr><tr>\n";
			}
			echo($cell);
		}
		$colspan = ($perline - (($i-$start)%$perline));
		if($colspan>0) {
			echo "<td colspan=\"$colspan\">&nbsp;</td>";	
		}
		print "</tr>\n</table>";
		print $nav_bar;

		return 0;
	}

	display_header (LABEL_BROWSE_AVATAR, false);
?>
	<script type="text/javascript" language="JavaScript">
		<!-- // Hide for old browsers
		function setAvatar(url) {
			opener.document.<?php echo $form_name?>.picture.value=url;
			opener.document.images.show_picture.src = url;
			window.close();
		}
		// End of script -->
	</script>
<?php

	// Check if a file has been uploaded
	if (!empty($_FILES[$upload_file_name]['name']) && $bn_avatar_upload) {
		require("$inc_dir/avatarupload.$ext");
		$my_uploader = new uploader();
		$my_uploader->max_filesize($max_avatar_size);
		$my_uploader->max_image_size($max_avatar_width, $max_avatar_height);
	    $mode = 2;
		if ($my_uploader->upload($upload_file_name, $acceptable_file_types, $default_extension)) {
			$my_uploader->save_file($bn_avatar_dir, $mode);
		}

		if ($my_uploader->error) {
			msgWarning($my_uploader->error);
		} else {
			if(stristr($my_uploader->file['type'], "image")) {
				echo "<img src=\"" . $bn_avatar_dir ."/". $my_uploader->file['name'] . "\" width=\"64\" height=\"64\" align=\"left\" border=\"1\" />";
				printf (MSG_AVATAR_UPLOADED, $my_uploader->file['name']);
			} else {
				@unlink($bn_avatar_dir ."/". $my_uploader->file['name']);
				msgWarning(sprintf (ERROR_AVATAR_UPLOAD, $my_uploader->file['name']));
			}
		}
	}

	$ret = browse_dir ($bn_avatar_dir, $first, $perpage);

	if ($ret == -2) {
		msgForm (sprintf(ERROR_ACCESS_DIRECTORY, $dir), "$main_page?site=$site", 'close');
		display_footer(false);
		exit;
	}

	if ($bn_avatar_upload) {
		beginForm($WA_SELF, 'post', true);
		hiddenField ("submitted", "true");
		hiddenField ("perpage", $perpage);
		hiddenField ("first", $first);

		echo "<br />".LABEL_UPLOAD_AVATAR."<input name=\"$upload_file_name\" type=\"file\">";
		submitButton ('submit', BUTTON_COPY);

		//Display list of allowed types
		// list of images types allowed (use include/mimetypes.php)
		load_mimetypes();
		$acceptable_file_types = trim(implode('|', array_keys($mime_dspfmt, ATT_DSP_IMG)));
		if (!empty($acceptable_file_types)) {
			print("<br /><br />". LABEL_ALLOWED_MIME_TYPES. "<br /><strong>" . str_replace("|", "</strong> | <strong>", $acceptable_file_types) . "</strong><br />\n");
        }

		endForm();
	}

	echo '<br />' . getButton ('cancel', BUTTON_CANCEL, 'window.close();');
	
	display_footer(false);
?>