<!DOCTYPE html>
<!--
Copyright (C) 2014 Everton

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<html>
    <head>
        <meta charset="UTF-8">
        <title>i81n :: Library for translation</title>
    </head>
    <body>
        <h1>i81n :: Gettext translation without gettext</h1>
        <p>i81n (whose name was inspired by the term i18n) is written in PHP for translation of pa'ginas and systems without the reliance on PHP extensions like gettext, eg class.</p>
        <h2>Installation</h2>
        <p>The installation for use only with the translation (without the parser) depends only on the inclusion of i81n.php file and setting the directory where translations are (default is "./locale").</p>
        <p>The "locale" directory (or other you want to specify) stores the translation files. For each language, there should be a subdirectory "locale" with the abbreviation of the language (en, en_US, for example). Within these subdirectories are the translation files generated by the parser.</p>
        <p>To change the directory "locale" to another, in the instance of i81n class that is created, use the setLocaleDir () method.</p>
        <h2>Use</h2>
        <p>The use is based on the creation of an instance of the class and i81n language setting to be used by setlang () method.</p>
        <p>Use the translate () method for the translation of messages (see sample files).</p>
        <p>You can also create alias for the method i81n :: translate (), is extending the i81n class or creating a function (you can even create a gettext function, for example).</p>
        <h2>Creating translations for your PHP files</h2>
        <p>i81n has a parser to extract the texts to be translated (which we call messages) straight from the pages of your application.</p>
        <p>Basically, the process follows these steps:</p>
        <ol>
            <li>Configuration INI file with the parameters of the parser (see parser_config_example.ini);</li>
            <li>Implementation of parser.bat file as argument stating the path to the INI configuration file;</li>
            <li>parser.bat runs parser.php file, which actually only serves to run the i81n :: parseDir () static method. You can create other ways of running the parser proque all the work is done by :: parseDir () method i81n.</li>
            <li>The parseDir :: i81n () method reads the parameters of the INI file and search the files of your application for the messages to be translated and placed them all in INI files in subdirectory "locale" for the language of your application;</li>
            <li>After that, just make copies of the translation INI files, one for each language (in separate subdirectories) and perform the translation of messages saved them.</li>
        </ol>
        <h2>The translation files</h2>
        <p>INI files translation are separated into sections where each section corresponds to the sha1 hash of the original message found in the files of your application. It is for this that the hash method i81n :: translate () finds the message to use.</p>
        <p>In each section, there are two parameters:</p>
        <ul>
            <li>omsg: the original message, used only as a reference to the time of the translation of messages in INI files.</li>
            <li>tmsg: the translated message that will be returned by the method i81n :: translate ().</li>
        </ul>
        <h2>Important Tips</h2>
        <p>Always use static, independent variables to messages that the translation is done correctly.</p>
        <p>Remember that any change in the messages, however small, will require a new implementation of the parser, and new manual translations.</p>
        <p>Before running the parser, backup INI files for translation.</p>
        <p>The examples are in example.php subdir_test files and directory.</p>
    </body>
</html>
