﻿using System;
using System.Configuration;
using System.IO;
using System.Web;

namespace AddRemoveRowDynamicallyUsingJQuery
{
    /// <summary>
    /// Summary description for FileUploadHandler
    /// </summary>
    public class FileUploadHandler : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            try
            {
                context.Response.ContentType = "text/plain";
                string tempPath = ConfigurationManager.AppSettings["FolderPath"];
                string pathSave = context.Server.MapPath(tempPath);
                if (!Directory.Exists(pathSave))
                {
                    try
                    {
                        Directory.CreateDirectory(pathSave);
                    }
                    catch { }
                }
                for (int i = 0; i < context.Request.Files.Count; i++)
                {
                    HttpPostedFile objHttpPostedFile = (HttpPostedFile)context.Request.Files[i];
                    string fileName = objHttpPostedFile.FileName;
                    int index = fileName.LastIndexOf("\\");
                    if (index != -1)
                        fileName = fileName.Substring(index, fileName.Length - index);
                    else
                        fileName = "\\" + fileName;
                    objHttpPostedFile.SaveAs(string.Concat(pathSave, fileName));
                    if (i == context.Request.Files.Count - 1)
                    {
                        context.Response.Write("Files uploaded successfully!");
                    }
                }
            }
            catch (Exception ex)
            {
                context.Response.Write("Error: " + ex.Message);
            }
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}