#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using SharpDom.Attributes;
using SharpDom.Navigation;

namespace SharpDom.Tags
{
    /// <summary>Implementation of style tag</summary>
    [Parentship(typeof(ITagStyleChild))]
    [Adoptability(typeof(ITagStyleAdoptability))]
    public class TagStyle : IndexedTag
    {
        /// <summary>Default constructor assigning the tag name</summary>
        public TagStyle() : base("style") { }

        public virtual AttrId Id { get { return GetAttr<AttrId>(); } set { SetAttr(value); } }
        public virtual AttrType Type { get { return GetAttr<AttrType>(); } set { SetAttr(value); } }
        public virtual AttrMedia Media { get { return GetAttr<AttrMedia>(); } set { SetAttr(value); } }
        public virtual AttrTitle Title { get { return GetAttr<AttrTitle>(); } set { SetAttr(value); } }
        public virtual AttrXmlSpace XmlSpace { get { return GetAttr<AttrXmlSpace>(); } set { SetAttr(value); } }
        public virtual AttrLang Lang { get { return GetAttr<AttrLang>(); } set { SetAttr(value); } }
        public virtual AttrXmlLang XmlLang { get { return GetAttr<AttrXmlLang>(); } set { SetAttr(value); } }
        public virtual AttrDir Dir { get { return GetAttr<AttrDir>(); } set { SetAttr(value); } }

        /// <summary>Assigns all needed attributes to the tag</summary>
        /// <returns>This instance downcasted to base class</returns>
        public virtual IndexedTag attr(
            AttrId id = null,
            AttrType type = null,
            AttrMedia media = null,
            AttrTitle title = null,
            AttrXmlSpace xmlspace = null,
            AttrLang lang = null,
            AttrXmlLang xmllang = null,
            AttrDir dir = null
        )
        {
            Id = id;
            Type = type;
            Media = media;
            Title = title;
            XmlSpace = xmlspace;
            Lang = lang;
            XmlLang = xmllang;
            Dir = dir;

            return this;
        }
    }
}
