#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using SharpDom.Attributes;
using SharpDom.Navigation;

namespace SharpDom.Tags
{
    /// <summary>Implementation of meta tag</summary>
    [Parentship(typeof(ITagMetaChild))]
    [Adoptability(typeof(ITagMetaAdoptability))]
    public class TagMeta : IndexedTag
    {
        /// <summary>Default constructor assigning the tag name</summary>
        public TagMeta() : base("meta") { }

        public virtual AttrId Id { get { return GetAttr<AttrId>(); } set { SetAttr(value); } }
        public virtual AttrHttpEquiv HttpEquiv { get { return GetAttr<AttrHttpEquiv>(); } set { SetAttr(value); } }
        public virtual AttrName Name { get { return GetAttr<AttrName>(); } set { SetAttr(value); } }
        public virtual AttrContent Content { get { return GetAttr<AttrContent>(); } set { SetAttr(value); } }
        public virtual AttrScheme Scheme { get { return GetAttr<AttrScheme>(); } set { SetAttr(value); } }
        public virtual AttrLang Lang { get { return GetAttr<AttrLang>(); } set { SetAttr(value); } }
        public virtual AttrXmlLang XmlLang { get { return GetAttr<AttrXmlLang>(); } set { SetAttr(value); } }
        public virtual AttrDir Dir { get { return GetAttr<AttrDir>(); } set { SetAttr(value); } }

        /// <summary>Assigns all needed attributes to the tag</summary>
        /// <returns>This instance downcasted to base class</returns>
        public virtual IndexedTag attr(
            AttrId id = null,
            AttrHttpEquiv httpequiv = null,
            AttrName name = null,
            AttrContent content = null,
            AttrScheme scheme = null,
            AttrLang lang = null,
            AttrXmlLang xmllang = null,
            AttrDir dir = null
        )
        {
            Id = id;
            HttpEquiv = httpequiv;
            Name = name;
            Content = content;
            Scheme = scheme;
            Lang = lang;
            XmlLang = xmllang;
            Dir = dir;

            return this;
        }
    }
}
