#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using SharpDom.Attributes;
using SharpDom.Navigation;

namespace SharpDom.Tags
{
    /// <summary>Implementation of frameset tag</summary>
    [Parentship(typeof(ITagFrameSetChild))]
    [Adoptability(typeof(ITagFrameSetAdoptability))]
    public class TagFrameSet : IndexedTag
    {
        /// <summary>Default constructor assigning the tag name</summary>
        public TagFrameSet() : base("frameset") { }

        public virtual AttrId Id { get { return GetAttr<AttrId>(); } set { SetAttr(value); } }
        public virtual AttrCssClass CssClass { get { return GetAttr<AttrCssClass>(); } set { SetAttr(value); } }
        public virtual AttrStyle Style { get { return GetAttr<AttrStyle>(); } set { SetAttr(value); } }
        public virtual AttrTitle Title { get { return GetAttr<AttrTitle>(); } set { SetAttr(value); } }
        public virtual AttrRows Rows { get { return GetAttr<AttrRows>(); } set { SetAttr(value); } }
        public virtual AttrCols Cols { get { return GetAttr<AttrCols>(); } set { SetAttr(value); } }
        public virtual AttrOnUnload OnUnload { get { return GetAttr<AttrOnUnload>(); } set { SetAttr(value); } }
        public virtual AttrOnLoad OnLoad { get { return GetAttr<AttrOnLoad>(); } set { SetAttr(value); } }

        /// <summary>Assigns all needed attributes to the tag</summary>
        /// <returns>This instance downcasted to base class</returns>
        public virtual IndexedTag attr(
            AttrRows rows = null,
            AttrCols cols = null,
            AttrId id = null,
            AttrCssClass cssclass = null,
            AttrStyle style = null,
            AttrTitle title = null,
            AttrOnUnload onunload = null,
            AttrOnLoad onload = null
        )
        {
            Rows = rows;
            Cols = cols;
            Id = id;
            CssClass = cssclass;
            Style = style;
            Title = title;
            OnUnload = onunload;
            OnLoad = onload;

            return this;
        }
    }
}
