#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using SharpDom.Attributes;
using SharpDom.Navigation;

namespace SharpDom.Tags
{
    /// <summary>Implementation of area tag</summary>
    [Parentship(typeof(ITagAreaChild))]
    [Adoptability(typeof(ITagAreaAdoptability))]
    public class TagArea : IndexedTag
    {
        /// <summary>Default constructor assigning the tag name</summary>
        public TagArea() : base("area") { }

        public virtual AttrShape Shape { get { return GetAttr<AttrShape>(); } set { SetAttr(value); } }
        public virtual AttrCoords Coords { get { return GetAttr<AttrCoords>(); } set { SetAttr(value); } }
        public virtual AttrHref Href { get { return GetAttr<AttrHref>(); } set { SetAttr(value); } }
        public virtual AttrNoHref NoHref { get { return GetAttr<AttrNoHref>(); } set { SetAttr(value); } }
        public virtual AttrAlt Alt { get { return GetAttr<AttrAlt>(); } set { SetAttr(value); } }
        public virtual AttrId Id { get { return GetAttr<AttrId>(); } set { SetAttr(value); } }
        public virtual AttrCssClass CssClass { get { return GetAttr<AttrCssClass>(); } set { SetAttr(value); } }
        public virtual AttrStyle Style { get { return GetAttr<AttrStyle>(); } set { SetAttr(value); } }
        public virtual AttrTitle Title { get { return GetAttr<AttrTitle>(); } set { SetAttr(value); } }
        public virtual AttrLang Lang { get { return GetAttr<AttrLang>(); } set { SetAttr(value); } }
        public virtual AttrXmlLang XmlLang { get { return GetAttr<AttrXmlLang>(); } set { SetAttr(value); } }
        public virtual AttrDir Dir { get { return GetAttr<AttrDir>(); } set { SetAttr(value); } }
        public virtual AttrOnClick OnClick { get { return GetAttr<AttrOnClick>(); } set { SetAttr(value); } }
        public virtual AttrOnDblClick OnDblClick { get { return GetAttr<AttrOnDblClick>(); } set { SetAttr(value); } }
        public virtual AttrOnMouseDown OnMouseDown { get { return GetAttr<AttrOnMouseDown>(); } set { SetAttr(value); } }
        public virtual AttrOnMouseUp OnMouseUp { get { return GetAttr<AttrOnMouseUp>(); } set { SetAttr(value); } }
        public virtual AttrOnMouseOver OnMouseOver { get { return GetAttr<AttrOnMouseOver>(); } set { SetAttr(value); } }
        public virtual AttrOnMouseMove OnMouseMove { get { return GetAttr<AttrOnMouseMove>(); } set { SetAttr(value); } }
        public virtual AttrOnMouseOut OnMouseOut { get { return GetAttr<AttrOnMouseOut>(); } set { SetAttr(value); } }
        public virtual AttrOnKeyPress OnKeyPress { get { return GetAttr<AttrOnKeyPress>(); } set { SetAttr(value); } }
        public virtual AttrOnKeyDown OnKeyDown { get { return GetAttr<AttrOnKeyDown>(); } set { SetAttr(value); } }
        public virtual AttrOnKeyUp OnKeyUp { get { return GetAttr<AttrOnKeyUp>(); } set { SetAttr(value); } }
        public virtual AttrAccessKey AccessKey { get { return GetAttr<AttrAccessKey>(); } set { SetAttr(value); } }
        public virtual AttrTabIndex TabIndex { get { return GetAttr<AttrTabIndex>(); } set { SetAttr(value); } }
        public virtual AttrOnFocus OnFocus { get { return GetAttr<AttrOnFocus>(); } set { SetAttr(value); } }
        public virtual AttrOnBlur OnBlur { get { return GetAttr<AttrOnBlur>(); } set { SetAttr(value); } }

        /// <summary>Assigns all needed attributes to the tag</summary>
        /// <returns>This instance downcasted to base class</returns>
        public virtual IndexedTag attr(
            AttrShape shape = null,
            AttrCoords coords = null,
            AttrHref href = null,
            AttrNoHref nohref = null,
            AttrAlt alt = null,
            AttrId id = null,
            AttrCssClass cssclass = null,
            AttrStyle style = null,
            AttrTitle title = null,
            AttrLang lang = null,
            AttrXmlLang xmllang = null,
            AttrDir dir = null,
            AttrOnClick onclick = null,
            AttrOnDblClick ondblclick = null,
            AttrOnMouseDown onmousedown = null,
            AttrOnMouseUp onmouseup = null,
            AttrOnMouseOver onmouseover = null,
            AttrOnMouseMove onmousemove = null,
            AttrOnMouseOut onmouseout = null,
            AttrOnKeyPress onkeypress = null,
            AttrOnKeyDown onkeydown = null,
            AttrOnKeyUp onkeyup = null,
            AttrAccessKey accesskey = null,
            AttrTabIndex tabindex = null,
            AttrOnFocus onfocus = null,
            AttrOnBlur onblur = null
        )
        {
            Shape = shape;
            Coords = coords;
            Href = href;
            NoHref = nohref;
            Alt = alt;
            Id = id;
            CssClass = cssclass;
            Style = style;
            Title = title;
            Lang = lang;
            XmlLang = xmllang;
            Dir = dir;
            OnClick = onclick;
            OnDblClick = ondblclick;
            OnMouseDown = onmousedown;
            OnMouseUp = onmouseup;
            OnMouseOver = onmouseover;
            OnMouseMove = onmousemove;
            OnMouseOut = onmouseout;
            OnKeyPress = onkeypress;
            OnKeyDown = onkeydown;
            OnKeyUp = onkeyup;
            AccessKey = accesskey;
            TabIndex = tabindex;
            OnFocus = onfocus;
            OnBlur = onblur;

            return this;
        }
    }
}
