#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using SharpDom.Tags;

namespace SharpDom
{
    /// <summary>Class used for building HTML content</summary>
    /// <remarks>It includes all tags and all atributes.</remarks>
    public abstract partial class AbstractBuilder
    {
        // all HTML tags
        public virtual TagHtml html { get { return new TagHtml(); } }
        public virtual TagHead head { get { return new TagHead(); } }
        public virtual TagTitle title { get { return new TagTitle(); } }
        public virtual TagBase basetag { get { return new TagBase(); } }
        public virtual TagMeta meta { get { return new TagMeta(); } }
        public virtual TagLink link { get { return new TagLink(); } }
        public virtual TagStyle style { get { return new TagStyle(); } }
        public virtual TagScript script { get { return new TagScript(); } }
        public virtual TagNoScript noscript { get { return new TagNoScript(); } }
        public virtual TagBody body { get { return new TagBody(); } }
        public virtual TagDiv div { get { return new TagDiv(); } }
        public virtual TagP p { get { return new TagP(); } }
        public virtual TagH1 h1 { get { return new TagH1(); } }
        public virtual TagH2 h2 { get { return new TagH2(); } }
        public virtual TagH3 h3 { get { return new TagH3(); } }
        public virtual TagH4 h4 { get { return new TagH4(); } }
        public virtual TagH5 h5 { get { return new TagH5(); } }
        public virtual TagH6 h6 { get { return new TagH6(); } }
        public virtual TagUl ul { get { return new TagUl(); } }
        public virtual TagOl ol { get { return new TagOl(); } }
        public virtual TagLi li { get { return new TagLi(); } }
        public virtual TagDl dl { get { return new TagDl(); } }
        public virtual TagDt dt { get { return new TagDt(); } }
        public virtual TagDd dd { get { return new TagDd(); } }
        public virtual TagAddress address { get { return new TagAddress(); } }
        public virtual TagHr hr { get { return new TagHr(); } }
        public virtual TagPre pre { get { return new TagPre(); } }
        public virtual TagBlockQuote blockquote { get { return new TagBlockQuote(); } }
        public virtual TagIns ins { get { return new TagIns(); } }
        public virtual TagDel del { get { return new TagDel(); } }
        public virtual TagA a { get { return new TagA(); } }
        public virtual TagSpan span { get { return new TagSpan(); } }
        public virtual TagBdo bdo { get { return new TagBdo(); } }
        public virtual TagBr br { get { return new TagBr(); } }
        public virtual TagEm em { get { return new TagEm(); } }
        public virtual TagStrong strong { get { return new TagStrong(); } }
        public virtual TagDfn dfn { get { return new TagDfn(); } }
        public virtual TagCode code { get { return new TagCode(); } }
        public virtual TagSamp samp { get { return new TagSamp(); } }
        public virtual TagKbd kbd { get { return new TagKbd(); } }
        public virtual TagVar var { get { return new TagVar(); } }
        public virtual TagCite cite { get { return new TagCite(); } }
        public virtual TagAbbr abbr { get { return new TagAbbr(); } }
        public virtual TagAcronym acronym { get { return new TagAcronym(); } }
        public virtual TagQ q { get { return new TagQ(); } }
        public virtual TagSub sub { get { return new TagSub(); } }
        public virtual TagSup sup { get { return new TagSup(); } }
        public virtual TagTt tt { get { return new TagTt(); } }
        public virtual TagI i { get { return new TagI(); } }
        public virtual TagB b { get { return new TagB(); } }
        public virtual TagBig big { get { return new TagBig(); } }
        public virtual TagSmall small { get { return new TagSmall(); } }
        public virtual TagObject objecttag { get { return new TagObject(); } }
        public virtual TagParam param { get { return new TagParam(); } }
        public virtual TagImg img { get { return new TagImg(); } }
        public virtual TagMap map { get { return new TagMap(); } }
        public virtual TagArea area { get { return new TagArea(); } }
        public virtual TagForm form { get { return new TagForm(); } }
        public virtual TagLabel label { get { return new TagLabel(); } }
        public virtual TagInput input { get { return new TagInput(); } }
        public virtual TagSelect select { get { return new TagSelect(); } }
        public virtual TagOptGroup optgroup { get { return new TagOptGroup(); } }
        public virtual TagOption option { get { return new TagOption(); } }
        public virtual TagTextArea textarea { get { return new TagTextArea(); } }
        public virtual TagFieldSet fieldset { get { return new TagFieldSet(); } }
        public virtual TagLegend legend { get { return new TagLegend(); } }
        public virtual TagButton button { get { return new TagButton(); } }
        public virtual TagTable table { get { return new TagTable(); } }
        public virtual TagCaption caption { get { return new TagCaption(); } }
        public virtual TagThead thead { get { return new TagThead(); } }
        public virtual TagTfoot tfoot { get { return new TagTfoot(); } }
        public virtual TagTbody tbody { get { return new TagTbody(); } }
        public virtual TagColGroup colgroup { get { return new TagColGroup(); } }
        public virtual TagCol col { get { return new TagCol(); } }
        public virtual TagTr tr { get { return new TagTr(); } }
        public virtual TagTh th { get { return new TagTh(); } }
        public virtual TagTd td { get { return new TagTd(); } }
        public virtual TagNoFrames noframes { get { return new TagNoFrames(); } }
        public virtual TagIFrame iframe { get { return new TagIFrame(); } }
        public virtual TagFrame frame { get { return new TagFrame(); } }
        public virtual TagFrameSet frameset { get { return new TagFrameSet(); } }

        public virtual TagCustom custom(string name) { return new TagCustom(name); }
    }
}
