#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion
using MvcAppSample.Views.Shared;
using SharpDom;
using SharpDom.Mvc;

namespace MvcAppSample.Views
{
    /// <summary>
    /// This is base class for all content pages in our project. We don't really need it but it reduces amount of common code
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public abstract class BasePage<T> : SharpDomView<T>
    {
        public BasePage()
        {
            CurrentDoctype = Doctype.XHTML10Strict;//this is doctype for all pages in our project
        }
        // linking master page and attaching specifc content to it's placeholders
        public ContainerTag ReusableCreateTagTree(ContainerTag container, PlaceHolderDelegate titleContent, PlaceHolderDelegate mainContent)
        {
            return

                // SEE HERE ! - example how to create master page
                CreateBuilder<SiteMaster>()
                // SEE HERE ! - example how to attach specifc content to master page's placeholders
                .Attach<SiteMaster>(b => b.TitleContent = titleContent)
                .Attach<SiteMaster>(b => b.MainContent = mainContent)

                // just call master page method to generate combined content 
                .CreateTags(Model);
        }
    }
}