﻿#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc.Html;
using MvcAppSample.Models;
using MvcAppSample.Views.Shared;
using SharpDom;
using SharpDom.Mvc;

namespace MvcAppSample.Views.Account
{
    public class LogOn : BasePage<LogOnModel>
    {
            public virtual ContainerTag TitleContent(ContainerTag container)
            {
                return container
                [
                    "Log On"
                ];
            }

            public virtual ContainerTag MainContent(ContainerTag container)
            {
                return container
                [
                    h2["Log On"],
                    p[
                        "Please enter your username and password. ",
                        Html.ActionLink("Register", "Register").ToLiteral(),
                        " if you don't have an account."
                    ],

                    form.attr(action:Url.Action("LogOn"), method:"POST")[
                        Html.ValidationSummary(true, "Login was unsuccessful. Please correct the errors and try again.").ToLiteral(),
                        div[
                            fieldset[
                                legend["Account Information"],
                                
                                div.attr(cssclass:"editor-label")[
                                    Html.LabelFor(m => m.UserName).ToLiteral()
                                ],
                                div.attr(cssclass:"editor-field")[
                                    Html.TextBoxFor(m => m.UserName).ToLiteral(),
                                    Html.ValidationMessageFor(m => m.UserName).ToLiteral()
                                ],
                                
                                div.attr(cssclass:"editor-label")[
                                    Html.LabelFor(m => m.Password).ToLiteral()
                                ],
                                div.attr(cssclass:"editor-field")[
                                    Html.PasswordFor(m => m.Password).ToLiteral(),
                                    Html.ValidationMessageFor(m => m.Password).ToLiteral()
                                ],
                                
                                div.attr(cssclass:"editor-label")[
                                    Html.CheckBoxFor(m => m.RememberMe).ToLiteral(),
                                    Html.LabelFor(m => m.RememberMe).ToLiteral()
                                ],
                                
                                p[
                                    input.attr(type:"submit", value:"Log On")
                                ]
                            ]
                        ]
                    ]
                ];
            }

            public override ContainerTag CreateTagTree(ContainerTag container)
            {
                return ReusableCreateTagTree(container, TitleContent, MainContent);
            }
    }
}








