#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using System;
using System.IO;
using SharpDom;

namespace ConsoleSample
{
    /// <summary>
    /// This sample demonstrates how to assign attributes to the tags.
    /// For it, just call attr method and supply needed attributes to it.
    /// Please, notice - you can supply only needed attributes
    /// (optional/named parameters of C# 4.0 are used in background).
    /// Also it is possible to use custom  and custom attributes
    /// (not HTML compliant) in your code.
    /// </summary>
    public class Sample2Attributes
    {
        public static void Run()
        {
            // initially we prepare view model
            var model = new ViewModel
            {
                Title = "Page Title",
                Message = "Hello World !!!"
            };

            // then we create page builder
            var pageBuilder = new PageBuilder();
            var writer = new StringWriter();

            // then we supply the page builder with the model
            pageBuilder.Render(model, writer);

            // finally we show generated HTML code
            Console.WriteLine(writer.ToString());
            Console.ReadKey();
        }

        // ----- Model and Builder of the Page -----

        /// <summary>Modifed view model contains this time a new field</summary>
        public class ViewModel
        {
            public string Title { get; set; }
            public string Message { get; set; }
        }

        /// <summary>Now HTML layout is not so simple but still quite static.</summary>
        public class PageBuilder : HtmlPageBuilder<ViewModel>
        {
            /// <summary>Again - this methods should be overriden in all page builders.
            /// It should contain real HTML layout expressed in terms of C# language.</summary>
            /// <param name="container">The container inside which new HTML layout should be placed.</param>
            /// <returns>The same container tag as incoming one</returns>
            public override ContainerTag CreateTagTree(ContainerTag container)
            {
                return container
                [
                    html[
                        head[
                            title[ Model.Title ]
                        ],

                        // SEE HERE ! - example of standard attributes
                        body.attr(onload:"alert('we are here!');")[
                            div.attr(style:"display:none;")[ "Some hidden text" ],
                            div.attr(id:"txtMessage")[
                                span.attr(cssclass: "blue", onclick: "alert('Clicked!');")[

                                    // SEE HERE ! - example of custom attribute
                                    span.attr(id:"id1").ext("specName", "value1")["the message is " + Model.Message]
                                ]
                            ],

                            // SEE HERE ! - example of custom tag with custom attribute
                            custom("specTag").ext("specName", "value2")
                        ]
                    ]
                ];
            }
        }
    }

}