#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using System;
using System.IO;
using SharpDom;

namespace ConsoleSample
{
    /// <summary>
    /// It is very simplistic sample of using SharpDOM project.
    /// In this sample, very basic functionality is shown -
    /// the ability to build HTML layout using C# language only.
    /// </summary>
    public class Sample1HelloWorld
    {
        public static void Run()
        {
            // initially we prepare view model
            var model = new ViewModel
            {
                Title = "Page Title"
            };

            // then we create page builder
            var pageBuilder = new PageBuilder();
            var writer = new StringWriter();

            // then we supply the page builder with the model
            pageBuilder.Render(model, writer);

            // finally we show generated HTML code
            Console.WriteLine(writer.ToString());
            Console.ReadKey();
        }

        // ----- Model and Builder of the Page -----

        /// <summary>View model is to be supplied to page builder
        /// in order to customize HTML layout.</summary>
        public class ViewModel
        {
            public string Title { get; set; }
        }

        /// <summary>It builds practically static HTML layout.
        /// The only dynamic thing is page title.</summary>
        public class PageBuilder : HtmlPageBuilder<ViewModel>
        {
            /// <summary>This methods should be overriden in all page builders.
            /// It should contain real HTML layout expressed in terms of C# language.</summary>
            /// <param name="container">The container inside which new HTML layout should be placed.</param>
            /// <returns>The same container tag as incoming one</returns>
            public override ContainerTag CreateTagTree(ContainerTag container)
            {
                return container
                [
                    html[
                        head[
                            title[ Model.Title ]
                        ],
                        body[
                            div[
                                span[ "Hello World !!!" ]
                            ]
                        ]
                    ]
                ];
            }
        }
    }

}