<?php

  function process_test_file($filename) {

    $values = file($filename);
    
    $result = array();

    // let's count total average render time 
    $total_render_time = 0;
    foreach ($values as $value) {
      $total_render_time += floatval($value);
    }
    $result['total_average_time'] = round(($total_render_time / count($values)),3);

    // let's count real average render time
    $real_render_time = 0;
    $real_values = $values;
    sort($real_values, SORT_NUMERIC);
    for ($i=0; $i < (round(count($real_values)/10)); $i++) {
      array_pop($real_values);
      array_shift($real_values);
    }
    foreach ($real_values as $value) {
      $real_render_time += floatval($value);
    }
    $result['real_average_time'] = round(($real_render_time / count($real_values)),3);

    // let's count minimal render time
    $min_render_time = 999999999;
    foreach ($values as $value) {
      if (floatval($value) < $min_render_time) {
        $min_render_time = floatval($value);
      }
    }
    $result['min_average_time'] = $min_render_time;

    // let's count maximal render time
    $max_render_time = 0;
    foreach ($values as $value) {
      if (floatval($value) > $max_render_time) {
        $max_render_time = floatval($value);
      }
    }
    $result['max_average_time'] = $max_render_time;

    // set number of requests
    $result['requests_count'] = count($values);



    return $result;

  }

  
  function display_results($files_data, $lang_text) {

    echo '<a href="?group_by=time&show_test='.$_GET['show_test'].'">'.$lang_text['group_by_time'].'</a> &nbsp; ';
    echo '<a href="?group_by=server&show_test='.$_GET['show_test'].'">'.$lang_text['group_by_server'].'</a> <br> ';

    if (isset($_REQUEST['group_by'])) {
      if ($_REQUEST['group_by']=='time') {
        display_results_grouped_by_time($files_data, $lang_text);
      } elseif ($_REQUEST['group_by']=='server') {
        display_results_grouped_by_server($files_data, $lang_text);     
      } else {
        die($lang_text['unsupported_group_by_option'].'!');
      }
    } else {
      display_results_grouped_by_time($files_data, $lang_text);
    }

  }

  function display_results_grouped_by_time($files_data, $lang_text) {

    $colors = array(0 => '#ccccff', 1 => '#ccffcc');

    echo '<table border="1" cellpadding="2" cellspacing="1">'."\n";

    /// render table heading
    
    echo '<tr><th>'.$lang_text['date_and_time'].'</th><th>'.$lang_text['server_name'].'</th>';

    foreach (array_keys(reset($files_data)) as $heading) {
      echo '<th>'.$lang_text['result_heading_'.$heading].'</th>';
    }
    echo '</tr>'."\n";

    /// prepare data for rendering
    
    $view_data = array();
    foreach ($files_data as $filename => $data) {
      /// filename description is in main program section
      $tmp = explode('-', $filename);
      $view_data[mktime($tmp[3],$tmp[4],0,$tmp[1],$tmp[2],$tmp[0])][$tmp[5]] = $data;
    }
    krsort($view_data);
    
    /// render results
    $color_index = 0;
    foreach ($view_data as $test_time => $servers_data) {
      ksort($servers_data);
      if ($color_index == count($colors)) $color_index = 0;
      foreach ($servers_data as $server_name => $server_data) {
        echo '<tr bgcolor="'.$colors[$color_index].'">';
        echo '<td>'.date("d.m.Y H:i", $test_time).'</td>';
        echo '<td>'.$server_name.'</td>';
        foreach ($server_data as $result_type => $result_value) {
          echo '<td>'.$result_value.'</td>';
        }
        echo '</tr>'."\n";
      }
      $color_index++;
    }

    echo '</table>'."\n";
  }


  function display_results_grouped_by_server($files_data, $lang_text) {

    $colors = array(0 => '#ccccff', 1 => '#ccffcc');

    echo '<table border="1" cellpadding="2" cellspacing="1">'."\n";

    /// render table heading
    
    echo '<tr><th>'.$lang_text['server_name'].'</th><th>'.$lang_text['date_and_time'].'</th>';

    foreach (array_keys(reset($files_data)) as $heading) {
      echo '<th>'.$lang_text['result_heading_'.$heading].'</th>';
    }
    echo '</tr>'."\n";

    /// prepare data for rendering
    
    $view_data = array();
    foreach ($files_data as $filename => $data) {
      /// filename description is in main program section
      $tmp = explode('-', $filename);
      $view_data[$tmp[5]][mktime($tmp[3],$tmp[4],0,$tmp[1],$tmp[2],$tmp[0])] = $data;
    }
    ksort($view_data);
    
    /// render results
    $color_index = 0;
    foreach ($view_data as $server_name => $servers_data) {
      krsort($servers_data);
      if ($color_index == count($colors)) $color_index = 0;
      foreach ($servers_data as $test_time => $server_data) {
        echo '<tr bgcolor="'.$colors[$color_index].'">';
         echo '<td>'.$server_name.'</td>';
       echo '<td>'.date("d.m.Y H:i", $test_time).'</td>';
        foreach ($server_data as $result_type => $result_value) {
          echo '<td>'.$result_value.'</td>';
        }
        echo '</tr>'."\n";
      }
      $color_index++;
    }

    echo '</table>'."\n";
  }


  /// if we are using PHP4, lets make own scandir() function
  if (version_compare(PHP_VERSION, '5.0.0', '<')) {

    function scandir($dir) {
      $files = array();
      $dh  = opendir($dir);
      while (false !== ($filename = readdir($dh))) {
        $files[] = $filename;
      }
      return $files;
    }

  }

function test_show($data_dir, $lang_text) {

  if ($files = scandir($data_dir)) {

    $files = array_diff($files, array('.', '..'));

    // keeps data for each file
    $files_data = array();
   
    foreach ($files as $filename) {
      if (is_file($data_dir.$filename)) {
        $file_parts = explode('-', $filename);

        /// file name format: YYYY-MM-DD-HH-II-server_name.tst
        if (count($file_parts)==6 && strpos($file_parts[5], '.tst')!==false) {
          $files_data[$filename] = process_test_file($data_dir.$filename); 
        }
      }
    }

    display_results($files_data, $lang_text);

  } else {

    echo $lang_text['file_open_failed'].': '.$data_dir;

  }
}

?>