<?php
  // outputs html for editor
  class ThimbleTextEditor {
    
    // property used for keeping status, if we've already loaded js for help dhtml windows
    private $js_init = false;
      
    // default setting of properties
    
    public $textarea_id = 'thimble_text';
    public $textarea_name = 'thimble_text';
    public $textarea_rows = 15;
    public $textarea_cols = 66;
    public $textarea_style = '';
    public $textarea_text = '';
    public $textarea_show_controls = true;
    public $textarea_show_help = true;
    
    // relative or absolute URL path to a folder where images are located, e.g. images (without slash at the end)
    public $images_url = 'images';
    
    // relative or absolute URL path to dhtmlwindow folder
    public $dhtmlwindow_url = 'dhtml_window';
    
    public $table_name = 'thimble_text';
    // row 'id' in database 
    public $table_id = false;
    
    function html_init() {
      if ($this->textarea_show_help && $this->js_init == false)  {
        $this->js_init = true;
        $output  = '<link rel="stylesheet" href="'.$this->dhtmlwindow_url.'/dhtmlwindow.css" type="text/css" />'."\n";
        $output .= '<script type="text/javascript" src="'.$this->dhtmlwindow_url.'/dhtmlwindow.php?dhtmlwindow_dir='.$this->dhtmlwindow_url.'"></script>'."\n";
        return $output;
      }
    }
    
    function html_head() {
      $function_name = $this->textarea_name.'_button_click';
      $jscript = <<<END
<script>
function $function_name(open_tag, close_tag, tag_text) {
  var text_element = document.getElementById('$this->textarea_id');
  if (text_element.setSelectionRange > '') {
    var p0 = text_element.selectionStart;
    var p1 = text_element.selectionEnd;
    var top = text_element.scrollTop;
    var str = tag_text;
    var cur0 = p0 + open_tag.length;
    var cur1 = p0 + open_tag.length + str.length;
    while (p1 > p0 && text_element.value.substring(p1-1, p1) == ' ') p1--; 
    if (p1 > p0) {
      str = text_element.value.substring(p0, p1);
      cur0 = p0 + open_tag.length + str.length + close_tag.length;
      cur1 = cur0;
    }
    text_element.value = text_element.value.substring(0,p0) + open_tag + str + close_tag + text_element.value.substring(p1);
    text_element.focus();
    text_element.selectionStart = cur0;
    text_element.selectionEnd = cur1;
    text_element.scrollTop = top;
  } else if (document.selection) {
    var str = document.selection.createRange().text;
    text_element.focus();
    range = document.selection.createRange()
    if (str == '') {
      range.text = open_tag + tag_text + close_tag;
      range.moveStart('character', -close_tag.length - tag_text.length );
      range.moveEnd('character', -close_tag.length );
    } else {
      if (str.charAt(str.length - 1) == " ") {
        close_tag = close_tag + " ";
        str = str.substr(0, str.length - 1);
      }
      range.text = open_tag + str + close_tag;
    }
    range.select();
  } else { text_element.value += open_tag + tag_text + close_tag; }
  return;
}
</script>
END;
      if (!$this->textarea_show_controls) $jscript = '';
      return $jscript;
    }
    
    function html_body() {
      $function_name = $this->textarea_name.'_button_click';
      $textarea_text = stripslashes($this->textarea_text);
      $html = '';
      if ($this->textarea_show_controls) {
        if ($this->textarea_show_help) {
          $help_text  = '<table style="" width="430" border="1" cellpadding="3" cellspacing="0">'."\n";
          $help_text .= '<tr><td><strong>ThimbleText syntax</strong></td><td><strong>HTML preview</strong></td></tr>'."\n";
          $help_text .= '<tr><td>aa *bb* cc</td><td>aa <strong>bb</strong> cc</td></tr>'."\n";
          $help_text .= '<tr><td>aa **bb** cc</td><td>aa <i>bb</i> cc</td></tr>'."\n";
          $help_text .= '<tr><td>aa --bb-- cc</td><td>aa <u>bb</u> cc</td></tr>'."\n";
          $help_text .= '<tr><td>aaaaa<br>#####</td><td><h1 style="padding:0;margin:0;border:0">aaaaa</h1></td></tr>'."\n";
          $help_text .= '<tr><td>aaaaa<br>=====</td><td><h2 style="padding:0;margin:0;border:0">aaaaa</h2></td></tr>'."\n";
          $help_text .= '<tr><td>aaaaa<br>-----</td><td><h3 style="padding:0;margin:0;border:0">aaaaa</h3></td></tr>'."\n";
          $help_text .= '<tr><td>{thimble.jpg}</td><td><img src="http://www.thimbleopensource.com/images/thimble2.jpg" alt="" border="0" /></td></tr>'."\n";
          $help_text .= '<tr><td>[http://www.google.com]google[/]</td><td><a href="http://www.google.com">google</a></td></tr>'."\n";
          $help_text .= '<tr><td> - aaaaa<br> &nbsp; - bbbbb</td><td><ul style="padding:0;border:0;margin:0;margin-left:30px;"><li>aaaaa</li><ul><li>bbbbb</li></ul></ul></td></tr>'."\n";
          $help_text .= '<tr><td>((block))aa bb cc((/block))</td><td>&lt;div&gt;aa bb cc&lt;/div&gt;</td></tr>'."\n";
          $help_text .= '</table>';
          $help_button  = '<a href="#" onClick="dhtmlwindow.open(\'tt_help_box\', \'div\', \'tt_help_div\', \'ThimbleText help and hints\', \'width=450px,height=400px,center=1,resize=1,scrolling=1\'); return false">'. "\n";
          $help_button .= '<img src="'.$this->images_url.'/button_help.gif" alt="Inline link" width="50" height="50" border="0"></a> '. "\n";
          $help_button .= '<div id="tt_help_div" style="display:none;">';
          $help_button .= $help_text.'<p style="text-align:center"><a href="http://www.thimbleopensource.com/products/thimbletext/thimbletext-syntax" onclick="dhtmlwindow.open(\'tt_help_box_web\', \'iframe\', \'http://www.thimbleopensource.com/products/thimbletext/thimbletext-syntax/1\', \'ThimbleText syntax\', \'width=550px,height=350px,resize=1,scrolling=1,center=1\', \'recal\'); return false;">Complete ThimbleText syntax at www.thimbleopensource.com</a></p></div>'. "\n";
        } else {
          $help_button = '';
        }
        $html = <<<HTML
<a href="#"><img onclick="$function_name('*','*','bold');" src="$this->images_url/button_bold.gif" alt="Bold" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('**','**','italics');" src="$this->images_url/button_italics.gif" alt="Italics" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('--','--','underline');" src="$this->images_url/button_underline.gif" alt="Underline" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('', '\\n#########','heading 1');" src="$this->images_url/button_heading1.gif" alt="Heading 1" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('', '\\n=========','heading 2');" src="$this->images_url/button_heading2.gif" alt="Heading 2" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('', '\\n---------','heading 3');" src="$this->images_url/button_heading3.gif" alt="Heading 3" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('{', '}','image url');" src="$this->images_url/button_inline_image.gif" alt="Inline image" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('[link url]', '[/]','link text');" src="$this->images_url/button_inline_link.gif" alt="Inline link" width="50" height="50" border="0"></a> 
$help_button
<br>
HTML;
      }
      $html.= <<<TEXTAREA
<textarea name="$this->textarea_name" id="$this->textarea_id" style="$this->textarea_style" rows="$this->textarea_rows" cols="$this->textarea_cols">$textarea_text</textarea>
TEXTAREA;
      return $html;
    }
    
    function save_text() {
      $thimble_text = new ThimbleText();
      $html = $thimble_text->parse_text($this->textarea_text);
      if (!$this->table_id) {
        mysql_query("INSERT INTO `".$this->table_name."`(text, html) VALUES('".mysql_real_escape_string($this->textarea_text)."', '".mysql_real_escape_string($html)."')");
        $this->table_id = mysql_insert_id();
        return $this->table_id;
      } else {
        mysql_query("UPDATE `".$this->table_name."` SET text='".mysql_real_escape_string($this->textarea_text)."', html='".mysql_real_escape_string($html)."' WHERE id='".$this->table_id."'");
        return $this->table_id;
      }
    }
    
  }

?>