<?php
    /*
    * Google PageRank PHP Script & Google PageRank Checksum Algorithm
    * Remani par: FloBaoti [ www.generatix.fr ]
    *
    * Auteur original: http://pagerank.gamesaga.net/
    *
    * Compatible PHP4 & PHP5 // support X86_64 CPU
    *
    * Ce script permet de rcuprer directement sur les serveurs Google,
    * l'indice PageRank d'une URL (cf http://www.webrankinfo.com/google/pagerank/index.php).

	Wertronic 30-10-2011 - Re structure function 
	getPageRank ou getRank suivant script qui appelle
	Use curl if exist else file(

	New pagerank 07-11-2010 
	Avant 07-10-2011 - search?client=navclient-auto - Depuis 07-10-2011 - /tbr?client=navclient-auto
	*/
    
     class PagerankSeo  { // GooglePageRanker pour Arfooo else PagerankSeo
     /*
    * * convert a string to a 32-bit integer
    * */
     function StrToNum($Str, $Check, $Magic)
     {
     $Int32Unit = 4294967296; // 2^32
    
     $length = strlen($Str);
     for ($i = 0; $i < $length; $i++)
     {
     $Check *= $Magic;
     //If the float is beyond the boundaries of integer (usually +/- 2.15e+9 = 2^31),
     // the result of converting to integer is undefined
     // refer to http://www.php.net/manual/en/language.types.integer.php
     if ($Check >= $Int32Unit)
     {
     $Check = ($Check - $Int32Unit * (int) ($Check / $Int32Unit));
     //if the check less than -2^31
     $Check = ($Check < -2147483648) ? ($Check + $Int32Unit) : $Check;
     }
     $Check += ord($Str{$i});
     }
     return $Check;
     }
    
     /*
     * Genearate a hash for a url
     */
     function HashURL($String)
     {
     $Check1 = $this->StrToNum($String, 0x1505, 0x21);
     $Check2 = $this->StrToNum($String, 0, 0x1003F);
    
     $Check1 >>= 2;
     $Check1 = (($Check1 >> 4) & 0x3FFFFC0 ) | ($Check1 & 0x3F);
     $Check1 = (($Check1 >> 4) & 0x3FFC00 ) | ($Check1 & 0x3FF);
     $Check1 = (($Check1 >> 4) & 0x3C000 ) | ($Check1 & 0x3FFF);
    
     $T1 = (((($Check1 & 0x3C0) << 4) | ($Check1 & 0x3C)) <<2 ) | ($Check2 & 0xF0F );
     $T2 = (((($Check1 & 0xFFFFC000) << 4) | ($Check1 & 0x3C00)) << 0xA) | ($Check2 & 0xF0F0000 );
    
     return ($T1 | $T2);
     }
    
     /*
     * genearate a checksum for the hash string
     */
     function CheckHash($Hashnum)
     {
     $CheckByte = 0;
     $Flag = 0;
    
     $HashStr = sprintf('%u', $Hashnum) ;
     $length = strlen($HashStr);
    
     for ($i = $length - 1; $i >= 0; $i --)
     {
     $Re = $HashStr{$i};
     if (1 === ($Flag % 2))
     {
     $Re += $Re;
     $Re = (int)($Re / 10) + ($Re % 10);
     }
     $CheckByte += $Re;
     $Flag ++;
     }
    
     $CheckByte %= 10;
     if (0 !== $CheckByte)
     {
     $CheckByte = 10 - $CheckByte;
     if (1 === ($Flag % 2) )
     {
     if (1 === ($CheckByte % 2))
     {
     $CheckByte += 9;
     }
     $CheckByte >>= 1;
     }
     }
    
     return '7'.$CheckByte.$HashStr;
     }
    
    // Get the Google Pagerank
	// Avant 07-10-2011 --> $dcgg = 'www.google.com'
	function getRank($url) { // Arfooo non utilis, $additionalServerUrl = false
		
		if(!ini_get('track_errors')) {
			ini_set('track_errors', 1); //pour avoir err & warning $php_errormsg
			$save_track = 0;
		}

		if (function_exists('curl_init')) { // Curl exist ?
			$methode = 'Curl ';
			$query = "http://toolbarqueries.google.com/tbr?client=navclient-auto&ch=" . $this->CheckHash($this->HashURL($url)) . "&features=Rank&q=info:" . $url . "&num=100&filter=0";
			$data = $this->file_get_contents_curl($query);
			$pos = strpos($data, "Rank_");
			if($pos === false){
				$methode = 'file( ';
				$data_query = @file('http://toolbarqueries.google.com/tbr?client=navclient-auto&ch='.$this->CheckHash($this->HashURL($url)).'&ie=UTF-8&oe=UTF-8&features=Rank&q=info:'.urlencode($url));
				$data = @implode("", $data_query); // renvoi Rank_1:1:3  pour pagerank de 3
				$pos = strpos($data, "Rank_");
			}
		} else {
			// Avant 07-10-2011 - search?client=navclient-auto - Depuis 07-10-2011 - /tbr?client=navclient-auto
			$data_query = @file('http://toolbarqueries.google.com/tbr?client=navclient-auto&ch='.$this->CheckHash($this->HashURL($url)).'&ie=UTF-8&oe=UTF-8&features=Rank&q=info:'.urlencode($url));
			$data = @implode("", $data_query); // renvoi Rank_1:1:3  pour pagerank de 3
			$pos = strpos($data, "Rank_");
		}
			
		if ($save_track == 0) {
			ini_set('track_errors', ''); //remet etat initial
		}

		//$pagerank = substr($data,strrpos($file, ":")+1);
		if($pos !== false){
			$pagerank = substr($data, $pos + 9);
		} elseif (strstr($php_errormsg, '403 Forbidden')) { 
			$pagerank = 'Forbidden';
		} else {
			$pagerank = 'no response';		
		}
		
		
		settype($pagerank, "string") ;
		return trim($methode.' '.$pagerank);

	}

   // Use curl the get the file contents
   function file_get_contents_curl($url) {
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_HEADER, 0);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // Set curl to return the data instead of printing it to the browser.
      curl_setopt($ch, CURLOPT_URL, $url);

      curl_setopt($ch, CURLOPT_TIMEOUT, 15);	//Le temps maximum d'excution de la fonction cURL.
      curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15); //Le nombre de secondes  attendre durant la tentative de connexion. Utilisez 0 pour attendre indfiniment. 

      $data = curl_exec($ch);
      curl_close($ch);
      return $data;
   }
}
?>
