﻿using Microsoft.SharePoint.Client;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using TodoAppWeb.ViewModels;

namespace TodoAppWeb.Controllers
{
    public class HomeController : Controller
    {
        [SharePointContextFilter]
        public ActionResult IndexTrimmed()
        {
            ViewBag.SenderId = HttpContext.Request.Params["SenderId"];
            return View(GetItems());
        }

        [SharePointContextFilter]
        public ActionResult Index()
        {
            return View(GetItems());
        }

        private List<TodoItemViewModel> GetItems()
        {
            List<TodoItemViewModel> result = new List<TodoItemViewModel>();
            var spContext = SharePointContextProvider.Current.GetSharePointContext(HttpContext);
            ViewBag.SPHostUrl = spContext.SPHostUrl;
            using (var clientContext = spContext.CreateAppOnlyClientContextForSPAppWeb())
            {
                if (clientContext != null)
                {
                    //Load list items
                    List list = clientContext.Web.Lists.GetByTitle("TodoList");
                    ListItemCollection items = list.GetItems(CamlQuery.CreateAllItemsQuery());
                    clientContext.Load(items);
                    clientContext.ExecuteQuery();

                    //Create the Todo item view models
                    result = items.ToArray().Select(li => new TodoItemViewModel()
                    {
                        Id = (int)li.Id,
                        Title = (string)li["Title"],
                        Completed = (bool)li["Completed"]
                    }).ToList();
                }
            }
            return result;
        }

        [HttpPost]
        public JsonResult AddItem(string title)
        {
            int newItemId = 0;
            var spContext = SharePointContextProvider.Current.GetSharePointContext(HttpContext);
            using (var clientContext = spContext.CreateAppOnlyClientContextForSPAppWeb())
            {
                if (clientContext != null)
                {
                    List list = clientContext.Web.Lists.GetByTitle("TodoList");
                    ListItem listItem = list.AddItem(new ListItemCreationInformation());
                    listItem["Title"] = title;
                    listItem.Update();
                    clientContext.Load(listItem, li => li.Id);
                    clientContext.ExecuteQuery();
                    newItemId = listItem.Id;
                }
            }
            return Json(newItemId, JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public JsonResult RemoveItem(int id)
        {
            var spContext = SharePointContextProvider.Current.GetSharePointContext(HttpContext);
            using (var clientContext = spContext.CreateAppOnlyClientContextForSPAppWeb())
            {
                if (clientContext != null)
                {
                    List list = clientContext.Web.Lists.GetByTitle("TodoList");
                    ListItem item = list.GetItemById(id);
                    item.DeleteObject();
                    clientContext.ExecuteQuery();
                }
            }
            return new JsonResult();
        }

        [HttpPost]
        public JsonResult UpdateItem(int id, string title, bool completed)
        {
            var spContext = SharePointContextProvider.Current.GetSharePointContext(HttpContext);
            using (var clientContext = spContext.CreateAppOnlyClientContextForSPAppWeb())
            {
                if (clientContext != null)
                {
                    List list = clientContext.Web.Lists.GetByTitle("TodoList");
                    ListItem item = list.GetItemById(id);

                    item["Title"] = title;
                    item["Completed"] = completed;
                    item.Update();
                    clientContext.ExecuteQuery();
                }
            }
            return new JsonResult();
        }
    }
}
