﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using PagedList;
using MvcDocuments.Models;

namespace MvcDocuments.Controllers
{
    public class StateController : Controller
    {
        private MvcDocumentsContext db = new MvcDocumentsContext();

        //
        // GET: /State/

        /*public ActionResult Index()
        {
            return View(db.States.ToList());
        }*/
        public ViewResult Index(string sortOrder, string currentFilter, string searchString, int? page)
        {
            ViewBag.CurrentSort = sortOrder;
            ViewBag.DateSortParm = sortOrder == "Date" ? "Date desc" : "Date";
            //Set value searchString 
            if (Request.HttpMethod == "GET")
            {
                searchString = currentFilter;
            }
            else
            {
                page = 1;
            }
            ViewBag.CurrentFilter = searchString;
            //Get documents
            var state_name = from d in db.States
                                select d;
            //Get documents based on searchString
            if (!String.IsNullOrEmpty(searchString))
            {
                state_name = state_name.Where(d => d.State_name.ToUpper().Contains(searchString.ToUpper()));
            }
            switch (sortOrder)
            {
                case "Date":
                    state_name = state_name.OrderBy(d => d.State_name);
                    break;
                case "Date desc":
                    state_name = state_name.OrderByDescending(d => d.State_name);
                    break;
                default:
                    state_name = state_name.OrderBy(d => d.State_name);
                    break;
            }
            //Pager
            int pageSize = 8;
            int pageNumber = (page ?? 1);
            //Return content
            return View(state_name.ToPagedList(pageNumber, pageSize));
        }
        //
        // GET: /State/Details/5

        public ActionResult Details(int id = 0)
        {
            State state = db.States.Find(id);
            if (state == null)
            {
                return HttpNotFound();
            }
            return View(state);
        }

        //
        // GET: /State/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /State/Create

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(State state)
        {
            if (ModelState.IsValid)
            {
                db.States.Add(state);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(state);
        }

        //
        // GET: /State/Edit/5

        public ActionResult Edit(int id = 0)
        {
            State state = db.States.Find(id);
            if (state == null)
            {
                return HttpNotFound();
            }
            return View(state);
        }

        //
        // POST: /State/Edit/5

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(State state)
        {
            if (ModelState.IsValid)
            {
                db.Entry(state).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(state);
        }

        //
        // GET: /State/Delete/5

        public ActionResult Delete(int id = 0)
        {
            State state = db.States.Find(id);
            if (state == null)
            {
                return HttpNotFound();
            }
            return View(state);
        }

        //
        // POST: /State/Delete/5

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            State state = db.States.Find(id);
            db.States.Remove(state);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}