﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using PagedList;
using MvcDocuments.Models;

namespace MvcDocuments.Controllers
{
    public class Mail_categoryController : Controller
    {
        private MvcDocumentsContext db = new MvcDocumentsContext();

        //
        // GET: /Mail_category/

        /*public ActionResult Index()
        {
            return View(db.Mail_categories.ToList());
        }*/
        public ViewResult Index(string sortOrder, string currentFilter, string searchString, int? page)
        {
            ViewBag.CurrentSort = sortOrder;
            ViewBag.DateSortParm = sortOrder == "Date" ? "Date desc" : "Date";
            //Set value searchString 
            if (Request.HttpMethod == "GET")
            {
                searchString = currentFilter;
            }
            else
            {
                page = 1;
            }
            ViewBag.CurrentFilter = searchString;
            //Get documents
            var mail_category = from d in db.Mail_categories
                            select d;
            //Get documents based on searchString
            if (!String.IsNullOrEmpty(searchString))
            {
                mail_category = mail_category.Where(d => d.Mail_category_name.ToUpper().Contains(searchString.ToUpper()));
            }
            switch (sortOrder)
            {
                case "Date":
                    mail_category = mail_category.OrderBy(d => d.Mail_category_name);
                    break;
                case "Date desc":
                    mail_category = mail_category.OrderByDescending(d => d.Mail_category_name);
                    break;
                default:
                    mail_category = mail_category.OrderBy(d => d.Mail_category_name);
                    break;
            }
            //Pager
            int pageSize = 8;
            int pageNumber = (page ?? 1);
            //Return content
            return View(mail_category.ToPagedList(pageNumber, pageSize));
        }
        //
        // GET: /Mail_category/Details/5

        public ActionResult Details(int id = 0)
        {
            Mail_category mail_category = db.Mail_categories.Find(id);
            if (mail_category == null)
            {
                return HttpNotFound();
            }
            return View(mail_category);
        }

        //
        // GET: /Mail_category/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /Mail_category/Create

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(Mail_category mail_category)
        {
            if (ModelState.IsValid)
            {
                db.Mail_categories.Add(mail_category);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(mail_category);
        }

        //
        // GET: /Mail_category/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Mail_category mail_category = db.Mail_categories.Find(id);
            if (mail_category == null)
            {
                return HttpNotFound();
            }
            return View(mail_category);
        }

        //
        // POST: /Mail_category/Edit/5

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(Mail_category mail_category)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mail_category).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(mail_category);
        }

        //
        // GET: /Mail_category/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Mail_category mail_category = db.Mail_categories.Find(id);
            if (mail_category == null)
            {
                return HttpNotFound();
            }
            return View(mail_category);
        }

        //
        // POST: /Mail_category/Delete/5

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mail_category mail_category = db.Mail_categories.Find(id);
            db.Mail_categories.Remove(mail_category);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}