﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using PagedList;
using MvcDocuments.Models;

namespace MvcDocuments.Controllers
{
    public class FunctionController : Controller
    {
        private MvcDocumentsContext db = new MvcDocumentsContext();

        //
        // GET: /Function/

        /*public ActionResult Index()
        {
            return View(db.Functions.ToList());
        }*/
        public ViewResult Index(string sortOrder, string currentFilter, string searchString, int? page)
        {
            ViewBag.CurrentSort = sortOrder;
            ViewBag.DateSortParm = sortOrder == "Date" ? "Date desc" : "Date";
            //Set value searchString 
            if (Request.HttpMethod == "GET")
            {
                searchString = currentFilter;
            }
            else
            {
                page = 1;
            }
            ViewBag.CurrentFilter = searchString;
            //Get documents
            var functions = from d in db.Functions
                            select d;
            //Get documents based on searchString
            if (!String.IsNullOrEmpty(searchString))
            {
                functions = functions.Where(d => d.Function_name.ToUpper().Contains(searchString.ToUpper()));
            }
            switch (sortOrder)
            {
                case "Date":
                    functions = functions.OrderBy(d => d.Function_name);
                    break;
                case "Date desc":
                    functions = functions.OrderByDescending(d => d.Function_name);
                    break;
                default:
                    functions = functions.OrderBy(d => d.Function_name);
                    break;
            }
            //Pager
            int pageSize = 8;
            int pageNumber = (page ?? 1);
            //Return content
            return View(functions.ToPagedList(pageNumber, pageSize));
        }

        //
        // GET: /Function/Details/5

        public ActionResult Details(int id = 0)
        {
            Function function = db.Functions.Find(id);
            if (function == null)
            {
                return HttpNotFound();
            }
            return View(function);
        }

        //
        // GET: /Function/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /Function/Create

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(Function function)
        {
            if (ModelState.IsValid)
            {
                db.Functions.Add(function);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(function);
        }

        //
        // GET: /Function/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Function function = db.Functions.Find(id);
            if (function == null)
            {
                return HttpNotFound();
            }
            return View(function);
        }

        //
        // POST: /Function/Edit/5

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(Function function)
        {
            if (ModelState.IsValid)
            {
                db.Entry(function).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(function);
        }

        //
        // GET: /Function/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Function function = db.Functions.Find(id);
            if (function == null)
            {
                return HttpNotFound();
            }
            return View(function);
        }

        //
        // POST: /Function/Delete/5

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Function function = db.Functions.Find(id);
            db.Functions.Remove(function);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}