﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using PagedList; //Added
using System.IO; //Added
using MvcDocuments.Models;

namespace MvcDocuments.Controllers
{
    public class DocumentController : Controller
    {
        private MvcDocumentsContext db = new MvcDocumentsContext();

        //
        // GET: /Document/

        public ViewResult Index(string sortOrder, string currentFilter , string searchString ,string referenceString, string mailCategoryString, string costGroupString, string paymentStatusString, int? page)
        {
            ViewBag.CurrentSort = sortOrder;
            ViewBag.DateSortParm = sortOrder == "Date" ? "Date desc" : "Date";
            //Set value searchString 
            if (Request.HttpMethod == "GET")
            {
                searchString = currentFilter;
            }
            else
            {
                page = 1;
            }
            ViewBag.CurrentFilter = searchString;
            //Get documents
            var document = from d in db.Documents
                           select d;
            //Get documents based on searchStrings
            if (!String.IsNullOrEmpty(searchString))
            {
                document = document.Where(d => d.Company.Company_name.ToUpper().Contains(searchString.ToUpper()));
            }
            if (!String.IsNullOrEmpty(referenceString))
            {
                document = document.Where(d => d.Reference.ToUpper().Contains(referenceString.ToUpper()));
            }
            if (!String.IsNullOrEmpty(mailCategoryString))
            {
                document = document.Where(d => d.Mail_category.Mail_category_name.ToUpper().Contains(mailCategoryString.ToUpper()));
            }
            if (!String.IsNullOrEmpty(costGroupString))
            {
                document = document.Where(d => d.Costs_group.Cost_group_name.ToUpper().Contains(costGroupString.ToUpper()));
            }
            if (!String.IsNullOrEmpty(paymentStatusString))
            {
                document = document.Where(d => d.Payment_status.Payment_status_name.ToUpper().Contains(paymentStatusString.ToUpper()));
            }
            switch (sortOrder)
            {
                case "Date":
                    document = document.OrderBy(d => d.Document_date);
                    break;
                case "Date desc":
                    document = document.OrderByDescending(d => d.Document_date);
                    break;
                default:
                    document = document.OrderByDescending(d => d.Document_date);
                    break;
            }
            //Pager
            int pageSize = 8;
            int pageNumber = (page ?? 1);
            //Return content
            return View(document.ToPagedList(pageNumber, pageSize));
        }

        //
        // GET: /Document/Details/5

        public ActionResult Details(int id = 0)
        {
            Document document = db.Documents.Find(id);
            if (document == null)
            {
                return HttpNotFound();
            }
            return View(document);
        }

        //
        // GET: /Document/Create

        public ActionResult Create()
        {
            ViewBag.CompanyId = new SelectList(db.Companies.OrderBy(x => x.Company_name), "CompanyId", "Company_name");
            ViewBag.Mail_categoryID = new SelectList(db.Mail_categories.OrderBy(x => x.Mail_category_name), "Mail_categoryId", "Mail_category_name");
            ViewBag.Costs_groupId = new SelectList(db.Costs_groups.OrderBy(x => x.Cost_group_name), "Costs_groupId", "Cost_group_name");
            ViewBag.Payment_statusId = new SelectList(db.Payment_statusses.OrderBy(x => x.Payment_status_name), "Payment_statusId", "Payment_status_name");
            return View();
        }

        //
        // POST: /Document/Create

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(Document document)
        {
            if (ModelState.IsValid)
            {
                db.Documents.Add(document);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.CompanyId = new SelectList(db.Companies, "CompanyId", "Company_name", document.CompanyId);
            ViewBag.Mail_categoryID = new SelectList(db.Mail_categories, "Mail_categoryId", "Mail_category_name", document.Mail_categoryID);
            ViewBag.Costs_groupId = new SelectList(db.Costs_groups, "Costs_groupId", "Cost_group_name", document.Costs_groupId);
            ViewBag.Payment_statusId = new SelectList(db.Payment_statusses, "Payment_statusId", "Payment_status_name", document.Payment_statusId);
            return View(document);
        }

        //
        // GET: /Document/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Document document = db.Documents.Find(id);
            if (document == null)
            {
                return HttpNotFound();
            }
            ViewBag.CompanyId = new SelectList(db.Companies.OrderBy(x => x.Company_name), "CompanyId", "Company_name", document.CompanyId);
            ViewBag.Mail_categoryID = new SelectList(db.Mail_categories.OrderBy(x => x.Mail_category_name ), "Mail_categoryId", "Mail_category_name", document.Mail_categoryID);
            ViewBag.Costs_groupId = new SelectList(db.Costs_groups.OrderBy(x => x.Cost_group_name), "Costs_groupId", "Cost_group_name", document.Costs_groupId);
            ViewBag.Payment_statusId = new SelectList(db.Payment_statusses.OrderBy(x => x.Payment_status_name), "Payment_statusId", "Payment_status_name", document.Payment_statusId);
            return View(document);
        }

        //
        // POST: /Document/Edit/5

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(Document document)
        {
            if (ModelState.IsValid)
            {
                db.Entry(document).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.CompanyId = new SelectList(db.Companies, "CompanyId", "Company_name", document.CompanyId);
            ViewBag.Mail_categoryID = new SelectList(db.Mail_categories, "Mail_categoryId", "Mail_category_name", document.Mail_categoryID);
            ViewBag.Costs_groupId = new SelectList(db.Costs_groups, "Costs_groupId", "Cost_group_name", document.Costs_groupId);
            ViewBag.Payment_statusId = new SelectList(db.Payment_statusses, "Payment_statusId", "Payment_status_name", document.Payment_statusId);
            return View(document);
        }

        //
        // GET: /Document/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Document document = db.Documents.Find(id);
            if (document == null)
            {
                return HttpNotFound();
            }
            return View(document);
        }

        //
        // POST: /Document/Delete/5

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Document document = db.Documents.Find(id);
            db.Documents.Remove(document);
            db.SaveChanges();
            return RedirectToAction("Index");
        }


        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }

        public ActionResult DocumentUpload()
        {
            return View();
        }
        [HttpPost]
        public ActionResult DocumentUpload(HttpPostedFileBase file)
        {
            string path = null;
            if (file.ContentLength > 0)
            {
                var fileName = Path.GetFileName(file.FileName);
                path = AppDomain.CurrentDomain.BaseDirectory + "Assets\\Documents\\" + fileName;
                Response.Write(path.ToString());
                file.SaveAs(path);

            }
            return RedirectToAction("Index");
            //return View();
        }
        public ActionResult OpenFile()
        {
            return View();
        }
    }
}