﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using PagedList;
using MvcDocuments.Models;

namespace MvcDocuments.Controllers
{
    public class Costs_groupController : Controller
    {
        private MvcDocumentsContext db = new MvcDocumentsContext();

        //
        // GET: /Costs_group/

        /*public ActionResult Index()
        {
            return View(db.Costs_groups.ToList());
        }*/
        public ViewResult Index(string sortOrder, string currentFilter, string searchString, int? page)
        {
            ViewBag.CurrentSort = sortOrder;
            ViewBag.DateSortParm = sortOrder == "Cost_group_name" ? "Date desc" : "Date";
            //Set value searchString 
            if (Request.HttpMethod == "GET")
            {
                searchString = currentFilter;
            }
            else
            {
                page = 1;
            }
            ViewBag.CurrentFilter = searchString;
            //Get documents
            var costs_group = from d in db.Costs_groups
                          select d;
            //Get documents based on searchString
            if (!String.IsNullOrEmpty(searchString))
            {
                costs_group = costs_group.Where(d => d.Cost_group_name.ToUpper().Contains(searchString.ToUpper()));
            }
            switch (sortOrder)
            {
                case "Cost_group_name":
                    costs_group = costs_group.OrderBy(d => d.Cost_group_name);
                    break;
                case "Date desc":
                    costs_group = costs_group.OrderByDescending(d => d.Cost_group_name);
                    break;
                default:
                    costs_group = costs_group.OrderBy(d => d.Cost_group_name);
                    break;
            }
            //Pager
            int pageSize = 8;
            int pageNumber = (page ?? 1);
            //Return content
            return View(costs_group.ToPagedList(pageNumber, pageSize));
        }

        //
        // GET: /Costs_group/Details/5

        public ActionResult Details(int id = 0)
        {
            Costs_group costs_group = db.Costs_groups.Find(id);
            if (costs_group == null)
            {
                return HttpNotFound();
            }
            return View(costs_group);
        }

        //
        // GET: /Costs_group/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /Costs_group/Create

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(Costs_group costs_group)
        {
            if (ModelState.IsValid)
            {
                db.Costs_groups.Add(costs_group);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(costs_group);
        }

        //
        // GET: /Costs_group/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Costs_group costs_group = db.Costs_groups.Find(id);
            if (costs_group == null)
            {
                return HttpNotFound();
            }
            return View(costs_group);
        }

        //
        // POST: /Costs_group/Edit/5

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(Costs_group costs_group)
        {
            if (ModelState.IsValid)
            {
                db.Entry(costs_group).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(costs_group);
        }

        //
        // GET: /Costs_group/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Costs_group costs_group = db.Costs_groups.Find(id);
            if (costs_group == null)
            {
                return HttpNotFound();
            }
            return View(costs_group);
        }

        //
        // POST: /Costs_group/Delete/5

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Costs_group costs_group = db.Costs_groups.Find(id);
            db.Costs_groups.Remove(costs_group);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}