﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using PagedList;
using MvcDocuments.Models;

namespace MvcDocuments.Controllers
{
    public class ContactController : Controller
    {
        private MvcDocumentsContext db = new MvcDocumentsContext();

        //
        // GET: /Contact/

        /*public ActionResult Index()
        {
            var contacts = db.Contacts.Include(c => c.Company).Include(c => c.Function).Include(c => c.Title);
            return View(contacts.ToList());
        }*/
        public ViewResult Index(string sortOrder, string currentFilter, string searchString, int? page)
        {
            ViewBag.CurrentSort = sortOrder;
            ViewBag.DateSortParm = sortOrder == "Last_name" ? "Date desc" : "Date";
            //Set value searchString 
            if (Request.HttpMethod == "GET")
            {
                searchString = currentFilter;
            }
            else
            {
                page = 1;
            }
            ViewBag.CurrentFilter = searchString;
            //Get documents
            var contact = from d in db.Contacts
                          select d;
            //Get documents based on searchString
            if (!String.IsNullOrEmpty(searchString))
            {
                string SearchFor = searchString.ToUpper();
                contact = contact.Where(d => d.Last_name.ToUpper().Contains(searchString.ToUpper()));
            }
            switch (sortOrder)
            {
                case "Last_name":
                    contact = contact.OrderBy(d => d.Last_name);
                    break;
                case "Date desc":
                    contact = contact.OrderByDescending(d => d.Last_name);
                    break;
                default:
                    contact = contact.OrderByDescending(d => d.Last_name);
                    break;
            }
            //Pager
            int pageSize = 8;
            int pageNumber = (page ?? 1);
            //Return content
            return View(contact.ToPagedList(pageNumber, pageSize));
        }
        //
        // GET: /Contact/Details/5

        public ActionResult Details(int id = 0)
        {
            Contact contact = db.Contacts.Find(id);
            if (contact == null)
            {
                return HttpNotFound();
            }
            return View(contact);
        }

        //
        // GET: /Contact/Create

        public ActionResult Create()
        {
            ViewBag.CompanyId = new SelectList(db.Companies.OrderBy( x => x.Company_name), "CompanyId", "Company_name");
            ViewBag.FunctionId = new SelectList(db.Functions.OrderBy( x => x.Function_name), "FunctionId", "Function_name");
            ViewBag.TitleId = new SelectList(db.Titles.OrderBy( x => x.Title_name), "TitleId", "Title_name");
            return View();
        }

        //
        // POST: /Contact/Create

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(Contact contact)
        {
            if (ModelState.IsValid)
            {
                db.Contacts.Add(contact);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.CompanyId = new SelectList(db.Companies, "CompanyId", "Company_name", contact.CompanyId);
            ViewBag.FunctionId = new SelectList(db.Functions, "FunctionId", "Function_name", contact.FunctionId);
            ViewBag.TitleId = new SelectList(db.Titles, "TitleId", "Title_name", contact.TitleId);
            return View(contact);
        }

        //
        // GET: /Contact/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Contact contact = db.Contacts.Find(id);
            if (contact == null)
            {
                return HttpNotFound();
            }
            ViewBag.CompanyId = new SelectList(db.Companies.OrderBy(x => x.Company_name), "CompanyId", "Company_name", contact.CompanyId);
            ViewBag.FunctionId = new SelectList(db.Functions.OrderBy(x => x.Function_name), "FunctionId", "Function_name", contact.FunctionId);
            ViewBag.TitleId = new SelectList(db.Titles.OrderBy(x => x.Title_name), "TitleId", "Title_name", contact.TitleId);
            return View(contact);
        }

        //
        // POST: /Contact/Edit/5

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(Contact contact)
        {
            if (ModelState.IsValid)
            {
                db.Entry(contact).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.CompanyId = new SelectList(db.Companies, "CompanyId", "Company_name", contact.CompanyId);
            ViewBag.FunctionId = new SelectList(db.Functions, "FunctionId", "Function_name", contact.FunctionId);
            ViewBag.TitleId = new SelectList(db.Titles, "TitleId", "Title_name", contact.TitleId);
            return View(contact);
        }

        //
        // GET: /Contact/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Contact contact = db.Contacts.Find(id);
            if (contact == null)
            {
                return HttpNotFound();
            }
            return View(contact);
        }

        //
        // POST: /Contact/Delete/5

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Contact contact = db.Contacts.Find(id);
            db.Contacts.Remove(contact);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}