﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using PagedList; //Added
using MvcDocuments.Models;

namespace MvcDocuments.Controllers
{
    public class CompanyController : Controller
    {
        private MvcDocumentsContext db = new MvcDocumentsContext();

        //
        // GET: /Company/

        /*public ActionResult Index()
        {
            var companies = db.Companies.Include(c => c.State).Include(c => c.Country);
            return View(companies.ToList());
        }*/
        public ViewResult Index(string sortOrder, string currentFilter, string searchString, int? page)
        {
            ViewBag.CurrentSort = sortOrder;
            ViewBag.DateSortParm = sortOrder == "Company_name" ? "Date desc" : "Date";
            //Set value searchString 
            if (Request.HttpMethod == "GET")
            {
                searchString = currentFilter;
            }
            else
            {
                page = 1;
            }
            ViewBag.CurrentFilter = searchString;
            //Get documents
            var company = from d in db.Companies
                           select d;
            //Get documents based on searchString
            if (!String.IsNullOrEmpty(searchString))
            {
                company = company.Where(d => d.Company_name.ToUpper().Contains(searchString.ToUpper()));
            }
            switch (sortOrder)
            {
                case "Company_name":
                    company = company.OrderBy(d => d.Company_name);
                    break;
                case "Date desc":
                    company = company.OrderByDescending(d => d.Company_name);
                    break;
                default:
                    company = company.OrderByDescending(d => d.Company_name);
                    break;
            }
            //Pager
            int pageSize = 8;
            int pageNumber = (page ?? 1);
            //Return content
            return View(company.ToPagedList(pageNumber, pageSize));
        }

        //
        // GET: /Company/Details/5

        public ActionResult Details(int id = 0)
        {
            Company company = db.Companies.Find(id);
            if (company == null)
            {
                return HttpNotFound();
            }
            return View(company);
        }

        //
        // GET: /Company/Create

        public ActionResult Create()
        {
            ViewBag.StateId = new SelectList(db.States, "StateId", "State_name");
            ViewBag.CountryId = new SelectList(db.Countries, "CountryId", "Country_name");
            return View();
        }

        //
        // POST: /Company/Create

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(Company company)
        {
            if (ModelState.IsValid)
            {
                db.Companies.Add(company);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.StateId = new SelectList(db.States, "StateId", "State_name", company.StateId);
            ViewBag.CountryId = new SelectList(db.Countries, "CountryId", "Country_name", company.CountryId);
            return View(company);
        }

        //
        // GET: /Company/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Company company = db.Companies.Find(id);
            if (company == null)
            {
                return HttpNotFound();
            }
            ViewBag.StateId = new SelectList(db.States.OrderBy( x => x.State_name), "StateId", "State_name", company.StateId);
            ViewBag.CountryId = new SelectList(db.Countries.OrderBy (x => x.Country_name), "CountryId", "Country_name", company.CountryId);
            return View(company);
        }

        //
        // POST: /Company/Edit/5

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(Company company)
        {
            if (ModelState.IsValid)
            {
                db.Entry(company).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.StateId = new SelectList(db.States, "StateId", "State_name", company.StateId);
            ViewBag.CountryId = new SelectList(db.Countries, "CountryId", "Country_name", company.CountryId);
            return View(company);
        }

        //
        // GET: /Company/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Company company = db.Companies.Find(id);
            if (company == null)
            {
                return HttpNotFound();
            }
            return View(company);
        }

        //
        // POST: /Company/Delete/5

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Company company = db.Companies.Find(id);
            db.Companies.Remove(company);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}