﻿using System;
using System.Collections;
using System.Linq;
using System.Xml.Linq;
using System.Web.Services;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;

public partial class _Default : System.Web.UI.Page 
{
  [WebMethod]
  public static IEnumerable GetFeedburnerItems(int Count)
  {
    XDocument feedXML = 
      XDocument.Load("http://feeds.encosia.com/Encosia");

    var feeds = 
      from feed in feedXML.Descendants("item")
      select new
      {
        Date = DateTime.Parse(feed.Element("pubDate").Value)
                       .ToShortDateString(),
        Title = feed.Element("title").Value,
        Link = feed.Element("link").Value,
        Description = feed.Element("description").Value
      };

    return feeds.Take(Count);
  }

  [System.Web.Services.WebMethod]
  public static IEnumerable CheckBankLedgers(int Count)
  {
      try
      {
          DataClassesDataContext dc = new DataClassesDataContext();
          var feeds = from feed in dc.AccountTransactions
                      select new
                      {
                          VoucherDate = feed.VoucherDate.ToString(),
                          VoucherNo = feed.VoucherNo,
                          VoucherType=feed.VoucherType,
                          LedgerName = feed.LedgerName,
                          TransactionAmt = feed.TransactionAmt
                      };
          return feeds.Take(100); 
      }
      catch
      {
          return "0";   
      }
  }
}
