﻿using System;
using System.ComponentModel.DataAnnotations;

namespace NorthwindMVC.Models
{
    #region Connect Base model classes to metadata
    [MetadataType(typeof(OrderMetaData))]
    public partial class Order { }

    [MetadataType(typeof(Order_DetailMetaData))]
    public partial class Order_Detail { }

    [MetadataType(typeof(ProductMetaData))]
    public partial class Product { }


    [MetadataType(typeof(CategoryMetaData))]
    public partial class Category { }

    [MetadataType(typeof(EmployeeMetaData))]
    public partial class Employee { }

    [MetadataType(typeof(CustomerMetaData))]
    public partial class Customer { }

    [MetadataType(typeof(SupplierMetaData))]
    public partial class Supplier { }

    [MetadataType(typeof(ShipperMetaData))]
    public partial class Shipper { }

    #endregion



    /// <summary>
    /// Class used to define metadata attributes for Order class.
    /// </summary>
    public class OrderMetaData
    {
        public int OrderID;
        public string CustomerID;
        public Nullable<int> EmployeeID;

        [Display(Name = "Order date")]
        [Required(AllowEmptyStrings = false, ErrorMessage = "Order date is required")]
        [DataType(DataType.Date, ErrorMessage = "Order data must be a valid date")
            , DisplayFormat(DataFormatString = "{0:MM/dd/yyyy}", ApplyFormatInEditMode = true)]
        public Nullable<System.DateTime> OrderDate;

        /// <summary>
        /// Data annotation for Order Date make it required & validate the date value
        ///                     Required Date make it optional but validate the date value if entered
        /// </summary>

        [Display(Name = "Required Date")]
        [DataType(DataType.Date, ErrorMessage = "Required date must be a valid date")
            , DisplayFormat(DataFormatString = "{0:MM/dd/yyyy}", ApplyFormatInEditMode = true)]
        public Nullable<System.DateTime> RequiredDate;

        [Display(Name = "Ship Date")]
        [DataType(DataType.Date, ErrorMessage = "Ship date must be a valid date")
            , DisplayFormat(DataFormatString = "{0:MM/dd/yyyy}", ApplyFormatInEditMode = true)]
        public Nullable<System.DateTime> ShippedDate;
        public Nullable<int> ShipVia;
        public Nullable<decimal> Freight;

        [Display(Name = "Ship To")]
        [MaxLength(256, ErrorMessage = "Name cannot exceed 256 characters")]
        public string ShipName;

        [Display(Name = "Mailing Address")]
        [MaxLength(256, ErrorMessage = "Name cannot exceed 256 characters")]
        public string ShipAddress;

        [Display(Name = "City")]
        [MaxLength(10, ErrorMessage = "Name cannot exceed 100 characters")]
        public string ShipCity;

        [Display(Name = "Region")]
        public string ShipRegion;

        [Display(Name = "Zip")]
        public string ShipPostalCode;

        [Display(Name = "Country")]
        [MaxLength(100, ErrorMessage = "Name cannot exceed 100 characters")]
        public string ShipCountry;

    }

    /// <summary>
    /// Class used to define metadata attributes for Order_Detail class.
    /// </summary>
    public class Order_DetailMetaData
    {
        public int OrderID;
        public int ProductID;

        [Display(Name = "Price/unit")]
        public decimal UnitPrice;
        public short Quantity;
        public float Discount;
    }

    /// <summary>
    /// Class used to define metadata attributes for Product class.
    /// </summary>
    public class ProductMetaData
    {
        public int ProductID;

        [Display(Name = "Product")]
        public string ProductName;
        public Nullable<int> SupplierID;
        public Nullable<int> CategoryID;

        [Display(Name = "Qty/unit")]
        public string QuantityPerUnit;

        [Display(Name = "Price/unit")]
        public Nullable<decimal> UnitPrice;

        [Display(Name = "On Hand")]
        public Nullable<short> UnitsInStock;

        [Display(Name = "On Order")]
        public Nullable<short> UnitsOnOrder;

        [Display(Name = "Reorder Level")]
        public Nullable<short> ReorderLevel;

        [Display(Name = "Discontinued")]
        public bool Discontinued;
    }

    public class CategoryMetaData
    {
        public int CategoryID;

        [Display(Name = "Category")]
        public string CategoryName;

        [Display(Name = "Category Description")]
        public string Description;

        [Display(Name = "Category Image")]
        public byte[] Picture;
    }

    public class EmployeeMetaData
    {
        public int EmployeeID;

        [Required(ErrorMessage = "Lastname required")]
        public string LastName;

        [Required(ErrorMessage = "Firstname required")]
        public string FirstName;

        public string Title;
        public string TitleOfCourtesy;

        [Display(Name = "Birthday")]
        [DataType(DataType.Date, ErrorMessage = "Birthday must be a valid date")
            , DisplayFormat(DataFormatString = "{0:MM/dd/yyyy}", ApplyFormatInEditMode = true)]
        public Nullable<System.DateTime> BirthDate;

        [Display(Name = "Hire date")]
        [DataType(DataType.Date, ErrorMessage = "Hire date must be a valid date")
            , DisplayFormat(DataFormatString = "{0:MM/dd/yyyy}", ApplyFormatInEditMode = true)]
        public Nullable<System.DateTime> HireDate;
        public string Address;
        public string City;
        public string Region;

        [Display(Name = "Zip")]
        public string PostalCode;
        public string Country;
        public string HomePhone;
        public string Extension;

        [Display(Name = "Employee Photo")]
        public byte[] Photo;

        public string Notes;

        [Display(Name = "Manager ID")]
        public Nullable<int> ReportsTo;

        public string PhotoPath;
    }

    public class CustomerMetaData
    {
        public string CustomerID;

        [Display(Name = "Customer Company")]
        [Required(ErrorMessage = "Customer name is required")]
        public string CompanyName;

        [Display(Name = "Customer Contact")]
        public string ContactName;
        public string ContactTitle;
        public string Address;
        public string City;
        public string Region;

        [Display(Name = "Zip")]
        public string PostalCode;
        public string Country;
        public string Phone;
        public string Fax;
    }

    public class SupplierMetaData
    {
        public int SupplierID;

        [Display(Name = "Supplier Company")]
        [Required(ErrorMessage = "Supplier name required")]
        public string CompanyName;

        [Display(Name = "Supplier Contact")]
        public string ContactName;
        public string ContactTitle;
        public string Address;
        public string City;
        public string Region;

        [Display(Name = "Zip")]
        public string PostalCode;
        public string Country;
        public string Phone;
        public string Fax;

        [Display(Name = "Website")]
        public string HomePage;
    }

    public class ShipperMetaData
    {
        public int ShipperID;

        [Display(Name = "Shipping Company")]
        [Required(ErrorMessage = "Shipper name required")]
        public string CompanyName;

        [Required(ErrorMessage = "Shipper phone# required")]
        public string Phone;
    }
}