﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using GenericRepoUowSample.Models;
using GenericRepoUowSample.Repository;

namespace GenericRepoUowSample.UnitOfWorkk
{
    public class UnitOfWork : IDisposable
    {
        private SampleDbEntities entities = null;
        public UnitOfWork()
        {
            entities = new SampleDbEntities();
        }

        // Add all the repository handles here
        IRepository<Contact> contactRepository = null;

        // Add all the repository getters here
        public IRepository<Contact> ContactRepository
        {
            get
            {
                if (contactRepository == null)
                {
                    contactRepository = new ContactsRepositoryWithUow(entities);
                }
                return contactRepository;
            }
        }

        public void SaveChanges()
        {
            entities.SaveChanges();
        }


        private bool disposed = false;

        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    entities.Dispose();
                }
            }
            this.disposed = true;
        }

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

    }
}