﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using GenericRepoUowSample.Models;
using System.Data;
using System.Data.Objects;

namespace GenericRepoUowSample.Repository
{
    class GenericRepository<T> : IRepository<T> where T : class
    {
        private SampleDbEntities entities = null;
        IObjectSet<T> _objectSet;

        public GenericRepository(SampleDbEntities _entities)
        {
            entities = _entities;
            _objectSet = entities.CreateObjectSet<T>();
        }

        public IEnumerable<T> GetAll(Func<T, bool> predicate = null)
        {
            if (predicate != null)
            {
                return _objectSet.Where(predicate);
            }

            return _objectSet.AsEnumerable();
        }

        public T Get(Func<T, bool> predicate)
        {
            return _objectSet.First(predicate);
        }

        public void Add(T entity)
        {
            _objectSet.AddObject(entity);
        }

        public void Attach(T entity)
        {
            _objectSet.Attach(entity);
            entities.ObjectStateManager.ChangeObjectState(entity, EntityState.Modified);
        }

        public void Delete(T entity)
        {
            _objectSet.DeleteObject(entity);
        }
    }
}