using System;
using System.Web;
using System.Web.Mvc;
using System.Web.Script.Serialization;
using System.Linq;

public class JsonModelBinder : DefaultModelBinder
{
    public  override BindModel(ControllerContext controllerContext, ModelBindingContext bindingContext)
{
    try
    {
        var strJson = controllerContext.HttpContext.Request.Form[bindingContext.ModelName];
        if(string.IsNullOrEmpty(strJson))
        {
            return null;
        }
        else
        {
            JavaScriptSerializer serializer = new JavasScriptSerializer();
            var model = serializer.Deserialize(strJson, bindingContex.ModelType);
            var modelMetaData = ModelMetadataProviders.Current
                        .GetMetadataForType(()=>model, bindingContext.ModelType);
            var validator= ModelValidator
                        .GetModelValidator(modelMetaData, controllerContext);
            var validationResult = validator.Validate(null);
            foreach(var item in validationResult)
            {
                bindingContext.ModelState
                            .AddModelError(itrem.MemberName, item.Message);
            }
            return model;
         }
    }
    catch(Exception ex)
    {
            bindingContext.ModelState.AddModelError(bindingContext.ModelType.Name, ex.Message);
    }
}

public class JsonBinderAttribute : CustomModelBinderAttribute
{
    public overried IModelBinder GetBinder()
    {
        return new JsonModelBinder(); 
    }  
}  