<?php
/**
 * @package AkarruCPE
 * @subpackage index
 * @version 0.6
 * @copyright (c) 2006 Eduardo Diaz Cortes
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License 
 * @author Eduardo Diaz <ediaz@lnds.net>
 */

require('akarru/common.php');
$user_name = request_value('user_name', '');
if (empty($user_name)) {
	redirect_to('/');
	return;
}

$page = request_value('page', 1);
$show = request_value('show', 'memes');
$template = new ProfileTemplate('master');

$user = new User(0, $user_name);
if ($show == 'profile')
{
	$user->avatar = get_gravatar($user->gravatar, 40);
}
else if ($show == 'favorites') {
	$memes = new MemeList($page, 'where (p.id in (select post_id from post_votes where user_id = '.$user->ID.')) and submitted_user_id <> '.$user->ID, 0, 'order by date_posted desc');
	$template->assign('message', MSG_FAVORITES);
	$template->set_data($memes);
	if ($memes->size == 0)
		$template->assign('no_memes', MSG_SELFISH);
}
else
{
	$memes = new MemeList($page, 'where submitted_user_id = '.$user->ID, 0, 'order by date_posted desc');
	if ($memes->size == 0)
		$template->assign('no_memes', MSG_NO_MEMES_SENT);
	$template->set_data($memes);
}
$template->set_profile($user);
$template->select_tab($show);
$template->hide_tabstrip();
$template->display('profile');

?>
