<?php
require('akarru/common.php');

$template = new Template('master');
$template->hide_tabstrip();
$template->no_preview();

if (is_post_back()) 
{
	$req = request_uri();
	if ($req == '/do_register') 
	{
		$email = request_value('email', '');
		if (empty($email) || !is_valid_email($email)) 
			$template->add_error(ERR_REQUIRES_EMAIL);
		else if (User::check_email_exists($email)) 
			$template->add_error(ERR_EMAIL_ALREADY_REGISTERED);

		$username = request_value('username','');
		if (empty($username)) 
			$template->add_error(ERR_REQUIRES_USERNAME);
		else if (User::check_user_exists($username)) 
			$template->add_error($username.ERR_USER_ALREADY_REGISTERED);
		$pass = request_value('pass', '');
		$pass2 = request_value('pass2', '');
		if (empty($pass)) 
			$template->add_error(ERR_REQUIRES_PASSWORD);
		else if ($pass != $pass2) 
			$template->add_error(ERR_PASSWORDS_MUST_MATCH);
		if ($template->has_errors() == 0) 
		{
			if (User::create_user($username, $email, $pass))
			{
				$template->message(MSG_REGISTER_WELCOME);
				$template->set_destination('/', MSG_CONTINUE);
				$template->display('result');
				return;
			}
			else
				$template->add_error(ERR_CANT_CREATE_USER);
		}

	}
}

$template->add_css('blogmemes_forms.css');
$template->assign('cats', false);
$template->display('registerform');

?>
