<?php
/**
 * @package AkarruCPE
 * @version 0.6
 * @copyright (c) 2006 Eduardo Diaz Cortes
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License 
 * @author Eduardo Diaz <ediaz@lnds.net>
 */

include_once('akarru/common.php');
$url = request_value('url', '');
$id = Meme::check_exists_url($url);
if ($id > 0) {
	redirect_to("/meme/$id");
	return;
}
$user = new User();
if (!$user->is_logged_in()) {
	redirect_to('/login?from=post&title='.request_value('title','').'&url='.request_value('url',''));
	return;
}
$form = 'postform';
$template = new Template('master');
$template->hide_tabstrip();
$template->no_preview();
$template->load_categories();
$template->add_css('blogmemes_forms.css');
if (is_post_back()) 
{
	$req = request_uri();
	if ($req == '/post_verify')
	{
		$form = 'postform_validate';
		$errors = 0;
		$template->validate_required_text('title', '', ERR_REQUIRES_TITLE);
		$url = $template->validate_optional_url('url', '', ERR_BAD_URL);
		if (Meme::check_exists_url(request_value('url', '')))
			$template->add_error(ERR_URL_ALREADY_PUBLISHED);
		if (!$template->has_errors()) 
		{
			$template->assign('action', '/post_submit');
			$cats = array('-1' => MSG_CHOOSE_CATEGORY);
			foreach ($template->cats->categories as $cat)
			{
				$cats[$cat->ID] = $cat->cat_title;
			}
			$template->assign('categories', $cats);
		}
	}
	else if ($req == '/post_submit') 
	{
		$template->validate_required_text('title', '', ERR_REQUIRES_TITLE);
		$url = $template->validate_optional_url('url', '', ERR_BAD_URL);
		$template->validate_required_text('description', '', ERR_REQUIRES_CONTENT);
		$template->validate_select('category', -1, ERR_REQUIRES_CATEGORY);
		if ($template->has_errors()) 
		{
			$cats = array('-1' => MSG_CHOOSE_CATEGORY);
			foreach ($template->cats->categories as $cat)
			{
				$cats[$cat->ID] = $cat->cat_title;
			}
			$template->assign('categories', $cats);
			$form = 'postform_validate';
		}
		else
		{
			$meme = Meme::create_meme($_REQUEST);
			redirect_to($meme->id == 0 ? '/queue' : '/meme/'.$meme->id);
			return;
		}
	}
}
else
{
	$url = request_value('url', 'http://');
	$title = request_value('title', '');
	$template->assign('url', $url);
	$template->assign('title', $title);
	$template->assign('action', '/post_verify');
}
$template->assign('cats', false);
$template->display($form)
?>
