<?php
/**
 * @package AkarruCPE
 * @version 0.6
 * @copyright (c) 2006 Eduardo Diaz Cortes
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License 
 * @author Eduardo Diaz <ediaz@lnds.net>
 */
require('akarru/common.php');
$from = request_value('from', '/');
$title = request_value('title', '');
$url = request_value('url','');
$template = new Template('master');
$template->hide_tabstrip();
$template->no_preview();
$template->add_css('blogmemes_forms.css');
if (is_post_back()) 
{
	$req = request_uri();
	if ($req == '/do_login')
	{
		$user = User::login(request_value('username'), request_value('pass'), request_value('remember', 0));
		if ($user->ID)
		{
			if ($title || $url) 
				$from .= '?r=post';
			if ($title) 
				$from .= '&title=' . $title;
			if ($url)
				$from .= '&url=' .$url;
			redirect_to($from);
			return;
		}
		else
			$template->add_error(ERR_BAD_LOGIN);
	}
	else if ($req == '/do_recover') 
	{
		$email = request_value('email');
		if (empty($email)) {
			$template->add_error(ERR_REQUIRES_EMAIL);
		}
		else
		{
			User::gen_password($email, '[blogmemes] recuperar clave', $bf_recover_pass, 'http://www.blogmemes.com/logon');
			$template->message(MSG_RECOVER_MAIL_SENT, TITLE_ATT);
			$template->set_destination('/', MSG_CONTINUE);
			$template->display('result');
			return;
		}
	}
}
$template->assign('from', $from);
$template->assign('url', $url);
$template->assign('title', $title);
$template->assign('cats', false);
$template->display('loginform');


?>
