<?php
/**
 * @package AkarruCPE
 * @version 0.6
 * @copyright (c) 2006 Eduardo Diaz Cortes
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License 
 * @author Eduardo Diaz <ediaz@lnds.net>
 */
		 
function __autoload($class_name)
{
	class_exists($class_name) || require('akarru/'.$class_name.'.class.php');
}


// encode special chars 
function check_plain($text)
{
    if (get_magic_quotes_gpc() == 1)
		$text = stripslashes($text);
	return htmlspecialchars($text, ENT_QUOTES);
}

function request_value($arg, $deflt='')
{
	$type = gettype($deflt);
	$var = $_REQUEST[$arg];
	if (!isset($var)) 
	{
		return $deflt;
	}
    $value = check_plain($var);
	settype($value, $type);
	return $value;
}

function get_gravatar($gravatar_id, $size)
{
	$default = BASE_URL . "img/anon${size}.png";
	return "http://www.gravatar.com/avatar.php?gravatar_id=$gravatar_id&amp;default=".urlencode($default)."&amp;size=$size.&amp;rating=R";
}


function get_myvideoes($url)
{
	$matches = array();
	@preg_match('/watch\/(.*)$/', $url, $matches);
	if (empty($matches[1])) {
		return '';
	}
	$url = 'http://www.myvideo.es/movie/'.$matches[1];
    return '<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="425" height="350"><param name="movie" value="'.$url.'" /><embed src="'.$url.'" width="425" height="350" type="application/x-shockwave-flash" /></object>';
}

function paginate($rows, $current_page, $page_size, $n_pages, $prev_text='&lt;&lt;', $next_text='&gt;&gt;')
{
	$max_pages = ceil($rows/$page_size);
	$pages = array();
	$pos = floor($current_page / $n_pages);
	$left = $n_pages*$pos+1;
	$right = min($left+$n_pages, $max_pages);

	$pages = array();
	if ($left > $n_pages) 
		$pages[] = '<a href="?page='.($left-$n_pages).'">'.$prev_text.'</a>';

	for ($i = $left; $i < $right; $i++) 
		if ($i == $current_page) 
			$pages[] = "<b>$i</b>";
		else
			$pages[] = '<a href="?page='.$i.'">'.$i.'</a>';

	if ($right < $max_pages)
		$pages[] = '<a href="?page='.$right.'">'.$next_text.'</a>';

	return $pages;
}


function calc_font_sizes($data, $field, $maxnb, $min_size, $max_size)
{
	$sum = 0;
	$fsize = $min_size;
	$nbt = array();
	foreach ($data as $datum)
		$nbt[] = $datum->$field;
	$threshold = $maxnb;
	unset($nbt);
	$result = array();
	foreach ($data as $datum)
	{
		$datum->font_size = $min_size + ceil(($max_size-$min_size)* ($datum->$field / $threshold));
		$result[] = $datum;
	}
	unset($data);
	return $result;
}

// code based on excellent article found at  http://www.leosingleton.com/projects/code/phpapp/
// 
// Application vars

define('APP_VAR_FILE','/tmp/akarru_application.data');

function set_app_var($var_name, $value)
{
    global $_APP_VARS;
	global $_APP_VARS_CHANGED;
	$_APP_VARS[$var_name] = $value;
	$_APP_VARS_CHANGED = true;
}

function get_app_var($var_name)
{
    global $_APP_VARS;
	return $_APP_VARS[$var_name];
}

function application_start ()
{
    global $_APP_VARS;

    // if data file exists, load application
    //   variables
    if (file_exists(APP_VAR_FILE))
    {
        // read data file
        $file = fopen(APP_VAR_FILE, "r");
        if ($file)
        {
            $data = fread($file,filesize(APP_VAR_FILE));
            fclose($file);
        }

        // build application variables from
        //   data file
        $_APP_VARS = unserialize($data);
    }
}

function application_end ()
{
    global $_APP_VARS;
	global $_APP_VARS_CHANGED;

	if ($_APP_VARS_CHANGED) 
	{
		// write application data to file
		$data = serialize($_APP_VARS);
		$file = fopen(APP_VAR_FILE, "w");
		if ($file)
		{
			fwrite($file, $data);
			fclose($file);
		}
	}
}

function is_post_back()
{
	return $_SERVER['REQUEST_METHOD']=='POST' || sizeof($_POST) > 0;
}


function request_uri()
{
	return $_SERVER['REQUEST_URI'];
}

function redirect_to($url)
{
	header("Location: $url");
	exit(0);
}

function check_url_format($url)
{
	$url_arr = @parse_url($url);
	if ($url_arr['scheme'] != 'http') 
		return false;
	if (empty($url_arr['host']) )
		return false;
	return $url;
}

function check_url_exists($url)
{
	$furl = @fopen($url, "r");
	if (!$furl) {
		return false;
	}
	@fclose($furl);
	return true;
}


function is_valid_email($addr)
{
	if(substr_count($addr,"@")!=1)
		return false;
	list($local, $domain) = explode("@", $addr);
	
	$pattern_local = '^([0-9a-z]*([-|_]?[0-9a-z]+)*)(([-|_]?)\.([-|_]?)[0-9a-z]*([-|_]?[0-9a-z]+)+)*([-|_]?)$';
	$pattern_domain = '^([0-9a-z]+([-]?[0-9a-z]+)*)(([-]?)\.([-]?)[0-9a-z]*([-]?[0-9a-z]+)+)*\.[a-z]{2,4}$';

	$match_local = eregi($pattern_local, $local);
	$match_domain = eregi($pattern_domain, $domain);
	
	return ($match_local && $match_domain && gethostbyname($domain));
}


?>
