<?php
/**
 * @package Akarru CPE
 * @version 0.5
 * @copyright (c) 2006 Eduardo Diaz Cortes
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License 
 * @author Eduardo Diaz <ediaz@lnds.net>
 */

class Database extends mysqli {

	var $row_count;

	/**
	 * private instance of this class, this allows only one instance of
	 * database connection per request
	 */
	private static $instance;

	/**
	 * You must use this static function to obtain the instance of the database
	 * This ensure only one Database object per request (Singleton Pattern
	 */
	public static function singleton()
	{
		if (!isset(self::$instance)) 
		{
           $c = __CLASS__;
           self::$instance = new $c;
		}
		return self::$instance;
	}

	/**
	 * This constants are defined on config.php
	 */
	var $user= DATABASE_USER;
	var $pass= DATABASE_PASS;
	var $host= DATABASE_HOST;
	var $name= DATABASE_NAME;

	/**
	 * Database constructor.
	 * Is private because we use the singleton pattern.
	 */
	private function __construct()
	{
        parent::__construct(
           $this->host,
           $this->user,
           $this->pass,
           $this->name);
	    $this->query("SET CHARACTER SET utf8");
	   // $this->query("SET NAMES 'utf8'");
	}

	/**
	 * Destructor close the connection to the database
	 */
	function __destruct()
	{
		$this->close();
	}

	/**
	 * sanitizes a string, eliminates quotes, strip html and php tags, and scape
	 * the string for use in mysql
	 */
	public function sanitize($str)
	{
	   // $str = htmlentities($str, ENT_QUOTES);
		$str = strip_tags($str, '<a><b><em><br><p><h1><h2><h3><h4><ul><li>');
		return $this->real_escape_string($str);
	}

	/**
	 * Return a single object representing the result of the SQL string in argument
	 */
	public function fetch_object($sql)
	{
		$row = null;
		if ($result = $this->query($sql, MYSQLI_USE_RESULT))
		{
			$row = $result->fetch_object();
			$result->free();
		}
		return $row;
	}

	/**
	 * Return an scalar for the SQL query string given.
	 * Is used to retrieve numbers (like count(*) or sum()
	 */
	public function fetch_scalar($sql, $default=0)
	{
		$ret = $default;
		if ($result = $this->query($sql, MYSQLI_USE_RESULT))
		{
			if ($row = @$result->fetch_row())
			{
				$result->free();
				$ret = $row[0];
			}
		}
		return $ret;
	}

	/**
	 * Execute inmediatly an sql statement.
	 */
	public function execute($query)
	{
		return $this->query($query);
	}

	/**
	 * return the count of the query.
	 */
	public function count($from, $where='')
	{
		$sql = "select SQL_CACHE count(*) $from $where";
		return $this->fetch_scalar($sql);
	}

	/**
	 * Do a select for the arguments, this retrieves all the fields for the table.
	 */
	public function select($from, $where, $order='', $limit='')
	{
		return $this->select_fields('*', $from, $where, $order, $limit);
	}

	/**
	 * retrieves some fields, this function build an sql select statement
	 */
	public function select_fields($fields, $from, $where, $order='', $limit='')
	{
		$sql = "select SQL_CACHE $fields $from $where $order $limit";
		$result = $this->query($sql, MYSQLI_STORE_RESULT);
		$data = array();
		if ($result) 
		{
			while ($row = $result->fetch_object())
			{
				$data[] = $row;
			}
			$result->free();
		}

		return $data;
	}

}


?>
