<?

class MemeList {

	var $page_size = RECORDS_TO_PAGE;
	var $content_type = 0;
	var $page = 1;
	var $pages = 0;
	var $cat_hash;

	public function __construct($page, $published='where p.promoted = 1 ', $micro_content='0', $order_by='order by p.rank desc')
	{
		$cats = get_app_var('cats');
		$this->cat_hash = $cats->cat_hash;

		$db = Database::singleton();
		$this->content_type = $micro_content;
		$this->page = $page;
		$this->order = $order_by;
		$this->load_published($db, $published);
	}

	private function load_published($db, $where)
	{
		if ($this->content_type != 0) {
			if (empty($where)) 
				$where = 'where is_content_type = '.$this->content_type;
			else
				$where .= ' and is_content_type = '.$this->content_type;
		}
		$this->size = $this->count_memes($db, $where);
		$this->rows = $this->load_page($db, $this->page, $where);
		$this->pages = ceil($this->size / $this->page_size);
	}


	public function get_memes()
	{
		return $this->rows;
	}

	private function load_page($db, $page, $where, $fields='p.date_posted, p.promoted, p.id, p.ID, p.category, p.votes, p.comments, p.content, p.is_micro_content, p.title,  p.rank, p.url,  u.username, u.gravatar, u.ID as user_id ')
	{
		$low = ($page-1)*$this->page_size;
		$result = $db->select_fields($fields , 'from posts p join users u on u.id = p.submitted_user_id ', $where, $this->order, "limit $low, $this->page_size" );
		return $this->filter($db, $result);
	}

	private function filter($db, $data)
	{
		$result = array();
		foreach ($data as $datum)
		{
			$datum->small_gravatar = get_gravatar($datum->gravatar, 16);
			if (empty($datum->url)) 
				$datum->url = "/meme/$datum->ID";
			else
				$datum->url = check_plain($datum->url);
			$datum->cat_title = $this->cat_hash[$datum->category];
			$datum->title = check_plain($datum->title);
			$mc = $datum->is_micro_content;
			if ($mc == 2) 
			{
				$datum->micro_content = media_snapshot($datum->url, 98, 80);
				if ($datum->micro_content) 
					$datum->url = 'http://'.DOMAIN."/meme/$datum->ID";
			}
			$result[] = $datum;
		}
		return $result;
	}


	public function count_memes($db, $where)
	{
		return $db->count('from posts p', $where);
	}
}
?>
