﻿Imports System.Text.RegularExpressions
Imports System.Web.UI.HtmlControls

<Assembly: TagPrefix("CustomsControls", "asp")> 

<ToolboxData("<{0}:AutoFilterGridView runat=""server""></{0}:AutoFilterGridView>")> _
Partial Public Class AutoFilterGridView
	Inherits GridView

	'used to hold information needed for filtering the fields
	' needs to be serializable so we can store it in teh viewstate
	<Serializable()> _
 Private Class FilterInfo
		Public Name As String
		Public PlaceHolder As String
		Public DataFieldType As System.Type
		Public DataFieldName As String
		Public [Operator] As String
	End Class
	Private Filters As New List(Of FilterInfo)

	<Category("Behavior")> _
	<Description("Add filters the gridview.")> _
	<DefaultValue(False)> _
 Public Property IncludeFilters() As Boolean
		Get
			If String.IsNullOrEmpty(ViewState("IncludeFilters")) Then
				Return False
			Else
				Return DirectCast(ViewState("IncludeFilters"), Boolean)
			End If
		End Get
		Set(ByVal Value As Boolean)
			ViewState("IncludeFilters") = Value
		End Set
	End Property

	<Category("Behavior")> _
	 <Description("Add filter button to which column position (0=first empty)?")> _
	 <DefaultValue(-1)> _
	Public Property FilterButtonsColumnIndex() As Integer
		Get
			If String.IsNullOrEmpty(ViewState("FilterButtonsColumnIndex")) Then
				Return 0
			Else
				Return DirectCast(ViewState("FilterButtonsColumnIndex"), Integer)
			End If
		End Get
		Set(ByVal Value As Integer)
			ViewState("FilterButtonsColumnIndex") = Value
		End Set
	End Property

	<Category("Behavior")> _
	 <Description("Basic client validation on filters")> _
	 <DefaultValue(True)> _
	Public Property ClientValidateFilters() As Boolean
		Get
			If String.IsNullOrEmpty(ViewState("ClientValidateFilters")) Then
				Return True
			Else
				Return DirectCast(ViewState("ClientValidateFilters"), Boolean)
			End If
		End Get
		Set(ByVal Value As Boolean)
			ViewState("ClientValidateFilters") = Value
		End Set
	End Property

	' Adds the needed js file for validation and clearig the filters
	Protected Overrides Sub OnPreRender(e As EventArgs)
		MyBase.OnPreRender(e)
		Dim resourceName As String = "MyCustomControls.AutoFilterGridView.js"
		Dim cs As ClientScriptManager = Me.Page.ClientScript
		cs.RegisterClientScriptResource(GetType(AutoFilterGridView), resourceName)
	End Sub

	' When the page loads add filters if required and postback
	Protected Sub Page_Load(sender As Object, e As System.EventArgs) Handles Me.Load
		If IncludeFilters AndAlso Page.IsPostBack Then
			FilterTheData()
		End If
	End Sub

	' this routine determins if we need to filter data and if so creates the filterparameters and filtrexpression
	Private Sub FilterTheData()
		' retrieve the latest filter information from the viewstate
		Filters = (New LosFormatter()).Deserialize(ViewState("CustomGridFilters"))
		Using ds As SqlDataSource = CType(Me.DataSourceObject, SqlDataSource)
			Dim FilterExpressions As New List(Of String)()

			With ds
				' remove parameters and recreate the needed ones
				.FilterParameters.Clear()
				' cycle through each filterable column set in the filters list
				For Each filter As FilterInfo In Filters
					' if there is a request value for the column (that is not equal to the placeholder) then add the filter to the datasource
					If Not String.IsNullOrEmpty(If(Page.Request(filter.Name), String.Empty)) AndAlso Page.Request(filter.Name) <> If(filter.PlaceHolder, String.Empty) Then
						Dim p As New FormParameter(filter.Name, filter.Name)
						With p
							.Type = System.Type.GetTypeCode(filter.DataFieldType)
							.DefaultValue = Page.Request(filter.Name)
							' If this is a datetime filter and the max value, we need to make an adjustment if there is no time. Since the filter should be =< the date and a date only is treated as midnight, add a dat to the value
							If .Type = TypeCode.DateTime AndAlso Regex.IsMatch(filter.Name, "^filter2_") AndAlso Regex.IsMatch(.DefaultValue, "^((0?[1-9]|1[012])[- /.](0?[1-9]|[12][0-9]|3[01])[- /.](19|20)[0-9]{2})?$") Then
								.DefaultValue = DateAdd(DateInterval.Second, -1, DateAdd(DateInterval.Day, 1, DateTime.Parse(.DefaultValue)))
							End If
						End With
						.FilterParameters.Add(p)

						' create each expression for the parameter
						Select Case System.Type.GetTypeCode(filter.DataFieldType)
							Case TypeCode.Boolean
								FilterExpressions.Add(filter.DataFieldName & filter.Operator & " '{" & (.FilterParameters.Count - 1) & "}'")

							Case TypeCode.Byte, TypeCode.Decimal, TypeCode.Double, TypeCode.Int16, TypeCode.Int32, TypeCode.Int64, TypeCode.SByte, TypeCode.Single, TypeCode.UInt16, TypeCode.UInt32, TypeCode.UInt64
								FilterExpressions.Add(filter.DataFieldName & filter.Operator & "{" & (.FilterParameters.Count - 1) & "}")

							Case TypeCode.DateTime
								FilterExpressions.Add(filter.DataFieldName & filter.Operator & "#{" & (.FilterParameters.Count - 1) & "}#")

							Case Else
								FilterExpressions.Add(filter.DataFieldName & " " & filter.Operator & " '%{" & (.FilterParameters.Count - 1) & "}%'")

						End Select

					End If
				Next

				' convert filter expressions into one expression and assign it to the filterexpression
				.FilterExpression = [String].Join(" AND ", FilterExpressions.ToArray())
				.DataBind()
			End With

			Me.DataBind()
		End Using
	End Sub

	Private Sub AutoFilterGridView_DataBound(sender As Object, e As System.EventArgs) Handles Me.DataBound
		' if the control is not told to add filters leave
		If Not IncludeFilters Then Return

		If Me.Controls.Count > 0 Then
			If Not AddFilterHeader() Then Return
		End If

		' store the filter list in the viewstate
		Using sw As New IO.StringWriter()
			Dim los = New LosFormatter
			los.Serialize(sw, Filters)
			ViewState("CustomGridFilters") = sw.GetStringBuilder().ToString()
		End Using

		Return
	End Sub

	Private Function MakeFilterCell(DataFieldName As String, DataType As System.Type, BoundFieldType As System.Type) As TableHeaderCell
		' create the cells to place in the header columns
		Using hc As New TableHeaderCell
			'If IsNothing(DataFieldName) OrElse String.IsNullOrEmpty(DataFieldName) Then
			'	' if there is no datafield name then make an empty cell
			'	hc.Text = String.Empty
			'Else
			' add the filter controls to the cell
			AddFilterControls(hc, DataType, DataFieldName, BoundFieldType)
			'End If
			' set a class to the cell
			hc.CssClass = "filterHeader"
			Return hc
		End Using
	End Function

	Private Function AddFilterHeader() As Boolean
		' get a view of the table
		Dim myTable = DirectCast(Me.Controls(0), Table)
		Dim myNewRow = New GridViewRow(0, -1, DataControlRowType.Header, DataControlRowState.Normal)
		Dim boolFilterDropped As Boolean = False
		Filters.Clear()
		' Get a view of the data columns
		Dim columns As DataColumnCollection
		If Not IsNothing(Me.DataSource) AndAlso Me.DataSource.GetType() Is GetType(DataTable) Then
			columns = DirectCast(Me.DataSource, DataTable).Columns
		ElseIf Not IsNothing(Me.DataSourceObject) AndAlso Me.DataSourceObject.GetType() Is GetType(SqlDataSource) Then
			columns = CType(CType(Me.DataSourceObject, SqlDataSource).Select(DataSourceSelectArguments.Empty), DataView).Table.Columns
		Else
			Return False
		End If

		'For each column, process it
		For x = 1 To Me.Columns.Count
			With Me.Columns(x - 1)
				If (FilterButtonsColumnIndex <> x) AndAlso (.ShowHeader AndAlso .Visible AndAlso GetType(BoundField).IsAssignableFrom(.GetType()) AndAlso Not String.IsNullOrEmpty(CType(Me.Columns(x - 1), BoundField).DataField)) Then
					Using tc As New TableHeaderCell
						AddFilterControls(tc, columns(CType(Me.Columns(x - 1), BoundField).DataField.ToString).DataType, CType(Me.Columns(x - 1), BoundField).DataField.ToString, .GetType())
						tc.CssClass = "filterHeader"

						myNewRow.Cells.Add(tc)
					End Using
				ElseIf FilterButtonsColumnIndex = x OrElse (FilterButtonsColumnIndex = 0 AndAlso .Visible And Not boolFilterDropped) Then
					Using tc As New TableHeaderCell
						tc.CssClass = "filterButtons"
						tc.Controls.Add(New Button() With {.ID = "btnApplyFilters", .CommandName = "ApplyFilters", .Text = "Filter", .CssClass = "filterButton"})
						Using b As New Button
							b.ID = "btnClearFilters"
							b.CommandName = "ClearFilters"
							b.Text = "Clear"
							b.CssClass = "filterButton"
							b.Attributes.Add("onclick", "ClearAllFilters()")
							tc.Controls.Add(b)
						End Using
						myNewRow.Cells.Add(tc)
					End Using
					boolFilterDropped = True
				ElseIf .Visible Then	' just make an empty cell
					myNewRow.Cells.Add(New TableHeaderCell())
				End If
			End With
		Next

		myTable.Rows.AddAt(0, myNewRow)

		Return True
	End Function

	Private Sub AddFilterControls(ByRef hc As TableHeaderCell, DataFieldType As System.Type, DataFieldName As String, BoundFieldType As System.Type)
		' Based on the datatype we will need to make different controls and set the values
		Select Case Type.GetTypeCode(DataFieldType)
			Case TypeCode.Boolean
				If BoundFieldType Is GetType(CheckBoxField) Then
					' create a tristate checkbox
					Using i As New HtmlGenericControl("input")
						i.Attributes.Add("id", "filter1_" & DataFieldName)
						i.Attributes.Add("name", i.Attributes("id"))
						i.Attributes.Add("type", "checkbox")
						i.Attributes.Add("data-indeterminate", String.IsNullOrEmpty(If(Page.Request(i.Attributes("name")), String.Empty)))
						If String.Compare(If(Page.Request(i.Attributes("name")), String.Empty), "True", True) = 0 Then
							i.Attributes.Add("checked", String.Compare(If(Page.Request(i.Attributes("name")), String.Empty), "True", True) = 0)
						End If
						i.Attributes.Add("class", "autoFilter tri " & DataFieldType.Name.ToLower)

						hc.Controls.Add(i)

						Filters.Add(New FilterInfo() With {.Name = i.Attributes("name"), .DataFieldType = DataFieldType, .DataFieldName = DataFieldName, .Operator = "="})
					End Using

				Else
					' create a true/false/any dropdownlist
					Using i As New HtmlGenericControl("select")
						i.Attributes.Add("id", "filter1_" & DataFieldName)
						i.Attributes.Add("name", i.Attributes("id"))
						Using o As New HtmlGenericControl("option")
							o.Attributes.Add("value", "")
							o.InnerText = ""
							If (If(Page.Request(i.Attributes("name")), String.Empty)) = o.Attributes("value") Then
								o.Attributes.Add("selected", "selected")
							End If
							i.Controls.Add(o)
						End Using
						Using o As New HtmlGenericControl("option")
							o.Attributes.Add("value", "false")
							o.InnerText = "False"
							If (If(Page.Request(i.Attributes("name")), String.Empty)) = o.Attributes("value") Then
								o.Attributes.Add("selected", "selected")
							End If
							i.Controls.Add(o)
						End Using
						Using o As New HtmlGenericControl("option")
							o.Attributes.Add("value", "true")
							o.InnerText = "True"
							If (If(Page.Request(i.Attributes("name")), String.Empty)) = o.Attributes("value") Then
								o.Attributes.Add("selected", "selected")
							End If
							i.Controls.Add(o)
						End Using

						i.Attributes.Add("class", "autoFilter " & DataFieldType.Name.ToLower)

						hc.Controls.Add(i)

						Filters.Add(New FilterInfo() With {.Name = i.Attributes("name"), .DataFieldType = DataFieldType, .DataFieldName = DataFieldName, .Operator = "="})
					End Using
				End If
			Case TypeCode.Byte, TypeCode.Decimal, TypeCode.Double, TypeCode.Int16, TypeCode.Int32, TypeCode.Int64, TypeCode.SByte, TypeCode.Single, TypeCode.UInt16, TypeCode.UInt32, TypeCode.UInt64
				' This is a range control, add min then max
				Dim mm As String() = {"min", "max", ">=", "<="}
				For x = 1 To 2
					Using i As New HtmlGenericControl("input")
						i.Attributes.Add("id", "filter" & x.ToString & "_" & DataFieldName)
						i.Attributes.Add("name", i.Attributes("id"))
						i.Attributes.Add("placeholder", mm(x - 1))
						If Type.GetTypeCode(DataFieldType) = TypeCode.Byte Then
							i.Attributes.Add("maxlength", 4)
						Else
							i.Attributes.Add("maxlength", 20)
						End If
						'i.Attributes.Add("style", "display:block;")
						i.Attributes.Add("class", "autoFilter " & mm(x - 1) & "Value numericValue " & DataFieldType.Name.ToLower)
						If ClientValidateFilters Then
							Select Case Type.GetTypeCode(DataFieldType)
								Case TypeCode.Byte, TypeCode.Int16, TypeCode.Int32, TypeCode.Int64, TypeCode.SByte
									i.Attributes.Add("onblur", "ValidateAutoFilter(this,/^([\-+]?\d+)?$/)")

								Case TypeCode.UInt16, TypeCode.UInt32, TypeCode.UInt64
									i.Attributes.Add("onblur", "ValidateAutoFilter(this,/^(\d+)?$/)")

								Case TypeCode.Decimal, TypeCode.Double, TypeCode.Single
									i.Attributes.Add("onblur", "ValidateAutoFilter(this,/^([-+]?[0-9]*\.?[0-9]+)?$/)")
							End Select
						End If

						i.Attributes.Add("value", If(Page.Request(i.Attributes("id")), String.Empty))
						hc.Controls.Add(i)

						Filters.Add(New FilterInfo() With {.Name = i.Attributes("id"), .DataFieldType = DataFieldType, .DataFieldName = DataFieldName, .Operator = mm(x + 1), .PlaceHolder = i.Attributes("placeholder")})
					End Using
				Next

			Case TypeCode.DateTime
				' This is a range control, add min then max
				Dim mm As String() = {"min", "max", ">=", "<="}
				For x = 1 To 2
					Using i As New HtmlGenericControl("input")
						i.Attributes.Add("id", "filter" & x.ToString & "_" & DataFieldName)
						i.Attributes.Add("name", i.Attributes("id"))
						i.Attributes.Add("placeholder", mm(x - 1))
						i.Attributes.Add("maxlength", 22)
						i.Attributes.Add("class", "autoFilter " & mm(x - 1) & "Value " & DataFieldType.Name.ToLower)

						If ClientValidateFilters Then
							i.Attributes.Add("onblur", "ValidateAutoFilter(this, /^((0?[1-9]|1[012])[- /.](0?[1-9]|[12][0-9]|3[01])[- /.](19|20)[0-9]{2}( ((2[0-3]|[0-1]?[0-9]):[0-5][0-9](:[0-5][0-9])?|(1[0-2]|[1-9]):[0-5][0-9](:[0-5][0-9])?( (am|pm))?))?)?$/i)")
						End If

						i.Attributes.Add("value", If(Page.Request(i.Attributes("id")), String.Empty))
						hc.Controls.Add(i)

						Filters.Add(New FilterInfo() With {.Name = i.Attributes("id"), .DataFieldType = DataFieldType, .DataFieldName = DataFieldName, .Operator = mm(x + 1), .PlaceHolder = i.Attributes("placeholder")})
					End Using
				Next

			Case Else
				Using i As New HtmlGenericControl("input")
					i.Attributes.Add("name", "filter_" & DataFieldName)
					i.Attributes.Add("id", "filter_" & DataFieldName)
					i.Attributes.Add("placeholder", "contains")
					If DataFieldType.Name = "Char" Then
						i.Attributes.Add("maxlength", 1)
					Else
						i.Attributes.Add("maxlength", 255)
					End If

					i.Attributes.Add("class", "autoFilter textValue " & DataFieldType.Name.ToLower)

					i.Attributes.Add("value", If(Page.Request(i.Attributes("id")), String.Empty))
					hc.Controls.Add(i)

					Filters.Add(New FilterInfo() With {.Name = i.Attributes("id"), .DataFieldType = DataFieldType, .DataFieldName = DataFieldName, .Operator = "LIKE", .PlaceHolder = i.Attributes("placeholder")})
				End Using

		End Select

	End Sub

End Class

